/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.model.PropertyContainer;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseComboGroup;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ComboGroup
extends BaseComboGroup
implements TimedModel,
PropertyContainer {
    private static final long serialVersionUID = 1L;
    private static final String JSON_PROP_ITEM_MODIFIED_PRICE = "itemModifiedPrices";
    private static final String JSON_PROP_MENU_ITEM_PRICE = "price";
    private static final String JSON_PROP_MENU_ITEM_ID = "menuItemId";
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    private transient JsonObject propertiesContainer;
    private List<String> itemsId;

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
        this.updateSyncTime = shouldUpdateSyncTime;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
        this.updateLastUpdateTime = shouldUpdateUpdateTime;
    }

    public ComboGroup() {
    }

    public ComboGroup(String id) {
        super(id);
    }

    public List<String> getItemsId() {
        return this.itemsId;
    }

    public void setItemsId(List<String> itemsId) {
        this.itemsId = itemsId;
    }

    @Override
    public JsonObject getPropertyStore() {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = StringUtils.isBlank((String)super.getProperties()) ? new JsonObject() : (JsonObject)new Gson().fromJson(super.getProperties(), JsonObject.class);
        }
        return this.propertiesContainer;
    }

    public void addItemPrice(String itemId, double modifiedPrice) {
        JsonObject itemIdJsonObj;
        JsonArray itemModifiedPrices;
        if (this.propertiesContainer == null) {
            this.propertiesContainer = this.getPropertyStore();
        }
        if ((itemModifiedPrices = this.propertiesContainer.getAsJsonArray(JSON_PROP_ITEM_MODIFIED_PRICE)) == null) {
            itemModifiedPrices = new JsonArray();
        }
        if ((itemIdJsonObj = this.getItemJsonObject(itemId, itemModifiedPrices)) == null) {
            itemIdJsonObj = new JsonObject();
            itemIdJsonObj.addProperty(JSON_PROP_MENU_ITEM_ID, itemId);
            itemIdJsonObj.addProperty(JSON_PROP_MENU_ITEM_PRICE, (Number)modifiedPrice);
            itemModifiedPrices.add((JsonElement)itemIdJsonObj);
        } else {
            itemIdJsonObj.remove(JSON_PROP_MENU_ITEM_PRICE);
            itemIdJsonObj.addProperty(JSON_PROP_MENU_ITEM_PRICE, (Number)modifiedPrice);
        }
        this.propertiesContainer.add(JSON_PROP_ITEM_MODIFIED_PRICE, (JsonElement)itemModifiedPrices);
    }

    public double getItemPrice(String itemId) {
        if (this.propertiesContainer == null) {
            return 0.0;
        }
        JsonArray itemModifiedPrices = this.propertiesContainer.getAsJsonArray(JSON_PROP_ITEM_MODIFIED_PRICE);
        if (itemModifiedPrices == null || itemModifiedPrices.isJsonNull()) {
            return 0.0;
        }
        for (JsonElement jsonElement : itemModifiedPrices) {
            JsonElement id;
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            if (jsonObject == null || (id = jsonObject.get(JSON_PROP_MENU_ITEM_ID)) == null || !id.getAsString().equals(itemId)) continue;
            JsonElement price = jsonObject.get(JSON_PROP_MENU_ITEM_PRICE);
            if (price == null) {
                return 0.0;
            }
            return price.getAsDouble();
        }
        return 0.0;
    }

    private JsonObject getItemJsonObject(String itemId, JsonArray itemModifiedPrices) {
        if (!itemModifiedPrices.isJsonNull()) {
            for (JsonElement jsonElement : itemModifiedPrices) {
                JsonElement id;
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                if (jsonObject == null || (id = jsonObject.get(JSON_PROP_MENU_ITEM_ID)) == null || !id.getAsString().equals(itemId)) continue;
                return jsonObject;
            }
        }
        return null;
    }
}

