/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseGiftCard;
import com.floreantpos.model.util.DateUtil;
import java.util.Calendar;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
@JsonIgnoreProperties(ignoreUnknown=true, value={"customCardNumber"})
public class GiftCard
extends BaseGiftCard
implements TimedModel {
    private static final long serialVersionUID = 1L;
    public static final String DURATION_TYPE_DAY = "DAY";
    public static final String DURATION_TYPE_MONTH = "MONTH";
    public static final String DURATION_TYPE_YEAR = "YEAR";
    @XmlTransient
    public String customCardNumber;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;

    public GiftCard() {
    }

    public GiftCard(String cardNumber) {
        super(cardNumber);
    }

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
        this.updateSyncTime = shouldUpdateSyncTime;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
        this.updateLastUpdateTime = shouldUpdateUpdateTime;
    }

    public void setCustomCardNumber(String customCardNumber) {
        this.customCardNumber = customCardNumber;
    }

    public String getCustomCardNumber() {
        StringBuilder gcn = new StringBuilder(super.getCardNumber());
        for (int i = 0; i < gcn.length(); ++i) {
            if (i != 4 && i != 9 && i != 14) continue;
            gcn.insert(i, "-");
        }
        return gcn.toString();
    }

    @Override
    public String toString() {
        return super.getCardNumber();
    }

    public Date prepareExpireDate(Date fromDate) {
        Calendar c = Calendar.getInstance();
        if (fromDate != null) {
            c.setTime(fromDate);
        }
        if (this.getDurationType().equals(DURATION_TYPE_DAY)) {
            c.add(5, this.getDuration());
        } else if (this.getDurationType().equals(DURATION_TYPE_MONTH)) {
            c.add(2, this.getDuration());
        } else {
            c.add(1, this.getDuration());
        }
        Date expiryDate = c.getTime();
        return DateUtil.endOfDay(expiryDate);
    }

    public boolean isExpried() {
        Date today = new Date();
        Date expiryDate = this.getExpiryDate();
        if (expiryDate != null && today.compareTo(expiryDate) > 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

