/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.PosLog;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseGratuity;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import java.io.Serializable;
import java.util.Set;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"ticket"})
@XmlRootElement
public class Gratuity
extends BaseGratuity
implements TimedModel {
    private static final long serialVersionUID = 1L;
    private transient boolean syncEdited;
    private transient Ticket ticket;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    private Double transactionTipsAmount;

    public Gratuity() {
    }

    public Gratuity(String id) {
        super(id);
    }

    public void calculateTransactionTips() {
        try {
            this.transactionTipsAmount = 0.0;
            String ticketId2 = this.getTicketId();
            if (StringUtils.isEmpty((String)ticketId2)) {
                return;
            }
            Ticket ticket = TicketDAO.getInstance().loadCouponsAndTransactions(ticketId2);
            if (ticket == null) {
                return;
            }
            Set<PosTransaction> transactions = ticket.getTransactions();
            if (transactions != null && transactions.size() > 0) {
                for (PosTransaction posTransaction : transactions) {
                    if (posTransaction.isVoided().booleanValue()) continue;
                    if (posTransaction instanceof RefundTransaction) {
                        this.transactionTipsAmount = this.transactionTipsAmount - posTransaction.getTipsAmount();
                        continue;
                    }
                    this.transactionTipsAmount = this.transactionTipsAmount + posTransaction.getTipsAmount();
                }
            }
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
        }
    }

    public Double getTransactionTipsAmount() {
        if (this.transactionTipsAmount == null) {
            this.calculateTransactionTips();
        }
        return this.transactionTipsAmount;
    }

    public Ticket getTicket() {
        if (this.ticket == null && StringUtils.isNotEmpty((String)this.getTicketId())) {
            this.ticket = (Ticket)DataProvider.get().getObjectOf(Ticket.class, (Serializable)((Object)this.getTicketId()));
        }
        return this.ticket;
    }

    public boolean isSyncEdited() {
        return this.syncEdited;
    }

    public void setSyncEdited(boolean syncEdited) {
        this.syncEdited = syncEdited;
    }

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
        this.updateSyncTime = shouldUpdateSyncTime;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
        this.updateLastUpdateTime = shouldUpdateUpdateTime;
    }

    @Override
    public Double getAmount() {
        Double amount = super.getAmount();
        if (Double.isNaN(amount)) {
            return 0.0;
        }
        return amount;
    }
}

