/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.MenuPageItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PropertyContainer;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseMenuPage;
import com.floreantpos.model.dao.MenuPageDAO;
import com.floreantpos.model.util.DataProvider;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"cellItemMap"})
@XmlRootElement
public class MenuPage
extends BaseMenuPage
implements TimedModel,
PropertyContainer {
    private static final long serialVersionUID = 1L;
    public static final int MAX_SIZE = 16;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    private Map<String, MenuPageItem> cellItemMap;
    private transient JsonObject propertiesContainer;

    public MenuPage() {
    }

    public MenuPage(String id) {
        super(id);
    }

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
        this.updateSyncTime = shouldUpdateSyncTime;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
        this.updateLastUpdateTime = shouldUpdateUpdateTime;
    }

    @Override
    public Integer getButtonWidth() {
        Integer buttonWidth = super.getButtonWidth();
        if (buttonWidth < 30) {
            return 30;
        }
        if (buttonWidth > 300) {
            return 300;
        }
        return buttonWidth;
    }

    @Override
    public Integer getButtonHeight() {
        Integer buttonHeight = super.getButtonHeight();
        if (buttonHeight < 30) {
            return 30;
        }
        if (buttonHeight > 300) {
            return 300;
        }
        return buttonHeight;
    }

    public MenuPageItem getItemForCell(int col, int row) {
        String cellKey;
        MenuPageItem menuPageItem2;
        MenuPageDAO.getInstance().initialize(this);
        List<MenuPageItem> pageItems = this.getPageItems();
        if (pageItems == null || pageItems.size() == 0) {
            return null;
        }
        if (this.cellItemMap == null || this.cellItemMap.size() != pageItems.size()) {
            this.cellItemMap = new HashMap<String, MenuPageItem>();
            for (MenuPageItem menuPageItem2 : pageItems) {
                String cellKey2 = String.valueOf(menuPageItem2.getCol()) + String.valueOf(menuPageItem2.getRow());
                this.cellItemMap.put(cellKey2, menuPageItem2);
            }
        }
        if ((menuPageItem2 = this.cellItemMap.get(cellKey = String.valueOf(col) + String.valueOf(row))) == null || StringUtils.isEmpty((String)menuPageItem2.getMenuItemId()) || StringUtils.isEmpty((String)menuPageItem2.getMenuItemName())) {
            return null;
        }
        return menuPageItem2;
    }

    @Override
    public String toString() {
        return super.getName();
    }

    @Override
    public JsonObject getPropertyStore() {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = new JsonObject();
        }
        return this.propertiesContainer;
    }

    @Override
    public String getProperties() {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.toString();
        }
        String properties = super.getProperties();
        if (StringUtils.isEmpty((String)properties)) {
            return null;
        }
        this.propertiesContainer = (JsonObject)new Gson().fromJson(properties, JsonObject.class);
        return properties;
    }

    @Override
    public void setProperties(String properties) {
        super.setProperties(properties);
        this.propertiesContainer = (JsonObject)new Gson().fromJson(properties, JsonObject.class);
    }

    public List<OrderType> getOrderTypes() {
        String[] orderTypeIdList;
        ArrayList<OrderType> orderTypes = new ArrayList<OrderType>();
        String orderTypeIds = this.getOrderTypeIds();
        if (StringUtils.isBlank((String)orderTypeIds)) {
            if (StringUtils.isBlank((String)this.getOrderTypeId())) {
                return orderTypes;
            }
            OrderType orderType = DataProvider.get().getOrderType(this.getOrderTypeId());
            if (orderType != null) {
                orderTypes.add(orderType);
            }
            return orderTypes;
        }
        for (String orderTypeId : orderTypeIdList = orderTypeIds.split(",")) {
            if (StringUtils.isBlank((String)orderTypeId)) continue;
            String replaceQuote = orderTypeId.replaceAll("'", "").trim();
            OrderType orderType = DataProvider.get().getOrderType(replaceQuote);
            if (orderType == null) continue;
            orderTypes.add(orderType);
        }
        return orderTypes;
    }
}

