/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuPage;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.base.BaseMenuPageItem;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.util.DataProvider;
import java.awt.Color;
import java.util.UUID;
import javax.swing.ImageIcon;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonIgnoreProperties(ignoreUnknown=true, value={"menuItem", "image", "buttonColor", "textColor"})
@XmlRootElement
public class MenuPageItem
extends BaseMenuPageItem {
    private static final long serialVersionUID = 1L;
    private transient MenuItem menuItem;
    private final String randomId = UUID.randomUUID().toString();

    public MenuPageItem() {
    }

    public MenuPageItem(String id) {
        super(id);
    }

    public MenuPageItem(Integer col, Integer row) {
        super.setCol(col);
        super.setRow(row);
    }

    public MenuPageItem(Integer col, Integer row, MenuItem menuItem, MenuPage menuPage) {
        super.setCol(col);
        super.setRow(row);
        this.setMenuItem(menuItem);
        this.setMenuPage(menuPage);
    }

    public void setMenuPage(MenuPage menuPage) {
        if (menuPage != null) {
            this.setMenuPageId(menuPage.getId());
        } else {
            this.setMenuPageId(null);
        }
    }

    @XmlTransient
    public MenuItem getMenuItem() {
        if (this.menuItem == null && this.getMenuItemId() != null) {
            this.menuItem = MenuItemDAO.getInstance().get(this.getMenuItemId());
        }
        return this.menuItem;
    }

    public void setMenuItem(MenuItem menuItem) {
        this.menuItem = menuItem;
        if (menuItem != null) {
            this.setMenuItemId(menuItem.getId());
            this.setMenuItemName(menuItem.getDisplayName());
            this.setTranslatedName(menuItem.getTranslatedName());
            this.setButtonColorCode(menuItem.getButtonColorCode());
            this.setTextColorCode(menuItem.getTextColorCode());
            this.setImageId(menuItem.getImageId());
            this.setShowImageOnly(menuItem.isShowImageOnly());
            this.setVariant(menuItem.isVariant());
            this.setHasVariant(menuItem.isHasVariant());
            this.setVisible(menuItem.isVisible());
        } else {
            this.setMenuItemId(null);
            this.setMenuItemName(null);
            this.setTranslatedName(null);
            this.setButtonColorCode(null);
            this.setTextColorCode(null);
            this.setImageId(null);
            this.setShowImageOnly(null);
            this.setVariant(null);
            this.setHasVariant(null);
            this.setVisible(null);
        }
    }

    public void setImage(ImageIcon image) {
    }

    @XmlTransient
    public ImageIcon getImage() {
        ImageResource imageResource = DataProvider.get().getImageResource(this.getImageId());
        if (imageResource != null) {
            return imageResource.getButtonImage();
        }
        return null;
    }

    @Override
    public Integer getButtonColorCode() {
        Integer buttonColorCode = super.getButtonColorCode();
        if (buttonColorCode == null || buttonColorCode == 0 || buttonColorCode == -1316371) {
            buttonColorCode = Color.WHITE.getRGB();
        }
        return buttonColorCode;
    }

    @XmlTransient
    public Color getButtonColor() {
        Integer buttonColorCode = this.getButtonColorCode();
        if (buttonColorCode == null) {
            return null;
        }
        return new Color(this.getButtonColorCode());
    }

    public void setButtonColor(Color buttonColor) {
        if (buttonColor != null) {
            this.setButtonColorCode(buttonColor.getRGB());
        }
    }

    @XmlTransient
    public Color getTextColor() {
        if (this.getTextColorCode() == null) {
            return null;
        }
        return new Color(this.getTextColorCode());
    }

    public void setTextColor(Color textColor) {
        if (textColor != null) {
            this.setTextColorCode(textColor.getRGB());
        }
    }

    public String getRandomId() {
        return this.randomId;
    }

    @XmlTransient
    public String getDisplayName() {
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        if ((terminal != null && terminal.isShowTranslatedName().booleanValue() || this.isVariant().booleanValue()) && StringUtils.isNotEmpty((String)super.getTranslatedName())) {
            return super.getTranslatedName();
        }
        String name = super.getMenuItemName();
        return name;
    }

    public boolean isRowColumnEquals(MenuPageItem other) {
        return this.getRow().equals(other.getRow()) && this.getCol().equals(other.getCol());
    }
}

