/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.IdContainer;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.RecepieItem;
import com.floreantpos.model.RecipeTable;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseRecepie;
import com.floreantpos.model.dao.RecipeTableDAO;
import com.floreantpos.model.ext.InvMapKey;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.NumberUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement
@JsonIgnoreProperties(ignoreUnknown=true, value={"menuItemName"})
public class Recepie
extends BaseRecepie
implements IdContainer,
TimedModel {
    private static final long serialVersionUID = 1L;
    private Double cost;
    private Boolean visible;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    private Double cookingYield;

    public Recepie() {
    }

    public Recepie(String id) {
        super(id);
    }

    public Recepie(String id, String name) {
        super(id, name);
    }

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
        this.updateSyncTime = shouldUpdateSyncTime;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
        this.updateLastUpdateTime = shouldUpdateUpdateTime;
    }

    public void addRecepieItem(RecepieItem recepieItem) {
        List<RecepieItem> recepieItems = this.getRecepieItems();
        if (recepieItems == null) {
            recepieItems = new ArrayList<RecepieItem>(3);
            this.setRecepieItems(recepieItems);
        }
        recepieItems.add(recepieItem);
    }

    @Override
    public String toString() {
        return super.getName();
    }

    public Double getCost() {
        return this.cost == null ? 0.0 : this.cost;
    }

    public void setCost(Double cost) {
        this.cost = cost;
    }

    public void calculateCost() {
        double portionCost = 0.0;
        double recipeCost = 0.0;
        List<RecepieItem> items = this.getRecepieItems();
        if (items != null && items.size() > 0) {
            for (RecepieItem recepieItem : items) {
                recepieItem.calculatePercentage();
                recipeCost += recepieItem.getCost();
            }
        }
        portionCost = recipeCost * this.getPortion() / this.getYield();
        this.setCost(portionCost);
    }

    @Override
    public Double getPortion() {
        return super.getPortion() == 0.0 ? 1.0 : super.getPortion();
    }

    @Override
    public Double getYield() {
        return super.getYield() == 0.0 ? 1.0 : super.getYield();
    }

    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    public Boolean isVisible() {
        return this.visible == null ? false : this.visible;
    }

    public void populateRecipeItemQuantity(Double mainItemQty, HashMap<InvMapKey, Double> recepieItemMap, double itemQuantity) {
        List<RecepieItem> recepieItems = this.getRecepieItems();
        if (recepieItems == null || recepieItems.size() == 0) {
            return;
        }
        for (RecepieItem recepieItem : recepieItems) {
            MenuItem inventoryItem = recepieItem.getInventoryItem();
            String unitCode = recepieItem.getUnitCode();
            if (inventoryItem == null || !inventoryItem.isInventoryItem().booleanValue()) continue;
            InvMapKey menuItemUnitKey = new InvMapKey(inventoryItem.getId(), unitCode);
            Double previousValue = recepieItemMap.get(menuItemUnitKey);
            if (previousValue == null) {
                previousValue = 0.0;
            }
            Double toBeAdjustQty = previousValue + itemQuantity * recepieItem.getQuantity() * mainItemQty;
            recepieItemMap.put(menuItemUnitKey, toBeAdjustQty);
        }
    }

    public Double getCookingYield() {
        return this.cookingYield == null ? 1.0 : this.cookingYield;
    }

    public void setCookingYield(Double cookingYield) {
        this.cookingYield = cookingYield;
    }

    @XmlTransient
    public String getMenuItemName() {
        return DataProvider.get().getRecipeMenuItemName(this);
    }

    public void setMenuItemName(String menuItemName) {
    }

    public void populateRecipeItems(HashMap<String, RecepieItem> recepieItemMap, double itemQuantity, Recepie recipe, boolean group) {
        List<RecepieItem> recepieItems = this.getRecepieItems();
        if (recepieItems == null || recepieItems.size() == 0) {
            return;
        }
        for (RecepieItem recepieItem : recepieItems) {
            MenuItem inventoryItem = recepieItem.getInventoryItem();
            if (inventoryItem == null) continue;
            Double percentage = 0.0;
            String key = inventoryItem.getId();
            if (!group) {
                key = recipe.getId() + "-" + key;
            }
            RecepieItem item = recepieItemMap.get(key);
            RecipeTable recipeTable = RecipeTableDAO.getInstance().findBy(key);
            if (recipeTable != null) continue;
            if (item == null) {
                item = new RecepieItem();
                item.setRecepie(recipe);
                item.setInventoryItem(recepieItem.getInventoryItem());
                item.setUnit(recepieItem.getUnit());
                item.setUnitCode(recepieItem.getUnitCode());
                if (!group) {
                    recepieItemMap.put(recipe.getId() + "-" + key, item);
                } else {
                    recepieItemMap.put(key, item);
                }
            }
            item.setGroupName(recipe.getName());
            item.setGroupId(recipe.getId());
            percentage = recepieItem.getPercentage() / 100.0;
            Double toBeAdjustQty = NumberUtil.roundToTwoDigit(item.getQuantity() + itemQuantity * percentage);
            item.setQuantity(toBeAdjustQty);
        }
    }

    public int getCookingMin() {
        int timeInSeconds = this.getCookingTime();
        int hours = timeInSeconds / 3600;
        int secondsLeft = timeInSeconds - hours * 3600;
        int minutes = secondsLeft / 60;
        return minutes;
    }
}

