/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.Messages;
import com.floreantpos.model.ShopTableTicket;
import com.floreantpos.model.TableStatus;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseShopTableStatus;
import com.floreantpos.model.base.BaseShopTableTicket;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"userName"})
@XmlRootElement
public class ShopTableStatus
extends BaseShopTableStatus
implements TimedModel {
    private static final long serialVersionUID = 1L;
    public static final String SEAT_TIME = "seat.time";
    private transient JsonObject propertiesContainer;
    private boolean shouldPublishMqtt = true;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
        this.updateSyncTime = shouldUpdateSyncTime;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
        this.updateLastUpdateTime = shouldUpdateUpdateTime;
    }

    public ShopTableStatus() {
    }

    public ShopTableStatus(Integer id) {
        super(id);
    }

    public TableStatus getTableStatus() {
        Integer tableStatus = super.getTableStatusNum();
        return TableStatus.get(tableStatus);
    }

    public void setTableStatus(TableStatus tableStatus) {
        super.setTableStatusNum(tableStatus.getValue());
    }

    public List<ShopTableTicket> getTicketNumbers() {
        String ticketInformations = this.getTicketInformations();
        if (StringUtils.isEmpty((String)ticketInformations)) {
            return null;
        }
        Gson gson = new Gson();
        List fromJson = (List)gson.fromJson(ticketInformations, new TypeToken<List<ShopTableTicket>>(){}.getType());
        return fromJson;
    }

    public void setTicketNumbers(List<ShopTableTicket> ticketNumbers) {
        if (ticketNumbers == null || ticketNumbers.size() == 0) {
            this.setTicketInformations(null);
            return;
        }
        JsonArray jsonArray = new JsonArray();
        for (ShopTableTicket shopTableTicket : ticketNumbers) {
            jsonArray.add(shopTableTicket.toJson());
        }
        this.setTicketInformations(jsonArray.toString());
    }

    public String getTicketId() {
        List<String> ticketNumbers = this.getListOfTicketNumbers();
        if (ticketNumbers != null && ticketNumbers.size() > 0) {
            return ticketNumbers.get(0);
        }
        return null;
    }

    public List<String> getListOfTicketNumbers() {
        List<ShopTableTicket> shopTableTickets = this.getTicketNumbers();
        ArrayList<String> listOfTicketNumbers = new ArrayList<String>();
        if (shopTableTickets != null) {
            for (ShopTableTicket shopTableTicket : shopTableTickets) {
                listOfTicketNumbers.add(shopTableTicket.getTicketId());
            }
        }
        return listOfTicketNumbers;
    }

    public boolean hasMultipleTickets() {
        List<ShopTableTicket> ticketNumbers = this.getTicketNumbers();
        return ticketNumbers != null && ticketNumbers.size() > 0;
    }

    public void setTicketId(String ticketId) {
        this.setTableTicket(ticketId, null, null, null);
    }

    public void setTableTicket(String ticketId, Integer tokenNo, String userId, String userFirstName) {
        this.setTableTicket(ticketId, tokenNo, userId, userFirstName, null);
    }

    public void setTableTicket(String ticketId, Integer tokenNo, String userId, String userFirstName, Date ticketCreateTime) {
        if (ticketId == null) {
            this.setTableStatus(TableStatus.Available);
            this.setTicketNumbers(null);
        } else {
            BaseShopTableTicket shopTableTicket = null;
            List<ShopTableTicket> shopTableTickets = this.getTicketNumbers();
            if (shopTableTickets != null && !shopTableTickets.isEmpty()) {
                for (ShopTableTicket shopT : shopTableTickets) {
                    if (!shopT.getTicketId().equals(ticketId)) continue;
                    shopTableTicket = shopT;
                }
            } else {
                shopTableTickets = new ArrayList<ShopTableTicket>();
            }
            if (shopTableTicket == null) {
                shopTableTicket = new ShopTableTicket();
                shopTableTickets.add((ShopTableTicket)shopTableTicket);
            }
            shopTableTicket.setTicketId(ticketId);
            shopTableTicket.setTokenNo(tokenNo);
            shopTableTicket.setUserId(userId);
            shopTableTicket.setUserName(userFirstName);
            shopTableTicket.setTicketCreateTime(ticketCreateTime);
            this.setTicketNumbers(shopTableTickets);
        }
    }

    public void addToTableTickets(List<Ticket> tickets) {
        if (tickets == null) {
            return;
        }
        ArrayList<String> existingTicketIds = new ArrayList<String>();
        List<ShopTableTicket> shopTableTickets = this.getTicketNumbers();
        if (shopTableTickets == null) {
            shopTableTickets = new ArrayList<ShopTableTicket>();
        }
        for (ShopTableTicket shopTableTicket : shopTableTickets) {
            String ticketId = shopTableTicket.getTicketId();
            if (ticketId == null) continue;
            existingTicketIds.add(ticketId);
        }
        for (Ticket ticket : tickets) {
            if (existingTicketIds.contains(ticket.getId())) continue;
            ShopTableTicket shopTableTicket = new ShopTableTicket();
            shopTableTicket.setTicketId(ticket.getId());
            shopTableTicket.setTokenNo(ticket.getTokenNo());
            shopTableTicket.setUserId(ticket.getOwner().getId());
            shopTableTicket.setUserName(ticket.getOwner().getFirstName());
            shopTableTicket.setTicketCreateTime(ticket.getCreateDate());
            shopTableTickets.add(shopTableTicket);
        }
        this.setTicketNumbers(shopTableTickets);
    }

    public String getUserId() {
        List<ShopTableTicket> shopTableTickets = this.getTicketNumbers();
        if (shopTableTickets == null || shopTableTickets.isEmpty()) {
            return null;
        }
        return shopTableTickets.get(0).getUserId();
    }

    public String getUserName() {
        List<ShopTableTicket> shopTableTickets = this.getTicketNumbers();
        if (shopTableTickets == null || shopTableTickets.isEmpty()) {
            return "";
        }
        int size = shopTableTickets.size();
        if (size > 1) {
            ArrayList<String> userIds = new ArrayList<String>();
            for (ShopTableTicket shopTableTicket : shopTableTickets) {
                if (userIds.contains(shopTableTicket.getUserId())) continue;
                userIds.add(shopTableTicket.getUserId());
            }
            if (userIds.size() > 1) {
                return Messages.getString("ShopTableStatus.2");
            }
        }
        return shopTableTickets.get(0).getUserName();
    }

    public String getTokenNo() {
        List<ShopTableTicket> shopTableTickets = this.getTicketNumbers();
        if (shopTableTickets == null || shopTableTickets.isEmpty()) {
            return "";
        }
        int size = shopTableTickets.size();
        if (size == 1) {
            return String.valueOf(shopTableTickets.get(0).getTokenNo());
        }
        String displayString = "";
        int count = 1;
        Iterator<ShopTableTicket> iterator = shopTableTickets.iterator();
        while (iterator.hasNext()) {
            ShopTableTicket shopTableTicket = iterator.next();
            displayString = displayString + String.valueOf(shopTableTicket.getTokenNo());
            if (count == 4) break;
            ++count;
            if (!iterator.hasNext()) continue;
            displayString = displayString + ",";
        }
        return displayString;
    }

    public Date getLastTicketCreateTime() {
        String ticketInformations = this.getTicketInformations();
        if (StringUtils.isEmpty((String)ticketInformations)) {
            return null;
        }
        Gson gson = new Gson();
        List fromJson = (List)gson.fromJson(ticketInformations, new TypeToken<List<ShopTableTicket>>(){}.getType());
        if (fromJson == null || fromJson.isEmpty()) {
            return null;
        }
        Collections.sort(fromJson, new Comparator<ShopTableTicket>(){

            @Override
            public int compare(ShopTableTicket o1, ShopTableTicket o2) {
                if (o1 == null || o2 == null) {
                    return 1;
                }
                if (o1.getTicketCreateTime() == null || o2.getTicketCreateTime() == null) {
                    return 1;
                }
                return o1.getTicketCreateTime().compareTo(o2.getTicketCreateTime());
            }
        });
        return ((ShopTableTicket)fromJson.get(0)).getTicketCreateTime();
    }

    @Override
    public String getProperties() {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.toString();
        }
        String properties = super.getProperties();
        if (StringUtils.isEmpty((String)properties)) {
            return null;
        }
        this.propertiesContainer = (JsonObject)new Gson().fromJson(properties, JsonObject.class);
        return properties;
    }

    @Override
    public void setProperties(String properties) {
        super.setProperties(properties);
        this.propertiesContainer = (JsonObject)new Gson().fromJson(properties, JsonObject.class);
    }

    public void addProperty(String key, String value) {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = new JsonObject();
        }
        this.propertiesContainer.addProperty(key, value);
    }

    public String getProperty(String key) {
        JsonElement jsonElement;
        if (this.propertiesContainer == null) {
            return null;
        }
        if (this.propertiesContainer.has(key) && !(jsonElement = this.propertiesContainer.get(key)).isJsonNull()) {
            return jsonElement.getAsString();
        }
        return null;
    }

    public boolean hasProperty(String key) {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.has(key);
        }
        return false;
    }

    public boolean isPropertyValueTrue(String propertyName) {
        String property = this.getProperty(propertyName);
        return POSUtil.getBoolean(property);
    }

    public void removeProperty(String propertyName) {
        if (this.propertiesContainer != null) {
            this.propertiesContainer.remove(propertyName);
        }
    }

    public boolean isShouldPublishMqtt() {
        return this.shouldPublishMqtt;
    }

    public void setShouldPublishMqtt(boolean shouldPublishMqtt) {
        this.shouldPublishMqtt = shouldPublishMqtt;
    }
}

