/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.model.CustomerGroup;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseSiiopaCustomer;
import com.floreantpos.model.dao.CustomerGroupDAO;
import com.floreantpos.util.AESencrp;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.swing.ImageIcon;
import org.apache.commons.lang.StringUtils;

public class SiiopaCustomer
extends BaseSiiopaCustomer
implements TimedModel {
    private static final long serialVersionUID = 1L;
    private Boolean selected;
    private transient JsonObject propertiesContainer;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;

    public SiiopaCustomer() {
    }

    public SiiopaCustomer(String id) {
        super(id);
    }

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
        this.updateSyncTime = shouldUpdateSyncTime;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
        this.updateLastUpdateTime = shouldUpdateUpdateTime;
    }

    @Override
    public String toString() {
        String fName = this.getName();
        if (fName == null) {
            fName = this.getEmail();
        }
        return fName;
    }

    public ImageIcon getImage() {
        return null;
    }

    @Override
    public String getName() {
        String name = super.getFirstName();
        if (StringUtils.isNotEmpty((String)super.getLastName())) {
            name = name + " " + super.getLastName();
        }
        return name;
    }

    @Override
    public void setMobileNo(String mobileNo) {
        if (StringUtils.isNotEmpty((String)mobileNo)) {
            mobileNo = mobileNo.replaceAll("(\\+)?\\D", "$1");
        }
        super.setMobileNo(mobileNo);
    }

    @Override
    public void setWorkPhoneNo(String workPhoneNo) {
        if (StringUtils.isNotEmpty((String)workPhoneNo)) {
            workPhoneNo = workPhoneNo.replaceAll("(\\+)?\\D", "$1");
        }
        super.setWorkPhoneNo(workPhoneNo);
    }

    @Override
    public void setHomePhoneNo(String homePhoneNo) {
        if (StringUtils.isNotEmpty((String)homePhoneNo)) {
            homePhoneNo = homePhoneNo.replaceAll("(\\+)?\\D", "$1");
        }
        super.setHomePhoneNo(homePhoneNo);
    }

    public Boolean isSelected() {
        return this.selected == null ? Boolean.FALSE : this.selected;
    }

    public void setSelected(Boolean enable) {
        this.selected = enable;
    }

    public CustomerGroup getCustomerGroup() {
        if (StringUtils.isNotEmpty((String)this.getCustomerGroupId())) {
            return CustomerGroupDAO.getInstance().get(this.getCustomerGroupId());
        }
        return null;
    }

    public void setCustomerGroup(CustomerGroup customerGroup) {
        String customerGroupId = null;
        if (customerGroup != null) {
            customerGroupId = customerGroup.getId();
        }
        super.setCustomerGroupId(customerGroupId);
    }

    public void setEncryptedSecretCode(String secretCode) {
        try {
            this.setSecretCode(AESencrp.encrypt((String)secretCode));
        }
        catch (Exception e) {
            this.setSecretCode(secretCode);
        }
    }

    public String getUnencryptedSecretCode() {
        String secretKey = this.getSecretCode();
        if (StringUtils.isNotEmpty((String)secretKey)) {
            try {
                secretKey = AESencrp.decrypt((String)secretKey);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return secretKey;
    }

    public void setEncryptedPin(String pin) {
        try {
            this.setPin(AESencrp.encrypt((String)pin));
        }
        catch (Exception e) {
            this.setPin(pin);
        }
    }

    public String getUnencryptedPin() {
        String pin = this.getPin();
        if (StringUtils.isNotEmpty((String)pin)) {
            try {
                pin = AESencrp.decrypt((String)pin);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return pin;
    }

    @Override
    public String getProperties() {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.toString();
        }
        String properties = super.getProperties();
        if (StringUtils.isEmpty((String)properties)) {
            return null;
        }
        this.propertiesContainer = (JsonObject)new Gson().fromJson(properties, JsonObject.class);
        return properties;
    }

    @Override
    public void setProperties(String properties) {
        super.setProperties(properties);
        if (StringUtils.isNotEmpty((String)properties)) {
            this.propertiesContainer = (JsonObject)new Gson().fromJson(properties, JsonObject.class);
        }
    }

    public void addProperty(String key, String value) {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = new JsonObject();
        }
        if (StringUtils.isNotEmpty((String)value)) {
            this.propertiesContainer.addProperty(key, value);
        }
    }

    public String getProperty(String key) {
        JsonElement jsonElement;
        if (this.propertiesContainer == null) {
            return null;
        }
        if (this.propertiesContainer.has(key) && !(jsonElement = this.propertiesContainer.get(key)).isJsonNull()) {
            return jsonElement.getAsString();
        }
        return null;
    }

    public boolean hasProperty(String key) {
        return this.getProperty(key) != null;
    }

    public boolean isPropertyValueTrue(String propertyName) {
        String property = this.getProperty(propertyName);
        return POSUtil.getBoolean(property);
    }

    public void removeProperty(String propertyName) {
        if (this.propertiesContainer != null) {
            this.propertiesContainer.remove(propertyName);
        }
    }
}

