/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.TipsReceivedBy;
import com.floreantpos.model.WorkingHours;
import com.floreantpos.model.base.BaseStore;
import com.floreantpos.model.util.DataProvider;
import com.orocube.siiopa.common.model.SubscriptionStatus;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

@JsonIgnoreProperties(ignoreUnknown=true, value={"storeLogo", "loginScreenBackground", "loginScreenBgImageResource", "databaseVersion", "softwareVersion", "softwareNumericVersion", "tableSeatForeColor", "tableServingForeColor", "tableServingBGColor", "tableBookForeColor", "tableBookBGColor", "tableBookBGColor", "tableFreeForeColor", "tableFreeBGColor", "tableSeatBGColor", "workingHours"})
@XmlRootElement(name="restaurant")
public class Store
extends BaseStore
implements TimedModel {
    private static final long serialVersionUID = 1L;
    public static final String STORE_PROP_DEFAULT_RESERVATION_OWNER = "Reservation.owner";
    public static final String STORE_PROP_DEFAULT_RESERVATION_ORDERTYPE = "Reservation.ordertype";
    public static final String STORE_PROP_RESERVATION_MERGE_IF_SAME_USER = "Reservation.Merge_If_Same_Member";
    public static final String STORE_PROP_RESERVATION_LOGGED_IN_USER = "Reservation.Logged_In_User_As_Owner";
    public static final String STORE_PROP_RESERVATION_DEFAULT_SALES_AREA = "Reservation.Default_Sales_Area";
    public static final String STORE_PROP_AUTOMATICALLY_SYNC_CHARGES_WHEN_DAY_CLOSED = "Charges.Automatically_Sync_Day";
    public static final String STORE_PROP_SUBSCRIPTION_SUFFIX = ".subscribed";
    public static final String STORE_PROP_SUBSCRIPTION_STATUS_SUFFIX = ".status";
    public static final String STORE_PROP_SUBSCRIPTION_START_DATE_SUFFIX = ".subscription.start_date";
    public static final String STORE_PROP_SUBSCRIPTION_END_DATE_SUFFIX = ".subscription.end_date";
    public static final String STORE_PROP_SUBSCRIPTION_PLAN_ID_SUFFIX = ".plan_id";
    public static final String STORE_PROP_EXTRA_MULTIPLIER = "multiplier.extra";
    public static final String STORE_PROP_HALF_MULTIPLIER = "multiplier.half";
    public static final String STORE_PROP_QUARTER_MULTIPLIER = "multiplier.quarter";
    public static final String STORE_PROP_SUPPRESS_ZERO_COST_MODIFIER = "suppress.zerocost.modifiers";
    public static final String STORE_PROP_FLORIDA_TAX_RULE = "tax.apply_florida_rule";
    public static final String RESET_TOKEN = "reset.token";
    public static final String TOKEN_NO_START_FROM = "token_no.start";
    public static final String ONLINE_PICKUP_ORDER_TYPE = "online.ordertype.pickup";
    public static final String ONLINE_DELIVERY_ORDER_TYPE = "online.ordertype.delivery";
    public static final String ONLINE_ORDER_PAYMENT_CASH_ON_DELIVERY = "online_order.payment.cash_on_delivery";
    public static final String ONLINE_ORDER_PAYMENT_CARD = "online_order.payment.card";
    public static final String ONLINE_ORDER_PAYMENT_CARD_GATEWAY = "online_order.payment.card.gateway";
    public static final String ONLINE_ORDER_AUTHNET_MERCHANTE_ID = "online_order.auth_net.merchantId";
    public static final String ONLINE_ORDER_AUTHNET_API_LOGIN_ID = "online_order.auth_net.apiLoginId";
    public static final String ONLINE_ORDER_AUTHNET_SANDBOX_MODE = "online_order.auth_net.sandbox_mode";
    @XmlTransient
    private ImageIcon storeLogo;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    private List<WorkingHours> workingHours;

    public Store() {
    }

    public Store(String id) {
        super(id);
    }

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
        this.updateSyncTime = shouldUpdateSyncTime;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
        this.updateLastUpdateTime = shouldUpdateUpdateTime;
    }

    @Override
    public Map<String, String> getProperties() {
        Map<String, String> map = super.getProperties();
        if (map == null) {
            map = new HashMap<String, String>();
        }
        return map;
    }

    public boolean hasProperty(String key) {
        return this.getProperty(key) != null;
    }

    public String getProperty(String key) {
        Map<String, String> properties = this.getProperties();
        if (properties == null) {
            return null;
        }
        return properties.get(key);
    }

    public String getProperty(String key, String defaultValue) {
        String string = this.getProperties().get(key);
        if (StringUtils.isEmpty((String)string)) {
            string = defaultValue;
        }
        return string;
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) {
        String string = this.getProperties().get(key);
        if (StringUtils.isBlank((String)string)) {
            return defaultValue;
        }
        return Boolean.valueOf(string);
    }

    public void addProperty(String key, String value) {
        this.getProperties().put(key, value);
    }

    @Override
    public String getCurrencyName() {
        String currencyName = super.getCurrencyName();
        if (StringUtils.isEmpty((String)currencyName)) {
            return "Sample Currency";
        }
        return currencyName;
    }

    @Override
    public String getCurrencySymbol() {
        String currencySymbol = super.getCurrencySymbol();
        if (StringUtils.isEmpty((String)currencySymbol)) {
            currencySymbol = "$";
        }
        return currencySymbol;
    }

    public boolean isAllwMemberbasedPOI() {
        String update = this.getProperty("inventory.allowMemberPOI");
        if (StringUtils.isEmpty((String)update)) {
            return false;
        }
        return Boolean.valueOf(update);
    }

    public boolean isUpdateOnHandBlncForSale() {
        String update = this.getProperty("inventory.updateOnHandBlnceForSale");
        if (StringUtils.isEmpty((String)update)) {
            return true;
        }
        return Boolean.valueOf(update);
    }

    public boolean isUpdateAvlBlncForSale() {
        String update = this.getProperty("inventory.updateAvlBlnceForSale");
        if (StringUtils.isEmpty((String)update)) {
            return true;
        }
        return Boolean.valueOf(update);
    }

    public boolean isAllwNegOnHandBlnce() {
        String update = this.getProperty("inventory.allowNegetiveOnHandBalance");
        if (StringUtils.isEmpty((String)update)) {
            return false;
        }
        return Boolean.valueOf(update);
    }

    public boolean isUpdateAvlBlncForPOCreated() {
        String update = this.getProperty("inventory.updateAvailBalanceForPurchaseOrderCreated");
        if (StringUtils.isEmpty((String)update)) {
            return false;
        }
        return Boolean.valueOf(update);
    }

    public boolean isUpdateOnHandBlncForPORec() {
        String update = this.getProperty("inventory.updateOnHandBalanceForPurchaseOrderReceived");
        if (StringUtils.isEmpty((String)update)) {
            return true;
        }
        return Boolean.valueOf(update);
    }

    public String getImageId() {
        String oldLogoResourceId;
        String storeLogoResourceId = this.getProperty("logo.imageid");
        if (StringUtils.isEmpty((String)storeLogoResourceId) && (oldLogoResourceId = this.getProperty("ticket.header.logo.imageid")) != null) {
            this.addProperty("logo.imageid", oldLogoResourceId);
            return oldLogoResourceId;
        }
        return storeLogoResourceId;
    }

    @XmlTransient
    public ImageIcon getStoreLogo() {
        if (this.storeLogo == null) {
            String storeLogoResourceId = this.getImageId();
            if (StringUtils.isEmpty((String)storeLogoResourceId)) {
                return null;
            }
            ImageResource logoResource = DataProvider.get().getImageResource(storeLogoResourceId);
            if (logoResource != null) {
                this.storeLogo = logoResource.getButtonBigImage();
            }
        }
        return this.storeLogo;
    }

    public boolean isInventoryAvgPricingMethod() {
        String property = this.getProperty("inventory.pricing.method");
        if (property == null) {
            return false;
        }
        return property.equals("avg");
    }

    public void setStoreLogo(ImageIcon storeLogo) {
        this.storeLogo = storeLogo;
    }

    @XmlTransient
    public ImageIcon getLoginScreenBackground() {
        String resourceId = this.getProperty("loginscreen.background");
        if (resourceId == null) {
            return null;
        }
        ImageResource imageResource = IconFactory.getImageResource(resourceId);
        if (imageResource != null && imageResource.getImageBytes() != null) {
            return new ImageIcon(imageResource.getImageBytes());
        }
        return null;
    }

    @XmlTransient
    public ImageResource getLoginScreenBgImageResource() {
        String resourceId = this.getProperty("loginscreen.background");
        if (resourceId == null) {
            return null;
        }
        return IconFactory.getImageResource(resourceId);
    }

    public void setLoginScreenBackgroundId(String resourceId) {
        this.addProperty("loginscreen.background", resourceId);
    }

    public static String getWebServiceUrl() {
        Store store = DataProvider.get().getStore();
        return store.getProperty("web.service.url") + "/service/data/store/" + store.getProperty("web.service.schema");
    }

    public TipsReceivedBy getTipsReceivedByForDeliveryOrder() {
        try {
            String tipsReceiver = this.getProperty("tips.receiver.delivery");
            if (StringUtils.isNotEmpty((String)tipsReceiver)) {
                return TipsReceivedBy.valueOf(tipsReceiver);
            }
            return TipsReceivedBy.Server;
        }
        catch (Exception e) {
            throw new PosException(Messages.getString("Store.8"));
        }
    }

    public TipsReceivedBy getTipsReceivedByForNonDeliveryOrder() {
        try {
            String tipsReceiver = this.getProperty("tips.receiver.nonDelivery");
            if (StringUtils.isNotEmpty((String)tipsReceiver)) {
                return TipsReceivedBy.valueOf(tipsReceiver);
            }
            return TipsReceivedBy.Server;
        }
        catch (Exception e) {
            throw new PosException(Messages.getString("Store.9"));
        }
    }

    public double getOvertimeMarkup() {
        try {
            String overtimeMarkup = this.getProperty("overtime.markup");
            if (StringUtils.isNotEmpty((String)overtimeMarkup)) {
                return Double.parseDouble(overtimeMarkup);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0.0;
    }

    public boolean hasCreateMemberPermission() {
        try {
            String memberCreate = this.getProperty("member.create.permission");
            if (StringUtils.isNotEmpty((String)memberCreate)) {
                return Boolean.valueOf(memberCreate);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    @XmlTransient
    @JsonIgnoreProperties
    public Integer getDatabaseVersion() {
        String property = this.getProperty("database.version");
        try {
            return Integer.parseInt(property);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setDatabaseVersion(int verson) {
        this.addProperty("database.version", String.valueOf(verson));
    }

    @XmlTransient
    @JsonIgnoreProperties
    public String getSoftwareVersion() {
        return this.getProperty("software.version");
    }

    public void setSoftwareVersion(String version) {
        this.addProperty("software.version", version);
    }

    @XmlTransient
    @JsonIgnoreProperties
    public Integer getSoftwareNumericVersion() {
        String property = this.getProperty("software.numeric.version");
        try {
            return Integer.parseInt(property);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setSoftwareNumericVersion(int verson) {
        this.addProperty("software.numeric.version", String.valueOf(verson));
    }

    public boolean isAutoSyncCharges() {
        return this.getBooleanProperty(STORE_PROP_AUTOMATICALLY_SYNC_CHARGES_WHEN_DAY_CLOSED, Boolean.FALSE);
    }

    public boolean isAllowPenyRounding() {
        try {
            String penyRoundAmnt = this.getProperty("store.peny.rounding");
            if (StringUtils.isNotEmpty((String)penyRoundAmnt)) {
                return Boolean.valueOf(penyRoundAmnt);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isAllowMulDiscount() {
        try {
            String strAllowMulDis = this.getProperty("store.allow.multiple.discount");
            if (StringUtils.isNotEmpty((String)strAllowMulDis)) {
                return Boolean.valueOf(strAllowMulDis);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isShowVoidedItemsOnTicket() {
        String showVoidedItem = this.getProperty("ticket.show_voided_item");
        if (StringUtils.isNotEmpty((String)showVoidedItem)) {
            return Boolean.valueOf(showVoidedItem);
        }
        return true;
    }

    public void setShowVoidedItemsOnTicket(boolean show) {
        this.addProperty("ticket.show_voided_item", String.valueOf(show));
    }

    public int getCustomerMonitorDisplayOption() {
        try {
            String displayOptionString = this.getProperty("customer.monitor.display.option");
            if (StringUtils.isNotEmpty((String)displayOptionString)) {
                return Integer.parseInt(displayOptionString);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public int getCustomerMonitorDisplaySlideDuration() {
        try {
            String slideDurationString = this.getProperty("customer.monitor.slide.duration");
            if (StringUtils.isNotEmpty((String)slideDurationString)) {
                return Integer.parseInt(slideDurationString);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 5;
    }

    public String getServerUrl() {
        try {
            String serverUrl = this.getProperty("update_server_url");
            if (StringUtils.isNotEmpty((String)serverUrl)) {
                return serverUrl;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public void setTablePrimaryFontSize(int priFont) {
        this.addProperty("floorplan.primaryFontSize", String.valueOf(priFont));
    }

    public int getTablePrimaryFontSize() {
        return this.getProperty("floorplan.primaryFontSize") == null ? 14 : Integer.valueOf(this.getProperty("floorplan.primaryFontSize"));
    }

    public void setTableSecondaryFontSize(int secFont) {
        this.addProperty("floorplan.secondaryFontSize", String.valueOf(secFont));
    }

    public int getTableSecondaryFontSize() {
        return this.getProperty("floorplan.secondaryFontSize") == null ? 9 : Integer.valueOf(this.getProperty("floorplan.secondaryFontSize"));
    }

    public void setTableBtnWidth(int btnWidth) {
        this.addProperty("floorplan.btnWidth", String.valueOf(btnWidth));
    }

    public int getTableBtnWidth() {
        return this.getProperty("floorplan.btnWidth") == null ? 100 : Integer.valueOf(this.getProperty("floorplan.btnWidth"));
    }

    public void setTableBtnHeight(int btnHeight) {
        this.addProperty("floorplan.btnHeight", String.valueOf(btnHeight));
    }

    public int getTableBtnHeight() {
        return this.getProperty("floorplan.btnHeight") == null ? 80 : Integer.valueOf(this.getProperty("floorplan.btnHeight"));
    }

    public void setTableSeatForeColor(Color seatForeColor) {
        this.addProperty("floorplan.seatForeColor", seatForeColor != null ? String.valueOf(seatForeColor.getRGB()) : "");
    }

    @XmlTransient
    public Color getTableSeatForeColor() {
        return Color.BLACK;
    }

    public void setTableSeatBGColor(Color seatBgColor) {
        this.addProperty("floorplan.seatBGColor", seatBgColor != null ? String.valueOf(seatBgColor.getRGB()) : "");
    }

    @XmlTransient
    public Color getTableSeatBGColor() {
        return new Color(249, 105, 14);
    }

    public void setTableServingForeColor(Color servingForeColor) {
        this.addProperty("floorplan.servingForeColor", servingForeColor != null ? String.valueOf(servingForeColor.getRGB()) : "");
    }

    @XmlTransient
    public Color getTableServingForeColor() {
        return Color.WHITE;
    }

    public void setTableServingBGColor(Color servingBgColor) {
        this.addProperty("floorplan.servingBGColor", servingBgColor != null ? String.valueOf(servingBgColor.getRGB()) : "");
    }

    @XmlTransient
    public Color getTableServingBGColor() {
        return new Color(240, 52, 52);
    }

    public void setTableBookForeColor(Color bookForeColor) {
        this.addProperty("floorplan.bookForeColor", bookForeColor != null ? String.valueOf(bookForeColor.getRGB()) : "");
    }

    @XmlTransient
    public Color getTableBookForeColor() {
        return Color.BLACK;
    }

    public void setTableBookBGColor(Color bookBgColor) {
        this.addProperty("floorplan.bookBGColor", bookBgColor != null ? String.valueOf(bookBgColor.getRGB()) : "");
    }

    @XmlTransient
    public Color getTableBookBGColor() {
        return Color.YELLOW;
    }

    public void setTableFreeForeColor(Color freeForeColor) {
        this.addProperty("floorplan.freeForeColor", freeForeColor != null ? String.valueOf(freeForeColor.getRGB()) : "");
    }

    @XmlTransient
    public Color getTableFreeForeColor() {
        return Color.black;
    }

    public void setTableFreeBGColor(Color freeBgColor) {
        this.addProperty("floorplan.freeBGColor", freeBgColor != null ? String.valueOf(freeBgColor.getRGB()) : "");
    }

    @XmlTransient
    public Color getTableFreeBGColor() {
        return Color.white;
    }

    public boolean isShowTableNameOnTable() {
        return Boolean.valueOf(this.getProperty("floorplan.showTableName", "false"));
    }

    public boolean isShowTableNumberOnTable() {
        return Boolean.valueOf(this.getProperty("floorplan.showTableNumber", "true"));
    }

    public boolean isShowServerNameOnTable() {
        return Boolean.valueOf(this.getProperty("floorplan.showServerName", "true"));
    }

    public boolean isShowTokenNumberOnTable() {
        return Boolean.valueOf(this.getProperty("floorplan.showTokenName", "true"));
    }

    public void setShowTableNameOnTable(boolean show) {
        this.addProperty("floorplan.showTableName", String.valueOf(show));
    }

    public void setShowTableNumberOnTable(boolean show) {
        this.addProperty("floorplan.showTableNumber", String.valueOf(show));
    }

    public void setShowServerNameOnTable(boolean show) {
        this.addProperty("floorplan.showServerName", String.valueOf(show));
    }

    public void setShowTokenNumberOnTable(boolean show) {
        this.addProperty("floorplan.showTokenName", String.valueOf(show));
    }

    public boolean isShowCustomerNameOnTable() {
        return Boolean.valueOf(this.getProperty("floorplan.showCustomerName", "false"));
    }

    public void setShowCustomerNameOnTable(boolean show) {
        this.addProperty("floorplan.showCustomerName", String.valueOf(show));
    }

    public boolean isShowResIdOnTable() {
        return Boolean.valueOf(this.getProperty("floorplan.showResId", "false"));
    }

    public void setShowResIdOnTable(boolean show) {
        this.addProperty("floorplan.showResId", String.valueOf(show));
    }

    public boolean isShowTableStatusOnTable() {
        return Boolean.valueOf(this.getProperty("floorplan.showTableStatus", "false"));
    }

    public void setShowTableStatusOnTable(boolean show) {
        this.addProperty("floorplan.showTableStatus", String.valueOf(show));
    }

    public boolean isKDSenabled() {
        return Boolean.valueOf(this.getProperty("kdsenabled", "false"));
    }

    public void setKDSenabled(boolean enabled) {
        this.addProperty("kdsenabled", Boolean.toString(enabled));
    }

    @Deprecated
    public boolean isShowTransparentBtnOnTable() {
        return false;
    }

    @Deprecated
    public void setShowTransparentBtnOnTable(boolean selected) {
    }

    public String getSendGridSenderEmail() {
        return this.getProperty("store.sendgrid.sender.email", null);
    }

    public void setSendGridSenderEmail(String email) {
        this.addProperty("store.sendgrid.sender.email", email);
    }

    public String getSendGridApiKey() {
        return this.getProperty("store.sendgrid.api.key", null);
    }

    public void setSendGridApiKey(String apiKey) {
        this.addProperty("store.sendgrid.api.key", apiKey);
    }

    public String getAdminEmail() {
        return this.getProperty("store.admin.email", null);
    }

    public void setAdminEmail(String email) {
        this.addProperty("store.admin.email", email);
    }

    public void setDateFormat(String dateFormat) {
        this.addProperty("default_date_format", dateFormat);
    }

    public String getDateFormat() {
        return this.getProperty("default_date_format", "dd-MMM-yy");
    }

    public Boolean isSubscriptionActive(String productId) {
        if (StringUtils.isEmpty((String)productId)) {
            return null;
        }
        Boolean isSubacribed = this.isSubscribed(productId);
        SubscriptionStatus subscriptionStatus = this.getSubscriptionStatus(productId);
        return isSubacribed != false && (subscriptionStatus == SubscriptionStatus.ACTIVE || subscriptionStatus == SubscriptionStatus.TRIALING);
    }

    public void setSubscribed(String productId, Boolean subscribed) {
        if (StringUtils.isEmpty((String)productId)) {
            return;
        }
        String key = productId + STORE_PROP_SUBSCRIPTION_SUFFIX;
        String value = String.valueOf(subscribed != null && subscribed != false);
        this.addProperty(key, value);
    }

    public Boolean isSubscribed(String productId) {
        if (StringUtils.isEmpty((String)productId)) {
            return null;
        }
        String key = productId + STORE_PROP_SUBSCRIPTION_SUFFIX;
        String property = this.getProperty(key);
        if (StringUtils.isNotEmpty((String)property)) {
            return Boolean.parseBoolean(property);
        }
        return Boolean.FALSE;
    }

    public void setSubscriptionStatus(String productId, SubscriptionStatus subscriptionStatus) {
        if (StringUtils.isEmpty((String)productId)) {
            return;
        }
        String key = productId + STORE_PROP_SUBSCRIPTION_STATUS_SUFFIX;
        this.addProperty(key, subscriptionStatus.getStatusName());
    }

    public SubscriptionStatus getSubscriptionStatus(String productId) {
        if (StringUtils.isEmpty((String)productId)) {
            return null;
        }
        String key = productId + STORE_PROP_SUBSCRIPTION_STATUS_SUFFIX;
        String property = this.getProperty(key);
        return SubscriptionStatus.fromName((String)property);
    }

    public void setSubscriptionStartDate(String productId, Long subscriptionStartDate) {
        if (StringUtils.isEmpty((String)productId) || subscriptionStartDate == null) {
            return;
        }
        String key = productId + STORE_PROP_SUBSCRIPTION_START_DATE_SUFFIX;
        this.addProperty(key, String.valueOf(subscriptionStartDate));
    }

    public Long getSubscriptionStartDate(String productId) {
        if (StringUtils.isEmpty((String)productId)) {
            return null;
        }
        String key = productId + STORE_PROP_SUBSCRIPTION_START_DATE_SUFFIX;
        String property = this.getProperty(key);
        if (StringUtils.isEmpty((String)property)) {
            return null;
        }
        return Long.parseLong(property);
    }

    public void setSubscriptionEndDate(String productId, Long subscriptionEndDate) {
        if (StringUtils.isEmpty((String)productId) || subscriptionEndDate == null) {
            return;
        }
        String key = productId + STORE_PROP_SUBSCRIPTION_END_DATE_SUFFIX;
        this.addProperty(key, String.valueOf(subscriptionEndDate));
    }

    public Long getSubscriptionEndDate(String productId) {
        if (StringUtils.isEmpty((String)productId)) {
            return null;
        }
        String key = productId + STORE_PROP_SUBSCRIPTION_END_DATE_SUFFIX;
        String property = this.getProperty(key);
        if (StringUtils.isEmpty((String)property)) {
            return null;
        }
        return Long.parseLong(property);
    }

    public void setSubscriptionPlanId(String productId, String subscriptionPlanId) {
        if (StringUtils.isEmpty((String)productId)) {
            return;
        }
        String key = productId + STORE_PROP_SUBSCRIPTION_PLAN_ID_SUFFIX;
        this.addProperty(key, subscriptionPlanId);
    }

    public String getSubscriptionPlanId(String productId) {
        if (StringUtils.isEmpty((String)productId)) {
            return null;
        }
        String key = productId + STORE_PROP_SUBSCRIPTION_PLAN_ID_SUFFIX;
        String property = this.getProperty(key);
        return property;
    }

    public Boolean hasExtraMultiplier() {
        String extraMultiplierId = this.getProperty(STORE_PROP_EXTRA_MULTIPLIER);
        return StringUtils.isNotEmpty((String)extraMultiplierId);
    }

    public Multiplier getExtraMultiplier() {
        return this.getExtraMultiplier(null);
    }

    public Multiplier getExtraMultiplier(Multiplier defaultMultiplier) {
        if (this.hasExtraMultiplier().booleanValue()) {
            String extraMultiplierId = this.getProperty(STORE_PROP_EXTRA_MULTIPLIER);
            Multiplier extraMultiplier = DataProvider.get().getMultiplierById(extraMultiplierId);
            return extraMultiplier;
        }
        return defaultMultiplier;
    }

    public Store setExtraMultiplier(Multiplier multiplier) {
        if (multiplier != null) {
            this.addProperty(STORE_PROP_EXTRA_MULTIPLIER, multiplier.getId());
        } else {
            this.addProperty(STORE_PROP_EXTRA_MULTIPLIER, null);
        }
        return this;
    }

    public Boolean hasHalfMultiplier() {
        String halfMultiplierId = this.getProperty(STORE_PROP_HALF_MULTIPLIER);
        return StringUtils.isNotEmpty((String)halfMultiplierId);
    }

    public Multiplier getHalfMultiplier() {
        return this.getHalfMultiplier(null);
    }

    public Multiplier getHalfMultiplier(Multiplier defaultMultiplier) {
        if (this.hasHalfMultiplier().booleanValue()) {
            String halfMultiplierId = this.getProperty(STORE_PROP_HALF_MULTIPLIER);
            Multiplier halfMultiplier = DataProvider.get().getMultiplierById(halfMultiplierId);
            return halfMultiplier;
        }
        return defaultMultiplier;
    }

    public Store setHalfMultiplier(Multiplier multiplier) {
        if (multiplier != null) {
            this.addProperty(STORE_PROP_HALF_MULTIPLIER, multiplier.getId());
        } else {
            this.addProperty(STORE_PROP_HALF_MULTIPLIER, null);
        }
        return this;
    }

    public Boolean hasQuarterMultiplier() {
        String quarterMultiplierId = this.getProperty(STORE_PROP_QUARTER_MULTIPLIER);
        return StringUtils.isNotEmpty((String)quarterMultiplierId);
    }

    public Multiplier getQuarterMultiplier() {
        return this.getQuarterMultiplier(null);
    }

    public Multiplier getQuarterMultiplier(Multiplier defaultMultiplier) {
        if (this.hasQuarterMultiplier().booleanValue()) {
            String quarterMultiplierId = this.getProperty(STORE_PROP_QUARTER_MULTIPLIER);
            Multiplier quarterMultiplier = DataProvider.get().getMultiplierById(quarterMultiplierId);
            return quarterMultiplier;
        }
        return defaultMultiplier;
    }

    public Store setQuarterMultiplier(Multiplier multiplier) {
        if (multiplier != null) {
            this.addProperty(STORE_PROP_QUARTER_MULTIPLIER, multiplier.getId());
        } else {
            this.addProperty(STORE_PROP_QUARTER_MULTIPLIER, null);
        }
        return this;
    }

    public boolean isEnableFloridaTaxRule() {
        String update = this.getProperty(STORE_PROP_FLORIDA_TAX_RULE);
        if (StringUtils.isBlank((String)update)) {
            return Boolean.FALSE;
        }
        return Boolean.valueOf(update);
    }

    public void setEnableFloridaTaxRule(boolean isApply) {
        this.addProperty(STORE_PROP_FLORIDA_TAX_RULE, String.valueOf(isApply));
    }

    @XmlTransient
    public List<WorkingHours> getWorkingHours() {
        if (this.workingHours == null) {
            this.workingHours = new ArrayList<WorkingHours>();
            for (int i = 1; i <= 7; ++i) {
                WorkingHours workingHour = this.getWorkingHours(i);
                if (workingHour == null) continue;
                this.workingHours.add(workingHour);
            }
        }
        return this.workingHours;
    }

    public WorkingHours getWorkingHours(int day) {
        if (!this.getBooleanProperty(day + ".Open", true)) {
            return null;
        }
        String dayString = WorkingHours.days[day];
        return new WorkingHours(day, this.getProperty(dayString + ".StartTime"), this.getProperty(dayString + ".EndTime"));
    }

    public void setWorkingHours(List<WorkingHours> workingHours) {
        this.workingHours = workingHours;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public boolean isEnableMultiUploadButton() {
        return this.getBooleanProperty("MULTI_UPLOAD_BUTTON", Boolean.FALSE);
    }

    public void setEnableMultiUploadButton(boolean isEnable) {
        this.addProperty("MULTI_UPLOAD_BUTTON", String.valueOf(isEnable));
    }

    public boolean isEnableCreditCardSurcharge() {
        return this.getBooleanProperty("ENABLE_CREDITCARD_SURCHARGE", Boolean.FALSE);
    }

    public void setEnableCreditCardSurcharge(boolean isEnable) {
        this.addProperty("ENABLE_CREDITCARD_SURCHARGE", String.valueOf(isEnable));
    }

    public void setSurchargeRule(String surchargeRuleArray) {
        this.addProperty("SurchargeRule", surchargeRuleArray);
    }

    public String getSurchargeRule() {
        return this.getProperty("SurchargeRule", "");
    }

    public Double getPercentagesAmountByCardType(String cardTypeName) {
        if (StringUtils.isBlank((String)cardTypeName)) {
            return 0.0;
        }
        String cardTypePercentages = this.getSurchargeRule();
        if (StringUtils.isBlank((String)cardTypePercentages)) {
            return 0.0;
        }
        JSONArray jsonArray = new JSONArray(cardTypePercentages);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String name = jsonObject.getString("name");
            if (!cardTypeName.equals(name)) continue;
            return jsonObject.getDouble("percentages");
        }
        return 0.0;
    }
}

