/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.floreantpos.Messages;
import com.floreantpos.main.Application;
import com.floreantpos.model.ComboGroup;
import com.floreantpos.model.ComboTicketItem;
import com.floreantpos.model.Course;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifiableTicketItem;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PosPrinters;
import com.floreantpos.model.Printer;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.Tax;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItemCookingInstruction;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.TicketItemTax;
import com.floreantpos.model.User;
import com.floreantpos.model.VirtualPrinter;
import com.floreantpos.model.VoidItem;
import com.floreantpos.model.base.BaseTicketItem;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.ext.KitchenStatus;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.JsonUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.OrgJsonUtil;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.beans.Transient;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

@JsonIgnoreProperties(ignoreUnknown=true, value={"inventoryAdjusted", "menuItem"})
@XmlSeeAlso(value={ModifiableTicketItem.class, ComboTicketItem.class})
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="classType")
@JsonSubTypes(value={@JsonSubTypes.Type(value=ModifiableTicketItem.class), @JsonSubTypes.Type(value=ComboTicketItem.class)})
public class TicketItem
extends BaseTicketItem
implements ITicketItem {
    public static final String JSON_PROP_VOID_ID = "voidId";
    private static final String JSON_PROP_VOID_ADJUSTED = "voidedAdjusted";
    public static final String JSON_PROP_MODIIFIER_VOID_IDS = "modifierVoidIds";
    public static final String JSON_PROP_VOID_REASON = "voidReason";
    public static final String JSON_PROP_VOID_QUANTITY = "voidQuantity";
    public static final String JSON_PROP_WASTED = "wasted";
    public static final String JSON_PROP_PRINTED_TO_KITCHEN = "originalItemPrintedToKitchen";
    public static final String JSON_PROP_RETURNED = "returned";
    public static final String JSON_PROP_RETURNED_ITEM_VOIDED = "returnedVoided";
    public static final String JSON_PROP_DELETABLE_VOID_ITEM = "deletableVoidItem";
    public static final String PROPERTY_COOKING_INSTRUCTION = "COOKING_INSTRUCTION";
    public static final String JSON_PROP_GIFT_CARD_PAID_AMOUNT = "gift_card_paid_amount";
    public static final String JSON_PROP_VOIDED_BY_USER = "voidedByUserId";
    public static final String JSON_PROP_SURCHARGE_ITEM_NAME = "CC Surcharge";
    public static final String PROPERTY_TAX = "TAX";
    public static final String PROPERTY_DISCOUNT = "DISCOUNT";
    private static final long serialVersionUID = 1L;
    private transient boolean syncEdited;
    private transient com.google.gson.JsonObject propertiesContainer;
    private String classType;
    private MenuItem menuItem;
    private int tableRowNum;
    private Double quantityToShip;
    public static final int HALF = 0;
    public static final int FULL = 1;
    public static final int SHARED_FULL = 2;
    public static final int SHARED_CUSTOM = 3;
    private Boolean includeVoidQuantity;
    private List<TicketItemCookingInstruction> cookingInstructions;
    private List<TicketItemTax> taxes;
    private List<TicketItemDiscount> discounts;
    private TicketItem parentTicketItem;
    private Integer sortOrder;

    public TicketItem() {
        this.setCreateDate(StoreDAO.getServerTimestamp());
    }

    public TicketItem(String id) {
        super(id);
        this.setCreateDate(StoreDAO.getServerTimestamp());
    }

    public TicketItem(Ticket ticket, String name, double unitPrice, double quantity, TicketItemTax tax) {
        this.setName(name);
        this.setUnitPrice(unitPrice);
        this.setQuantity(quantity);
        this.addTotaxes(tax);
        this.setTicket(ticket);
        this.setCreateDate(StoreDAO.getServerTimestamp());
    }

    public TicketItem createNew() {
        if (this instanceof ModifiableTicketItem) {
            return new ModifiableTicketItem();
        }
        return new TicketItem();
    }

    public Boolean isHasModifiers() {
        List<TicketItemModifier> ticketItemModifiers = this.getTicketItemModifiers();
        return ticketItemModifiers != null && ticketItemModifiers.size() > 0;
    }

    public TicketItemModifier getSizeModifier() {
        return null;
    }

    public void setSizeModifier(TicketItemModifier sizeModifier) {
    }

    public List<TicketItemModifier> getTicketItemModifiers() {
        return null;
    }

    public void setTicketItemModifiers(List<TicketItemModifier> ticketItemModifiers) {
    }

    public void addToticketItemModifiers(TicketItemModifier ticketItemModifier) {
    }

    public TicketItem clone() {
        return (TicketItem)SerializationUtils.clone((Serializable)this);
    }

    public TicketItem cloneAsNew() {
        return this.cloneAsNew(false);
    }

    public TicketItem cloneAsNew(boolean needToCheeckPrintStatus) {
        try {
            TicketItem newTicketItem = (TicketItem)SerializationUtils.clone((Serializable)this);
            newTicketItem.setId(null);
            newTicketItem.setCreateDate(StoreDAO.getServerTimestamp());
            newTicketItem.setVersion(0L);
            newTicketItem.setPrintedToKitchen(needToCheeckPrintStatus && newTicketItem.isPrintedToKitchen() != false);
            newTicketItem.setInventoryAdjustQty(0.0);
            newTicketItem.setCloudSynced(false);
            newTicketItem.setHasSyncError(false);
            newTicketItem.setSeat(null);
            if (newTicketItem.getSizeModifier() != null) {
                newTicketItem.getSizeModifier().setId(null);
                newTicketItem.getSizeModifier().setPrintedToKitchen(false);
            }
            List<TicketItemModifier> ticketItemModifiers = newTicketItem.getTicketItemModifiers();
            newTicketItem.setTicketItemModifiers(null);
            if (ticketItemModifiers != null && ticketItemModifiers.size() > 0) {
                for (TicketItemModifier ticketItemModifier : ticketItemModifiers) {
                    ticketItemModifier.setId(null);
                    ticketItemModifier.setPrintedToKitchen(false);
                    newTicketItem.addToticketItemModifiers(ticketItemModifier);
                }
            }
            List<TicketItem> comboItems = newTicketItem.getComboItems();
            ArrayList<TicketItem> newComboItems = new ArrayList<TicketItem>();
            if (this.isComboItem().booleanValue()) {
                ComboTicketItem comboTicketItem = (ComboTicketItem)newTicketItem;
                if (comboItems != null) {
                    for (TicketItem oldComboItem : comboItems) {
                        TicketItem clonedCombo = oldComboItem.cloneAsNew(needToCheeckPrintStatus);
                        clonedCombo.setId(null);
                        clonedCombo.setComboItems(null);
                        clonedCombo.setParentTicketItem(comboTicketItem);
                        newComboItems.add(clonedCombo);
                    }
                    comboTicketItem.setComboItems(newComboItems);
                }
                return comboTicketItem;
            }
            newTicketItem.setComboItems(null);
            return newTicketItem;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setTaxes(List<TicketItemTax> taxes) {
        this.taxes = taxes;
        this.buildTaxes();
    }

    public List<TicketItemTax> getTaxes() {
        if (this.taxes == null) {
            this.taxes = new ArrayList<TicketItemTax>();
            String property = super.getTaxesProperty();
            if (StringUtils.isNotEmpty((String)property)) {
                JsonReader jsonParser = Json.createReader((Reader)new StringReader(property));
                JsonArray jsonArray = jsonParser.readArray();
                jsonParser.close();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonObject jsonObject = (JsonObject)jsonArray.get(i);
                    TicketItemTax tit = new TicketItemTax();
                    tit.setId(JsonUtil.getString(jsonObject, TicketItemTax.PROP_ID));
                    tit.setName(JsonUtil.getString(jsonObject, TicketItemTax.PROP_NAME));
                    tit.setSfName(JsonUtil.getString(jsonObject, TicketItemTax.PROP_SF_NAME));
                    tit.setRate(JsonUtil.getDouble(jsonObject, TicketItemTax.PROP_RATE));
                    tit.setTaxAmount(JsonUtil.getDouble(jsonObject, TicketItemTax.PROP_TAX_AMOUNT));
                    this.taxes.add(tit);
                }
            }
        }
        return this.taxes;
    }

    public void addTotaxes(TicketItemTax tax) {
        this.taxes = this.getTaxes();
        if (this.taxes == null) {
            this.taxes = new ArrayList<TicketItemTax>();
        }
        this.taxes.add(tax);
    }

    public void buildTaxes() {
        if (this.taxes == null || this.taxes.isEmpty()) {
            this.setTaxesProperty(null);
            return;
        }
        JSONArray jsonArray = new JSONArray();
        for (TicketItemTax ticketItemTax : this.taxes) {
            jsonArray.put((Object)ticketItemTax.toJson());
        }
        this.setTaxesProperty(jsonArray.toString());
    }

    public void setDiscounts(List<TicketItemDiscount> discounts) {
        this.discounts = discounts;
    }

    public List<TicketItemDiscount> getDiscounts() {
        if (this.discounts == null) {
            this.discounts = new ArrayList<TicketItemDiscount>();
            String property = super.getDiscountsProperty();
            if (StringUtils.isNotEmpty((String)property)) {
                JSONArray jsonArray = new JSONArray(property);
                for (int i = 0; i < jsonArray.length(); ++i) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    TicketItemDiscount tid = new TicketItemDiscount();
                    tid.setTicketItem(this);
                    tid.setDiscountId(OrgJsonUtil.getString(jsonObject, TicketItemDiscount.PROP_DISCOUNT_ID));
                    tid.setName(OrgJsonUtil.getString(jsonObject, TicketItemDiscount.PROP_NAME));
                    tid.setType(OrgJsonUtil.getInt(jsonObject, TicketItemDiscount.PROP_TYPE));
                    tid.setAutoApply(OrgJsonUtil.getBoolean(jsonObject, TicketItemDiscount.PROP_AUTO_APPLY));
                    tid.setCouponQuantity(OrgJsonUtil.getDouble(jsonObject, TicketItemDiscount.PROP_COUPON_QUANTITY));
                    tid.setMinimumAmount(OrgJsonUtil.getDouble(jsonObject, TicketItemDiscount.PROP_MINIMUM_AMOUNT));
                    tid.setValue(OrgJsonUtil.getDouble(jsonObject, TicketItemDiscount.PROP_VALUE));
                    tid.setAmount(OrgJsonUtil.getDouble(jsonObject, TicketItemDiscount.PROP_AMOUNT));
                    this.discounts.add(tid);
                }
            }
        }
        return this.discounts;
    }

    public void addTodiscounts(TicketItemDiscount discount) {
        this.discounts = this.getDiscounts();
        if (this.discounts == null) {
            this.discounts = new ArrayList<TicketItemDiscount>();
        }
        this.discounts.add(discount);
        ActionHistoryDAO.addTicketItemDiscountAddedActionHistory(this.getTicket(), discount);
    }

    public void buildDiscounts() {
        if (this.discounts == null || this.discounts.isEmpty()) {
            this.setDiscountsProperty(null);
            return;
        }
        JSONArray jsonArray = new JSONArray();
        for (TicketItemDiscount ticketItemDiscount : this.discounts) {
            jsonArray.put((Object)ticketItemDiscount.toJson());
        }
        this.setDiscountsProperty(jsonArray.toString());
    }

    public int getTableRowNum() {
        return this.tableRowNum;
    }

    public void setTableRowNum(int tableRowNum) {
        this.tableRowNum = tableRowNum;
    }

    @Override
    public boolean canAddCookingInstruction() {
        return this.isPrintedToKitchen() == false;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public void setCookingInstructions(List<TicketItemCookingInstruction> cookingInstructions) {
        this.cookingInstructions = cookingInstructions;
        this.buildCoookingInstructions();
    }

    public void addCookingInstructions(List<TicketItemCookingInstruction> instructions) {
        this.cookingInstructions = this.getCookingInstructions();
        if (this.cookingInstructions == null) {
            this.cookingInstructions = new ArrayList<TicketItemCookingInstruction>(2);
        }
        for (TicketItemCookingInstruction ticketItemCookingInstruction : instructions) {
            this.addCookingInstruction(ticketItemCookingInstruction);
        }
    }

    public void addCookingInstruction(TicketItemCookingInstruction cookingInstruction) {
        this.cookingInstructions = this.getCookingInstructions();
        if (this.cookingInstructions == null) {
            this.cookingInstructions = new ArrayList<TicketItemCookingInstruction>();
            return;
        }
        this.cookingInstructions.add(cookingInstruction);
        this.buildCoookingInstructions();
    }

    public void buildCoookingInstructions() {
        if (this.cookingInstructions == null || this.cookingInstructions.isEmpty()) {
            this.setCookingInstructionsProperty(null);
            return;
        }
        JSONArray jsonArray = new JSONArray();
        for (TicketItemCookingInstruction cookingIns : this.cookingInstructions) {
            jsonArray.put((Object)cookingIns.toJson());
        }
        this.setCookingInstructionsProperty(jsonArray.toString());
    }

    public void removeCookingInstruction(TicketItemCookingInstruction itemCookingInstruction) {
        List<TicketItemCookingInstruction> cookingInstructions2 = this.getCookingInstructions();
        if (cookingInstructions2 == null || cookingInstructions2.size() == 0) {
            return;
        }
        Iterator<TicketItemCookingInstruction> iterator = cookingInstructions2.iterator();
        while (iterator.hasNext()) {
            TicketItemCookingInstruction ticketItemCookingInstruction = iterator.next();
            if (ticketItemCookingInstruction.getTableRowNum() != itemCookingInstruction.getTableRowNum()) continue;
            iterator.remove();
            this.buildCoookingInstructions();
            return;
        }
    }

    public TicketItemModifier findTicketItemModifierFor(MenuModifier menuModifier) {
        List<TicketItemModifier> modifiers = this.getTicketItemModifiers();
        if (modifiers == null) {
            return null;
        }
        for (TicketItemModifier ticketItemModifier : modifiers) {
            String itemId = ticketItemModifier.getItemId();
            if (itemId == null || !itemId.equals(menuModifier.getId())) continue;
            return ticketItemModifier;
        }
        return null;
    }

    public TicketItemModifier addTicketItemModifier(MenuModifier menuModifier, int modifierType, OrderType type, Multiplier multiplier) {
        return this.addTicketItemModifier(menuModifier, modifierType, type, multiplier, 1.0);
    }

    public TicketItemModifier addTicketItemModifier(MenuModifier menuModifier, int modifierType, OrderType type, Multiplier multiplier, double quantity) {
        TicketItemModifier ticketItemModifier = new TicketItemModifier();
        ticketItemModifier.setTaxIncluded(Application.getInstance().isPriceIncludesTax());
        ticketItemModifier.setItemId(menuModifier.getId());
        ticketItemModifier.setPageItemId(menuModifier.getPageItemId());
        MenuItemModifierSpec menuItemModifierGroup = menuModifier.getMenuItemModifierGroup();
        if (menuItemModifierGroup != null) {
            ticketItemModifier.setGroupId(menuItemModifierGroup.getId());
        }
        ticketItemModifier.setItemQuantity(quantity);
        ticketItemModifier.setName(menuModifier.getDisplayName());
        double price = menuModifier.getPriceForMultiplier(multiplier);
        if (multiplier != null) {
            ticketItemModifier.setMultiplierName(multiplier.getId());
            ticketItemModifier.setName(multiplier.getTicketPrefix() + " " + menuModifier.getDisplayName());
        }
        ticketItemModifier.setUnitPrice(price);
        if (menuModifier.isTaxable().booleanValue()) {
            ticketItemModifier.setTaxable(true);
            ticketItemModifier.setTaxSameAsItem(menuModifier.isTaxSameAsItem());
            ticketItemModifier.setTaxes(menuModifier.getTaxByOrderType(this.getTicket().getOrderType(), this));
        } else {
            ticketItemModifier.setTaxable(false);
            ticketItemModifier.setTaxSameAsItem(false);
            ticketItemModifier.setTaxes(null);
        }
        ticketItemModifier.setModifierType(modifierType);
        ticketItemModifier.setShouldPrintToKitchen(menuModifier.isShouldPrintToKitchen());
        ticketItemModifier.setTicketItem(this);
        if (StringUtils.isNotEmpty((String)menuModifier.getTranslatedName())) {
            ticketItemModifier.addProperty("translatedName", menuModifier.getTranslatedName());
        }
        this.addToticketItemModifiers(ticketItemModifier);
        return ticketItemModifier;
    }

    public TicketItemModifier addTicketItemModifier(MenuModifier menuModifier, boolean addOn) {
        TicketItemModifier ticketItemModifier = new TicketItemModifier();
        ticketItemModifier.setTaxIncluded(Application.getInstance().isPriceIncludesTax());
        ticketItemModifier.setItemId(menuModifier.getId());
        MenuItemModifierSpec menuItemModifierGroup = menuModifier.getMenuItemModifierGroup();
        if (menuItemModifierGroup != null) {
            ticketItemModifier.setGroupId(menuItemModifierGroup.getId());
        }
        ticketItemModifier.setItemCount(1);
        ticketItemModifier.setName(menuModifier.getDisplayName());
        if (addOn) {
            ticketItemModifier.setUnitPrice(menuModifier.getExtraPrice());
            ticketItemModifier.setModifierType(3);
        } else {
            ticketItemModifier.setUnitPrice(menuModifier.getPrice());
            ticketItemModifier.setModifierType(1);
        }
        if (menuModifier.isTaxable().booleanValue()) {
            ticketItemModifier.setTaxable(true);
            ticketItemModifier.setTaxSameAsItem(menuModifier.isTaxSameAsItem());
            ticketItemModifier.setTaxes(menuModifier.getTaxByOrderType(this.getTicket().getOrderType(), this));
        } else {
            ticketItemModifier.setTaxable(false);
            ticketItemModifier.setTaxSameAsItem(false);
            ticketItemModifier.setTaxes(null);
        }
        ticketItemModifier.setTaxSameAsItem(menuModifier.isTaxSameAsItem());
        ticketItemModifier.setShouldPrintToKitchen(menuModifier.isShouldPrintToKitchen());
        ticketItemModifier.setTicketItem(this);
        this.addToticketItemModifiers(ticketItemModifier);
        return ticketItemModifier;
    }

    public void updateModifiersUnitPrice(double defaultSellPortion) {
        List<TicketItemModifier> ticketItemModifiers = this.getTicketItemModifiers();
        if (ticketItemModifiers != null) {
            for (TicketItemModifier ticketItemModifier : ticketItemModifiers) {
                if (ticketItemModifier.isInfoOnly().booleanValue()) continue;
                ticketItemModifier.setUnitPrice(ticketItemModifier.getUnitPrice() * defaultSellPortion / 100.0);
            }
        }
    }

    public void updateModifiersUnitPriceByGroup(MenuItemModifierSpec group) {
        List<TicketItemModifier> ticketItemModifiers = this.getTicketItemModifiers();
        ArrayList<TicketItemModifier> groupModifiers = new ArrayList<TicketItemModifier>();
        if (ticketItemModifiers != null) {
            double numOfModifiers = 0.0;
            for (TicketItemModifier ticketItemModifier : ticketItemModifiers) {
                if (ticketItemModifier.isInfoOnly().booleanValue() || !ticketItemModifier.getGroupId().equals(group.getId())) continue;
                groupModifiers.add(ticketItemModifier);
                numOfModifiers += ticketItemModifier.getItemQuantity().doubleValue();
            }
            Double groupPrice = group.getPrice((int)numOfModifiers);
            if (groupPrice != null && numOfModifiers > 0.0) {
                for (TicketItemModifier ticketItemModifier : groupModifiers) {
                    ticketItemModifier.setUnitPrice(ticketItemModifier.getMultiplierPrice(groupPrice / (double)((int)numOfModifiers)));
                }
            }
        }
    }

    public boolean contains(TicketItemModifier ticketItemModifier) {
        List<TicketItemModifier> ticketItemModifiers = this.getTicketItemModifiers();
        int count = 0;
        if (ticketItemModifiers != null) {
            for (TicketItemModifier ticketItemModifier2 : ticketItemModifiers) {
                if (ticketItemModifier2.isInfoOnly().booleanValue() || !ticketItemModifier.getName().trim().equals(ticketItemModifier2.getName().trim())) continue;
                ++count;
            }
        }
        return count > 1;
    }

    public TicketItemModifier removeTicketItemModifier(TicketItemModifier ticketItemModifier) {
        List<TicketItemModifier> ticketItemModifiers = this.getTicketItemModifiers();
        if (ticketItemModifiers == null) {
            return ticketItemModifier;
        }
        Iterator<TicketItemModifier> iter = ticketItemModifiers.iterator();
        while (iter.hasNext()) {
            TicketItemModifier oldTicketItemModifier = iter.next();
            if (!oldTicketItemModifier.getItemId().equals(ticketItemModifier.getItemId()) || oldTicketItemModifier.getModifierType() != ticketItemModifier.getModifierType()) continue;
            iter.remove();
            return oldTicketItemModifier;
        }
        return ticketItemModifier;
    }

    public TicketItemModifier removeTicketItemModifier(int modifierIndex) {
        List<TicketItemModifier> ticketItemModifiers = this.getTicketItemModifiers();
        if (ticketItemModifiers == null) {
            return null;
        }
        TicketItemModifier ticketItemModifier = ticketItemModifiers.get(modifierIndex);
        ticketItemModifiers.remove(modifierIndex);
        return ticketItemModifier;
    }

    public void calculatePrice() {
        if (this.isTreatAsSeat().booleanValue()) {
            return;
        }
        BigDecimal unitPrice = NumberUtil.convertToBigDecimal(this.getUnitPrice());
        BigDecimal itemQuantity = NumberUtil.convertToBigDecimal(this.getQuantity());
        BigDecimal subtotalWithoutModifiers = unitPrice.multiply(itemQuantity);
        BigDecimal discountWithoutModifiers = this.calculateDiscount(subtotalWithoutModifiers);
        BigDecimal serviceCharge = this.calculateServiceCharge(subtotalWithoutModifiers);
        BigDecimal modifierSubtotal = NumberUtil.convertToBigDecimal("0");
        BigDecimal modifierDiscount = NumberUtil.convertToBigDecimal("0");
        BigDecimal taxableModifierAmount = NumberUtil.convertToBigDecimal("0");
        BigDecimal taxWithoutModifiers = null;
        BigDecimal tax = null;
        List<TicketItemModifier> ticketItemModifiers = this.getTicketItemModifiers();
        if (ticketItemModifiers != null) {
            HashSet<String> averagePricedModifierList = new HashSet<String>();
            for (TicketItemModifier modifier : ticketItemModifiers) {
                if (modifier.isInfoOnly().booleanValue()) continue;
                modifier.calculatePrice();
                if (modifier.isShouldSectionWisePrice().booleanValue() && averagePricedModifierList.contains(modifier.getItemId())) continue;
                modifierSubtotal = modifierSubtotal.add(NumberUtil.convertToBigDecimal(modifier.getSubTotalAmount()));
                modifierDiscount = modifierDiscount.add(NumberUtil.convertToBigDecimal(modifier.getDiscountAmount()));
                if (modifier.isTaxable()) {
                    taxableModifierAmount = taxableModifierAmount.add(NumberUtil.convertToBigDecimal(modifier.getSubTotalAmount() - modifier.getDiscountAmount()));
                }
                serviceCharge = serviceCharge.add(NumberUtil.convertToBigDecimal(modifier.getServiceCharge()));
                averagePricedModifierList.add(modifier.getItemId());
            }
        }
        BigDecimal subtotal = subtotalWithoutModifiers.add(modifierSubtotal);
        BigDecimal discount = discountWithoutModifiers.add(modifierDiscount);
        if (this.isTaxOnServiceCharge().booleanValue()) {
            taxWithoutModifiers = this.calculateTax(subtotalWithoutModifiers.subtract(discountWithoutModifiers).add(serviceCharge));
            tax = this.calculateTax(subtotalWithoutModifiers.subtract(discountWithoutModifiers).add(taxableModifierAmount).add(serviceCharge));
        } else {
            taxWithoutModifiers = this.calculateTax(subtotalWithoutModifiers.subtract(discountWithoutModifiers));
            tax = this.calculateTax(subtotalWithoutModifiers.subtract(discountWithoutModifiers).add(taxableModifierAmount));
        }
        BigDecimal total = NumberUtil.convertToBigDecimal("0");
        BigDecimal totalWithoutModifiers = NumberUtil.convertToBigDecimal("0");
        if (this.getTicket() != null && this.getTicket().isTaxIncluded().booleanValue()) {
            total = subtotal.subtract(discount).add(serviceCharge);
            totalWithoutModifiers = subtotalWithoutModifiers.subtract(discountWithoutModifiers).add(serviceCharge);
        } else {
            total = subtotal.subtract(discount).add(tax).add(serviceCharge);
            totalWithoutModifiers = subtotalWithoutModifiers.subtract(discountWithoutModifiers).add(taxWithoutModifiers).add(serviceCharge);
        }
        this.setSubtotalAmount(NumberUtil.round(subtotal.doubleValue()));
        this.setSubtotalAmountWithoutModifiers(NumberUtil.round(subtotalWithoutModifiers.doubleValue()));
        this.setDiscountAmount(NumberUtil.round(discount.doubleValue()));
        this.setDiscountWithoutModifiers(NumberUtil.round(discountWithoutModifiers.doubleValue()));
        this.setTaxAmount(NumberUtil.round(tax.doubleValue()));
        this.setTaxAmountWithoutModifiers(NumberUtil.round(taxWithoutModifiers.doubleValue()));
        this.setServiceCharge(NumberUtil.round(serviceCharge.doubleValue()));
        this.setTotalAmount(NumberUtil.round(total.doubleValue()));
        this.setTotalAmountWithoutModifiers(NumberUtil.round(totalWithoutModifiers.doubleValue()));
        this.setAdjustedUnitPrice(unitPrice.doubleValue());
        this.setAdjustedDiscount(NumberUtil.round(discount.doubleValue()));
        this.setAdjustedDiscountWithoutModifiers(NumberUtil.round(discountWithoutModifiers.doubleValue()));
        this.setAdjustedSubtotal(NumberUtil.round(subtotal.doubleValue()));
        this.setAdjustedSubtotalWithoutModifiers(NumberUtil.round(subtotalWithoutModifiers.doubleValue()));
        this.setAdjustedTax(NumberUtil.round(tax.doubleValue()));
        this.setAdjustedTaxWithoutModifiers(NumberUtil.round(taxWithoutModifiers.doubleValue()));
        this.setAdjustedTotal(NumberUtil.round(total.doubleValue()));
        this.setAdjustedTotalWithoutModifiers(NumberUtil.round(totalWithoutModifiers.doubleValue()));
    }

    public void calculateAdjustedPrice() {
        BigDecimal subtotalAfterDiscount;
        if (this.isTreatAsSeat().booleanValue()) {
            return;
        }
        Ticket ticket = this.getTicket();
        if (ticket == null) {
            return;
        }
        BigDecimal ticketSubtotalAmount = NumberUtil.convertToBigDecimal(ticket.getSubtotalAmountWithVoidItems());
        BigDecimal ticketDiscountAmount = NumberUtil.convertToBigDecimal(ticket.getTicketDiscountAmount());
        BigDecimal itemDiscountAmount = NumberUtil.convertToBigDecimal(ticket.getItemDiscountAmount());
        BigDecimal ticketSubtotalAfterItemDiscount = ticketSubtotalAmount.subtract(itemDiscountAmount);
        BigDecimal ticketSubtotalAfterAllDiscount = ticketSubtotalAfterItemDiscount.subtract(ticketDiscountAmount);
        BigDecimal adjustedSubtotalWithoutModifiers = subtotalAfterDiscount = NumberUtil.convertToBigDecimal(this.getSubtotalAmountWithoutModifiers()).subtract(NumberUtil.convertToBigDecimal(this.getDiscountWithoutModifiers()));
        if (ticketSubtotalAfterItemDiscount.compareTo(BigDecimal.ZERO) != 0) {
            adjustedSubtotalWithoutModifiers = subtotalAfterDiscount.multiply(ticketSubtotalAfterAllDiscount).divide(ticketSubtotalAfterItemDiscount, 4, RoundingMode.HALF_UP);
        }
        BigDecimal serviceCharge = NumberUtil.convertToBigDecimal(this.getServiceCharge());
        BigDecimal adjustedTaxWithoutModifiers = this.calculateTax(adjustedSubtotalWithoutModifiers.add(serviceCharge));
        BigDecimal itemQuantity = NumberUtil.convertToBigDecimal(this.getQuantity());
        BigDecimal adjustedUnitPrice = adjustedSubtotalWithoutModifiers.divide(itemQuantity, 4, RoundingMode.HALF_UP);
        BigDecimal modifierAdjustedSubtotal = NumberUtil.convertToBigDecimal("0");
        BigDecimal modifierAdjustedDiscount = NumberUtil.convertToBigDecimal("0");
        BigDecimal modifierAdjustedTax = NumberUtil.convertToBigDecimal("0");
        List<TicketItemModifier> ticketItemModifiers = this.getTicketItemModifiers();
        if (ticketItemModifiers != null) {
            HashSet<String> averagePricedModifierList = new HashSet<String>();
            for (TicketItemModifier modifier : ticketItemModifiers) {
                if (modifier.isInfoOnly().booleanValue()) continue;
                modifier.calculateAdjustedPrice();
                if (!modifier.isShouldSectionWisePrice().booleanValue() && averagePricedModifierList.contains(modifier.getItemId())) continue;
                modifierAdjustedSubtotal = modifierAdjustedSubtotal.add(itemQuantity.multiply(NumberUtil.convertToBigDecimal(modifier.getAdjustedSubtotal()).abs()));
                modifierAdjustedDiscount = modifierAdjustedDiscount.add(itemQuantity.multiply(NumberUtil.convertToBigDecimal(modifier.getAdjustedDiscount()).abs()));
                modifierAdjustedTax = modifierAdjustedTax.add(itemQuantity.multiply(NumberUtil.convertToBigDecimal(modifier.getAdjustedTax()).abs()));
                averagePricedModifierList.add(modifier.getItemId());
            }
        }
        BigDecimal adjustedSubtotal = adjustedSubtotalWithoutModifiers.add(modifierAdjustedSubtotal);
        BigDecimal myAdjustedDiscountWithoutModifiers = NumberUtil.convertToBigDecimal(this.getSubtotalAmountWithoutModifiers()).subtract(adjustedSubtotalWithoutModifiers);
        BigDecimal adjustedDiscount = myAdjustedDiscountWithoutModifiers.add(modifierAdjustedDiscount);
        BigDecimal adjustedTax = adjustedTaxWithoutModifiers.add(modifierAdjustedTax);
        BigDecimal adjustedTotal = NumberUtil.convertToBigDecimal(0.0);
        BigDecimal adjustedTotalWithoutModifiers = NumberUtil.convertToBigDecimal(0.0);
        if (this.isTaxIncluded().booleanValue()) {
            adjustedTotal = adjustedSubtotal.add(serviceCharge);
            adjustedTotalWithoutModifiers = adjustedSubtotalWithoutModifiers.add(serviceCharge);
        } else {
            adjustedTotal = adjustedSubtotal.add(adjustedTax).add(serviceCharge);
            adjustedTotalWithoutModifiers = adjustedSubtotalWithoutModifiers.add(adjustedTaxWithoutModifiers).add(serviceCharge);
        }
        this.setAdjustedUnitPrice(NumberUtil.round(adjustedUnitPrice.doubleValue()));
        this.setAdjustedDiscount(NumberUtil.round(adjustedDiscount.doubleValue()));
        this.setAdjustedDiscountWithoutModifiers(NumberUtil.round(myAdjustedDiscountWithoutModifiers.doubleValue()));
        this.setAdjustedSubtotal(NumberUtil.round(adjustedSubtotal.doubleValue()));
        this.setAdjustedSubtotalWithoutModifiers(NumberUtil.round(adjustedSubtotalWithoutModifiers.doubleValue()));
        this.setAdjustedTax(NumberUtil.round(adjustedTax.doubleValue()));
        this.setAdjustedTaxWithoutModifiers(NumberUtil.round(adjustedTaxWithoutModifiers.doubleValue()));
        this.setAdjustedTotal(NumberUtil.round(adjustedTotal.doubleValue()));
        this.setAdjustedTotalWithoutModifiers(NumberUtil.round(adjustedTotalWithoutModifiers.doubleValue()));
    }

    public BigDecimal calculateServiceCharge(BigDecimal subtotalAmount) {
        Double serviceChargeRate = this.getServiceChargeRate();
        Ticket ticket = this.getTicket();
        if (ticket == null || ticket.getOrderType() == null) {
            return new BigDecimal("0");
        }
        if (!this.isServiceChargeApplicable().booleanValue() || serviceChargeRate == 0.0 || !ticket.getOrderType().isServiceChargeApplicable().booleanValue()) {
            return new BigDecimal("0");
        }
        BigDecimal bdChargeRate = NumberUtil.convertToBigDecimal(serviceChargeRate / 100.0);
        return NumberUtil.round(subtotalAmount.multiply(bdChargeRate));
    }

    public boolean isMergable(TicketItem otherItem, boolean merge) {
        if (this.isTreatAsSeat().booleanValue() || otherItem.isTreatAsSeat().booleanValue()) {
            return false;
        }
        if (this.isFractionalUnit().booleanValue() || otherItem.isFractionalUnit().booleanValue()) {
            return false;
        }
        if (this.getQuantity() > 0.0 && otherItem.getQuantity() < 0.0 || this.getQuantity() < 0.0 && otherItem.getQuantity() > 0.0) {
            return false;
        }
        if (StringUtils.isEmpty((String)this.getMenuItemId()) || StringUtils.isEmpty((String)otherItem.getMenuItemId())) {
            return false;
        }
        if (this.hasCookingInstructions() || otherItem.hasCookingInstructions()) {
            return false;
        }
        if (this.isReturned() || otherItem.isReturned()) {
            return false;
        }
        if (!this.getMenuItemId().equals(otherItem.getMenuItemId()) || JSON_PROP_SURCHARGE_ITEM_NAME.equals(otherItem.getMenuItemName())) {
            return false;
        }
        if (!this.getUnitPrice().equals(otherItem.getUnitPrice())) {
            return false;
        }
        if (this.getSeatNumber().intValue() != otherItem.getSeatNumber().intValue()) {
            return false;
        }
        if (!this.isHasModifiers().booleanValue() && !otherItem.isHasModifiers().booleanValue()) {
            return true;
        }
        return this.isMergableModifiers(this.getTicketItemModifiers(), otherItem.getTicketItemModifiers(), merge);
    }

    public boolean isMergableModifiers(List<TicketItemModifier> thisModifiers, List<TicketItemModifier> thatModifiers, boolean merge) {
        if (POSUtil.isNullOrEmpty(thatModifiers) && POSUtil.isNullOrEmpty(thisModifiers)) {
            return true;
        }
        if (thisModifiers == null || thatModifiers == null) {
            return false;
        }
        if (thisModifiers.size() != thatModifiers.size()) {
            return false;
        }
        Comparator<TicketItemModifier> comparator = new Comparator<TicketItemModifier>(){

            @Override
            public int compare(TicketItemModifier o1, TicketItemModifier o2) {
                return o1.getItemId().compareTo(o2.getItemId());
            }
        };
        Collections.sort(thisModifiers, comparator);
        Collections.sort(thatModifiers, comparator);
        Iterator<TicketItemModifier> thisIterator = thisModifiers.iterator();
        Iterator<TicketItemModifier> thatIterator = thatModifiers.iterator();
        while (thisIterator.hasNext()) {
            TicketItemModifier next2;
            TicketItemModifier next1 = thisIterator.next();
            if (comparator.compare(next1, next2 = thatIterator.next()) != 0) {
                return false;
            }
            if (!merge) continue;
            next1.merge(next2);
        }
        return true;
    }

    public void doCalculateComboItemPrice() {
        if (!(this instanceof ComboTicketItem)) {
            return;
        }
        ComboTicketItem ticketItem = (ComboTicketItem)this;
        List<ComboGroup> comboGroups = ticketItem.getMenuItem().getComboGroups();
        if (comboGroups == null || comboGroups.isEmpty()) {
            return;
        }
        double comboItemsPrice = ticketItem.getComboItemsPrice();
        for (ComboGroup comboGroup : comboGroups) {
            List<MenuItem> menuItems;
            if (comboGroup == null || (menuItems = comboGroup.getItems()) == null || menuItems.isEmpty()) continue;
            List<TicketItem> addedItems = ticketItem.getComboItems();
            for (MenuItem menuItem : menuItems) {
                if (menuItem == null || StringUtils.isEmpty((String)menuItem.getId())) continue;
                for (TicketItem addedTicketItem : addedItems) {
                    if (addedTicketItem == null || StringUtils.isEmpty((String)addedTicketItem.getMenuItemId()) || !menuItem.getId().equals(addedTicketItem.getMenuItemId()) || addedTicketItem.getGroupId() == null) continue;
                    comboItemsPrice += comboGroup.getItemPrice(menuItem.getId());
                }
            }
        }
        ticketItem.setUnitPrice(comboItemsPrice);
    }

    public void merge(TicketItem otherItem) {
        if (!this.isHasModifiers().booleanValue() && !otherItem.isHasModifiers().booleanValue()) {
            this.setQuantity(this.getQuantity() + otherItem.getQuantity());
            return;
        }
        if (this.isMergable(otherItem, false)) {
            this.setQuantity(this.getQuantity() + otherItem.getQuantity());
        }
    }

    public boolean hasCookingInstructions() {
        return this.getCookingInstructions() != null && this.getCookingInstructions().size() > 0;
    }

    public BigDecimal calculateDiscount(BigDecimal subtotalAmount) {
        BigDecimal discount = NumberUtil.convertToBigDecimal(0.0);
        List<TicketItemDiscount> discounts = this.getDiscounts();
        if (discounts != null) {
            for (TicketItemDiscount ticketItemDiscount : discounts) {
                if (ticketItemDiscount.getType() == 2) continue;
                if (ticketItemDiscount.getType() == 1) {
                    discount = discount.add(NumberUtil.convertToBigDecimal(ticketItemDiscount.calculateDiscount(subtotalAmount.doubleValue() - discount.doubleValue())));
                    continue;
                }
                if (ticketItemDiscount.getType() == 0) {
                    Double discountAmount = ticketItemDiscount.getValue();
                    if (this.isVoided().booleanValue() || this.isReturned()) {
                        discountAmount = discountAmount * -1.0;
                    }
                    Double ticketItemQuantity = ticketItemDiscount.getTicketItem().getQuantity();
                    if (ticketItemDiscount.getMinimumAmount() > Math.abs(ticketItemQuantity)) {
                        discountAmount = 0.0;
                    }
                    ticketItemDiscount.setAmount(discountAmount);
                    discount = discount.add(NumberUtil.convertToBigDecimal(discountAmount));
                    continue;
                }
                if (ticketItemDiscount.getType() != 4) continue;
                double cost = this.getUnitCost();
                if (NumberUtil.isZero(cost)) {
                    discount = discount.add(NumberUtil.convertToBigDecimal(0.0));
                    continue;
                }
                if (NumberUtil.isZero(ticketItemDiscount.getValue())) continue;
                Double quantity = Math.abs(this.getQuantity());
                double calculateDiscount = (this.getUnitPrice() - (cost + cost * (ticketItemDiscount.getValue() / 100.0))) * quantity;
                double d = calculateDiscount = calculateDiscount < 0.0 ? this.getUnitPrice() * quantity : calculateDiscount;
                if (this.isVoided().booleanValue() || this.isReturned()) {
                    calculateDiscount *= -1.0;
                }
                ticketItemDiscount.setAmount(calculateDiscount);
                discount = discount.add(NumberUtil.convertToBigDecimal(calculateDiscount));
            }
        }
        this.buildDiscounts();
        if (discount.compareTo(subtotalAmount.abs()) > 0) {
            return subtotalAmount;
        }
        return NumberUtil.round(discount);
    }

    public double getAmountByType(TicketItemDiscount discount) {
        switch (discount.getType()) {
            case 0: {
                return discount.getValue();
            }
            case 1: {
                return discount.getValue() * this.getUnitPrice() / 100.0;
            }
        }
        return 0.0;
    }

    private BigDecimal calculateTax(BigDecimal subtotal) {
        Ticket ticket = this.getTicket();
        double subtotalAmount = subtotal.doubleValue();
        double totalTaxAmount = 0.0;
        List<TicketItemTax> taxList = this.getTaxes();
        if (taxList != null) {
            if (ticket != null && ticket.isTaxIncluded().booleanValue()) {
                for (TicketItemTax ticketItemTax : taxList) {
                    if (ticketItemTax.getRate() == 0.0) {
                        ticketItemTax.setTaxAmount(0.0);
                        continue;
                    }
                    double actualPrice = subtotalAmount / (ticketItemTax.getRate() / 100.0 + 1.0);
                    double taxAmount = NumberUtil.round(actualPrice * ticketItemTax.getRate() / 100.0);
                    ticketItemTax.setTaxAmount(taxAmount);
                    totalTaxAmount += taxAmount;
                }
            } else {
                for (TicketItemTax ticketItemTax : taxList) {
                    if (ticketItemTax.getRate() == 0.0) continue;
                    double taxAmount = NumberUtil.round(subtotalAmount * ticketItemTax.getRate() / 100.0);
                    ticketItemTax.setTaxAmount(taxAmount);
                    totalTaxAmount += taxAmount;
                }
            }
        }
        this.buildTaxes();
        if (ticket != null && ticket.isTaxExempt().booleanValue()) {
            return BigDecimal.ZERO;
        }
        this.addProperty("tax.exempt.amount", String.valueOf(NumberUtil.round(totalTaxAmount)));
        return Tax.applyFloridaTaxRule(subtotal, NumberUtil.convertToBigDecimal(totalTaxAmount));
    }

    public double getTotalTaxRate() {
        List<TicketItemTax> ticketItemTaxes = this.getTaxes();
        if (ticketItemTaxes == null || ticketItemTaxes.isEmpty()) {
            return 0.0;
        }
        double totalTaxRate = 0.0;
        for (TicketItemTax tax : ticketItemTaxes) {
            totalTaxRate += tax.getRate().doubleValue();
        }
        return totalTaxRate;
    }

    @Override
    public String getNameDisplay() {
        return this.getNameDisplay(this.getName());
    }

    public String getNameDisplay(String name) {
        if (this.isTreatAsSeat().booleanValue()) {
            return name;
        }
        String displayName = "";
        if (this.getQuantity() < 0.0) {
            if (this.isVoided().booleanValue() && !this.isItemReturned().booleanValue()) {
                displayName = displayName + "*Voided* ";
                displayName = displayName + this.getItemQuantityDisplay(true);
            } else {
                displayName = displayName + this.getItemQuantityDisplay();
            }
        } else {
            displayName = displayName + this.getItemQuantityDisplay();
        }
        if (this.isComboItem().booleanValue()) {
            List<TicketItem> comboItems = this.getComboItems();
            if (comboItems != null && !comboItems.isEmpty()) {
                displayName = displayName + name;
                displayName = displayName + "\n";
                Iterator<TicketItem> iterator = comboItems.iterator();
                while (iterator.hasNext()) {
                    TicketItem item = iterator.next();
                    displayName = displayName + " #" + NumberUtil.trimDecilamIfNotNeeded(item.getQuantity() / this.getQuantity(), true) + " " + item.getName();
                    List<TicketItemModifier> ticketItemModifiers = item.getTicketItemModifiers();
                    if (iterator.hasNext() || ticketItemModifiers != null) {
                        displayName = displayName + "\n";
                    }
                    if (ticketItemModifiers == null || ticketItemModifiers.isEmpty()) continue;
                    Iterator<TicketItemModifier> iterator2 = ticketItemModifiers.iterator();
                    while (iterator2.hasNext()) {
                        TicketItemModifier modifier = iterator2.next();
                        displayName = displayName + modifier.getNameDisplay();
                        if (iterator2.hasNext()) {
                            displayName = displayName + "\n";
                            continue;
                        }
                        if (!iterator.hasNext()) continue;
                        displayName = displayName + "\n";
                    }
                }
                return displayName;
            }
        } else if (this.getSizeModifier() != null) {
            displayName = displayName + this.getSizeModifier().getNameDisplay().replaceAll(" -- ", "") + " " + this.getName();
            return displayName;
        }
        displayName = displayName + name;
        return displayName;
    }

    @Override
    public String getUnitPriceDisplay() {
        if (this.isTreatAsSeat().booleanValue()) {
            return null;
        }
        return NumberUtil.formatNumberAcceptNegative(this.getUnitPrice());
    }

    @Override
    public String getItemQuantityDisplay() {
        return this.getItemQuantityDisplay(false);
    }

    public String getItemQuantityDisplay(boolean itemVoided) {
        if (this.isTreatAsSeat().booleanValue()) {
            return "";
        }
        Double quantity = itemVoided ? Math.abs(this.getQuantity()) : this.getQuantity();
        if (!this.isFractionalUnit().booleanValue() && quantity == 1.0) {
            return "";
        }
        String itemQuantity = NumberUtil.trimDecilamIfNotNeeded(quantity, true);
        String unitName = this.getUnitName();
        if (unitName.equals("") || "ea".equals(unitName) || "pc".equals(unitName)) {
            return itemQuantity + "x ";
        }
        return itemQuantity + unitName + " ";
    }

    @Override
    public String getTaxAmountWithoutModifiersDisplay() {
        return NumberUtil.formatNumberAcceptNegative(this.getTaxAmountWithoutModifiers());
    }

    @Override
    public String getTotalAmountWithoutModifiersDisplay() {
        return NumberUtil.formatNumberAcceptNegative(this.getTotalAmountWithoutModifiers());
    }

    @Override
    public String getSubTotalAmountWithoutModifiersDisplay() {
        if (this.isTreatAsSeat().booleanValue()) {
            return null;
        }
        return NumberUtil.formatNumberAcceptNegative(this.getSubtotalAmountWithoutModifiers());
    }

    @Override
    public String getItemCode() {
        return String.valueOf(this.getMenuItemId());
    }

    public List<Printer> getPrinters(OrderType orderType) {
        PrinterGroup printerGroup = this.getPrinterGroup();
        ArrayList<Printer> printerAll = new ArrayList<Printer>();
        PosPrinters printers = DataProvider.get().getPrinters();
        List<Printer> kitchenPrinters = printers.getKitchenPrinters();
        printerAll.addAll(printers.getStickerPrinters());
        if (printerGroup == null && (kitchenPrinters == null || kitchenPrinters.isEmpty()) && printers.isPrintToKds()) {
            printerAll.add(VirtualPrinter.getKdsPrinter());
        }
        if (printerGroup == null && kitchenPrinters != null && kitchenPrinters.size() > 0) {
            Printer printer = kitchenPrinters.get(0);
            if (StringUtils.isBlank((String)printer.getDeviceName())) {
                printerAll.add(VirtualPrinter.getKdsPrinter());
            } else {
                printerAll.add(printer);
            }
            return printerAll;
        }
        if (printerGroup != null) {
            List<String> printerNames = printerGroup.getPrinterNames();
            for (Printer printer : kitchenPrinters) {
                VirtualPrinter virtualPrinter = printer.getVirtualPrinter();
                if (StringUtils.isBlank((String)printer.getDeviceName()) || !printerNames.contains(virtualPrinter.getName())) continue;
                printerAll.add(printer);
            }
        }
        if (printerAll.isEmpty() && printers.isPrintToKds()) {
            printerAll.add(VirtualPrinter.getKdsPrinter());
        }
        return printerAll;
    }

    @Override
    public boolean canAddDiscount() {
        return true;
    }

    @Override
    public boolean canVoid() {
        return true;
    }

    @Override
    public boolean canAddAdOn() {
        return true;
    }

    public MenuItem getMenuItem() {
        if (this.menuItem == null) {
            String itemId = this.getMenuItemId();
            if (StringUtils.isEmpty((String)itemId)) {
                return null;
            }
            this.menuItem = MenuItemDAO.getInstance().loadInitialized(itemId);
        }
        return this.menuItem;
    }

    public String getMenuItemName() {
        String menuItemName = "";
        if (this.getMenuItem() != null) {
            menuItemName = this.getMenuItem().getName();
        }
        return menuItemName;
    }

    @Transient
    public void setMenuItem(MenuItem menuItem) {
        this.menuItem = menuItem;
        String menuItemId = null;
        if (menuItem != null) {
            menuItemId = menuItem.getId();
        }
        super.setMenuItemId(menuItemId);
    }

    @Override
    public KitchenStatus getKitchenStatusValue() {
        return KitchenStatus.fromString(super.getKitchenStatus());
    }

    public void setKitchenStatusValue(KitchenStatus kitchenStatus) {
        super.setKitchenStatus(kitchenStatus.name());
    }

    @Override
    public String getUnitName() {
        if (super.getUnitName() == null) {
            return "";
        }
        return super.getUnitName();
    }

    public Double getQuantityToShip() {
        return this.quantityToShip == null ? 0.0 : this.quantityToShip;
    }

    public void setQuantityToShip(Double shipQuantity) {
        this.quantityToShip = shipQuantity;
    }

    @Override
    public String getSubTotalAmountDisplay() {
        if (this.isTreatAsSeat().booleanValue()) {
            return null;
        }
        if (this.isVoided().booleanValue() && this.getVoidedItemId() != null) {
            return "(" + NumberUtil.formatAmount(Math.abs(this.getSubtotalAmount())) + ")";
        }
        return NumberUtil.formatAmount(this.getSubtotalAmount());
    }

    public TicketItemModifier findTicketItemModifierFor(MenuModifier menuModifier, Multiplier multiplier) {
        List<TicketItemModifier> modifiers = this.getTicketItemModifiers();
        if (modifiers == null) {
            return null;
        }
        for (TicketItemModifier ticketItemModifier : modifiers) {
            boolean idIsNull;
            String itemId = ticketItemModifier.getItemId();
            String menuItemMGId = menuModifier.getMenuItemModifierGroup().getId();
            String ticketItemMGId = ticketItemModifier.getGroupId();
            String multiplierName = ticketItemModifier.getMultiplierName();
            boolean bl = idIsNull = itemId == null || menuItemMGId == null || ticketItemMGId == null;
            if (idIsNull) {
                return null;
            }
            if (!multiplier.getId().equals(multiplierName)) {
                return null;
            }
            if (!menuItemMGId.equals(ticketItemMGId) || !itemId.equals(menuModifier.getId())) continue;
            return ticketItemModifier;
        }
        return null;
    }

    public List<TicketItemModifier> findTicketItemModifiersFor(MenuModifier menuModifier, Multiplier multiplier) {
        List<TicketItemModifier> modifiers = this.getTicketItemModifiers();
        ArrayList<TicketItemModifier> ticketItemModifiers = new ArrayList<TicketItemModifier>();
        if (modifiers == null) {
            return ticketItemModifiers;
        }
        for (TicketItemModifier ticketItemModifier : modifiers) {
            String itemId = ticketItemModifier.getItemId();
            if (itemId == null || !itemId.equals(menuModifier.getId()) || !multiplier.getId().equals(ticketItemModifier.getMultiplierName())) continue;
            ticketItemModifiers.add(ticketItemModifier);
        }
        return ticketItemModifiers;
    }

    public double findTicketItemModifierByMenuModifier(MenuModifier menuModifier) {
        if (menuModifier == null) {
            return 0.0;
        }
        double totalAmount = 0.0;
        List<Multiplier> multiplierList = DataProvider.get().getMultiplierList();
        if (multiplierList != null) {
            for (Multiplier multiplier : multiplierList) {
                List<TicketItemModifier> ticketItemModifiers = this.findTicketItemModifiersFor(menuModifier, multiplier);
                if (ticketItemModifiers == null || ticketItemModifiers.isEmpty()) continue;
                for (TicketItemModifier modifier : ticketItemModifiers) {
                    totalAmount += modifier.getItemQuantity().doubleValue();
                }
            }
        }
        return totalAmount;
    }

    public TicketItemModifier findTicketItemModifierFor(MenuModifier menuModifier, String sectionName) {
        return this.findTicketItemModifierFor(menuModifier, sectionName, null);
    }

    public TicketItemModifier findTicketItemModifierFor(MenuModifier menuModifier, String sectionName, Multiplier multiplier) {
        List<TicketItemModifier> modifiers = this.getTicketItemModifiers();
        if (modifiers == null) {
            return null;
        }
        for (TicketItemModifier ticketItemModifier : modifiers) {
            String itemId = ticketItemModifier.getItemId();
            if (multiplier != null && itemId != null && itemId.equals(menuModifier.getId()) && sectionName != null && sectionName.equals(ticketItemModifier.getSectionName()) && multiplier != null && multiplier.getId().equals(ticketItemModifier.getMultiplierName())) {
                return ticketItemModifier;
            }
            if (itemId == null || !itemId.equals(menuModifier.getId()) || sectionName == null || !sectionName.equals(ticketItemModifier.getSectionName())) continue;
            return ticketItemModifier;
        }
        return null;
    }

    public int countModifierFromGroup(MenuItemModifierSpec menuItemModifierGroup) {
        List<TicketItemModifier> modifiers = this.getTicketItemModifiers();
        if (modifiers == null) {
            return 0;
        }
        int modifierFromGroupCount = 0;
        for (TicketItemModifier ticketItemModifier : modifiers) {
            String groupId = ticketItemModifier.getGroupId();
            if (groupId == null || !groupId.equals(menuItemModifierGroup.getId())) continue;
            modifierFromGroupCount = (int)((double)modifierFromGroupCount + ticketItemModifier.getItemQuantity());
        }
        return modifierFromGroupCount;
    }

    public boolean requiredModifiersAdded(MenuItemModifierSpec menuItemModifierGroup) {
        int minQuantity = menuItemModifierGroup.getMinQuantity();
        if (minQuantity == 0) {
            return true;
        }
        return this.countModifierFromGroup(menuItemModifierGroup) >= minQuantity;
    }

    public boolean deleteTicketItemModifier(TicketItemModifier ticketItemModifierToRemove) {
        List<TicketItemModifier> modifiers = this.getTicketItemModifiers();
        if (modifiers == null || modifiers.isEmpty()) {
            return false;
        }
        Iterator<TicketItemModifier> iterator = modifiers.iterator();
        while (iterator.hasNext()) {
            TicketItemModifier ticketItemModifier = iterator.next();
            if (ticketItemModifier != ticketItemModifierToRemove) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public boolean deleteTicketItemModifierByName(TicketItemModifier ticketItemModifierToRemove) {
        List<TicketItemModifier> modifiers = this.getTicketItemModifiers();
        if (modifiers == null) {
            return false;
        }
        Iterator<TicketItemModifier> iterator = modifiers.iterator();
        while (iterator.hasNext()) {
            TicketItemModifier ticketItemModifier = iterator.next();
            if (!ticketItemModifier.getName().equals(ticketItemModifierToRemove.getName())) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public void setPizzaSectionMode(PIZZA_SECTION_MODE pizzaSectionMode) {
        this.setPizzaSectionModeType(pizzaSectionMode.getValue());
    }

    public PIZZA_SECTION_MODE getPizzaSectionMode() {
        return PIZZA_SECTION_MODE.from(this.getPizzaSectionModeType());
    }

    public TicketItemModifier findTicketItemModifierByPageItem(MenuModifier menuModifier) {
        List<TicketItemModifier> modifiers = this.getTicketItemModifiers();
        if (modifiers == null) {
            return null;
        }
        for (TicketItemModifier ticketItemModifier : modifiers) {
            String itemId = ticketItemModifier.getPageItemId();
            if (itemId == null || !itemId.equals(menuModifier.getPageItemId())) continue;
            return ticketItemModifier;
        }
        return null;
    }

    public TicketItemModifier findTicketItemComboModifierFor(MenuModifier menuModifier) {
        List<TicketItemModifier> modifiers = this.getTicketItemModifiers();
        if (modifiers == null) {
            return null;
        }
        for (TicketItemModifier ticketItemModifier : modifiers) {
            String itemId = ticketItemModifier.getItemId();
            if (itemId == null || !itemId.equals(menuModifier.getId()) || ticketItemModifier.getModifierType() != 3) continue;
            return ticketItemModifier;
        }
        return null;
    }

    public TicketItemModifier removeTicketItemModifierByPageItem(TicketItemModifier ticketItemModifier) {
        List<TicketItemModifier> ticketItemModifiers = this.getTicketItemModifiers();
        if (ticketItemModifiers == null) {
            return ticketItemModifier;
        }
        Iterator<TicketItemModifier> iter = ticketItemModifiers.iterator();
        while (iter.hasNext()) {
            TicketItemModifier oldTicketItemModifier = iter.next();
            String pageItemId = oldTicketItemModifier.getPageItemId();
            if (pageItemId == null || !pageItemId.equals(ticketItemModifier.getPageItemId()) || oldTicketItemModifier.getModifierType() != ticketItemModifier.getModifierType()) continue;
            iter.remove();
            return oldTicketItemModifier;
        }
        return ticketItemModifier;
    }

    public void removeTicketItemDiscount(TicketItemDiscount itemDiscount) {
        List<TicketItemDiscount> discounts = this.getDiscounts();
        if (discounts == null) {
            return;
        }
        Iterator<TicketItemDiscount> iterator = discounts.iterator();
        while (iterator.hasNext()) {
            TicketItemDiscount ticketItemDiscount = iterator.next();
            if (ticketItemDiscount.getTableRowNum() != itemDiscount.getTableRowNum()) continue;
            iterator.remove();
            return;
        }
    }

    public boolean isInventoryAdjusted() {
        if (this.isTreatAsSeat().booleanValue()) {
            return false;
        }
        return this.getQuantity().doubleValue() == this.getInventoryAdjustQty().doubleValue();
    }

    public Boolean isIncludeVoidQuantity() {
        return this.includeVoidQuantity == null ? false : this.includeVoidQuantity;
    }

    public void setIncludeVoidQuantity(Boolean includeVoidQuantity) {
        this.includeVoidQuantity = includeVoidQuantity;
    }

    public void markVoidedItemAsAdjusted(VoidItem voidItem) {
        this.addProperty(JSON_PROP_VOID_ADJUSTED, "true");
        this.removeProperty(JSON_PROP_VOID_REASON);
    }

    public VoidItem getVoidItem() {
        String voidReason = this.getProperty(JSON_PROP_VOID_REASON);
        if (StringUtils.isBlank((String)voidReason)) {
            return null;
        }
        double voidQuantity = POSUtil.parseDouble(this.getProperty(JSON_PROP_VOID_QUANTITY));
        if (voidQuantity == 0.0) {
            return null;
        }
        VoidItem voidItem = this.createVoidItem(voidReason, POSUtil.getBoolean(this.getProperty(JSON_PROP_WASTED)), voidQuantity);
        return voidItem;
    }

    public void markVoided(String voidReason, boolean itemWasted, double quantity, boolean returned) {
        this.setVoidDate(StoreDAO.getServerTimestamp());
        this.setQuantity(-quantity);
        if (returned) {
            List<TicketItemModifier> ticketItemModifiers;
            this.setReturned(true);
            this.setPaid(false);
            if (this.isHasModifiers().booleanValue() && (ticketItemModifiers = this.getTicketItemModifiers()) != null) {
                for (TicketItemModifier ticketItemModifier : ticketItemModifiers) {
                    ticketItemModifier.setItemQuantity(-1.0 * ticketItemModifier.getItemQuantity());
                }
            }
        } else {
            this.setVoided(true);
        }
        if (this.isComboItem().booleanValue() && this.getComboItems() != null) {
            for (TicketItem comboTicketItem : this.getComboItems()) {
                comboTicketItem.markVoided(voidReason, itemWasted, comboTicketItem.getQuantity(), returned);
            }
        }
        this.setVoidProperties(voidReason, itemWasted, quantity);
    }

    public void markReturnedItemVoided(String voidReason, boolean itemWasted, double quantity) {
        this.setVoided(true);
        this.setVoidDate(StoreDAO.getServerTimestamp());
        this.setQuantity(quantity);
        this.setReturned(false);
        this.setVoidedItemId(this.getId());
        if (itemWasted) {
            this.setInventoryAdjustQty(quantity);
        } else {
            this.setInventoryAdjustQty(0.0);
        }
        this.setPrintedToKitchen(false);
        this.setVoidProperties(voidReason, itemWasted, quantity);
        this.addProperty(JSON_PROP_RETURNED_ITEM_VOIDED, String.valueOf(true));
    }

    public void removeVoidProperties() {
        this.removeProperty(JSON_PROP_VOID_REASON);
        this.removeProperty(JSON_PROP_WASTED);
        this.removeProperty(JSON_PROP_VOID_QUANTITY);
        this.removeProperty(JSON_PROP_VOID_ID);
    }

    public void setVoidProperties(String voidReason, boolean wasted, double quantity) {
        this.setVoidProperties(voidReason, wasted, quantity, this.isPrintedToKitchen());
    }

    public void setVoidProperties(String voidReason, boolean wasted, double quantity, boolean printedToKitchen) {
        this.addProperty(JSON_PROP_VOID_REASON, voidReason);
        this.addProperty(JSON_PROP_WASTED, String.valueOf(wasted));
        this.addProperty(JSON_PROP_VOID_QUANTITY, String.valueOf(quantity));
        this.addProperty(JSON_PROP_PRINTED_TO_KITCHEN, String.valueOf(printedToKitchen));
        this.addProperty(JSON_PROP_VOIDED_BY_USER, Application.getCurrentUser().getId());
        this.setVoidReason(voidReason);
    }

    public VoidItem createVoidItem(String voidReason, boolean wasted, double quantity) {
        TicketItem clonedTicket = this.cloneAsNew();
        clonedTicket.setQuantity(quantity);
        clonedTicket.calculatePrice();
        VoidItem newVoidItem = new VoidItem();
        if (clonedTicket.getTicket() != null) {
            newVoidItem.setTicketId(clonedTicket.getTicket().getId());
        }
        newVoidItem.setVoidReason(voidReason);
        newVoidItem.setItemId(clonedTicket.getId());
        newVoidItem.setMenuItemId(clonedTicket.getMenuItemId());
        newVoidItem.setMenuItemName(clonedTicket.getName());
        newVoidItem.setUnitPrice(clonedTicket.getUnitPrice());
        newVoidItem.setQuantity(quantity);
        newVoidItem.setItemWasted(wasted);
        newVoidItem.setVoidDate(new Date());
        newVoidItem.setModifier(false);
        newVoidItem.setPrinterGroup(clonedTicket.getPrinterGroup());
        User currentUser = Application.getCurrentUser();
        newVoidItem.setVoidByUser(currentUser);
        newVoidItem.setTerminal(Application.getInstance().getTerminal());
        if (currentUser.getActiveDrawerPullReport() != null) {
            newVoidItem.setCashDrawerId(currentUser.getActiveDrawerPullReport().getId());
        }
        newVoidItem.setTaxAmount(clonedTicket.getTaxAmountWithoutModifiers());
        newVoidItem.setTotalPrice(clonedTicket.getAdjustedTotalWithoutModifiers());
        double ticketItemQuantity = clonedTicket.getQuantity();
        double voidItemQuantity = newVoidItem.getQuantity();
        ArrayList<VoidItem> modifierVoidItems = new ArrayList<VoidItem>();
        if (clonedTicket.isHasModifiers().booleanValue()) {
            for (TicketItemModifier ticketItemModifier : clonedTicket.getTicketItemModifiers()) {
                VoidItem modifierVoidItem = new VoidItem();
                double voidModifierquantity = ticketItemModifier.getItemQuantity() * voidItemQuantity / ticketItemQuantity;
                if (!(voidModifierquantity > 0.0)) continue;
                String tfvoidItemReason = newVoidItem.getVoidReason();
                if (!StringUtils.isEmpty((String)tfvoidItemReason)) {
                    modifierVoidItem.setVoidReason(tfvoidItemReason);
                }
                modifierVoidItem.setModifierId(ticketItemModifier.getItemId());
                modifierVoidItem.setItemId(ticketItemModifier.getId());
                modifierVoidItem.setMenuItemName(ticketItemModifier.getNameDisplay());
                modifierVoidItem.setUnitPrice(ticketItemModifier.getUnitPrice());
                modifierVoidItem.setQuantity(voidModifierquantity);
                modifierVoidItem.setItemWasted(newVoidItem.isItemWasted());
                modifierVoidItem.setVoidDate(new Date());
                modifierVoidItem.setModifier(true);
                modifierVoidItem.setVoidByUser(currentUser);
                modifierVoidItem.setTerminal(Application.getInstance().getTerminal());
                modifierVoidItem.setCashDrawerId(currentUser.getActiveDrawerPullReport().getId());
                modifierVoidItem.setTaxAmount(ticketItemModifier.getTaxAmount());
                modifierVoidItem.setTotalPrice(ticketItemModifier.getAdjustedSubtotal() + ticketItemModifier.getTaxAmount());
                modifierVoidItem.setTicketId(newVoidItem.getTicketId());
                modifierVoidItems.add(modifierVoidItem);
            }
        }
        newVoidItem.setVoidModifiers(modifierVoidItems);
        return newVoidItem;
    }

    @Override
    public boolean isSaved() {
        return this.getId() != null;
    }

    public boolean isRefundable() {
        return true;
    }

    public List<TicketItemCookingInstruction> getCookingInstructions() {
        if (this.cookingInstructions == null) {
            this.cookingInstructions = new ArrayList<TicketItemCookingInstruction>();
            String property = super.getCookingInstructionsProperty();
            if (StringUtils.isNotEmpty((String)property)) {
                JsonReader jsonParser = Json.createReader((Reader)new StringReader(property));
                JsonArray jsonArray = jsonParser.readArray();
                jsonParser.close();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonObject jsonObject = (JsonObject)jsonArray.get(i);
                    TicketItemCookingInstruction tic = new TicketItemCookingInstruction();
                    tic.setDescription(JsonUtil.getString(jsonObject, TicketItemCookingInstruction.PROP_DESCRIPTION));
                    tic.setPrintedToKitchen(JsonUtil.getBoolean(jsonObject, TicketItemCookingInstruction.PROP_PRINTED_TO_KITCHEN));
                    tic.setSaved(JsonUtil.getBoolean(jsonObject, TicketItemCookingInstruction.PROP_SAVED));
                    this.cookingInstructions.add(tic);
                }
            }
        }
        return this.cookingInstructions;
    }

    public PrinterGroup getPrinterGroup() {
        PrinterGroup printerGroup = DataProvider.get().getPrinterGroupById(this.getPrinterGroupId());
        if (printerGroup == null) {
            DataProvider.get().getDefaultPrinterGroup();
        }
        return printerGroup;
    }

    public void setPrinterGroup(PrinterGroup printerGroup) {
        String printerGroupId = null;
        if (printerGroup != null) {
            printerGroupId = printerGroup.getId();
        }
        super.setPrinterGroupId(printerGroupId);
    }

    public TicketItem getParentTicketItem() {
        return this.parentTicketItem;
    }

    public void setParentTicketItem(TicketItem parentTicketItem) {
        this.parentTicketItem = parentTicketItem;
    }

    public List<TicketItem> getComboItems() {
        return null;
    }

    public void setComboItems(List<TicketItem> comboItems) {
    }

    public void addTocomboItems(TicketItem item) {
    }

    public Integer getSortOrder() {
        if (this.sortOrder != null) {
            return this.sortOrder;
        }
        if (StringUtils.isEmpty((String)this.getCourseId())) {
            return 0;
        }
        Course course = DataProvider.get().getCourse(this.getCourseId());
        if (course != null) {
            return course.getSortOrder();
        }
        return 0;
    }

    public void setSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
    }

    public boolean isSyncEdited() {
        return this.syncEdited;
    }

    public void setSyncEdited(boolean syncEdited) {
        this.syncEdited = syncEdited;
    }

    public void addProperty(String key, String value) {
        this.initPropertyContainer();
        this.propertiesContainer.addProperty(key, value);
        super.setProperties(this.propertiesContainer.toString());
    }

    public String getProperty(String key) {
        JsonElement jsonElement;
        this.initPropertyContainer();
        if (this.propertiesContainer.has(key) && !(jsonElement = this.propertiesContainer.get(key)).isJsonNull()) {
            return jsonElement.getAsString();
        }
        return null;
    }

    public boolean hasProperty(String key) {
        return this.getProperty(key) != null;
    }

    public boolean isPropertyValueTrue(String propertyName) {
        String property = this.getProperty(propertyName);
        return POSUtil.getBoolean(property);
    }

    public void removeProperty(String propertyName) {
        this.initPropertyContainer();
        this.propertiesContainer.remove(propertyName);
        super.setProperties(this.propertiesContainer.toString());
    }

    public void setUnitSelection(boolean unitSelection) {
        this.addProperty("menuitem.allow_unit_selection", String.valueOf(unitSelection));
    }

    public boolean isAllowUnitSelection() {
        String isAllowUnitSelection = this.getProperty("menuitem.allow_unit_selection");
        if (StringUtils.isNotEmpty((String)isAllowUnitSelection)) {
            return Boolean.parseBoolean(isAllowUnitSelection);
        }
        return false;
    }

    public void setItemIsGiftCard(String giftCardNo, double balance) {
        this.setQuantity(1.0);
        this.setShouldPrintToKitchen(false);
        this.setInventoryItem(false);
        this.setName(Messages.getString("TicketItem.0") + "\n" + giftCardNo);
        this.setCategoryName(Messages.getString("GiftCard"));
        this.setGroupName(Messages.getString("GiftCard"));
        this.setUnitPrice(balance);
        this.addProperty("isGiftCard", String.valueOf(true));
        this.addProperty("giftCardNo", giftCardNo);
    }

    public boolean isGiftCard() {
        return Boolean.valueOf(this.getProperty("isGiftCard"));
    }

    public String getGiftCardNo() {
        return this.getProperty("giftCardNo");
    }

    public String getClassType() {
        return this.classType;
    }

    public void setClassType(String classType) {
        this.classType = classType;
    }

    public void setReturned(Boolean returned) {
        this.addProperty(JSON_PROP_RETURNED, String.valueOf(returned));
        super.setItemReturned(returned);
    }

    public boolean isReturned() {
        return Boolean.valueOf(this.getProperty(JSON_PROP_RETURNED));
    }

    public void setPaid(Boolean paid) {
        this.addProperty("paid", String.valueOf(paid));
    }

    public boolean isPaid() {
        return Boolean.valueOf(this.getProperty("paid"));
    }

    public boolean isReturnedItemVoided() {
        return Boolean.valueOf(this.getProperty(JSON_PROP_RETURNED_ITEM_VOIDED));
    }

    public double getTaxAmountFromProperty() {
        return POSUtil.parseDouble(this.getProperty("tax.exempt.amount"));
    }

    public double getComboItemsPrice() {
        double itemsPrice = 0.0;
        List<TicketItem> comboItems = this.getComboItems();
        if (comboItems != null) {
            for (TicketItem comboItem : comboItems) {
                if (comboItem.getGroupId() != null) continue;
                itemsPrice += comboItem.getUnitPrice().doubleValue();
            }
        }
        return itemsPrice;
    }

    public boolean isDeletableVoidItem() {
        return POSUtil.getBoolean(this.getProperty(JSON_PROP_DELETABLE_VOID_ITEM));
    }

    public void setDeletableVoidItem(boolean show) {
        this.addProperty(JSON_PROP_DELETABLE_VOID_ITEM, String.valueOf(show));
    }

    public double getGiftCardPaidAmount() {
        return POSUtil.parseDouble(this.getProperty(JSON_PROP_GIFT_CARD_PAID_AMOUNT));
    }

    public void setGiftCardPaidAmount(double amount) {
        this.addProperty(JSON_PROP_GIFT_CARD_PAID_AMOUNT, String.valueOf(amount));
    }

    public void setSplitted(boolean split) {
        this.addProperty("splitted", String.valueOf(split));
    }

    public boolean isSplitted() {
        return Boolean.valueOf(this.getProperty("splitted"));
    }

    private void initPropertyContainer() {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = StringUtils.isBlank((String)super.getProperties()) ? new com.google.gson.JsonObject() : (com.google.gson.JsonObject)new Gson().fromJson(super.getProperties(), com.google.gson.JsonObject.class);
        }
    }

    public String getCmsTypeName() {
        return this.getProperty("cms_type_name");
    }

    public void setCmsTypeName(String string) {
        this.addProperty("cms_type_name", string);
    }

    public String getCmsSubTypeName() {
        return this.getProperty("cms_sub_type_name");
    }

    public void setCmsSubTypeName(String string) {
        this.addProperty("cms_sub_type_name", string);
    }

    public void setServiceChargeName(String scName) {
        this.addProperty("scName", scName);
    }

    public String getServiceChargeName() {
        return this.getProperty("scName");
    }

    public void setTransactionUUId(String transactionUUId) {
        this.addProperty("TRANSACTION_UUID", transactionUUId);
    }

    public String getTransactionUUId() {
        String transactionUUId = this.getProperty("TRANSACTION_UUID");
        return StringUtils.isBlank((String)transactionUUId) ? "" : transactionUUId;
    }

    public void setRefundItemIds(String refundItemIds) {
        this.addProperty("REFUND_ITEMID", refundItemIds);
    }

    public String getRefundItemIds() {
        return this.getProperty("REFUND_ITEMID");
    }

    public boolean isHideFromCustomerReceipt() {
        return POSUtil.getBoolean(this.getProperty("hide_from_customer_receipt"));
    }

    public void setHideFromCustomerReceipt(boolean isHideFromCustomerReceipt) {
        this.addProperty("hide_from_customer_receipt", String.valueOf(isHideFromCustomerReceipt));
    }

    public static enum PIZZA_SECTION_MODE {
        FULL(1),
        HALF(2),
        QUARTER(3);

        private final int value;

        private PIZZA_SECTION_MODE(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static PIZZA_SECTION_MODE from(int value) {
            if (value == 2) {
                return HALF;
            }
            if (value == 3) {
                return QUARTER;
            }
            return FULL;
        }

        public String toString() {
            return this.name();
        }
    }
}

