/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.CashBreakdown;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.DrawerType;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.BaseCashDrawerDAO;
import com.floreantpos.model.dao.CashBreakdownDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.services.report.CashDrawerReportService;
import com.floreantpos.swing.PaginationSupport;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.PropertyExpression;
import org.hibernate.criterion.Restrictions;

public class CashDrawerDAO
extends BaseCashDrawerDAO {
    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCashDrawerReport(PaginationSupport model, Date fromDate, Date toDate) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.ge((String)CashDrawer.PROP_REPORT_TIME, (Object)fromDate));
            criteria.add((Criterion)Restrictions.le((String)CashDrawer.PROP_REPORT_TIME, (Object)toDate));
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            model.setNumRows(rowCount.intValue());
            criteria.setProjection(null);
            criteria.setFirstResult(model.getCurrentRowIndex());
            criteria.setMaxResults(model.getPageSize());
            model.setRows(criteria.list());
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CashDrawer> findReports(Date start, Date end) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.ge((String)CashDrawer.PROP_REPORT_TIME, (Object)start));
            criteria.add((Criterion)Restrictions.le((String)CashDrawer.PROP_REPORT_TIME, (Object)end));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CashDrawer> findByStoreOperationData(StoreSession data, Boolean openDrawer) {
        if (data == null) {
            return null;
        }
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)CashDrawer.PROP_STORE_SESSION_ID, (Object)data.getId()));
            if (openDrawer != null) {
                criteria.add(openDrawer != false ? Restrictions.isNull((String)CashDrawer.PROP_REPORT_TIME) : Restrictions.isNotNull((String)CashDrawer.PROP_REPORT_TIME));
            }
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CashDrawer> findByStoreOperationData(StoreSession data) {
        if (data == null) {
            return null;
        }
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)CashDrawer.PROP_STORE_SESSION_ID, (Object)data.getId()));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getCashDrawerIds(StoreSession data) {
        if (data == null) {
            return null;
        }
        Session session = null;
        try {
            List list;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection((Projection)Projections.property((String)CashDrawer.PROP_ID));
            criteria.add((Criterion)Restrictions.eq((String)CashDrawer.PROP_STORE_SESSION_ID, (Object)data.getId()));
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getSumOfOpeningBalance(StoreSession storeSession) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)CashDrawer.PROP_STORE_SESSION_ID, (Object)storeSession.getId()));
            criteria.setProjection((Projection)Projections.sum((String)CashDrawer.PROP_BEGIN_CASH));
            Double openingBalance = (Double)criteria.uniqueResult();
            if (openingBalance == null) {
                double d = 0.0;
                return d;
            }
            double d = openingBalance;
            return d;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CashDrawer> findByUnSyncStoreOperationData(StoreSession data) {
        if (data == null) {
            return null;
        }
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            Criterion nullUpdateTime = Restrictions.isNull((String)CashDrawer.PROP_LAST_UPDATE_TIME);
            Criterion nullSyncTime = Restrictions.isNull((String)CashDrawer.PROP_LAST_SYNC_TIME);
            PropertyExpression gtQuery = Restrictions.gtProperty((String)CashDrawer.PROP_LAST_UPDATE_TIME, (String)CashDrawer.PROP_LAST_SYNC_TIME);
            criteria.add((Criterion)Restrictions.or((Criterion[])new Criterion[]{nullUpdateTime, nullSyncTime, gtQuery}));
            criteria.add((Criterion)Restrictions.eq((String)CashDrawer.PROP_STORE_SESSION_ID, (Object)data.getId()));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateCashDrawer(List<CashDrawer> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (dataList == null) {
            return;
        }
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (CashDrawer item : dataList) {
                List<CashBreakdown> cashBreakdowns = item.getCashBreakdownList();
                item.setCashBreakdownList(null);
                item.setUpdateLastUpdateTime(updateLastUpdateTime);
                item.setUpdateSyncTime(updateSyncTime);
                CashDrawerDAO dao = CashDrawerDAO.getInstance();
                CashDrawer existingItem = dao.get(item.getId());
                if (existingItem != null) {
                    if (!BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), item.getId() + " already updated");
                        continue;
                    }
                    long version = existingItem.getVersion();
                    item.setVersion(version);
                } else {
                    this.save(item, session);
                }
                if (cashBreakdowns != null && cashBreakdowns.size() > 0) {
                    for (CashBreakdown breakdown : cashBreakdowns) {
                        CashBreakdownDAO breakdownDAO = CashBreakdownDAO.getInstance();
                        CashBreakdown existingCashBreakdown = breakdownDAO.get(breakdown.getId());
                        if (existingCashBreakdown == null) {
                            dao.save(breakdown, session);
                            continue;
                        }
                        breakdown.setVersion(existingCashBreakdown.getVersion());
                    }
                }
                item.setCashBreakdownList(cashBreakdowns);
                this.saveOrUpdate(item, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CashDrawer> findStaffBank(Date fromDate, Date toDate, User staff) {
        Session session = null;
        try {
            List cashDrawerList;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)CashDrawer.PROP_TYPE, (Object)DrawerType.STAFF_BANK.getTypeNumber()));
            criteria.add(Restrictions.between((String)CashDrawer.PROP_START_TIME, (Object)fromDate, (Object)toDate));
            if (staff != null) {
                criteria.add((Criterion)Restrictions.eq((String)CashDrawer.PROP_ASSIGNED_USER_ID, (Object)staff.getId()));
            }
            if (!(cashDrawerList = criteria.list()).isEmpty()) {
                for (CashDrawer cashDrawer : cashDrawerList) {
                    CashDrawerReportService cashDrawerReportService = new CashDrawerReportService(cashDrawer);
                    cashDrawerReportService.populateReport();
                }
            }
            List list = cashDrawerList;
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveDrawerAssignment(CashDrawer cashDrawer, Terminal terminal) {
        Transaction tx = null;
        try (Session session = this.createNewSession();){
            tx = session.beginTransaction();
            if (cashDrawer != null) {
                this.saveOrUpdate(cashDrawer);
            }
            if (terminal != null) {
                TerminalDAO.getInstance().saveOrUpdate(terminal);
            }
            tx.commit();
        }
        catch (Exception e) {
            try {
                tx.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExist(String drawerId) {
        if (StringUtils.isEmpty((String)drawerId)) {
            return false;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)CashDrawer.PROP_ID, (Object)drawerId));
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            boolean bl = number != null && number.intValue() > 0;
            return bl;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void transferUser(CashDrawer cashDrawer, User user) {
        Transaction transaction = null;
        try (Session session = this.createNewSession();){
            transaction = session.beginTransaction();
            cashDrawer.setAssignedUser(user);
            this.update(cashDrawer, session);
            transaction.commit();
        }
        catch (Exception e) {
            transaction.rollback();
            throw e;
        }
    }
}

