/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.ComboGroup;
import com.floreantpos.model.ComboItem;
import com.floreantpos.model.dao.BaseComboItemDAO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class ComboItemDAO
extends BaseComboItemDAO {
    public List<ComboItem> getByMenuItem(String menuItemId) {
        if (StringUtils.isEmpty((String)menuItemId)) {
            return new ArrayList<ComboItem>(0);
        }
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)ComboItem.PROP_ITEM_ID, (Object)menuItemId));
            List list = criteria.list();
            return list;
        }
    }

    public boolean isUsedInComboItem(String menuItemId) {
        if (StringUtils.isEmpty((String)menuItemId)) {
            return false;
        }
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(ComboItem.class);
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)ComboItem.PROP_ITEM_ID, (Object)menuItemId));
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            if (number != null && number.intValue() > 0) {
                boolean bl = true;
                return bl;
            }
            Criteria groupCriteria = session.createCriteria(ComboGroup.class);
            groupCriteria = groupCriteria.createAlias("items", "item");
            groupCriteria.add(Restrictions.in((String)"item.id", Arrays.asList(menuItemId)));
            int rowCount = this.rowCount(groupCriteria);
            if (rowCount > 0) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public List<ComboItem> getByMenuItem(String menuItemId, Session session) {
        if (StringUtils.isEmpty((String)menuItemId)) {
            return new ArrayList<ComboItem>(0);
        }
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.add((Criterion)Restrictions.eq((String)ComboItem.PROP_ITEM_ID, (Object)menuItemId));
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
        return criteria.list();
    }

    public boolean isContain(String menuItemId, Session session) {
        if (StringUtils.isEmpty((String)menuItemId)) {
            return false;
        }
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.add((Criterion)Restrictions.eq((String)ComboItem.PROP_ITEM_ID, (Object)menuItemId));
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
        criteria.setProjection(Projections.rowCount());
        Number number = (Number)criteria.uniqueResult();
        return number != null && number.intValue() > 0;
    }
}

