/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.CreditBook;
import com.floreantpos.model.CreditBookType;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.dao.BaseCreditBookDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.util.NumberUtil;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class CreditBookDAO
extends BaseCreditBookDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CreditBook> findByMemberId(String memberId) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)CreditBook.PROP_CUSTOMER_ID, (Object)memberId));
            List list = criteria.list();
            if (!list.isEmpty()) {
                for (CreditBook creditBook : list) {
                    criteria = session.createCriteria(CreditBookType.class);
                    criteria.add((Criterion)Restrictions.eq((String)CreditBookType.PROP_ID, (Object)creditBook.getCreditBookTypeId()));
                    criteria.setProjection((Projection)Projections.property((String)CreditBookType.PROP_LABEL));
                    String creditBookTypeLabel = (String)criteria.uniqueResult();
                    creditBook.setCreditBookTypeLabel(creditBookTypeLabel);
                }
                List list2 = list;
                return list2;
            }
            List<CreditBook> list3 = null;
            return list3;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CreditBook> findByMemberAndCreditBookTypeId(String memberId, String creditBookTypeId) {
        Session session = null;
        try {
            session = this.createNewSession();
            List<CreditBook> list = this.findByMemberAndCreditBookTypeId(memberId, creditBookTypeId, session);
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<CreditBook> findByMemberAndCreditBookTypeId(String memberId, String creditBookTypeId, Session session) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.addOrder(Order.asc((String)CreditBook.PROP_EXPIRY_DATE));
        criteria.add((Criterion)Restrictions.eq((String)CreditBook.PROP_CUSTOMER_ID, (Object)memberId));
        criteria.add((Criterion)Restrictions.eq((String)CreditBook.PROP_CREDIT_BOOK_TYPE_ID, (Object)creditBookTypeId));
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)CreditBook.PROP_EXPIRY_DATE), (Criterion)Restrictions.ge((String)CreditBook.PROP_EXPIRY_DATE, (Object)DateUtil.startOfDay(StoreDAO.getServerTimestamp()))));
        criteria.add((Criterion)Restrictions.eq((String)CreditBook.PROP_EXPIRED, (Object)Boolean.FALSE));
        List list = criteria.list();
        if (!list.isEmpty()) {
            return list;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CreditBook> findByOrdertype(OrderType orderType, String memberId) {
        Session session = null;
        try {
            List list;
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(CreditBookType.class, "creditBookType");
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add((Projection)Projections.property((String)CreditBookType.PROP_LABEL));
            criteria.setProjection((Projection)projectionList);
            List creditBookTypeIdList = criteria.list();
            criteria = session.createCriteria(CreditBook.class);
            criteria.add((Criterion)Restrictions.eq((String)CreditBook.PROP_EXPIRED, (Object)false));
            criteria.add((Criterion)Restrictions.eq((String)CreditBook.PROP_CUSTOMER_ID, (Object)memberId));
            criteria.list();
            if (!creditBookTypeIdList.isEmpty()) {
                // empty if block
            }
            if (!(list = criteria.list()).isEmpty()) {
                List list2 = list;
                return list2;
            }
            List<CreditBook> list3 = null;
            return list3;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void adjustCreditBookBalance(double transactionAmount, List<CreditBook> creditBooks) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            this.adjustCreditBookBalance(transactionAmount, creditBooks, session);
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void adjustCreditBookBalance(double transactionAmount, List<CreditBook> creditBooks, Session session) {
        double reducedAmount = 0.0;
        ArrayList<CreditBook> updatedCreditBook = new ArrayList<CreditBook>();
        for (CreditBook creditBook : creditBooks) {
            reducedAmount = transactionAmount - creditBook.getBalance();
            if (reducedAmount <= 0.0) {
                creditBook.setBalance(NumberUtil.roundToTwoDigit(Math.abs(reducedAmount)));
                updatedCreditBook.add(creditBook);
                break;
            }
            creditBook.setBalance(0.0);
            transactionAmount = reducedAmount;
            updatedCreditBook.add(creditBook);
        }
        for (CreditBook creditBook : updatedCreditBook) {
            this.saveOrUpdate(creditBook, session);
        }
    }
}

