/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.Currency;
import com.floreantpos.model.dao.BaseCurrencyDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class CurrencyDAO
extends BaseCurrencyDAO {
    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveOrUpdate(Currency currency) {
        Transaction transaction = null;
        try (Session session = null;){
            List<Currency> mainCurrencies;
            session = this.createNewSession();
            transaction = session.beginTransaction();
            if (currency.isMain().booleanValue() && (mainCurrencies = this.getMainCurrencies(session, currency.getId())) != null && mainCurrencies.size() > 0) {
                for (Currency currency2 : mainCurrencies) {
                    currency2.setMain(false);
                    this.update(currency2, session);
                }
            }
            this.saveOrUpdate(currency, session);
            transaction.commit();
        }
    }

    public void saveOrUpdateCurrency(List<Currency> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (dataList == null) {
            return;
        }
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (Currency item : dataList) {
                Currency existingItem = this.get(item.getId(), session);
                boolean mainCurr = item.isMain();
                if (existingItem != null) {
                    if (!BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), item.getName() + " already updated");
                        continue;
                    }
                    long version = existingItem.getVersion();
                    boolean deleted = item.isDeleted();
                    PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                    existingItem.setVersion(version);
                    mainCurr = this.doCheckMainCurrencyAndUpdate(session, item, mainCurr);
                    existingItem.setMain(mainCurr);
                    existingItem.setDeleted(deleted);
                    existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
                    existingItem.setUpdateSyncTime(updateSyncTime);
                    this.update(existingItem, session);
                    continue;
                }
                mainCurr = this.doCheckMainCurrencyAndUpdate(session, item, mainCurr);
                item.setMain(mainCurr);
                item.setUpdateLastUpdateTime(updateLastUpdateTime);
                item.setUpdateSyncTime(updateSyncTime);
                this.save(item, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    private boolean doCheckMainCurrencyAndUpdate(Session session, Currency item, boolean mainCurr) {
        List<Currency> mainCurrencies;
        if (mainCurr && (mainCurrencies = this.getMainCurrencies(session, item.getId())) != null && mainCurrencies.size() > 0) {
            for (Currency currency2 : mainCurrencies) {
                if (item.getLastUpdateTime() == null) {
                    return false;
                }
                if (currency2.getLastUpdateTime() == null || item.getLastUpdateTime().after(currency2.getLastUpdateTime())) {
                    currency2.setMain(false);
                    this.update(currency2, session);
                    continue;
                }
                mainCurr = false;
            }
        }
        return mainCurr;
    }

    @Override
    protected void delete(Object obj, Session session) {
        Currency currency = (Currency)obj;
        if (currency == null) {
            throw new PosException(Messages.getString("CurrencyDAO.0"));
        }
        if (currency.isMain().booleanValue()) {
            throw new PosException(Messages.getString("CurrencyDAO.1"));
        }
        List<Currency> allCurrencies = this.findAll();
        if (allCurrencies.size() == 1) {
            throw new PosException(Messages.getString("CanNotDeleteLastOne"));
        }
        currency.setDeleted(true);
        this.update(currency, session);
    }

    @Override
    public List<Currency> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    public List<Currency> getMainCurrencies(Session session, String currencyId) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.add((Criterion)Restrictions.eq((String)Currency.PROP_MAIN, (Object)Boolean.TRUE));
        if (currencyId != null) {
            criteria.add((Criterion)Restrictions.ne((String)Currency.PROP_ID, (Object)currencyId));
        }
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
        return criteria.list();
    }
}

