/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.Department;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PriceRule;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.BaseDepartmentDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;

public class DepartmentDAO
extends BaseDepartmentDAO {
    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    @Override
    protected void delete(Object obj, Session session) {
        Department bean = (Department)obj;
        if (bean == null) {
            throw new PosException(Messages.getString("DepartmentDAO.0"));
        }
        this.checkForeignRelation(bean);
        bean.setDeleted(Boolean.TRUE);
        this.update(bean, session);
    }

    private void checkForeignRelation(Department bean) throws PosException {
        String id = bean.getId();
        StringBuilder ref = new StringBuilder();
        StringBuilder details = new StringBuilder();
        try (Session ses = this.createNewSession();){
            GenericDAO dao = GenericDAO.getInstance();
            this.append(dao.getForeignDataListNames(ses, MenuCategory.class, "departments", Department.PROP_ID, id), Messages.getString("DepartmentDAO.2"), ref, details);
            this.append(dao.getForeignDataListNames(ses, OrderType.class, "departments", Department.PROP_ID, id), Messages.getString("DepartmentDAO.4"), ref, details);
            this.append(dao.getForeignDataListNames(ses, Outlet.class, "departments", Department.PROP_ID, id), Messages.getString("DepartmentDAO.6"), ref, details);
            this.append(dao.getForeignDataListNames(ses, SalesArea.class, SalesArea.PROP_DEPARTMENT_ID, id), Messages.getString("DepartmentDAO.7"), ref, details);
            this.append(dao.getForeignDataListNames(ses, PriceRule.class, PriceRule.PROP_DEPARTMENT_ID, id), Messages.getString("DepartmentDAO.8"), ref, details);
            this.append(dao.getForeignDataListNames(ses, Terminal.class, Terminal.PROP_DEPARTMENT_ID, id), Messages.getString("DepartmentDAO.9"), ref, details);
        }
        String foreignItemDetails = details.toString();
        if (StringUtils.isNotBlank((String)foreignItemDetails)) {
            String foreignReferences = ref.toString();
            if (foreignReferences.endsWith(", ")) {
                foreignReferences = foreignReferences.substring(0, foreignReferences.length() - 2);
            }
            throw new PosException(Messages.getString("DepartmentDAO.11") + foreignReferences + Messages.getString("DepartmentDAO.12") + foreignReferences + ".", foreignItemDetails);
        }
    }

    private void append(List<String> foreignDataListNames, String ref, StringBuilder refDetails, StringBuilder details) {
        if (foreignDataListNames == null || foreignDataListNames.isEmpty()) {
            return;
        }
        details.append(Messages.getString("DepartmentDAO.14") + ref + ":");
        refDetails.append(ref + ", ");
        int count = 1;
        for (String itemName : foreignDataListNames) {
            details.append("\n" + count + ". " + itemName);
            ++count;
        }
        details.append("\n");
    }

    @Override
    public List<Department> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Department initialize(Department dept) {
        if (dept == null || dept.getId() == null) {
            return dept;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)dept);
            Hibernate.initialize(dept.getOutlets());
            Department department = dept;
            return department;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Department> findByOrderType(OrderType orderType) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.getSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.createAlias("orderTypes", "o");
            criteria.add((Criterion)Restrictions.eq((String)"o.id", (Object)orderType.getId()));
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsDepartment(OrderType orderType) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            if (orderType != null) {
                criteria.createAlias("orderTypes", "o");
                criteria.add((Criterion)Restrictions.eq((String)"o.id", (Object)orderType.getId()));
            }
            this.addDeletedFilter(criteria);
            Number rowCount = (Number)criteria.uniqueResult();
            boolean bl = rowCount != null && rowCount.intValue() > 0;
            return bl;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Department> findDepartmentbyOutlet(Outlet outlet) {
        try (Session session = null;){
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            if (list == null || list.size() == 0) {
                List<Department> list2 = null;
                return list2;
            }
            List list3 = list;
            return list3;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Department findById(String departmentId) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Department.PROP_ID, (Object)departmentId));
            this.addDeletedFilter(criteria);
            Department department = (Department)criteria.uniqueResult();
            return department;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Department> findAllUnSyncDepartment() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            SimpleExpression falseCriteria = Restrictions.eq((String)Department.PROP_CLOUD_SYNCED, (Object)Boolean.FALSE);
            Criterion nullCriteria = Restrictions.isNull((String)Department.PROP_CLOUD_SYNCED);
            criteria.add((Criterion)Restrictions.or((Criterion)falseCriteria, (Criterion)nullCriteria));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void saveOrUpdateDepartments(List<Department> departments, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (departments == null) {
            return;
        }
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (Department department : departments) {
                Department existingItem = this.get(department.getId());
                if (existingItem != null) {
                    if (!BaseDataServiceDao.get().shouldSave(department.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), department.getName() + " already updated");
                        continue;
                    }
                    String id = existingItem.getId();
                    long version = existingItem.getVersion();
                    PropertyUtils.copyProperties((Object)existingItem, (Object)department);
                    existingItem.setId(id);
                    existingItem.setVersion(version);
                    existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
                    existingItem.setUpdateSyncTime(updateSyncTime);
                    this.update(existingItem, session);
                    continue;
                }
                department.setVersion(0L);
                department.setUpdateLastUpdateTime(updateLastUpdateTime);
                department.setUpdateSyncTime(updateSyncTime);
                this.save(department, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }
}

