/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.dao.BaseGiftCardDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.PaginationSupport;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class GiftCardDAO
extends BaseGiftCardDAO {
    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void delete(Object obj, Session s) {
        if (obj instanceof GiftCard) {
            GiftCard giftCard = (GiftCard)obj;
            giftCard.setDeleted(Boolean.TRUE);
            super.update(giftCard, s);
        } else {
            super.delete(obj, s);
        }
    }

    @Override
    public List<GiftCard> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    public void saveAsList(List<GiftCard> giftCardList) {
        Transaction tx = null;
        try (Session session = null;){
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (GiftCard giftCard : giftCardList) {
                String cardNumber = giftCard.getCardNumber();
                if (cardNumber == null) {
                    throw new PosException(Messages.getString("GiftCardDAO.0"));
                }
                GiftCard card = (GiftCard)session.get(GiftCard.class, (Serializable)((Object)cardNumber));
                if (card == null) {
                    cardNumber = cardNumber.replaceAll("-", "");
                    giftCard.setCardNumber(cardNumber);
                    this.save(giftCard, session);
                    continue;
                }
                card.setOwnerName(giftCard.getOwnerName());
                card.setBalance(giftCard.getBalance());
                card.setIssueDate(giftCard.getIssueDate());
                card.setActivationDate(giftCard.getActivationDate());
                card.setDeActivationDate(giftCard.getDeActivationDate());
                card.setExpiryDate(giftCard.getExpiryDate());
                card.setActive(giftCard.isActive());
                card.setDisable(giftCard.isDisable());
                card.setDurationType(giftCard.getDurationType());
                card.setDuration(giftCard.getDuration());
                card.setPinNumber(giftCard.getPinNumber());
                card.setPoint(giftCard.getPoint());
                card.setBatchNo(giftCard.getBatchNo());
                card.setEmail(giftCard.getEmail());
                card.setType(giftCard.getType());
                card.setDeleted(false);
                this.update(card, session);
            }
            tx.commit();
        }
    }

    public GiftCard findByCardNumber(Session session, String cardNumber) {
        Criteria criteria = session.createCriteria(GiftCard.class);
        this.addDeletedFilter(criteria);
        if (StringUtils.isNotEmpty((String)cardNumber)) {
            criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_CARD_NUMBER, (Object)cardNumber));
            if (criteria.list().isEmpty()) {
                return null;
            }
            return (GiftCard)criteria.list().get(0);
        }
        return null;
    }

    public GiftCard findByCardNumber(String cardNumber) {
        try (Session session = this.createNewSession();){
            GiftCard giftCard = this.findByCardNumber(session, cardNumber);
            return giftCard;
        }
    }

    public void searchByCardAndIssueDate(String cardNumber, String batchNumber, Date fromDate, Date toDate, String status, PaginationSupport model) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(GiftCard.class);
            this.addDeletedFilter(criteria);
            if (fromDate != null && toDate != null) {
                criteria.add(Restrictions.between((String)GiftCard.PROP_ISSUE_DATE, (Object)fromDate, (Object)toDate));
            }
            if (StringUtils.isNotEmpty((String)cardNumber)) {
                criteria.add(Restrictions.ilike((String)GiftCard.PROP_CARD_NUMBER, (String)cardNumber, (MatchMode)MatchMode.START));
            }
            if (StringUtils.isNotEmpty((String)batchNumber)) {
                criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_BATCH_NO, (Object)batchNumber));
            }
            if (status.equalsIgnoreCase("ACTIVE")) {
                criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_ACTIVE, (Object)true));
            } else if (status.equalsIgnoreCase("DEACTIVE")) {
                criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_ACTIVE, (Object)false));
            } else if (status.equalsIgnoreCase("DISABLED")) {
                criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_DISABLE, (Object)true));
            }
            criteria.setProjection(Projections.rowCount());
            Number uniqueResult = (Number)criteria.uniqueResult();
            model.setNumRows(uniqueResult.intValue());
            criteria.setProjection(null);
            criteria.addOrder(Order.asc((String)GiftCard.PROP_ISSUE_DATE));
            criteria.setFirstResult(model.getCurrentRowIndex());
            criteria.setMaxResults(model.getPageSize());
            model.setRows(criteria.list());
        }
    }

    public void searchByCardNoOrOwnerName(String cardNoOrOwnerName, String status, PaginationSupport model) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(GiftCard.class);
            this.addDeletedFilter(criteria);
            if (StringUtils.isNotEmpty((String)cardNoOrOwnerName)) {
                Criterion cardNoCriterion = Restrictions.ilike((String)GiftCard.PROP_CARD_NUMBER, (String)cardNoOrOwnerName, (MatchMode)MatchMode.START);
                Criterion ownerNameCriterion = Restrictions.ilike((String)GiftCard.PROP_OWNER_NAME, (String)cardNoOrOwnerName, (MatchMode)MatchMode.ANYWHERE);
                criteria.add((Criterion)Restrictions.or((Criterion)cardNoCriterion, (Criterion)ownerNameCriterion));
            }
            criteria.add((Criterion)Restrictions.ge((String)GiftCard.PROP_EXPIRY_DATE, (Object)DateUtil.startOfDay(new Date())));
            if (status.equalsIgnoreCase("ACTIVE")) {
                criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_ACTIVE, (Object)true));
            } else if (status.equalsIgnoreCase("DEACTIVE")) {
                criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_ACTIVE, (Object)false));
            } else if (status.equalsIgnoreCase("DISABLED")) {
                criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_DISABLE, (Object)true));
            }
            model.setNumRows(this.rowCount(criteria));
            criteria.addOrder(Order.asc((String)GiftCard.PROP_ISSUE_DATE));
            criteria.setFirstResult(model.getCurrentRowIndex());
            criteria.setMaxResults(model.getPageSize());
            model.setRows(criteria.list());
        }
    }

    public List<Date> findByDate() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(GiftCard.class);
            this.addDeletedFilter(criteria);
            criteria.setProjection(Projections.distinct((Projection)Projections.property((String)GiftCard.PROP_ISSUE_DATE)));
            List list = criteria.list();
            if (list.isEmpty()) {
                List<Date> list2 = null;
                return list2;
            }
            List list3 = list;
            return list3;
        }
    }

    public List<GiftCard> findExceptDisable() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(GiftCard.class);
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_DISABLE, (Object)false));
            List list = criteria.list();
            if (!list.isEmpty()) {
                List list2 = list;
                return list2;
            }
            List<GiftCard> list3 = null;
            return list3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GiftCard initialize(GiftCard giftCard) {
        if (giftCard == null) {
            return giftCard;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)giftCard);
            GiftCard giftCard2 = giftCard;
            return giftCard2;
        }
        finally {
            this.closeSession(session);
        }
    }

    public boolean findActiveCardByBatchNumber(String batchNumber) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(GiftCard.class);
            this.addDeletedFilter(criteria);
            if (StringUtils.isNotEmpty((String)batchNumber)) {
                criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_BATCH_NO, (Object)batchNumber));
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)GiftCard.PROP_ACTIVE, (Object)true), (Criterion)Restrictions.and((Criterion)Restrictions.eq((String)GiftCard.PROP_ACTIVE, (Object)false), (Criterion)Restrictions.isNotNull((String)GiftCard.PROP_ACTIVATION_DATE))));
                boolean bl = !criteria.list().isEmpty();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public boolean deleteCardListByBatchNumber(String batchNumber) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(GiftCard.class);
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_DISABLE, (Object)false));
            List giftCardList = null;
            if (StringUtils.isNotEmpty((String)batchNumber)) {
                criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_BATCH_NO, (Object)batchNumber));
                giftCardList = criteria.list();
                if (giftCardList != null) {
                    for (GiftCard giftCard : giftCardList) {
                        this.delete(giftCard);
                    }
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
    }

    public List<GiftCard> findByBatchNumber(String batchNO) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(GiftCard.class);
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_BATCH_NO, (Object)batchNO));
            List list = criteria.list();
            if (!list.isEmpty()) {
                List list2 = list;
                return list2;
            }
            List<GiftCard> list3 = null;
            return list3;
        }
    }

    public List<GiftCard> findGiftCardsToExportIntoCsvFile(Boolean active) {
        try (Session session = this.createNewSession();){
            List list;
            Criteria criteria = session.createCriteria(GiftCard.class);
            this.addDeletedFilter(criteria);
            if (active != null) {
                criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_ACTIVE, (Object)active));
            }
            if (!(list = criteria.list()).isEmpty()) {
                List list2 = list;
                return list2;
            }
            List<GiftCard> list3 = null;
            return list3;
        }
    }

    public boolean hasBatchNo(String batchNO) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(GiftCard.class);
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_BATCH_NO, (Object)batchNO));
            criteria.setMaxResults(1);
            boolean bl = criteria.list().size() > 0;
            return bl;
        }
    }

    public List<GiftCard> findGiftCards(Date fromDate, Date toDate, boolean isExpired, String sortOption) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(GiftCard.class);
            this.addDeletedFilter(criteria);
            criteria.add(Restrictions.between((String)GiftCard.PROP_ACTIVATION_DATE, (Object)fromDate, (Object)toDate));
            if (isExpired) {
                criteria.add((Criterion)Restrictions.lt((String)GiftCard.PROP_EXPIRY_DATE, (Object)new Date()));
            } else {
                criteria.add((Criterion)Restrictions.ge((String)GiftCard.PROP_EXPIRY_DATE, (Object)new Date()));
            }
            if ("Owner".equals(sortOption)) {
                criteria.addOrder(Order.asc((String)GiftCard.PROP_OWNER_NAME));
            } else {
                criteria.addOrder(Order.asc((String)GiftCard.PROP_ACTIVATION_DATE));
            }
            List list = criteria.list();
            return list;
        }
    }

    public void updateItemsLastSyncTime(List<String> ids, String tableName) {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        String whereCondition = "(";
        Iterator<String> iterator = ids.iterator();
        while (iterator.hasNext()) {
            String id = iterator.next();
            whereCondition = whereCondition + "'" + id + "'";
            if (!iterator.hasNext()) continue;
            whereCondition = whereCondition + ",";
        }
        whereCondition = whereCondition + ")";
        Transaction tx = null;
        try (Session session = this.createNewSession();){
            tx = session.beginTransaction();
            String hqlString = "update " + tableName + " set %s=:lastSyncTime where %s in %s";
            hqlString = String.format(hqlString, GiftCard.PROP_LAST_SYNC_TIME, GiftCard.PROP_CARD_NUMBER, whereCondition);
            Query query = session.createQuery(hqlString);
            Date realTime = new Date();
            query.setParameter("lastSyncTime", (Object)realTime);
            query.executeUpdate();
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
    }

    public void saveOrUpdateGiftCardList(List<GiftCard> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (dataList == null) {
            return;
        }
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (GiftCard item : dataList) {
                GiftCard existingItem = this.get(item.getCardNumber());
                if (existingItem != null) {
                    if (!BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), item.getBatchNo() + " already updated");
                        continue;
                    }
                    long version = existingItem.getVersion();
                    PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                    existingItem.setVersion(version);
                    existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
                    existingItem.setUpdateSyncTime(updateSyncTime);
                    this.update(existingItem, session);
                    continue;
                }
                item.setUpdateLastUpdateTime(updateLastUpdateTime);
                item.setUpdateSyncTime(updateSyncTime);
                this.save(item, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<GiftCard> findAllWithoutExpireDate(Session session) {
        Criteria criteria = session.createCriteria(GiftCard.class);
        this.addDeletedFilter(criteria);
        criteria.add(Restrictions.isNull((String)GiftCard.PROP_EXPIRY_DATE));
        return criteria.list();
    }

    public List<GiftCard> findAllExpiredGiftcard(Session session) {
        Criteria criteria = session.createCriteria(GiftCard.class);
        this.addDeletedFilter(criteria);
        criteria.add((Criterion)Restrictions.le((String)GiftCard.PROP_EXPIRY_DATE, (Object)DateUtil.startOfDay(new Date())));
        criteria.add((Criterion)Restrictions.eq((String)GiftCard.PROP_ACTIVE, (Object)Boolean.TRUE));
        return criteria.list();
    }
}

