/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.InventoryStock;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.PackagingUnit;
import com.floreantpos.model.dao.BaseInventoryUnitDAO;
import com.floreantpos.util.POSUtil;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class InventoryUnitDAO
extends BaseInventoryUnitDAO {
    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    @Override
    protected void delete(Object obj, Session s) {
        InventoryUnit inventoryUnit = (InventoryUnit)obj;
        if (inventoryUnit == null) {
            throw new PosException(Messages.getString("InventoryUnitDAO.0"));
        }
        if (this.isInventoryUnitUsed(inventoryUnit)) {
            throw new PosException(Messages.getString("InventoryUnitDAO.1"));
        }
        inventoryUnit.setDeleted(true);
        this.update(inventoryUnit, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nameExists(InventoryUnit unit, String code) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(InventoryUnit.class);
            if (unit.getId() != null) {
                criteria.add((Criterion)Restrictions.ne((String)InventoryUnit.PROP_ID, (Object)unit.getId()));
            }
            criteria.add((Criterion)Restrictions.eq((String)InventoryUnit.PROP_CODE, (Object)code).ignoreCase());
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount != null && rowCount.intValue() > 0) {
                boolean bl = true;
                return bl;
            }
            criteria = session.createCriteria(PackagingUnit.class);
            criteria.add((Criterion)Restrictions.eq((String)InventoryUnit.PROP_CODE, (Object)code).ignoreCase());
            criteria.setProjection(Projections.rowCount());
            rowCount = (Number)criteria.uniqueResult();
            if (rowCount != null && rowCount.intValue() > 0) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InventoryUnit> findByGroupId(String unitGroupId) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)InventoryUnit.PROP_UNIT_GROUP_ID, (Object)unitGroupId));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public List<InventoryUnit> findUnGrouped() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add(Restrictions.isNull((String)InventoryUnit.PROP_UNIT_GROUP_ID));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)InventoryUnit.PROP_DELETED), (Criterion)Restrictions.ne((String)InventoryUnit.PROP_DELETED, (Object)Boolean.TRUE)));
            List list = criteria.list();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IUnit findByCode(String code) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)InventoryUnit.PROP_CODE, (Object)code));
            List list = criteria.list();
            if (list != null && !list.isEmpty()) {
                InventoryUnit inventoryUnit = (InventoryUnit)list.get(0);
                return inventoryUnit;
            }
            criteria = session.createCriteria(PackagingUnit.class);
            criteria.add((Criterion)Restrictions.eq((String)PackagingUnit.PROP_CODE, (Object)code));
            list = criteria.list();
            if (list != null && !list.isEmpty()) {
                PackagingUnit packagingUnit = (PackagingUnit)list.get(0);
                return packagingUnit;
            }
            IUnit iUnit = null;
            return iUnit;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InventoryUnit findByName(String name) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)InventoryUnit.PROP_NAME, (Object)name));
            List list = criteria.list();
            if (list != null && !list.isEmpty()) {
                InventoryUnit inventoryUnit = (InventoryUnit)list.get(0);
                return inventoryUnit;
            }
            InventoryUnit inventoryUnit = null;
            return inventoryUnit;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInventoryUnitUsed(InventoryUnit unit) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_UNIT_NAME, (Object)unit.getCode()));
            criteria.setProjection(Projections.rowCount());
            Object uniqueResult1 = criteria.uniqueResult();
            if (POSUtil.getInteger(uniqueResult1) > 0) {
                boolean bl = true;
                return bl;
            }
            criteria = session.createCriteria(InventoryStock.class);
            criteria.add((Criterion)Restrictions.eq((String)InventoryStock.PROP_UNIT, (Object)unit.getCode()));
            criteria.setProjection(Projections.rowCount());
            Object uniqueResult2 = criteria.uniqueResult();
            if (POSUtil.getInteger(uniqueResult2) > 0) {
                boolean bl = true;
                return bl;
            }
            criteria = session.createCriteria(InventoryTransaction.class);
            criteria.add((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_UNIT, (Object)unit.getCode()));
            criteria.setProjection(Projections.rowCount());
            Object uniqueResult3 = criteria.uniqueResult();
            if (POSUtil.getInteger(uniqueResult3) > 0) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.closeSession(session);
        }
        return false;
    }

    public void saveOrUpdateInventoryUnits(List<InventoryUnit> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (dataList == null) {
            return;
        }
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (InventoryUnit item : dataList) {
                InventoryUnit existingItem = this.get(item.getId());
                if (existingItem != null) {
                    if (!BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), item.getName() + " already updated");
                        continue;
                    }
                    long version = existingItem.getVersion();
                    PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                    existingItem.setVersion(version);
                    existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
                    existingItem.setUpdateSyncTime(updateSyncTime);
                    this.update(existingItem, session);
                    continue;
                }
                item.setUpdateLastUpdateTime(updateLastUpdateTime);
                item.setUpdateSyncTime(updateSyncTime);
                this.save(item, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }
}

