/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.KitchenTicketItem;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.dao.BaseKitchenTicketItemDAO;
import com.floreantpos.model.dao.TicketItemDAO;
import com.floreantpos.model.ext.KitchenStatus;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class KitchenTicketItemDAO
extends BaseKitchenTicketItemDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<KitchenTicketItem> find(String itemId, boolean modifier) {
        Session session = null;
        try {
            session = this.getSession();
            List<KitchenTicketItem> list = this.find(itemId, modifier, session);
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<KitchenTicketItem> find(String itemId, boolean modifier, Session session) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.add((Criterion)Restrictions.eq((String)(modifier ? KitchenTicketItem.PROP_TICKET_ITEM_MODIFIER_ID : KitchenTicketItem.PROP_TICKET_ITEM_ID), (Object)itemId));
        return criteria.list();
    }

    public void markVoided(String itemId, boolean modifier, Session session) {
        String queryString = "UPDATE %s SET %s=:voidedStatus WHERE %s=:itemId";
        queryString = String.format(queryString, KitchenTicketItem.class.getSimpleName(), KitchenTicketItem.PROP_VOIDED, modifier ? KitchenTicketItem.PROP_TICKET_ITEM_MODIFIER_ID : KitchenTicketItem.PROP_TICKET_ITEM_ID);
        Query query = session.createQuery(queryString);
        query.setParameter("voidedStatus", (Object)true);
        query.setParameter("itemId", (Object)itemId);
        query.executeUpdate();
    }

    public void bumpTicketItem(KitchenTicketItem kitchenTicketItem) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            Criteria criteria = session.createCriteria(KitchenTicketItem.class);
            criteria.add((Criterion)Restrictions.eq((String)KitchenTicketItem.PROP_TICKET_ITEM_ID, (Object)kitchenTicketItem.getTicketItemId()));
            List list = criteria.list();
            for (KitchenTicketItem kitchenTicketItem2 : list) {
                kitchenTicketItem2.setStatus(KitchenStatus.BUMP.name());
                this.update(kitchenTicketItem2, session);
            }
            criteria = session.createCriteria(TicketItem.class);
            criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_ID, (Object)kitchenTicketItem.getTicketItemId()));
            List list2 = criteria.list();
            for (TicketItem ticketItem : list2) {
                ticketItem.setKitchenStatus(KitchenStatus.BUMP.name());
                TicketItemDAO.getInstance().update(ticketItem, session);
            }
            kitchenTicketItem.setStatus(KitchenStatus.BUMP.name());
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }
}

