/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.Discount;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuPage;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.BaseMenuGroupDAO;
import com.floreantpos.model.dao.DiscountDAO;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuPageDAO;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PaginationSupport;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.transform.Transformers;

public class MenuGroupDAO
extends BaseMenuGroupDAO {
    @Override
    public Serializable save(Object menuGroup, Session s) throws HibernateException {
        this.updateTime(menuGroup);
        Serializable serializable = super.save(menuGroup, s);
        this.updateDependentModels((MenuGroup)menuGroup, s);
        return serializable;
    }

    @Override
    public void update(Object menuGroup, Session s) throws HibernateException {
        this.updateTime(menuGroup);
        super.update(menuGroup, s);
        this.updateDependentModels((MenuGroup)menuGroup, s);
    }

    @Override
    public void saveOrUpdate(Object menuGroup, Session s) throws HibernateException {
        this.updateTime(menuGroup);
        super.saveOrUpdate(menuGroup, s);
        this.updateDependentModels((MenuGroup)menuGroup, s);
    }

    @Override
    public void delete(Object obj, Session s) throws HibernateException {
        MenuGroup menuGroup = (MenuGroup)obj;
        if (menuGroup == null) {
            throw new PosException(Messages.getString("MenuGroupDAO.0"));
        }
        menuGroup.setMenuCategory(null);
        menuGroup.setDeleted(true);
        this.removeFromDependentModels(menuGroup, s);
        this.update(menuGroup, s);
        this.removeFromDiscounts(menuGroup, s);
    }

    @Override
    public List<MenuGroup> findAll() {
        return this.findAllForReport(true);
    }

    public List<MenuGroup> findAllForReport(boolean isAllowSortOrder) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (isAllowSortOrder) {
                criteria.addOrder(Order.asc((String)MenuGroup.PROP_SORT_ORDER));
            }
            criteria.addOrder(Order.asc((String)MenuGroup.PROP_NAME));
            List list = criteria.list();
            return list;
        }
    }

    private void updateDependentModels(MenuGroup menuGroup, Session session) {
        String hqlString = "update MenuItem set %s=:groupName, %s=:categoryId, %s=:categoryName, %s=:beverage where %s=:groupId";
        hqlString = String.format(hqlString, MenuItem.PROP_MENU_GROUP_NAME, MenuItem.PROP_MENU_CATEGORY_ID, MenuItem.PROP_MENU_CATEGORY_NAME, MenuItem.PROP_BEVERAGE, MenuItem.PROP_MENU_GROUP_ID);
        Query query = session.createQuery(hqlString);
        query.setParameter("groupName", (Object)menuGroup.getName());
        query.setParameter("categoryId", (Object)menuGroup.getMenuCategoryId());
        query.setParameter("categoryName", (Object)menuGroup.getMenuCategoryName());
        query.setParameter("beverage", (Object)menuGroup.isBeverage());
        query.setParameter("groupId", (Object)menuGroup.getId());
        query.executeUpdate();
        session.saveOrUpdate((Object)menuGroup);
    }

    private void removeFromDependentModels(MenuGroup menuGroup, Session session) {
        String menuGroupId = menuGroup.getId();
        String hqlString = "update MenuItem set " + MenuItem.PROP_MENU_GROUP_NAME + "= null, " + MenuItem.PROP_MENU_GROUP_ID + "= null, " + MenuItem.PROP_MENU_CATEGORY_ID + "= null, " + MenuItem.PROP_MENU_CATEGORY_NAME + "= null, %s=:beverage where %s=:groupId";
        hqlString = String.format(hqlString, MenuItem.PROP_BEVERAGE, MenuItem.PROP_MENU_GROUP_ID);
        Query query = session.createQuery(hqlString);
        query.setParameter("beverage", (Object)false);
        query.setParameter("groupId", (Object)menuGroupId);
        query.executeUpdate();
        MenuPageDAO menuPageDAO = MenuPageDAO.getInstance();
        List<MenuPage> menuPages = menuPageDAO.findByGroup(menuGroup);
        if (menuPages != null && !menuPages.isEmpty()) {
            menuPageDAO.deleteAll(menuPages, session);
        }
    }

    private void removeFromDiscounts(MenuGroup menuGroup, Session session) {
        DiscountDAO discountDAO = DiscountDAO.getInstance();
        List<Discount> discounts = discountDAO.getDiscountsByMenuGroup(menuGroup, session);
        if (discounts != null && !discounts.isEmpty()) {
            for (Discount discount : discounts) {
                List<MenuGroup> menuGroups = discount.getMenuGroups();
                menuGroups.remove(menuGroup);
                discountDAO.saveOrUpdate(discount, session);
            }
        }
    }

    public void initialize(MenuGroup menuGroup) {
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)menuGroup);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadGroupsForGroupView(OrderType orderType, MenuCategory parentCategory, PaginatedListModel listModel) throws PosException {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (orderType != null && orderType.getId() != null) {
                criteria.createAlias(MenuGroup.PROP_MENU_PAGES, "menuPage");
                MenuPageDAO.addOrderTypeCriteria(orderType, criteria, "menuPage.");
            }
            criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_VISIBLE, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (parentCategory != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_MENU_CATEGORY_ID, (Object)parentCategory.getId()));
            }
            criteria.add(Restrictions.isNotEmpty((String)MenuGroup.PROP_MENU_PAGES));
            criteria.addOrder(Order.asc((String)MenuGroup.PROP_SORT_ORDER));
            criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
            List list = criteria.list();
            listModel.setNumRows(list.size());
            listModel.setPageSize(listModel.getNumRows());
            listModel.setData(list);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<MenuGroup> loadActiveGroupsByOrderType(OrderType orderType) throws PosException {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_VISIBLE, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            List<MenuCategory> activeCategories = MenuCategoryDAO.getInstance().findActiveCategories(orderType);
            ArrayList<String> activeCatIds = new ArrayList<String>();
            for (MenuCategory menuCategory : activeCategories) {
                activeCatIds.add(menuCategory.getId());
            }
            if (!activeCatIds.isEmpty()) {
                criteria.add(Restrictions.in((String)MenuGroup.PROP_MENU_CATEGORY_ID, activeCatIds));
            }
            criteria.setProjection(null);
            criteria.addOrder(Order.asc((String)MenuGroup.PROP_SORT_ORDER));
            List list = criteria.list();
            return list;
        }
    }

    public List<MenuGroup> findEnabledByParent(MenuCategory menuCategory) throws PosException {
        try (Session session = this.createNewSession();){
            List list;
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_VISIBLE, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (menuCategory != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_MENU_CATEGORY_ID, (Object)menuCategory.getId()));
            }
            criteria.addOrder(Order.asc((String)MenuGroup.PROP_SORT_ORDER));
            List list2 = list = criteria.list();
            return list2;
        }
    }

    public List<String> findEnabledGroupsIdsByParent(MenuCategory menuCategory) throws PosException {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection((Projection)Projections.property((String)MenuGroup.PROP_ID));
            criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_VISIBLE, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (menuCategory != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_MENU_CATEGORY_ID, (Object)menuCategory.getId()));
            }
            criteria.addOrder(Order.asc((String)MenuGroup.PROP_SORT_ORDER));
            List list = criteria.list();
            return list;
        }
    }

    public List<MenuGroup> findByParent(MenuCategory menuCategory) throws PosException {
        try (Session session = this.createNewSession();){
            List list;
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (menuCategory != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_MENU_CATEGORY_ID, (Object)menuCategory.getId()));
            }
            criteria.addOrder(Order.asc((String)MenuGroup.PROP_SORT_ORDER));
            List list2 = list = criteria.list();
            return list2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasChildren(Terminal terminal, MenuGroup group, OrderType orderType) throws PosException {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(MenuItem.class);
            criteria.add(Restrictions.eqOrIsNull((String)MenuItem.PROP_DELETED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            boolean bl = rowCount.intValue() > 0;
            return bl;
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            throw new PosException("");
        }
    }

    public void releaseParent(List<MenuGroup> menuGroupList) {
        if (menuGroupList == null) {
            return;
        }
        Transaction tx = null;
        try (Session session = this.createNewSession();){
            tx = session.beginTransaction();
            for (MenuGroup menuGroup : menuGroupList) {
                menuGroup.setMenuCategoryId(null);
                session.saveOrUpdate((Object)menuGroup);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            LogFactory.getLog(ShopTableDAO.class).error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public void releaseParentAndDelete(MenuGroup group) {
        if (group == null) {
            return;
        }
        this.initialize(group);
        Transaction tx = null;
        try (Session session = this.createNewSession();){
            tx = session.beginTransaction();
            String queryString = "delete from MENUGROUP_DISCOUNT where MENUGROUP_ID='%s'";
            queryString = String.format(queryString, group.getId());
            SQLQuery query = session.createSQLQuery(queryString);
            query.executeUpdate();
            String queryString2 = "update MENU_ITEM set GROUP_ID=null where GROUP_ID='%s'";
            queryString2 = String.format(queryString2, group.getId());
            SQLQuery query2 = session.createSQLQuery(queryString2);
            query2.executeUpdate();
            session.delete((Object)group);
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            LogFactory.getLog(ShopTableDAO.class).error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public boolean existsMenuGroups(MenuCategory menuCategory) {
        Criteria criteria = null;
        try (Session session = this.createNewSession();){
            Number rowCount;
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (menuCategory != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_MENU_CATEGORY_ID, (Object)menuCategory.getId()));
            }
            boolean bl = (rowCount = (Number)criteria.uniqueResult()) != null && rowCount.intValue() > 0;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMenuGroups(PaginationSupport paginationSupport, String itemName, MenuCategory menuCategory, String ... fields) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(MenuGroup.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (StringUtils.isNotEmpty((String)itemName)) {
                criteria.add(Restrictions.ilike((String)MenuGroup.PROP_NAME, (String)itemName.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (menuCategory != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_MENU_CATEGORY_ID, (Object)menuCategory.getId()));
            }
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount != null) {
                paginationSupport.setNumRows(rowCount.intValue());
            }
            criteria.setProjection(null);
            criteria.addOrder(Order.asc((String)MenuGroup.PROP_SORT_ORDER));
            criteria.addOrder(Order.asc((String)MenuGroup.PROP_NAME));
            if (fields != null && fields.length > 0) {
                ProjectionList projectionList = Projections.projectionList();
                for (String field : fields) {
                    projectionList.add((Projection)Projections.property((String)field), field);
                }
                criteria.setProjection((Projection)projectionList);
                criteria.setResultTransformer(Transformers.aliasToBean(MenuGroup.class));
                paginationSupport.setRows(criteria.list());
            } else {
                paginationSupport.setRows(criteria.list());
            }
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<MenuGroup> findGroupsWithInventoryItems() throws PosException {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)Boolean.TRUE));
            criteria.setProjection((Projection)Projections.property((String)MenuItem.PROP_MENU_GROUP_ID));
            List groupIdList = criteria.list();
            criteria = session.createCriteria(MenuGroup.class);
            if (!groupIdList.isEmpty()) {
                criteria.add(Restrictions.in((String)MenuGroup.PROP_ID, (Collection)groupIdList));
            }
            List list = criteria.list();
            return list;
        }
    }

    public MenuGroup findMenuGroupByName(String name) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_NAME, (Object)name).ignoreCase());
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            List list = criteria.list();
            if (list != null && !list.isEmpty()) {
                MenuGroup menuGroup = (MenuGroup)list.get(0);
                return menuGroup;
            }
            MenuGroup menuGroup = null;
            return menuGroup;
        }
    }

    public List<MenuGroup> findAllUnSyncMenuGroup() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            SimpleExpression falseCriteria = Restrictions.eq((String)MenuGroup.PROP_CLOUD_SYNCED, (Object)Boolean.FALSE);
            Criterion nullCriteria = Restrictions.isNull((String)MenuGroup.PROP_CLOUD_SYNCED);
            criteria.add((Criterion)Restrictions.or((Criterion)falseCriteria, (Criterion)nullCriteria));
            List list = criteria.list();
            return list;
        }
    }

    public void saveOrUpdateMenuGroups(List<MenuGroup> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (dataList == null) {
            return;
        }
        Transaction tx = null;
        try (Session session = this.createNewSession();){
            tx = session.beginTransaction();
            for (MenuGroup item : dataList) {
                MenuGroup existingItem = this.get(item.getId());
                if (existingItem != null) {
                    if (!BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), item.getName() + " already updated");
                        continue;
                    }
                    String id = existingItem.getId();
                    long version = existingItem.getVersion();
                    List<MenuPage> menuPages = existingItem.getMenuPages();
                    PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                    existingItem.setId(id);
                    existingItem.setVersion(version);
                    existingItem.setMenuPages(menuPages);
                    existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
                    existingItem.setUpdateSyncTime(updateSyncTime);
                    this.update(existingItem, session);
                    continue;
                }
                item.setUpdateLastUpdateTime(updateLastUpdateTime);
                item.setUpdateSyncTime(updateSyncTime);
                this.save(item, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
    }

    public void findGroups(PaginationSupport model, String gruopName, MenuCategory menuCategory) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(MenuGroup.class);
            this.addDeletedFilter(criteria);
            if (StringUtils.isNotBlank((String)gruopName)) {
                criteria.add(Restrictions.ilike((String)MenuGroup.PROP_NAME, (String)gruopName, (MatchMode)MatchMode.ANYWHERE));
            }
            if (menuCategory != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuGroup.PROP_MENU_CATEGORY_ID, (Object)menuCategory.getId()));
            }
            model.setNumRows(this.rowCount(criteria));
            criteria.setFirstResult(model.getCurrentRowIndex());
            criteria.setMaxResults(model.getPageSize());
            criteria.addOrder(Order.asc((String)MenuGroup.PROP_SORT_ORDER));
            criteria.addOrder(Order.asc((String)MenuGroup.PROP_NAME).ignoreCase());
            model.setRows(criteria.list());
        }
    }
}

