/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.dao.BaseMenuItemModifierSpecDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class MenuItemModifierSpecDAO
extends BaseMenuItemModifierSpecDAO {
    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuItemModifierSpec initialize(MenuItemModifierSpec menuItemModifierSpec) {
        if (menuItemModifierSpec == null || menuItemModifierSpec.getId() == null) {
            return menuItemModifierSpec;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)menuItemModifierSpec);
            Hibernate.initialize(menuItemModifierSpec.getDefaultModifierList());
            Hibernate.initialize(menuItemModifierSpec.getModifierPages());
            MenuItemModifierSpec menuItemModifierSpec2 = menuItemModifierSpec;
            return menuItemModifierSpec2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuItemModifierSpec findByGroup(ModifierGroup modifierGroup) {
        try (Session session = null;){
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)MenuItemModifierSpec.PROP_MODIFIER_GROUP_ID, (Object)(modifierGroup == null ? null : modifierGroup.getId())));
            List list = criteria.list();
            if (list != null && !list.isEmpty()) {
                MenuItemModifierSpec menuItemModifierSpec = (MenuItemModifierSpec)list.get(0);
                return menuItemModifierSpec;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItemModifierSpec> findMenuItemModifierSpecsByGroup(ModifierGroup modifierGroup) {
        try (Session session = null;){
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)MenuItemModifierSpec.PROP_MODIFIER_GROUP_ID, (Object)(modifierGroup == null ? null : modifierGroup.getId())));
            List list = criteria.list();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuItemModifierSpec findByMenuItemId(String menuItemId) {
        try (Session session = null;){
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)MenuItemModifierSpec.PROP_MENU_ITEM_ID, (Object)menuItemId));
            List list = criteria.list();
            if (list != null && !list.isEmpty()) {
                MenuItemModifierSpec menuItemModifierSpec = (MenuItemModifierSpec)list.get(0);
                return menuItemModifierSpec;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItemModifierSpec> findByMenuItem(String menuItemId) {
        try (Session session = null;){
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)MenuItemModifierSpec.PROP_MENU_ITEM_ID, (Object)menuItemId));
            List list = criteria.list();
            return list;
        }
    }

    public void saveOrUpdate(MenuItemModifierSpec spec, MenuItemModifierPage page) {
        Transaction tx = null;
        try (Session session = null;){
            session = this.createNewSession();
            tx = session.beginTransaction();
            session.saveOrUpdate((Object)page);
            session.saveOrUpdate((Object)spec);
            tx.commit();
        }
    }

    public void saveOrUpdateMenuItemModifierSpecList(List<MenuItemModifierSpec> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (dataList == null) {
            return;
        }
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (MenuItemModifierSpec item : dataList) {
                BaseDataServiceDao.get().saveOrSetVersionMenuItemModifierSpecs(session, updateLastUpdateTime, updateSyncTime, null, item);
                this.saveOrUpdate(item, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }
}

