/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.dao.BaseModifierGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuItemModifierSpecDAO;
import com.floreantpos.swing.PaginationSupport;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;

public class ModifierGroupDAO
extends BaseModifierGroupDAO {
    private static final String EMPTY_NEWLINE_STRING = "\n";

    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    @Override
    public List<ModifierGroup> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    private String constructExceptionDetailsByMenuitem(ModifierGroup modifierGroup, List<String> foreignItemNames) {
        if (foreignItemNames != null && !foreignItemNames.isEmpty()) {
            StringBuilder builder = new StringBuilder(modifierGroup.getName() + " " + Messages.getString("DiscountDAO.3"));
            for (int i = 0; i < foreignItemNames.size(); ++i) {
                String message = i + 1 + ". " + foreignItemNames.get(i);
                builder.append(EMPTY_NEWLINE_STRING).append(message);
            }
            return builder.toString();
        }
        return "";
    }

    @Override
    protected void delete(Object obj, Session session) {
        ModifierGroup modifierGroup = (ModifierGroup)obj;
        if (modifierGroup == null) {
            throw new PosException(Messages.getString("ModifierGroupDAO.0"));
        }
        StringBuilder details = new StringBuilder();
        List<String> foreignItemNames = this.getMenuItemByModifierGroup(modifierGroup, session);
        if (foreignItemNames != null && !foreignItemNames.isEmpty()) {
            details.append(this.constructExceptionDetailsByMenuitem(modifierGroup, foreignItemNames));
            details.append(EMPTY_NEWLINE_STRING);
        }
        String message = Messages.getString("ModifierGroupDAO.1");
        String detailsMessage = details.toString();
        if (StringUtils.isNotBlank((String)detailsMessage)) {
            throw new PosException(message, detailsMessage);
        }
        modifierGroup.setDeleted(true);
        this.update(modifierGroup, session);
    }

    private List<String> getMenuItemByModifierGroup(ModifierGroup modifierGroup, Session session) {
        Criteria criteria = session.createCriteria(MenuItem.class);
        criteria.setProjection(Projections.distinct((Projection)Projections.property((String)MenuItem.PROP_NAME)));
        criteria.createAlias("menuItemModiferSpecs", "specs");
        criteria.add((Criterion)Restrictions.eq((String)("specs." + MenuItemModifierSpec.PROP_MODIFIER_GROUP_ID), (Object)modifierGroup.getId()));
        this.addDeletedFilter(criteria, MenuItem.class);
        return criteria.list();
    }

    private void deleteModifierGroupFromModifierSpec(ModifierGroup modifierGroup, Session session) {
        Criteria criteria = session.createCriteria(MenuItemModifierSpec.class);
        criteria.add((Criterion)Restrictions.eq((String)MenuItemModifierSpec.PROP_MODIFIER_GROUP_ID, (Object)modifierGroup.getId()));
        List itemModifierSpecs = criteria.list();
        if (itemModifierSpecs == null || itemModifierSpecs.isEmpty()) {
            return;
        }
        for (MenuItemModifierSpec itemModifierSpec : itemModifierSpecs) {
            this.removeMenuItemModifierSpecFromMenuItem(itemModifierSpec, session);
            MenuItemModifierSpecDAO.getInstance().delete(itemModifierSpec, session);
        }
    }

    private void removeMenuItemModifierSpecFromMenuItem(MenuItemModifierSpec modifierSpec, Session session) {
        Criteria criteria = session.createCriteria(MenuItem.class);
        criteria.createAlias("menuItemModiferSpecs", "modifierSpecs");
        criteria.add((Criterion)Restrictions.eq((String)("modifierSpecs." + MenuItem.PROP_ID), (Object)modifierSpec.getId()));
        List menuItems = criteria.list();
        if (menuItems == null || menuItems.isEmpty()) {
            return;
        }
        for (MenuItem menuItem : menuItems) {
            menuItem.getMenuItemModiferSpecs().remove(modifierSpec);
            MenuItemDAO.getInstance().update(menuItem, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ModifierGroup> findPizzaModifierGroups() {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(ModifierGroup.class);
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)ModifierGroup.PROP_PIZZA_MODIFIER_GROUP, (Object)Boolean.TRUE));
            List list = criteria.list();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ModifierGroup> findNormalModifierGroups() {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(ModifierGroup.class);
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)ModifierGroup.PROP_PIZZA_MODIFIER_GROUP), (Criterion)Restrictions.eq((String)ModifierGroup.PROP_PIZZA_MODIFIER_GROUP, (Object)Boolean.FALSE)));
            List list = criteria.list();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPizzaModifierGroup() {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(ModifierGroup.class);
            criteria.setProjection(Projections.rowCount());
            criteria.add((Criterion)Restrictions.eq((String)ModifierGroup.PROP_PIZZA_MODIFIER_GROUP, (Object)Boolean.TRUE));
            Number rowCount = (Number)criteria.uniqueResult();
            boolean bl = rowCount != null && rowCount.intValue() > 0;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateModifierGroupBooleanPropertyValue(boolean pizzaGroup) {
        if (this.hasPizzaModifierGroup()) {
            return;
        }
        Session session = null;
        Criteria criteria = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            criteria = session.createCriteria(ModifierGroup.class);
            criteria.createAlias("modifiers", "m");
            if (pizzaGroup) {
                criteria.add((Criterion)Restrictions.eq((String)"m.pizzaModifier", (Object)Boolean.TRUE));
            } else {
                criteria.add((Criterion)Restrictions.ne((String)"m.pizzaModifier", (Object)Boolean.TRUE));
            }
            List list = criteria.list();
            if (list != null && list.size() > 0) {
                for (ModifierGroup group : list) {
                    group.setPizzaModifierGroup(pizzaGroup);
                    this.saveOrUpdate(group, session);
                }
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModifierGroup findModifierGroupByName(String name) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)ModifierGroup.PROP_NAME, (Object)name));
            List list = criteria.list();
            if (list != null && !list.isEmpty()) {
                ModifierGroup modifierGroup = (ModifierGroup)list.get(0);
                return modifierGroup;
            }
            ModifierGroup modifierGroup = null;
            return modifierGroup;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ModifierGroup> findAllUnSyncModifierGroup() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            SimpleExpression falseCriteria = Restrictions.eq((String)ModifierGroup.PROP_CLOUD_SYNCED, (Object)Boolean.FALSE);
            Criterion nullCriteria = Restrictions.isNull((String)ModifierGroup.PROP_CLOUD_SYNCED);
            criteria.add((Criterion)Restrictions.or((Criterion)falseCriteria, (Criterion)nullCriteria));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void updateModifierGroupSync(List<String> ids, Boolean synced) {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        String whereCondition = "(";
        Iterator<String> iterator = ids.iterator();
        while (iterator.hasNext()) {
            String id = iterator.next();
            whereCondition = whereCondition + "'" + id + "'";
            if (!iterator.hasNext()) continue;
            whereCondition = whereCondition + ",";
        }
        whereCondition = whereCondition + ")";
        Transaction tx = null;
        Session session = null;
        try {
            session = this.getSession();
            tx = session.beginTransaction();
            String hqlString = "update ModifierGroup set %s=:synced where %s in" + whereCondition;
            hqlString = String.format(hqlString, ModifierGroup.PROP_CLOUD_SYNCED, ModifierGroup.PROP_ID);
            Query query = session.createQuery(hqlString);
            query.setParameter("synced", (Object)synced);
            query.executeUpdate();
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findModifierGroupByName(PaginationSupport paginationSupport, String itemName) {
        Session session = null;
        try {
            Number rowCount;
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.setProjection(Projections.rowCount());
            if (StringUtils.isNotEmpty((String)itemName)) {
                criteria.add(Restrictions.ilike((String)ModifierGroup.PROP_NAME, (String)itemName.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            if ((rowCount = (Number)criteria.uniqueResult()) != null) {
                paginationSupport.setNumRows(rowCount.intValue());
            }
            criteria.setProjection(null);
            criteria.addOrder(Order.asc((String)ModifierGroup.PROP_SORT_ORDER));
            paginationSupport.setRows(criteria.list());
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateModifierGroups(List<ModifierGroup> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (dataList == null) {
            return;
        }
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (ModifierGroup item : dataList) {
                ModifierGroup existingItem = this.get(item.getId());
                if (existingItem != null) {
                    if (!BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), item.getName() + " already updated");
                        continue;
                    }
                    long version = existingItem.getVersion();
                    PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                    existingItem.setVersion(version);
                    existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
                    existingItem.setUpdateSyncTime(updateSyncTime);
                    this.update(existingItem, session);
                    continue;
                }
                item.setUpdateLastUpdateTime(updateLastUpdateTime);
                item.setUpdateSyncTime(updateSyncTime);
                this.save(item, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void initialize(ModifierGroup modifierGroup) {
        if (modifierGroup == null || modifierGroup.getId() == null) {
            return;
        }
        if (Hibernate.isInitialized(modifierGroup.getModifiers())) {
            return;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)modifierGroup);
            Hibernate.initialize(modifierGroup.getModifiers());
        }
        finally {
            this.closeSession(session);
        }
    }

    public void findModifierGroups(PaginationSupport model, String itemName) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            if (StringUtils.isNotBlank((String)itemName)) {
                criteria.add(Restrictions.ilike((String)ModifierGroup.PROP_NAME, (String)itemName, (MatchMode)MatchMode.ANYWHERE));
            }
            model.setNumRows(this.rowCount(criteria));
            criteria.setFirstResult(model.getCurrentRowIndex());
            criteria.setMaxResults(model.getPageSize());
            criteria.addOrder(Order.asc((String)ModifierGroup.PROP_SORT_ORDER));
            criteria.addOrder(Order.asc((String)ModifierGroup.PROP_NAME).ignoreCase());
            model.setRows(criteria.list());
        }
    }
}

