/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.model.PriceRule;
import com.floreantpos.model.PriceTable;
import com.floreantpos.model.dao.BasePriceTableDAO;
import com.floreantpos.model.dao.PriceRuleDAO;
import java.io.Serializable;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;

public class PriceTableDAO
extends BasePriceTableDAO {
    private static final String EMPTY_STRING = "";
    private static final String EMPTY_NEWLINE_STRING = "\n";
    private static final String EMPTY_DOT_STRING = ".";
    private static final String EMPTY_SPACE_STRING = " ";

    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void delete(Object obj, Session s) {
        if (obj instanceof PriceTable) {
            PriceTable priceTable = (PriceTable)obj;
            this.checkForeignRelation(priceTable, s);
            priceTable.setDeleted(Boolean.TRUE);
            super.update(priceTable, s);
        } else {
            super.delete(obj, s);
        }
    }

    private void checkForeignRelation(PriceTable priceTable, Session s) {
        List<PriceRule> priceRules = PriceRuleDAO.getInstance().getPriceRulesByPriceTable(priceTable, s);
        if (priceRules != null && !priceRules.isEmpty()) {
            String message = priceTable.getName() + EMPTY_SPACE_STRING + Messages.getString("PriceTableDAO.4");
            String details = this.constructExceptionDetailsByMenuItems(priceTable, priceRules);
            throw new PosException(message, details);
        }
    }

    private String constructExceptionDetailsByMenuItems(PriceTable priceTable, List<PriceRule> priceRules) {
        if (priceRules != null && !priceRules.isEmpty()) {
            StringBuilder builder = new StringBuilder(priceTable.getName() + EMPTY_SPACE_STRING + Messages.getString("PriceTableDAO.5"));
            for (int i = 0; i < priceRules.size(); ++i) {
                String message = i + 1 + EMPTY_DOT_STRING + EMPTY_SPACE_STRING + priceRules.get(i).getName();
                builder.append(EMPTY_NEWLINE_STRING).append(message);
            }
            return builder.toString();
        }
        return EMPTY_STRING;
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    @Override
    public List<PriceTable> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    @Deprecated
    public void releaseParentAndDelete(PriceTable priceTable) {
        this.delete(priceTable);
    }
}

