/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.ShopFloor;
import com.floreantpos.model.ShopSeat;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.ShopTableType;
import com.floreantpos.model.dao.BaseShopFloorDAO;
import com.floreantpos.model.dao.ShopTableDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;

public class ShopFloorDAO
extends BaseShopFloorDAO {
    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    @Override
    protected void updateTime(Object model) {
        ShopFloor shopFloor = (ShopFloor)model;
        if (shopFloor.getTables() != null) {
            for (ShopTable shopTable : shopFloor.getTables()) {
                super.updateTime(shopTable);
            }
        }
        super.updateTime(model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ShopFloor> findAll() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.addOrder(Order.asc((String)ShopFloor.PROP_SORT_ORDER));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public boolean hasFloor() {
        Number result = (Number)this.getSession().createCriteria(this.getReferenceClass()).setProjection(Projections.rowCount()).uniqueResult();
        return result.intValue() != 0;
    }

    public void initializeTables(ShopFloor shopFloor) {
        if (shopFloor == null || shopFloor.getId() == null) {
            return;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)shopFloor);
            Hibernate.initialize(shopFloor.getTables());
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    public void delete(ShopFloor shopFloor) throws HibernateException {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            this.refresh(shopFloor, session);
            shopFloor.setDeleted(Boolean.TRUE);
            Set<ShopTable> tables = shopFloor.getTables();
            if (tables != null && !tables.isEmpty()) {
                for (ShopTable shopTable : tables) {
                    shopTable.setFloorId(null);
                    ShopTableDAO.getInstance().update(shopTable, session);
                }
                shopFloor.getTables().removeAll(tables);
            }
            this.saveOrUpdate(shopFloor, session);
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            LogFactory.getLog(ShopFloorDAO.class).error((Object)e);
            throw new HibernateException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateShopFloors(List<ShopFloor> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (dataList == null) {
            return;
        }
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (ShopFloor shopFloor : dataList) {
                ShopFloor existingShopFloor = this.get(shopFloor.getId());
                ShopFloorDAO.getInstance().initializeTables(existingShopFloor);
                Set<ShopTable> shopTables = shopFloor.getTables();
                shopFloor.setTables(null);
                shopFloor.setUpdateLastUpdateTime(updateLastUpdateTime);
                shopFloor.setUpdateSyncTime(updateSyncTime);
                if (existingShopFloor == null) {
                    this.save(shopFloor, session);
                } else {
                    if (!BaseDataServiceDao.get().shouldSave(shopFloor.getLastUpdateTime(), existingShopFloor.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), shopFloor.getName() + " already updated");
                        continue;
                    }
                    shopFloor.setVersion(existingShopFloor.getVersion());
                }
                this.saveShopTables(session, shopFloor, existingShopFloor, shopTables, updateLastUpdateTime, updateSyncTime);
                shopFloor.setTables(shopTables);
                this.update(shopFloor, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    private void saveShopTables(Session session, ShopFloor shopFloor, ShopFloor existingShopFloor, Set<ShopTable> shopTables, boolean updateLastUpdateTime, boolean updateSyncTime) {
        if (shopTables != null && shopTables.size() > 0) {
            for (ShopTable table : shopTables) {
                table.setFloor(shopFloor);
                Set<ShopSeat> shopSeats = table.getSeats();
                List<ShopTableType> shopTableTypes = table.getTypes();
                table.setSeats(null);
                table.setTypes(null);
                ShopTableDAO shopTableDao = ShopTableDAO.getInstance();
                ShopTable existingTable = shopTableDao.get(table.getId());
                if (existingTable == null) {
                    table.setUpdateLastUpdateTime(updateLastUpdateTime);
                    table.setUpdateSyncTime(updateSyncTime);
                    session.save((Object)table);
                } else {
                    table.setUpdateLastUpdateTime(updateLastUpdateTime);
                    table.setUpdateSyncTime(updateSyncTime);
                    table.setVersion(existingTable.getVersion());
                    shopTableDao.initializeSeats(existingTable);
                    shopTableDao.initializeTypes(existingTable);
                }
                shopTableDao.saveOrSetVersionShopSeat(session, table, existingTable, shopSeats);
                shopTableDao.saveOrSetVersionShopTableTypes(session, table, existingTable, shopTableTypes);
            }
        }
    }
}

