/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.ShopSeat;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemSeat;
import com.floreantpos.model.dao.BaseShopSeatDAO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class ShopSeatDAO
extends BaseShopSeatDAO {
    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    public ShopSeat getShopSeatById(String id, Ticket ticket) {
        if (StringUtils.isBlank((String)id)) {
            return null;
        }
        ShopSeat shopSeat = null;
        try {
            shopSeat = this.get(id);
            if (shopSeat == null && ticket != null) {
                List<ShopSeat> extraSeats = ticket.getExtraSeats();
                if (!(extraSeats = extraSeats.stream().filter(seat -> seat.getId().equals(id)).collect(Collectors.toList())).isEmpty()) {
                    shopSeat = extraSeats.get(0);
                }
            }
        }
        catch (Exception e0) {
            PosLog.error(this.getClass(), e0);
        }
        return shopSeat;
    }

    public List<ShopSeat> getShopSeatsByTableId(Integer tableId) {
        List<ShopSeat> shopSeats = new ArrayList<ShopSeat>();
        if (tableId != null) {
            try (Session session = this.createNewSession();){
                Criteria criteria = session.createCriteria(this.getReferenceClass());
                criteria.add((Criterion)Restrictions.eq((String)ShopSeat.PROP_TABLE_ID, (Object)tableId));
                shopSeats = criteria.list();
            }
            catch (Exception e0) {
                PosLog.error(this.getClass(), e0);
            }
        }
        return shopSeats;
    }

    public List<ShopSeat> getShopSeatsByTableIds(List<Integer> tableIds) {
        List<ShopSeat> shopSeats = new ArrayList<ShopSeat>();
        if (tableIds != null && !tableIds.isEmpty()) {
            try (Session session = this.createNewSession();){
                Criteria criteria = session.createCriteria(this.getReferenceClass());
                criteria.add(Restrictions.in((String)ShopSeat.PROP_TABLE_ID, tableIds));
                shopSeats = criteria.list();
            }
            catch (Exception e0) {
                PosLog.error(this.getClass(), e0);
            }
        }
        return shopSeats;
    }

    public boolean isShopSeatServing(String shopSeatId) {
        if (StringUtils.isBlank((String)shopSeatId)) {
            return false;
        }
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(Ticket.class);
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)Boolean.FALSE));
            criteria.createAlias("ticketItems", "ti");
            criteria.add((Criterion)Restrictions.eq((String)("ti." + TicketItem.PROP_TREAT_AS_SEAT), (Object)Boolean.TRUE));
            criteria.createAlias("ti.seat", "s");
            criteria.add((Criterion)Restrictions.eq((String)("s." + TicketItemSeat.PROP_SEAT_ID), (Object)shopSeatId));
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            boolean bl = rowCount != null && rowCount.intValue() > 0;
            return bl;
        }
    }

    public List<ShopSeat> getShopSeats(Integer tableId) {
        ArrayList<ShopSeat> shopSeats = new ArrayList();
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)ShopSeat.PROP_TABLE_ID, (Object)tableId));
            criteria.addOrder(Order.asc((String)ShopSeat.PROP_SEAT_NUMBER));
            shopSeats = criteria.list();
        }
        return shopSeats;
    }
}

