/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.BookingInfo;
import com.floreantpos.model.ShopFloor;
import com.floreantpos.model.ShopSeat;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.ShopTableStatus;
import com.floreantpos.model.ShopTableTicket;
import com.floreantpos.model.ShopTableType;
import com.floreantpos.model.TableStatus;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.base.BaseBookingInfo;
import com.floreantpos.model.dao.BaseShopTableDAO;
import com.floreantpos.model.dao.BookingInfoDAO;
import com.floreantpos.model.dao.ShopSeatDAO;
import com.floreantpos.model.dao.ShopTableStatusDAO;
import com.floreantpos.model.dao.ShopTableTypeDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.util.POSUtil;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class ShopTableDAO
extends BaseShopTableDAO {
    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    @Override
    public Order getDefaultOrder() {
        return Order.asc((String)ShopTable.PROP_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ShopTable> findAll() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.addOrder(Order.asc((String)ShopTable.PROP_ID));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public int getNextTableNumber() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.setProjection((Projection)Projections.max((String)ShopTable.PROP_ID));
            int n = POSUtil.getInteger(criteria.uniqueResult());
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShopTable getByNumber(int tableNumber) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)ShopTable.PROP_ID, (Object)tableNumber));
            ShopTable shopTable = (ShopTable)criteria.uniqueResult();
            return shopTable;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ShopTable> getByFloor(ShopFloor shopFloor) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)ShopTable.PROP_FLOOR_ID, (Object)shopFloor.getId()));
            criteria.addOrder(Order.asc((String)ShopTable.PROP_ID));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<ShopTable> getAllUnassigned() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add(Restrictions.isNull((String)ShopTable.PROP_FLOOR_ID));
            this.addDeletedFilter(criteria);
            criteria.addOrder(Order.asc((String)ShopTable.PROP_ID));
            List list = criteria.list();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ShopTable> getByNumbers(Collection<Integer> tableNumbers) {
        if (tableNumbers == null || tableNumbers.size() == 0) {
            return null;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            Disjunction disjunction = Restrictions.disjunction();
            for (Integer tableNumber : tableNumbers) {
                disjunction.add((Criterion)Restrictions.eq((String)ShopTable.PROP_ID, (Object)tableNumber));
            }
            criteria.add((Criterion)disjunction);
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<ShopTable> getTables(Ticket ticket) {
        return this.getByNumbers(ticket.getTableNumbers());
    }

    public void bookedTables(List<ShopTableStatus> tables) {
        if (tables == null) {
            return;
        }
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (ShopTableStatus shopTableStatus : tables) {
                shopTableStatus.setTableStatus(TableStatus.Seat);
                session.saveOrUpdate((Object)shopTableStatus);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            LogFactory.getLog(ShopTableDAO.class).error((Object)e);
            throw new RuntimeException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public void occupyTables(Ticket ticket) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            this.occupyTables(ticket, session);
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            LogFactory.getLog(ShopTableDAO.class).error((Object)e);
            throw new RuntimeException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public void occupyTables(Ticket ticket, Session session) {
        List<Integer> tableNumbers = ticket.getTableNumbers();
        ArrayList<String> ticketNumbers = new ArrayList<String>();
        ticketNumbers.add(ticket.getId());
        User owner = ticket.getOwner();
        for (Integer tableId : tableNumbers) {
            ShopTableStatus shopTableStatus = ShopTableStatusDAO.getInstance().get(tableId, session);
            if (shopTableStatus == null) {
                shopTableStatus = new ShopTableStatus();
                shopTableStatus.setId(tableId);
            }
            String ownerId = null;
            String firstName = null;
            if (owner != null) {
                ownerId = owner.getId();
                firstName = owner.getFirstName();
            }
            shopTableStatus.setTableTicket(ticket.getId(), ticket.getTokenNo(), ownerId, firstName, ticket.getCreateDate());
            shopTableStatus.setTableStatus(TableStatus.Serving);
            shopTableStatus.setShouldPublishMqtt(ticket.isShouldPublishMqtt());
            ShopTableStatusDAO.getInstance().saveOrUpdate(shopTableStatus, session);
        }
    }

    public void freeBookedTables(List<ShopTableStatus> tableStatusList) {
        if (tableStatusList == null) {
            return;
        }
        Transaction transaction = null;
        try (Session session = this.createNewSession();){
            transaction = session.beginTransaction();
            for (ShopTableStatus shopTableStatus : tableStatusList) {
                List<ShopTableTicket> ticketNumbers = shopTableStatus.getTicketNumbers();
                if (ticketNumbers != null && !ticketNumbers.isEmpty()) continue;
                shopTableStatus.setTableStatus(TableStatus.Available);
                shopTableStatus.removeProperty("seat.time");
                ShopTableStatusDAO.getInstance().saveOrUpdate(shopTableStatus, session);
            }
            transaction.commit();
        }
        catch (Exception e) {
            transaction.rollback();
            LogFactory.getLog(ShopTableDAO.class).error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public void freeTables(List<ShopTableStatus> tableStatusList) {
        if (tableStatusList == null) {
            return;
        }
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (ShopTableStatus shopTableStatus : tableStatusList) {
                shopTableStatus.setTableStatus(TableStatus.Available);
                shopTableStatus.removeProperty("seat.time");
                ShopTableStatusDAO.getInstance().saveOrUpdate(shopTableStatus, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            LogFactory.getLog(ShopTableDAO.class).error((Object)e);
            throw new RuntimeException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public void freeTablesByNumbers(List<Integer> tableNumbers) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            this.freeTables(tableNumbers, session);
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            LogFactory.getLog(ShopTableDAO.class).error((Object)e);
            throw new RuntimeException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public void freeTicketTables(Ticket ticket, Session session) {
        if (ticket == null || session == null) {
            return;
        }
        List<Integer> tableNumbers = ticket.getTableNumbers();
        if (tableNumbers == null) {
            return;
        }
        for (Integer tableNumber : tableNumbers) {
            ShopTableStatus shopTableStatus = (ShopTableStatus)session.get(ShopTableStatus.class, (Serializable)tableNumber);
            List<ShopTableTicket> ticketNumbers = shopTableStatus.getTicketNumbers();
            if (ticketNumbers == null) continue;
            Iterator<ShopTableTicket> iterator = ticketNumbers.iterator();
            while (iterator.hasNext()) {
                ShopTableTicket shopTableTicket = iterator.next();
                String ticketId = shopTableTicket.getTicketId();
                if (!ticketId.equals(ticket.getId())) continue;
                iterator.remove();
            }
            shopTableStatus.setTicketNumbers(ticketNumbers);
            if (ticketNumbers.isEmpty()) {
                shopTableStatus.setTableStatus(TableStatus.Available);
                shopTableStatus.removeProperty("seat.time");
            }
            this.saveOrUpdate(shopTableStatus, session);
        }
    }

    public void freeTables(List<Integer> tableNumbers, Session session) {
        for (Integer tableId : tableNumbers) {
            ShopTableStatus shopTableStatus = (ShopTableStatus)session.get(ShopTableStatus.class, (Serializable)tableId);
            shopTableStatus.setTicketId(null);
            shopTableStatus.setTableStatus(TableStatus.Available);
            shopTableStatus.removeProperty("seat.time");
            this.saveOrUpdate(shopTableStatus, session);
        }
    }

    public void releaseTables(Ticket ticket) {
        List<ShopTable> tables = this.getTables(ticket);
        if (tables == null) {
            return;
        }
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (ShopTable shopTable : tables) {
                shopTable.setTableStatus(TableStatus.Available);
                ShopTableStatus status = shopTable.getShopTableStatus();
                status.removeProperty("seat.time");
                ShopTableStatusDAO.getInstance().update(status);
                this.saveOrUpdate(shopTable, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            LogFactory.getLog(ShopTableDAO.class).error((Object)e);
            throw new RuntimeException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public void releaseAndDeleteTicketTables(Ticket ticket) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            this.releaseTables(ticket);
            ticket.setTableNumbers(null);
            TicketDAO.getInstance().saveOrUpdate(ticket);
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            LogFactory.getLog(ShopTableDAO.class).error((Object)e);
            throw new RuntimeException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    public void delete(ShopTable shopTable) throws HibernateException {
        shopTable.setDeleted(Boolean.TRUE);
        super.update(shopTable);
    }

    public void deleteTables(Collection<ShopTable> tables) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (ShopTable shopTable : tables) {
                super.delete(shopTable, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            LogFactory.getLog(ShopTableDAO.class).error((Object)e);
            throw new RuntimeException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<ShopTableType> getTableByTypes(List<ShopTableType> types) {
        ArrayList<String> typeIds = new ArrayList<String>();
        for (ShopTableType shopTableType : types) {
            typeIds.add(shopTableType.getId());
        }
        Session session = this.getSession();
        Criteria criteria = session.createCriteria(ShopTable.class);
        criteria.createAlias("types", "t");
        criteria.add(Restrictions.in((String)"t.id", typeIds));
        criteria.addOrder(Order.asc((String)ShopTable.PROP_ID));
        return criteria.list();
    }

    public void createNewTables(int totalNumberOfTableHaveToCreate) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (int i = 0; i < totalNumberOfTableHaveToCreate; ++i) {
                ShopTable table = new ShopTable();
                table.setId(i + 1);
                table.setCapacity(4);
                super.save(table, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            LogFactory.getLog(ShopTableDAO.class).error((Object)e);
            throw new RuntimeException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public void updateTableStatus(List<Integer> tableNumbers, Integer status, Ticket ticket, boolean saveTicket) {
        try (Session session = this.createNewSession();){
            this.updateTableStatus(tableNumbers, status, ticket, saveTicket, session);
        }
    }

    public void updateTableStatus(List<Integer> tableNumbers, Integer status, Ticket ticket, boolean saveTicket, Session session) {
        if (tableNumbers == null || tableNumbers.isEmpty()) {
            return;
        }
        Transaction transaction = null;
        try {
            transaction = session.beginTransaction();
            this.updateTableStatus(tableNumbers, status, ticket, session);
            if (saveTicket) {
                session.saveOrUpdate((Object)ticket);
            }
            transaction.commit();
        }
        catch (Exception e0) {
            if (transaction != null) {
                transaction.rollback();
            }
            PosLog.error(this.getClass(), e0);
            throw new RuntimeException(e0);
        }
    }

    public void updateTableStatus(List<Integer> tableNumbers, Integer status, Ticket ticket, Session session) {
        String ticketId = null;
        ArrayList<String> tickets = new ArrayList<String>();
        String userId = null;
        String userName = null;
        if (ticket != null) {
            ticketId = ticket.getId();
            userId = ticket.getOwner().getId();
            userName = ticket.getOwner().getFirstName();
            tickets.add(ticket.getId());
        }
        for (Integer integer : tableNumbers) {
            ShopTableStatus tableStatus = ShopTableStatusDAO.getInstance().get(integer, session);
            if (tableStatus == null) continue;
            if (ticket != null) {
                tableStatus.setTableTicket(ticketId, ticket.getTokenNo(), userId, userName, ticket.getCreateDate());
            } else {
                tableStatus.setTicketId(null);
            }
            session.saveOrUpdate((Object)tableStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ShopTable> findByCapacity(String searchSubject) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (StringUtils.isEmpty((String)searchSubject)) {
                List<ShopTable> list = null;
                return list;
            }
            if (StringUtils.isNumeric((String)searchSubject)) {
                criteria.add((Criterion)Restrictions.eq((String)ShopTable.PROP_CAPACITY, (Object)Integer.valueOf(searchSubject)));
            }
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            if (list != null || list.size() > 0) {
                for (ShopTable shopTable : list) {
                    Hibernate.initialize(shopTable.getTypes());
                }
                List list2 = list;
                return list2;
            }
            List<ShopTable> list3 = null;
            return list3;
        }
        catch (Exception e) {
            PosLog.error(this.getReferenceClass(), e.getMessage(), e);
        }
        finally {
            this.closeSession(session);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getTableNames(List tableNumbers) {
        Session session = null;
        try {
            session = this.createNewSession();
            String queryString = String.format("select %s, %s from %s table where ", ShopTable.PROP_ID, ShopTable.PROP_NAME, ShopTable.class.getSimpleName());
            Query query = session.createQuery(queryString + "table.id IN (:tableNumbers)");
            query.setParameterList("tableNumbers", (Collection)tableNumbers);
            List list = query.list();
            if (list == null || list.isEmpty()) {
                List<String> list2 = null;
                return list2;
            }
            ArrayList<String> names = new ArrayList<String>();
            for (int i = 0; i < list.size(); ++i) {
                Object[] obj = (Object[])list.get(i);
                String tableName = (String)obj[1];
                if (StringUtils.isNotBlank((String)tableName)) {
                    names.add(tableName);
                    continue;
                }
                names.add(String.valueOf(obj[0]));
            }
            ArrayList<String> arrayList = names;
            return arrayList;
        }
        catch (Exception e) {
            PosLog.error(ShopTableDAO.class, e.getMessage(), e);
        }
        finally {
            this.closeSession(session);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShopTable loadWithSeats(Integer tableId) {
        if (tableId == null) {
            return null;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            ShopTable shopTable = this.get(tableId, session);
            Hibernate.initialize(shopTable.getSeats());
            Set<ShopSeat> seats = shopTable.getSeats();
            for (ShopSeat shopSeat : seats) {
                shopSeat.setShopTable(shopTable);
            }
            ShopTable shopTable2 = shopTable;
            return shopTable2;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void initializeSeats(ShopTable shopTable) {
        if (shopTable == null || shopTable.getId() == null) {
            return;
        }
        if (Hibernate.isInitialized(shopTable.getSeats())) {
            return;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)shopTable);
            Hibernate.initialize(shopTable.getSeats());
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeTablesSeats(List<ShopTable> tables) {
        Session session = null;
        try {
            session = this.createNewSession();
            for (ShopTable table : tables) {
                session.refresh((Object)table);
                Hibernate.initialize(table.getSeats());
            }
        }
        finally {
            this.closeSession(session);
        }
    }

    public void detachFloor(List<ShopTable> selectedTables) {
        if (selectedTables == null || selectedTables.isEmpty()) {
            return;
        }
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (ShopTable shopTable : selectedTables) {
                shopTable.setFloorId(null);
                this.saveOrUpdate(shopTable, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw new RuntimeException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<ShopTable> findAllWithTypes() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(ShopTable.class);
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            for (ShopTable shopTable : list) {
                Hibernate.initialize(shopTable.getTypes());
            }
            List list2 = list;
            return list2;
        }
    }

    public void initializeTypes(ShopTable shopTable) {
        if (shopTable == null || shopTable.getId() == null) {
            return;
        }
        if (Hibernate.isInitialized(shopTable.getTypes())) {
            return;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)shopTable);
            Hibernate.initialize(shopTable.getTypes());
        }
        finally {
            this.closeSession(session);
        }
    }

    public void updateTableList(List<ShopTable> tables, Session session) {
        for (ShopTable shopTable : tables) {
            this.update(shopTable, session);
        }
    }

    public void updateTableList(List<ShopTable> tables) {
        if (tables == null || tables.isEmpty()) {
            return;
        }
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            this.updateTableList(tables, session);
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw new RuntimeException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ShopTable> findByBookingInfo(String bookingInfoId) {
        Session session = null;
        try {
            List list;
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(ShopTable.class);
            criteria.add((Criterion)Restrictions.eq((String)ShopTable.PROP_CURRENT_BOOKING_ID, (Object)bookingInfoId));
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getTotalCapacity(Date fromDate, Date toDate, BookingInfo currentBookingInfo) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(ShopTable.class);
            criteria.setProjection((Projection)Projections.sum((String)ShopTable.PROP_CAPACITY));
            criteria.add((Criterion)Restrictions.eq((String)ShopTable.PROP_RESERVABLE, (Object)true));
            Long totalCapacity = (Long)criteria.uniqueResult();
            if (totalCapacity == null) {
                totalCapacity = 0L;
            }
            criteria = session.createCriteria(BookingInfo.class);
            criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.gt((String)BookingInfo.PROP_TO_DATE, (Object)fromDate), (Criterion)Restrictions.lt((String)BookingInfo.PROP_FROM_DATE, (Object)toDate))).add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)BookingInfo.PROP_STATUS, (Object)"open"), (Criterion)Restrictions.eq((String)BookingInfo.PROP_STATUS, (Object)"seat")));
            List list = criteria.list();
            ArrayList<ShopTable> bookedTableList = new ArrayList<ShopTable>();
            for (Object bookingInfo : list) {
                for (ShopTable shopTable : ((BaseBookingInfo)bookingInfo).getTables()) {
                    bookedTableList.add(shopTable);
                }
            }
            int bookedTableCapacity = 0;
            for (ShopTable shopTable : bookedTableList) {
                bookedTableCapacity += shopTable.getCapacity().intValue();
            }
            criteria.setProjection(null);
            criteria.setProjection((Projection)Projections.sum((String)BookingInfo.PROP_GUEST_COUNT));
            Long totalGuestCount = (Long)criteria.uniqueResult();
            if (totalGuestCount == null) {
                totalGuestCount = 0L;
            }
            boolean isContain = false;
            List<BookingInfo> bookingInfoByDate = BookingInfoDAO.getInstance().getAllBookingInfoByDate(fromDate, toDate);
            for (BookingInfo bookingInfo2 : bookingInfoByDate) {
                if (!currentBookingInfo.equals(bookingInfo2)) continue;
                isContain = true;
                break;
            }
            int currentBookingCapacity = 0;
            int currentBookingGuestCount = 0;
            if (currentBookingInfo.getId() != null) {
                List<ShopTable> shopTablesOfCurrentBookingInfo = currentBookingInfo.getTables();
                for (ShopTable shopTable : shopTablesOfCurrentBookingInfo) {
                    currentBookingCapacity += shopTable.getCapacity().intValue();
                }
                currentBookingGuestCount = currentBookingInfo.getGuestCount();
            }
            int totalBookedNumber = 0;
            for (BookingInfo bookingInfo : list) {
                if (bookingInfo.getTables() != null && !bookingInfo.getTables().isEmpty()) {
                    for (ShopTable shopTable : bookingInfo.getTables()) {
                        if (bookingInfo.getGuestCount() > shopTable.getCapacity()) {
                            totalBookedNumber += bookingInfo.getGuestCount().intValue();
                            continue;
                        }
                        totalBookedNumber += shopTable.getCapacity().intValue();
                    }
                    continue;
                }
                totalBookedNumber += bookingInfo.getGuestCount().intValue();
            }
            int sumTotalCapacity = 0;
            int differenceCapacity = totalBookedNumber - bookedTableCapacity;
            List<ShopTable> shopTables = this.findAll();
            List availableTables = (List)CollectionUtils.subtract(shopTables, bookedTableList);
            for (ShopTable shopTable : availableTables) {
                sumTotalCapacity += shopTable.getCapacity().intValue();
            }
            sumTotalCapacity -= differenceCapacity;
            if (isContain) {
                sumTotalCapacity = currentBookingCapacity > currentBookingGuestCount ? (sumTotalCapacity += currentBookingCapacity) : (sumTotalCapacity += currentBookingGuestCount);
            }
            if (sumTotalCapacity < 0) {
                sumTotalCapacity = 0;
            }
            Long l = sumTotalCapacity;
            return l;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ShopTable> findReservableTables() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(ShopTable.class).createAlias(ShopTable.PROP_SHOP_TABLE_STATUS, "status");
            criteria.add((Criterion)Restrictions.ne((String)("status." + ShopTableStatus.PROP_TABLE_STATUS_NUM), (Object)TableStatus.Disable.getValue()));
            criteria.add((Criterion)Restrictions.eq((String)ShopTable.PROP_RESERVABLE, (Object)true));
            this.addDeletedFilter(criteria);
            criteria.addOrder(Order.asc((String)ShopTable.PROP_ID));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteAllTables() {
        Transaction tx = null;
        try (Session session = null;){
            session = this.createNewSession();
            tx = session.beginTransaction();
            Criteria criteria = session.createCriteria(ShopTable.class);
            criteria.createAlias(ShopTable.PROP_SHOP_TABLE_STATUS, "shopTableStatus");
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)("shopTableStatus." + ShopTableStatus.PROP_TABLE_STATUS_NUM), (Object)TableStatus.Available.getValue()), (Criterion)Restrictions.eq((String)("shopTableStatus." + ShopTableStatus.PROP_TABLE_STATUS_NUM), (Object)TableStatus.Disable.getValue())));
            this.addDeletedFilter(criteria);
            List availableTableList = criteria.list();
            if (availableTableList == null || availableTableList.isEmpty()) {
                throw new PosException("Available tables not found!");
            }
            for (ShopTable table : availableTableList) {
                List<BookingInfo> bookingList = BookingInfoDAO.getInstance().findByShopTable(table, session);
                boolean isContainNotClosedBookingInfo = false;
                if (bookingList != null && !bookingList.isEmpty()) {
                    for (BookingInfo info : bookingList) {
                        if (!info.isClosed().booleanValue()) {
                            isContainNotClosedBookingInfo = true;
                            break;
                        }
                        info.setTables(null);
                        BookingInfoDAO.getInstance().saveOrUpdate(info, session);
                    }
                }
                if (isContainNotClosedBookingInfo) continue;
                table.setFloor(null);
                table.setTypes(null);
                table.setDeleted(true);
                ShopTableDAO.getInstance().saveOrUpdate(table, session);
            }
            tx.commit();
            criteria = session.createCriteria(ShopTable.class);
            this.addDeletedFilter(criteria);
            criteria.setProjection(Projections.rowCount());
            Object object = criteria.uniqueResult();
            if (object instanceof Long) {
                Long number = (Long)object;
                boolean bl = number <= 0L;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        return false;
    }

    public void saveOrUpdateShoptables(List<ShopTable> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        try (Session session = this.createNewSession();){
            this.saveOrUpdateShoptables(dataList, updateLastUpdateTime, updateSyncTime, session);
        }
    }

    public void saveOrUpdateShoptables(List<ShopTable> dataList, boolean updateLastUpdateTime, boolean updateSyncTime, Session session) throws Exception {
        if (dataList == null) {
            return;
        }
        Transaction tx = null;
        try {
            tx = session.beginTransaction();
            for (ShopTable shopTable : dataList) {
                ShopTable existingItem = this.get(shopTable.getId());
                if (existingItem != null && !BaseDataServiceDao.get().shouldSave(shopTable.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
                    PosLog.info(this.getReferenceClass(), shopTable.getId() + " already updated");
                    continue;
                }
                this.initializeSeats(existingItem);
                this.initializeTypes(existingItem);
                Set<ShopSeat> seats = shopTable.getSeats();
                List<ShopTableType> types = shopTable.getTypes();
                shopTable.setSeats(null);
                shopTable.setTypes(null);
                this.saveOrSetVersionShopTable(session, shopTable, existingItem, updateLastUpdateTime, updateSyncTime);
                this.saveOrSetVersionShopSeat(session, shopTable, existingItem, seats);
                this.saveOrSetVersionShopTableTypes(session, existingItem, existingItem, types);
                shopTable.setSeats(seats);
                shopTable.setTypes(types);
                shopTable.setUpdateLastUpdateTime(updateLastUpdateTime);
                shopTable.setUpdateSyncTime(updateSyncTime);
                session.saveOrUpdate((Object)shopTable);
            }
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw e;
        }
    }

    public void saveOrSetVersionShopSeat(Session session, ShopTable item, ShopTable existingItem, Set<ShopSeat> seats) {
        if (seats != null && seats.size() > 0) {
            for (ShopSeat shopSeat : seats) {
                shopSeat.setTableId(item.getId());
                this.saveOrUpdateShopSeat(session, shopSeat);
            }
        }
    }

    private void saveOrUpdateShopSeat(Session session, ShopSeat shopSeat) {
        ShopSeatDAO dao = ShopSeatDAO.getInstance();
        ShopSeat existingShopSeat = dao.get(shopSeat.getId());
        if (existingShopSeat == null) {
            dao.save(shopSeat, session);
        } else {
            shopSeat.setVersion(existingShopSeat.getVersion());
        }
    }

    public void saveOrSetVersionShopTableTypes(Session session, ShopTable item, ShopTable existingItem, List<ShopTableType> types) {
        if (types != null && types.size() > 0) {
            for (ShopTableType shopTableType : types) {
                this.saveOrUpdateShopTableType(session, shopTableType);
            }
        }
    }

    private void saveOrUpdateShopTableType(Session session, ShopTableType tableType) {
        ShopTableTypeDAO dao = ShopTableTypeDAO.getInstance();
        ShopTableType existingTableType = dao.get(tableType.getId(), session);
        if (existingTableType == null) {
            dao.save(tableType, session);
        } else {
            tableType.setVersion(existingTableType.getVersion());
        }
    }

    private void saveOrSetVersionShopTable(Session session, ShopTable shopTable, ShopTable existingItem, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (existingItem == null) {
            ShopTableDAO.getInstance().save(shopTable, session);
        } else {
            ShopTableStatus tableStatus = ShopTableStatusDAO.getInstance().updateVersionOfShopTableStatus(existingItem.getShopTableStatus());
            existingItem.setShopTableStatus(tableStatus);
            shopTable.setVersion(existingItem.getVersion());
        }
    }

    public void transferTickets(Ticket ticket, List<Integer> newTatableNumbers) throws Exception {
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            ShopTableStatusDAO.getInstance().removeTicketFromShopTableStatus(ticket, session);
            ticket.setTableNumbers(newTatableNumbers);
            ShopTableDAO.getInstance().occupyTables(ticket, session);
            TicketDAO.getInstance().update(ticket, session);
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ShopTable> findAllEnableTable() {
        Session session = null;
        try {
            List list;
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(ShopTable.class).createAlias(ShopTable.PROP_SHOP_TABLE_STATUS, "status");
            criteria.add((Criterion)Restrictions.ne((String)("status." + ShopTableStatus.PROP_TABLE_STATUS_NUM), (Object)TableStatus.Disable.getValue()));
            this.addDeletedFilter(criteria);
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }
}

