/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TerminalType;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.BaseTerminalDAO;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.ext.DeviceType;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;

public class TerminalDAO
extends BaseTerminalDAO {
    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void delete(Object obj, Session s) {
        if (obj instanceof Terminal) {
            Terminal terminal = (Terminal)obj;
            terminal.setDeleted(Boolean.TRUE);
            super.update(terminal, s);
        } else {
            super.delete(obj, s);
        }
    }

    @Override
    public List<Terminal> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.addOrder(Order.asc((String)Terminal.PROP_NAME));
            List list = criteria.list();
            return list;
        }
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    public boolean isDrawerAssigned(Terminal terminal) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)Terminal.PROP_ID, (Object)terminal.getId()));
            criteria.setProjection((Projection)Projections.property((String)Terminal.PROP_ASSIGNED_USER_ID));
            Object result = criteria.uniqueResult();
            boolean bl = result != null;
            return bl;
        }
    }

    public String createNewTerminalName() {
        try (Session session = this.createNewSession();){
            String string = this.createNewTerminalName(session);
            return string;
        }
    }

    public Integer createNewTerminalId(String terminalKey) {
        try {
            String hashCode = String.valueOf(terminalKey.hashCode()).replaceFirst("-", "0");
            return Integer.parseInt(hashCode);
        }
        catch (Exception e) {
            return terminalKey.hashCode();
        }
    }

    public String createNewTerminalName(Session session) {
        String terminalId;
        Criteria criteria;
        Object uniqueResult;
        if (session == null) {
            return this.createNewTerminalName();
        }
        Random random = new Random();
        do {
            terminalId = String.valueOf(random.nextInt(10000) + 1);
            criteria = session.createCriteria(this.getClass());
            criteria.add((Criterion)Restrictions.eq((String)Terminal.PROP_ID, (Object)terminalId));
        } while ((uniqueResult = criteria.uniqueResult()) != null);
        return terminalId;
    }

    public Terminal createNewTerminal(String terminalKey, Outlet outlet) {
        return this.createNewTerminal(terminalKey, outlet, null);
    }

    public Terminal createNewTerminal(String terminalKey, Outlet outlet, Session session) {
        Terminal terminal = new Terminal();
        terminal.setId(this.createNewTerminalId(terminalKey));
        terminal.setName(this.createNewTerminalName(session));
        terminal.setTerminalKey(terminalKey);
        if (outlet != null) {
            terminal.setOutletId(outlet.getId());
        }
        if (session == null) {
            this.save(terminal);
        } else {
            this.save(terminal, session);
        }
        return terminal;
    }

    public void refresh(Terminal terminal) {
        try (Session session = this.createNewSession();){
            session.refresh((Object)terminal);
        }
    }

    public List<Terminal> findOpenTerminals() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add(Restrictions.isNotNull((String)Terminal.PROP_ASSIGNED_USER_ID));
            List list = criteria.list();
            return list;
        }
    }

    public List<Terminal> findCashDrawerTerminals() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)Terminal.PROP_HAS_CASH_DRAWER, (Object)Boolean.TRUE));
            List list = criteria.list();
            return list;
        }
    }

    public void performBatchSave(Object ... objects) {
        Transaction tx = null;
        try (Session session = this.createNewSession();){
            tx = session.beginTransaction();
            for (Object object : objects) {
                if (object == null) continue;
                session.saveOrUpdate(object);
            }
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw e;
        }
    }

    public void performBatchSave(List<String> customQueryList, Object ... objects) {
        Transaction tx = null;
        try (Session session = this.createNewSession();){
            tx = session.beginTransaction();
            for (Object object : objects) {
                if (object == null) continue;
                session.saveOrUpdate(object);
            }
            if (customQueryList != null) {
                for (String sql : customQueryList) {
                    Query query = session.createQuery(sql);
                    query.executeUpdate();
                }
            }
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw e;
        }
    }

    public void resetCashDrawer(CashDrawer report, Terminal terminal, User user, double balance) throws Exception {
        Transaction tx = null;
        report.setClosedBy(user);
        report.setReportTime(new Date());
        try (Session session = this.createNewSession();){
            tx = session.beginTransaction();
            terminal.setAssignedUserId(null);
            terminal.setCurrentCashDrawer(null);
            this.update(terminal, session);
            this.saveOrUpdate(report, session);
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw e;
        }
    }

    public void resetStaffBank(User closedByUser, CashDrawer cashDrawer) throws Exception {
        Transaction tx = null;
        try (Session session = this.createNewSession();){
            tx = session.beginTransaction();
            this.resetStaffBank(closedByUser, cashDrawer, session);
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw e;
        }
    }

    public void resetStaffBank(User closedByUser, CashDrawer cashDrawer, Session session) throws Exception {
        User assignedUser;
        cashDrawer.setClosedBy(closedByUser);
        cashDrawer.setReportTime(StoreDAO.getServerTimestamp());
        CashDrawerDAO.getInstance().saveOrUpdate(cashDrawer, session);
        String assignedUserId = cashDrawer.getAssignedUserId();
        if (StringUtils.isNotEmpty((String)assignedUserId) && (assignedUser = UserDAO.getInstance().get(assignedUserId)) != null) {
            assignedUser.setStaffBankStarted(false);
            assignedUser.setCurrentCashDrawer(null);
            UserDAO.getInstance().update(assignedUser, session);
        }
    }

    public Terminal initialize(Terminal terminal) {
        if (terminal == null || terminal.getId() == null) {
            return terminal;
        }
        try (Session session = this.createNewSession();){
            session.refresh((Object)terminal);
            Terminal terminal2 = terminal;
            return terminal2;
        }
    }

    public Terminal getByTerminalKey(String terminalKey) {
        try (Session session = this.createNewSession();){
            Terminal terminal = this.getByTerminalKey(terminalKey, session);
            return terminal;
        }
    }

    public Terminal getByTerminalKey(String terminalKey, Session session) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.add((Criterion)Restrictions.eq((String)Terminal.PROP_TERMINAL_KEY, (Object)terminalKey));
        List list = criteria.list();
        if (list.size() > 0) {
            return (Terminal)list.get(0);
        }
        return null;
    }

    public Terminal findByAssignedUser(User user) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)Terminal.PROP_ASSIGNED_USER_ID, (Object)user.getId()));
            List list = criteria.list();
            if (list.size() > 0) {
                Terminal terminal = (Terminal)list.get(0);
                return terminal;
            }
            Terminal terminal = null;
            return terminal;
        }
    }

    public boolean isVersionEqual(Class beanClass, Object id, long versionToCompare) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(beanClass);
            criteria.add((Criterion)Restrictions.eq((String)"id", (Object)id));
            criteria.setProjection((Projection)Projections.property((String)"version"));
            Object result = criteria.uniqueResult();
            if (result instanceof Number) {
                boolean bl = ((Number)result).longValue() == versionToCompare;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    public long getVersion(Class beanClass, String column, Object id) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(beanClass);
            criteria.add((Criterion)Restrictions.eq((String)column, (Object)id));
            criteria.setProjection((Projection)Projections.property((String)"version"));
            long l = (Long)criteria.uniqueResult();
            return l;
        }
    }

    public void executeSqlQuery(List<String> sqlList) {
        if (sqlList == null) {
            return;
        }
        Transaction tx = null;
        try (Session session = this.createNewSession();){
            tx = session.beginTransaction();
            for (String sql : sqlList) {
                SQLQuery query = session.createSQLQuery(sql);
                query.executeUpdate();
            }
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            PosLog.error(this.getClass(), e);
        }
    }

    public List executeSqlQuery(String sql) {
        return this.executeSqlQuery(sql, 0L, 0L);
    }

    public List executeSqlQuery(String sql, long startIndex, long maxResult) {
        try (Session session = this.createNewSession();){
            SQLQuery sqlQuery = session.createSQLQuery(sql);
            if (maxResult > 0L) {
                sqlQuery.setFirstResult((int)startIndex);
                sqlQuery.setMaxResults((int)maxResult);
            }
            List list = sqlQuery.list();
            return list;
        }
    }

    public List<Terminal> findTerminalsByDeviceType(int deviceType, int limit) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)Terminal.PROP_DEVICE_TYPE, (Object)deviceType));
            if (limit > 0) {
                criteria.setMaxResults(limit);
            }
            List list = criteria.list();
            return list;
        }
    }

    public int rowCount(Class beanClass, Date lastUpdateTime) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(beanClass);
            criteria.setProjection(Projections.rowCount());
            if (lastUpdateTime != null) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"lastUpdateTime"), (Criterion)Restrictions.gt((String)"lastUpdateTime", (Object)lastUpdateTime)));
                PosLog.debug(this.getClass(), beanClass + " : " + lastUpdateTime);
            }
            criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
            Number uniqueResult = (Number)criteria.uniqueResult();
            int n = uniqueResult == null ? 0 : uniqueResult.intValue();
            return n;
        }
    }

    public List findDataList(Class beanClass, Date lastUpdateTime) {
        return this.findDataList(beanClass, lastUpdateTime, null);
    }

    public List findDataList(Class beanClass, Date lastUpdateTime, Criterion criterion) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(beanClass);
            if (criterion != null) {
                criteria.add(criterion);
            }
            if (lastUpdateTime != null) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"lastUpdateTime"), (Criterion)Restrictions.gt((String)"lastUpdateTime", (Object)lastUpdateTime)));
                PosLog.debug(this.getClass(), beanClass + " : " + lastUpdateTime);
            }
            criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
            List list = criteria.list();
            return list;
        }
    }

    public int getActiveTerminalCount() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add(Restrictions.neOrIsNotNull((String)Terminal.PROP_TERMINAL_KEY, (Object)""));
            criteria.add((Criterion)Restrictions.eq((String)Terminal.PROP_ACTIVE, (Object)Boolean.TRUE));
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount != null) {
                int n = rowCount.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Boolean deactivateAllActiveTerminal() {
        Transaction transaction = null;
        try (Session session = this.createNewSession();){
            transaction = session.beginTransaction();
            String hql = "UPDATE " + Terminal.REF + " T SET T." + Terminal.PROP_ACTIVE + "=:newValue WHERE T." + Terminal.PROP_ACTIVE + "=:oldValue";
            Query query = session.createQuery(hql);
            query.setParameter("newValue", (Object)Boolean.FALSE);
            query.setParameter("oldValue", (Object)Boolean.TRUE);
            query.executeUpdate();
            transaction.commit();
            Boolean bl = Boolean.TRUE;
            return bl;
        }
        catch (Exception e0) {
            if (transaction != null) {
                transaction.rollback();
            }
            PosLog.error(this.getReferenceClass(), e0);
            return Boolean.FALSE;
        }
    }

    public List<Terminal> findMasterTerminal(Terminal currentTerminalToExclude) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(Terminal.class);
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)Terminal.PROP_MASTER_TERMINAL, (Object)true));
            if (currentTerminalToExclude != null) {
                criteria.add((Criterion)Restrictions.ne((String)Terminal.PROP_ID, (Object)currentTerminalToExclude.getId()));
            }
            List list = criteria.list();
            return list;
        }
    }

    public void resetMasterTerminal(List<Terminal> masterTerminals) {
        Transaction tx = null;
        try (Session session = this.createNewSession();){
            tx = session.beginTransaction();
            if (masterTerminals != null && !masterTerminals.isEmpty()) {
                for (Terminal terminal : masterTerminals) {
                    terminal.setMasterTerminal(false);
                    this.update(terminal, session);
                }
            }
            tx.commit();
        }
    }

    public Integer getMasterTerminalId() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(Terminal.class);
            this.addDeletedFilter(criteria);
            criteria.setProjection((Projection)Projections.property((String)Terminal.PROP_ID));
            criteria.add((Criterion)Restrictions.eq((String)Terminal.PROP_MASTER_TERMINAL, (Object)true));
            criteria.setMaxResults(1);
            Number number = (Number)criteria.uniqueResult();
            Integer n = number == null ? null : Integer.valueOf(number.intValue());
            return n;
        }
    }

    public Object getFieldValueByTerminalKey(String terminaKey, String fieldName) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(Terminal.class);
            this.addDeletedFilter(criteria);
            criteria.setProjection((Projection)Projections.property((String)fieldName));
            criteria.add((Criterion)Restrictions.eq((String)Terminal.PROP_TERMINAL_KEY, (Object)terminaKey));
            criteria.setMaxResults(1);
            Object object = criteria.uniqueResult();
            return object;
        }
    }

    public void saveOrUpdateTerminal(List<Terminal> terminals, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (terminals == null) {
            return;
        }
        Transaction tx = null;
        try (Session session = this.createNewSession();){
            tx = session.beginTransaction();
            for (Terminal item : terminals) {
                TerminalDAO dao = TerminalDAO.getInstance();
                Terminal existingItem = dao.get(item.getId());
                if (existingItem != null) {
                    if (!BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), item.getName() + " already updated");
                        continue;
                    }
                    CashDrawer sourceCashDrawer = item.getCurrentCashDrawer();
                    CashDrawer existingCashDrawer = existingItem.getCurrentCashDrawer();
                    long version = existingItem.getVersion();
                    PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                    existingItem.setVersion(version);
                    existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
                    existingItem.setUpdateSyncTime(updateSyncTime);
                    if (sourceCashDrawer != null && !CashDrawerDAO.getInstance().isExist(sourceCashDrawer.getId())) {
                        CashDrawerDAO.getInstance().save(sourceCashDrawer);
                    }
                    if (sourceCashDrawer == null && existingCashDrawer != null && existingCashDrawer.getReportTime() == null) {
                        existingItem.setCurrentCashDrawer(existingCashDrawer);
                    }
                    if (sourceCashDrawer != null && existingCashDrawer != null && !sourceCashDrawer.getId().equals(existingCashDrawer.getId()) && existingCashDrawer.getStartTime().after(sourceCashDrawer.getStartTime())) {
                        existingItem.setCurrentCashDrawer(existingCashDrawer);
                    }
                    dao.update(existingItem);
                    continue;
                }
                item.setUpdateLastUpdateTime(updateLastUpdateTime);
                item.setUpdateSyncTime(updateSyncTime);
                dao.save(item);
            }
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw e;
        }
    }

    public List<String> getActiveTerminalKeys() {
        return this.getActiveTerminalKeys(null);
    }

    public List<String> getActiveTerminalKeys(DeviceType deviceType) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add(Restrictions.eqOrIsNull((String)Terminal.PROP_ACTIVE, (Object)true));
            criteria.add(Restrictions.eqOrIsNull((String)Terminal.PROP_DELETED, (Object)false));
            if (deviceType != null) {
                criteria.add(Restrictions.eqOrIsNull((String)Terminal.PROP_DEVICE_TYPE, (Object)deviceType.getDeviceType()));
            }
            criteria.add(Restrictions.neOrIsNotNull((String)Terminal.PROP_TERMINAL_KEY, (Object)""));
            criteria.setProjection((Projection)Projections.property((String)Terminal.PROP_TERMINAL_KEY));
            List list = criteria.list();
            return list;
        }
    }

    public List<Terminal> getTerminalsByTerminalType(TerminalType terminalType, Session session) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        this.addDeletedFilter(criteria);
        criteria.add((Criterion)Restrictions.eq((String)Terminal.PROP_TERMINAL_TYPE_ID, (Object)terminalType.getId()));
        criteria.setProjection(Projections.alias((Projection)Projections.property((String)Terminal.PROP_NAME), (String)Terminal.PROP_NAME));
        return criteria.setResultTransformer(Transformers.aliasToBean((Class)this.getReferenceClass())).list();
    }
}

