/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.ext;

import com.floreantpos.Messages;
import java.util.regex.Pattern;

public enum CardTypeEnum {
    VISA(Messages.getString("CardTypeEnum.0"), "^4[0-9]{12}(?:[0-9]{3}){0,2}$"),
    MASTER_CARD(Messages.getString("CardTypeEnum.1"), "^(?:5[1-5]|2(?!2([01]|20)|7(2[1-9]|3))[2-7])\\d{14}$"),
    AMERICAN_EXPRESS(Messages.getString("CardTypeEnum.2"), "^3[47][0-9]{13}$"),
    DISCOVER(Messages.getString("CardTypeEnum.3"), "^6(?:011|[45][0-9]{2})[0-9]{12}$"),
    JCB(Messages.getString("CardTypeEnum.4"), "^(?:2131|1800|35\\d{3})\\d{11}$"),
    DINERS_CLUB(Messages.getString("CardTypeEnum.5"), "^3(?:0[0-5]|[68][0-9])[0-9]{11}$");

    private final String value;
    private Pattern pattern;

    private CardTypeEnum(String v) {
        this(v, "");
    }

    private CardTypeEnum(String v, String pattern) {
        this.value = v;
        this.pattern = Pattern.compile(pattern);
    }

    public String value() {
        return this.value;
    }

    public static CardTypeEnum fromValue(String v) {
        for (CardTypeEnum c : CardTypeEnum.values()) {
            if (!c.value.equals(v)) continue;
            return c;
        }
        throw new IllegalArgumentException(v);
    }

    public static CardTypeEnum detect(String cardNumber) {
        for (CardTypeEnum cardType : CardTypeEnum.values()) {
            if (null == cardType.pattern || !cardType.pattern.matcher(cardNumber).matches()) continue;
            return cardType;
        }
        return null;
    }
}

