/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.ext;

import com.floreantpos.model.Terminal;
import com.floreantpos.model.util.DataProvider;
import org.apache.commons.lang.StringUtils;

public enum PaperSize {
    A4,
    LETTER;


    public static String getReportNameAccording2Size(String reportName) {
        Terminal currentTerminal = DataProvider.get().getCurrentTerminal();
        if (currentTerminal == null) {
            return reportName;
        }
        String paperSize = currentTerminal.getProperty("report.paper_size");
        if (A4.name().equalsIgnoreCase(paperSize)) {
            return reportName;
        }
        return reportName + "-letter";
    }

    public static PaperSize getDefaultPaperSize() {
        try {
            Terminal currentTerminal = DataProvider.get().getCurrentTerminal();
            String paperSize = currentTerminal.getProperty("report.paper_size");
            if (StringUtils.isNotEmpty((String)paperSize)) {
                return PaperSize.valueOf(paperSize);
            }
            return LETTER;
        }
        catch (Exception e) {
            return LETTER;
        }
    }
}

