/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.util;

import com.floreantpos.model.ComboTicketItem;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import java.util.Iterator;
import java.util.List;

public class TicketMergeUtil {
    public static void doMergeTickets(Ticket mainTicket, List<Ticket> tickets) {
        TicketMergeUtil.cleanMainTicket(mainTicket);
        Iterator<Ticket> iterator = tickets.iterator();
        while (iterator.hasNext()) {
            Ticket ticket = iterator.next();
            if (ticket.equals(mainTicket)) {
                iterator.remove();
                continue;
            }
            List<TicketItem> ticketItems = ticket.getTicketItems();
            if (ticketItems == null) continue;
            Iterator<TicketItem> iterator2 = ticketItems.iterator();
            while (iterator2.hasNext()) {
                TicketItem ticketItem = iterator2.next();
                if (ticketItem.isTreatAsSeat().booleanValue()) {
                    iterator2.remove();
                    continue;
                }
                TicketItem cloneTicketItem = ticketItem.clone();
                TicketMergeUtil.cleanTicketItem(mainTicket, ticket, cloneTicketItem);
                mainTicket.addToticketItems(cloneTicketItem);
            }
        }
    }

    private static void cleanTicketItem(Ticket mainTicket, Ticket ticket, TicketItem ticketItem) {
        ComboTicketItem comboTicketItem;
        List<TicketItem> comboItems;
        List<TicketDiscount> discounts;
        ticketItem.setId(null);
        ticketItem.setVersion(0L);
        ticketItem.setSeat(null);
        ticketItem.setSeatNumber(null);
        ticketItem.setTicket(mainTicket);
        TicketMergeUtil.cleanModifiers(ticketItem);
        if (ticketItem.isPizzaType().booleanValue()) {
            TicketMergeUtil.cleanSizeModifier(ticketItem);
        }
        if ((discounts = ticket.getDiscounts()) != null && discounts.size() > 0) {
            ticket.getDiscounts().clear();
        }
        if (ticketItem instanceof ComboTicketItem && (comboItems = (comboTicketItem = (ComboTicketItem)ticketItem).getComboItems()) != null) {
            for (TicketItem comboItem : comboItems) {
                TicketMergeUtil.cleanTicketItem(mainTicket, ticket, comboItem);
                comboItem.setTicket(null);
            }
        }
    }

    private static void cleanModifiers(TicketItem cloneTicketItem) {
        List<TicketItemModifier> ticketItemModifiers = cloneTicketItem.getTicketItemModifiers();
        if (ticketItemModifiers != null && !ticketItemModifiers.isEmpty()) {
            for (TicketItemModifier ticketItemModifier : ticketItemModifiers) {
                ticketItemModifier.setId(null);
                ticketItemModifier.setVersion(0L);
            }
        }
    }

    private static void cleanSizeModifier(TicketItem cloneTicketItem) {
        TicketItemModifier ticketItemModifier = cloneTicketItem.getSizeModifier();
        if (ticketItemModifier != null) {
            ticketItemModifier.setId(null);
            ticketItemModifier.setVersion(0L);
        }
    }

    private static void cleanMainTicket(Ticket mainTicket) {
        mainTicket.getDiscounts().clear();
        if (mainTicket.getTicketItems() != null) {
            Iterator<TicketItem> iterator = mainTicket.getTicketItems().iterator();
            while (iterator.hasNext()) {
                TicketItem ticketItem = iterator.next();
                if (ticketItem.isTreatAsSeat().booleanValue()) {
                    iterator.remove();
                    continue;
                }
                ticketItem.setSeat(null);
                ticketItem.setSeatNumber(null);
            }
        }
    }
}

