/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.util;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.model.Customer;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Store;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.util.ForeteesCacheManager;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.NumberUtil;
import java.util.List;

public class TicketUtil {
    public static void setCustomer(Ticket ticket, Customer customer) {
        if (customer == null) {
            ticket.removeCustomer();
            return;
        }
        ticket.removeCustomer();
        ticket.setCustomerId(customer.getId());
        ticket.addProperty("CUSTOMER_ID", String.valueOf(customer.getId()));
        ticket.addProperty("CUSTOMER_NAME", customer.getFirstName());
        ticket.addProperty("CUSTOMER_LAST_NAME", customer.getLastName());
        ticket.addProperty("CUSTOMER_MOBILE", customer.getMobileNo());
        ticket.addProperty("CUSTOMER_ZIP_CODE", customer.getZipCode());
        ticket.addProperty("customer.taxExempt", customer.isTaxExempt().toString());
        ticket.setTaxExempt(customer.isTaxExempt());
        List<TicketItem> ticketItems = ticket.getTicketItems();
        if (ticketItems == null) {
            return;
        }
        for (TicketItem ticketItem : ticketItems) {
            MenuItem menuItem = ticketItem.getMenuItem();
            if (menuItem == null) continue;
            ForeteesCacheManager cacheManager = (ForeteesCacheManager)DataProvider.get();
            TaxGroup taxGroup = cacheManager.findTaxGroup(menuItem, customer);
            MenuItem.setItemTaxes(ticketItem, taxGroup, ticket.getOrderType());
        }
        ticket.calculatePrice();
    }

    public static void closeTicketIfApplicable(Ticket ticket) {
        OrderType ticketType;
        if (NumberUtil.round(ticket.getDueAmount()) == 0.0 && (ticketType = ticket.getOrderType()) != null && (ticketType.isCloseOnPaid().booleanValue() || ticketType.isBarTab().booleanValue())) {
            ticket.setClosed(true);
            ticket.setClosingDate(StoreDAO.getServerTimestamp());
        }
    }

    public static double calculateSurchargeReturnAmount(double tenderAmount, String ticketItemIds, Ticket ticket) {
        return TicketUtil.calculateSurchargeReturnAmount(tenderAmount, ticketItemIds, ticket, true);
    }

    public static double calculateSurchargeReturnAmount(double tenderAmount, String ticketItemIds, Ticket ticket, Boolean shouldAddtoTicket) {
        if (ticket == null) {
            return 0.0;
        }
        Store store = DataProvider.get().getStore();
        if (ticket.getOrderType().isApplyCreditCardSurcharge() && store.isEnableCreditCardSurcharge()) {
            Double percentagesAmountByCardType = store.getPercentagesAmountByCardType(ticket.getCreditCardType());
            double surchargeAmount = NumberUtil.round(tenderAmount * (percentagesAmountByCardType / 100.0));
            if (surchargeAmount > ticket.getTotalSurchargeAmount()) {
                surchargeAmount = ticket.getTotalSurchargeAmount();
            }
            ticket.setTotalSurchargeAmount(ticket.getTotalSurchargeAmount() - surchargeAmount);
            ticket.addToticketItems(TicketUtil.createTicketItem(surchargeAmount, ticketItemIds, ticket));
            ticket.calculatePrice();
            return surchargeAmount;
        }
        return 0.0;
    }

    public static TicketItem createTicketItem(double surchargeAmount, String ticketItemIds, Ticket ticket) {
        TicketItem ticketItem = new TicketItem();
        ticketItem.setTaxIncluded(false);
        ticketItem.setQuantity(-1.0);
        MenuItem menuItem = MenuItemDAO.getInstance().findByName("CC Surcharge");
        if (menuItem == null) {
            throw new PosException(Messages.getString("NO_ITEM_FOUND_WITH_NAME") + "CC Surcharge");
        }
        ticketItem.setMenuItemId(menuItem.getId());
        ticketItem.setName(menuItem.getName());
        ticketItem.setUnitPrice(surchargeAmount);
        ticketItem.setSubtotalAmount(surchargeAmount);
        ticketItem.setTotalAmount(surchargeAmount);
        ticketItem.setRefundItemIds(ticketItemIds);
        ticketItem.setTicket(ticket);
        return ticketItem;
    }
}

