/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.print;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.main.Application;
import com.floreantpos.model.CardReader;
import com.floreantpos.model.KitchenTicket;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.ext.ReciptPaperSize;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.print.ReceiptPrintServiceProvider;
import com.floreantpos.report.KitchenTicketDataSource;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.TicketDataSource;
import com.floreantpos.report.TicketPrintProperties;
import com.floreantpos.services.PosTransactionService;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.TicketReceiptView;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.PrintServiceUtil;
import java.awt.print.PrinterAbortException;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.engine.export.JRPrintServiceExporter;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimplePrintServiceExporterConfiguration;
import org.apache.commons.lang3.text.WordUtils;

public class JasperPrintService
extends ReceiptPrintServiceProvider {
    @Override
    public void printTicket(Ticket ticket, HashMap map, String deviceName) throws Exception {
        JasperPrint jasperPrint = this.createPrint(ticket, map, null, false, true);
        jasperPrint.setName("ORDER-" + ticket.getId() + deviceName);
        jasperPrint.setProperty("printerName", deviceName);
        JasperPrintService.printQuitely(jasperPrint);
    }

    @Override
    public void printTransaction(Ticket ticket, HashMap map, PosTransaction transaction, String deviceName) throws Exception {
        JasperPrint jasperPrint = this.createPrint(ticket, map, transaction, false, true);
        jasperPrint.setName("ORDER-" + ticket.getId() + deviceName);
        jasperPrint.setProperty("printerName", deviceName);
        JasperPrintService.printQuitely(jasperPrint);
    }

    @Override
    public void printRefundTicket(Ticket ticket, HashMap map, String deviceName) throws Exception {
        JasperPrint jasperPrint = this.createRefundPrint(ticket, map);
        jasperPrint.setName("REFUND_" + ticket.getId());
        jasperPrint.setProperty("printerName", deviceName);
        JasperPrintService.printQuitely(jasperPrint);
    }

    @Override
    public void printVoidTicket(Ticket ticket, HashMap map, String deviceName) throws Exception {
        JasperPrint jasperPrint = this.createPrint(ticket, map, null);
        jasperPrint.setName("VOID_" + ticket.getId());
        jasperPrint.setProperty("printerName", deviceName);
        JasperPrintService.printQuitely(jasperPrint);
    }

    @Override
    public void printKitchenTicket(KitchenTicket kitchenTicket, HashMap map, Ticket ticket, String printerName, String deviceName) throws Exception {
        JasperPrint jasperPrint = this.createKitchenPrint(map, printerName, kitchenTicket, deviceName);
        jasperPrint.setName("KitchenReceipt_" + ticket.getId() + "_" + kitchenTicket.getSequenceNumber());
        jasperPrint.setProperty("printerName", deviceName);
        JasperPrintService.printQuitely(jasperPrint);
    }

    @Override
    public void printVoidKitchenTicket(KitchenTicket kitchenTicket, HashMap map, String printerName, String deviceName) throws Exception {
        KitchenTicketDataSource dataSource = new KitchenTicketDataSource(kitchenTicket);
        JasperPrint jasperPrint = this.createJasperPrint(ReportUtil.getReport("kitchen-receipt"), map, (JRDataSource)new JRTableModelDataSource((TableModel)dataSource));
        jasperPrint.setName("Void_KitchenReceipt_" + kitchenTicket.getId() + "_" + kitchenTicket.getSequenceNumber());
        jasperPrint.setProperty("printerName", deviceName);
        JasperPrintService.printQuitely(jasperPrint);
    }

    @Override
    public void rendererTicketReceipt(Ticket ticket, JPanel reportPanel) throws Exception {
        TicketPrintProperties printProperties = new TicketPrintProperties(null, false, true, true);
        HashMap<String, Object> map = ReceiptPrintService.populateTicketProperties(ticket, printProperties, null);
        map.put("IS_IGNORE_PAGINATION", true);
        JasperPrint jasperPrint = this.createPrint(ticket, map, null, false, true);
        TicketReceiptView receiptView = new TicketReceiptView(jasperPrint);
        reportPanel.add(receiptView.getReportPanel());
    }

    @Override
    public void rendererPosTransactionReceipt(PosTransaction transaction, JPanel reportPanel) throws Exception {
        JasperPrint jasperPrint = this.createTransactionReceipt(transaction);
        TicketReceiptView receiptView = new TicketReceiptView(jasperPrint);
        reportPanel.add(receiptView.getReportPanel());
    }

    @Override
    public void rendererKitchenReceipt(Ticket ticket, JPanel reportPanel) throws Exception {
        JasperPrint jasperPrint = this.getKitchenJasperPrintPreview(ticket);
        TicketReceiptView receiptView = new TicketReceiptView(jasperPrint);
        reportPanel.add(receiptView.getReportPanel());
    }

    public JasperPrint createJasperPrint(JasperReport report, Map<String, Object> properties, JRDataSource dataSource) throws Exception {
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)report, properties, (JRDataSource)dataSource);
        return jasperPrint;
    }

    public JasperPrint createPrint(Ticket ticket, Map<String, Object> map, PosTransaction transaction) throws Exception {
        return this.createPrint(ticket, map, transaction, false);
    }

    public JasperPrint createPrint(Ticket ticket, Map<String, Object> map, PosTransaction transaction, boolean includeSeat) throws Exception {
        return this.createPrint(ticket, map, transaction, false, false);
    }

    public JasperPrint createPrint(Ticket ticket, Map<String, Object> map, PosTransaction transaction, boolean includeSeat, boolean isCustomerRecipt) throws Exception {
        TicketDataSource dataSource = new TicketDataSource(ticket, includeSeat, isCustomerRecipt);
        ReciptPaperSize paperSize = JasperPrintService.getReceiptPaperSize("main.recipt.paper_size");
        ArrayList<PosTransaction> transactions = new ArrayList<PosTransaction>(ticket.getTransactions().stream().collect(Collectors.toList()));
        PosTransactionService.sortTransactionsByTransactionTypeAndDateDesc(transactions);
        if (transactions.size() > 0) {
            map.put("settlementsHeader", Messages.getString("JasperPrintService.0"));
            TransactionReportModel subReportModel = new TransactionReportModel(transaction, transactions);
            map.put("tenderAmountDataSource", new JRTableModelDataSource((TableModel)subReportModel));
            JasperReport subReport = ReportUtil.getReport(paperSize.getReportNameAccording2Size("ticket-recipt-transaction"));
            map.put("tenderAmountReport", subReport);
        }
        return this.createJasperPrint(ReportUtil.getReport(paperSize.getReportNameAccording2Size("ticket-recipt")), map, (JRDataSource)new JRTableModelDataSource((TableModel)dataSource));
    }

    public JasperPrint createRefundPrint(Ticket ticket, HashMap map) throws Exception {
        TicketDataSource dataSource = new TicketDataSource(ticket);
        ReciptPaperSize paperSize = JasperPrintService.getReceiptPaperSize("main.recipt.paper_size");
        return this.createJasperPrint(ReportUtil.getReport(paperSize.getReportNameAccording2Size("ticket-recipt")), map, (JRDataSource)new JRTableModelDataSource((TableModel)dataSource));
    }

    public JasperPrint createTransactionReceipt(PosTransaction transaction) {
        try {
            Ticket ticket = transaction.getTicket();
            TicketPrintProperties printProperties = new TicketPrintProperties(Messages.getString("ReceiptPrintService.3"), true, true, true);
            printProperties.setPrintCookingInstructions(false);
            HashMap<String, Object> map = ReceiptPrintService.populateTicketProperties(ticket, printProperties, transaction);
            map.put("IS_IGNORE_PAGINATION", true);
            if (transaction != null && transaction.isCard()) {
                CardReader cardReader = CardReader.fromString(transaction.getCardReader());
                if (cardReader == CardReader.EXTERNAL_TERMINAL) {
                    return null;
                }
                map.put("cardPayment", true);
                map.put("copyType", Messages.getString("ReceiptPrintService.4"));
                JasperPrint jasperPrint = this.createPrint(ticket, map, transaction);
                jasperPrint.setName("Ticket-" + ticket.getId() + "-CustomerCopy");
                jasperPrint.setProperty("printerName", DataProvider.get().getPrinters().getReceiptPrinter());
                map.put("copyType", Messages.getString("ReceiptPrintService.5"));
                jasperPrint = this.createPrint(ticket, map, transaction);
                jasperPrint.setName("Ticket-" + ticket.getId() + "-MerchantCopy");
                jasperPrint.setProperty("printerName", DataProvider.get().getPrinters().getReceiptPrinter());
                return jasperPrint;
            }
            JasperPrint jasperPrint = this.createPrint(ticket, map, transaction);
            jasperPrint.setName("Ticket-" + ticket.getId());
            jasperPrint.setProperty("printerName", DataProvider.get().getPrinters().getReceiptPrinter());
            return jasperPrint;
        }
        catch (Exception e) {
            ReceiptPrintService.getLogger().error((Object)POSConstants.PRINT_ERROR, (Throwable)e);
            return null;
        }
    }

    private static ReciptPaperSize getReceiptPaperSize(String reciptPaperSizeInMm) {
        return ReceiptPrintService.getReceiptPaperSize(reciptPaperSizeInMm);
    }

    public JasperPrint createKitchenPrint(KitchenTicket ticket) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cardPayment", true);
        map.put("showHeaderSeparator", Boolean.TRUE);
        map.put("showHeaderSeparator", Boolean.TRUE);
        KitchenTicketDataSource dataSource = new KitchenTicketDataSource(ticket);
        ReciptPaperSize paperSize = JasperPrintService.getReceiptPaperSize("kitchen.recipt.paper_size");
        return this.createJasperPrint(ReportUtil.getReport(paperSize.getReportNameAccording2Size("kitchen-receipt")), map, (JRDataSource)new JRTableModelDataSource((TableModel)dataSource));
    }

    public JasperPrint createKitchenPrint(HashMap map, String virtualPrinterName, KitchenTicket ticket, String deviceName) throws Exception {
        return this.createKitchenPrint(map, virtualPrinterName, ticket, deviceName, false);
    }

    public JasperPrint createKitchenPrint(HashMap map, String virtualPrinterName, KitchenTicket ticket, String deviceName, boolean ignorePagination) throws Exception {
        KitchenTicketDataSource dataSource = new KitchenTicketDataSource(ticket);
        String reciptName = "kitchen-receipt";
        ReciptPaperSize paperSize = JasperPrintService.getReceiptPaperSize("kitchen.recipt.paper_size");
        if (Application.getInstance().getTerminal().isGroupByCatagoryKitReceipt().booleanValue()) {
            reciptName = "kitchen-receipt-with-group";
        }
        return this.createJasperPrint(ReportUtil.getReport(paperSize.getReportNameAccording2Size(reciptName)), map, (JRDataSource)new JRTableModelDataSource((TableModel)dataSource));
    }

    public static void printQuitely(JasperPrint jasperPrint) throws JRException {
        block4: {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
                Date date = new Date();
                String dateTime = dateFormat.format(date);
                String printerName = jasperPrint.getProperty("printerName");
                if (printerName != null && printerName.equals(ReceiptPrintService.OROPOS_PDF_PRINTER)) {
                    String fileName = jasperPrint.getName().replace(printerName, "") + "-[" + dateTime + "]";
                    File pdfFile = new File(ReceiptPrintService.getPdfPrinterDir(), fileName + ".pdf");
                    JasperExportManager.exportReportToPdfFile((JasperPrint)jasperPrint, (String)pdfFile.getAbsolutePath());
                } else {
                    SimplePrintServiceExporterConfiguration configuration = new SimplePrintServiceExporterConfiguration();
                    configuration.setPrintService(PrintServiceUtil.getPrintServiceForPrinter(jasperPrint.getProperty("printerName")));
                    JRPrintServiceExporter exporter = new JRPrintServiceExporter();
                    exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
                    exporter.setConfiguration((ExporterConfiguration)configuration);
                    exporter.exportReport();
                }
            }
            catch (Exception x) {
                if (x != null && x.getCause() instanceof PrinterAbortException) break block4;
                String msg = "No print selected\n";
                ReceiptPrintService.getLogger().error((Object)(msg + x));
            }
        }
    }

    private JasperPrint getKitchenJasperPrintPreview(Ticket ticket) {
        try {
            List<KitchenTicket> kitchenTickets = KitchenTicket.fromTicket(ticket, false);
            Iterator<KitchenTicket> iterator = kitchenTickets.iterator();
            if (iterator.hasNext()) {
                KitchenTicket kitchenTicket = iterator.next();
                kitchenTicket.setParentTicket(ticket);
                HashMap<String, Object> map = ReceiptPrintService.populateKitchenTicketProperties(kitchenTicket, "", "", true);
                JasperPrint jasperPrint = this.createKitchenPrint(map, "", kitchenTicket, "", true);
                jasperPrint.setName("FP_KitchenReceipt_" + ticket.getId() + "_" + kitchenTicket.getSequenceNumber());
                return jasperPrint;
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
        return null;
    }

    public void printGenericReport(HashMap<String, Object> map) throws Exception {
        JasperPrint jasperPrint = this.createJasperPrint(ReportUtil.getReport("generic-receipt"), map, (JRDataSource)new JREmptyDataSource());
        jasperPrint.setProperty("printerName", DataProvider.get().getPrinters().getReceiptPrinter());
        JasperPrintService.printQuitely(jasperPrint);
    }

    @Override
    public void testPrinter(HashMap<String, Object> map, String deviceName) throws Exception {
        JasperPrint jasperPrint = this.createJasperPrint(ReportUtil.getReport("test-printer"), map, (JRDataSource)new JREmptyDataSource());
        jasperPrint.setProperty("printerName", deviceName);
        JasperPrintService.printQuitely(jasperPrint);
    }

    private static class TransactionReportModel
    extends ListTableModel<PosTransaction> {
        private PosTransaction currentTransaction;

        public TransactionReportModel(PosTransaction currentTransaction, List<PosTransaction> posTransactions) {
            super(new String[]{"tenderName", "transAmount"}, posTransactions);
            this.currentTransaction = currentTransaction;
        }

        @Override
        public String[] getColumnNames() {
            return this.columnNames;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            PosTransaction transaction = (PosTransaction)this.getRowData(rowIndex);
            String currencySymbol = CurrencyUtil.getCurrencySymbol();
            switch (columnIndex) {
                case 0: {
                    PaymentType paymentType = transaction.getPaymentType();
                    String paymentTypeText = null;
                    paymentTypeText = paymentType == PaymentType.CUSTOM_PAYMENT ? transaction.getCustomPaymentName() : WordUtils.capitalizeFully((String)transaction.getPaymentType().getDisplayString());
                    paymentTypeText = transaction instanceof RefundTransaction ? paymentTypeText + Messages.getString("EscPosPrintService.0") + currencySymbol : paymentTypeText + currencySymbol;
                    if (transaction.isVoided().booleanValue()) {
                        return this.doStrike(paymentTypeText);
                    }
                    return paymentTypeText;
                }
                case 1: {
                    Double amount = transaction.getAmount();
                    if (transaction.equals(this.currentTransaction)) {
                        amount = this.currentTransaction.getTenderAmount();
                    }
                    if (transaction instanceof RefundTransaction) {
                        amount = -1.0 * transaction.getAmount();
                    }
                    String formatAmount = NumberUtil.formatNumber(amount, true);
                    if (transaction.isVoided().booleanValue()) {
                        return this.doStrike(formatAmount);
                    }
                    return formatAmount;
                }
            }
            return null;
        }

        private String doStrike(String stringText) {
            return "<strike>" + stringText + "</strike>";
        }
    }
}

