/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.print;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.PrinterIsNotConfiguredException;
import com.floreantpos.main.Application;
import com.floreantpos.model.CashBreakdown;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.DrawerPullVoidEntry;
import com.floreantpos.model.DrawerType;
import com.floreantpos.model.Printer;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.TipsCashoutReport;
import com.floreantpos.model.TipsCashoutReportTableModel;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.VoidItemDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.services.report.CashDrawerReportService;
import com.floreantpos.util.NumberUtil;
import java.awt.print.PrinterAbortException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PosPrintService {
    private static final SimpleDateFormat date_formatter = new SimpleDateFormat("dd MMM, yyyy hh:mm aaa");
    private static Log logger = LogFactory.getLog(PosPrintService.class);

    public static void printDrawerPullReport(CashDrawer cashDrawer) throws Exception {
        try {
            JasperPrint jasperPrint = PosPrintService.populateDrawerPullReportParameters(cashDrawer);
            PosPrintService.printReportByJasperPrint(jasperPrint);
        }
        catch (PrinterIsNotConfiguredException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void printCashDrawerSummaryReport(CashDrawer cashDrawer) {
        try {
            JasperPrint jasperPrint = PosPrintService.populateStoreSessionSummaryReportParameters(cashDrawer);
            PosPrintService.printReportByJasperPrint(jasperPrint);
        }
        catch (PrinterIsNotConfiguredException e) {
            throw e;
        }
        catch (PrinterAbortException printerAbortException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void printReportByJasperPrint(JasperPrint jasperPrint) {
        try {
            List<Printer> receiptPrinters = DataProvider.get().getPrinters().getReceiptPrinters();
            if (receiptPrinters == null || receiptPrinters.isEmpty()) {
                throw new PrinterIsNotConfiguredException(Messages.getString("PosPrintService.11"));
            }
            boolean printerFound = false;
            for (Printer printer : receiptPrinters) {
                String printerName = printer.getDeviceName();
                if (StringUtils.isEmpty((CharSequence)printerName)) continue;
                printerFound = true;
                jasperPrint.setProperty("printerName", printerName);
                ReceiptPrintService.printQuitely(jasperPrint);
            }
            if (!printerFound) {
                throw new PrinterIsNotConfiguredException(Messages.getString("PosPrintService.11"));
            }
        }
        catch (PrinterIsNotConfiguredException e) {
            throw e;
        }
        catch (Exception e) {
            PosLog.error(PosPrintService.class, e);
        }
    }

    public static void printServerTipsReport(TipsCashoutReport report) {
        try {
            JasperPrint jasperPrint = PosPrintService.createServerTipsReport(report);
            PosPrintService.printReportByJasperPrint(jasperPrint);
        }
        catch (Exception e) {
            PosLog.error(PosPrintService.class, e);
            logger.error((Object)"error print tips report", (Throwable)e);
        }
    }

    public static JasperPrint createServerTipsReport(TipsCashoutReport report) throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("server", report.getServer());
        if (report.getFromDate() != null) {
            parameters.put("fromDate", Application.formatDate(report.getFromDate()));
        }
        if (report.getToDate() != null) {
            parameters.put("toDate", Application.formatDate(report.getToDate()));
        }
        parameters.put("reportDate", new SimpleDateFormat("dd MMM yyyy, hh:mm aaa").format(report.getReportTime()));
        parameters.put("transactionCount", report.getDatas() == null ? "0" : "" + report.getDatas().size());
        parameters.put("cashTips", NumberUtil.formatNumber(report.getCashTipsAmount()));
        parameters.put("chargedTips", NumberUtil.formatNumber(report.getChargedTipsAmount()));
        parameters.put("declaredTips", report.getDeclaredTipsAmount());
        parameters.put("tipsDue", report.getTipsDue());
        Store store = StoreDAO.getRestaurant();
        parameters.put("headerLine1", store.getName());
        JasperReport mainReport = ReportUtil.getReport("ServerTipsReport");
        JRTableModelDataSource dataSource = new JRTableModelDataSource((TableModel)new TipsCashoutReportTableModel(report.getDatas(), new String[]{"ticketId", "saleType", "ticketTotal", "tips", "chargedTips", "tipsPaid"}));
        return JasperFillManager.fillReport((JasperReport)mainReport, parameters, (JRDataSource)dataSource);
    }

    public static JasperPrint populateDrawerPullReportParameters(CashDrawer cashDrawer) throws Exception {
        boolean staffBankReport = cashDrawer.getDrawerType() == DrawerType.STAFF_BANK;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Store store = StoreDAO.getRestaurant();
        parameters.put("headerLine1", store.getName());
        parameters.put("reportTitle", staffBankReport ? "Staff bank report" : "Cash drawer report");
        PosPrintService.populateTerminalStatusReportParams(parameters);
        parameters.put("IS_IGNORE_PAGINATION", true);
        User assignedUser = cashDrawer.getAssignedUser();
        if (assignedUser != null) {
            String userInfo = assignedUser.getFullName();
            parameters.put("user", (staffBankReport ? "Staff: " : Messages.getString("PosPrintService.4") + " ") + userInfo);
        }
        if (cashDrawer.getStartTime() != null) {
            parameters.put("startTime", Messages.getString("PosPrintService.12") + date_formatter.format(cashDrawer.getStartTime()));
        }
        parameters.put("date", Messages.getString("PosPrintService.13") + date_formatter.format(new Date()));
        parameters.put("totalVoid", cashDrawer.getTotalVoid());
        parameters.put("declaredTips", cashDrawer.getDeclaredTips());
        JasperReport subReportCurrencyBalance = ReportUtil.getReport("drawer-currency-balance");
        JasperReport subReport = ReportUtil.getReport("drawer-pull-void-veport");
        parameters.put("currencyBalanceReport", subReportCurrencyBalance);
        parameters.put("subreportParameter", subReport);
        JasperReport mainReport = ReportUtil.getReport("terminal_status_report");
        JRBeanCollectionDataSource dataSource = new JRBeanCollectionDataSource(Arrays.asList(cashDrawer));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)mainReport, parameters, (JRDataSource)dataSource);
        jasperPrint.setProperty("printerName", DataProvider.get().getPrinters().getReceiptPrinter());
        jasperPrint.setName("DrawerPullReport" + cashDrawer.getId());
        return jasperPrint;
    }

    public static JasperPrint populateStoreSessionSummaryReportParameters(CashDrawer cashDrawer) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Store store = StoreDAO.getRestaurant();
        map.put("headerLine1", store.getName());
        map.put("reportTitle", ReportUtil.reportLabelWithBoldTag(Messages.getString("StoreSessionReportTitle")));
        map.put("salesBalance", Messages.getString("SALES_BALANCE"));
        map.put("rowNetSales", POSConstants.NET_SALES);
        map.put("rowDiscount", "-" + POSConstants.DISCOUNT);
        map.put("rowSalesTax", "+" + POSConstants.SALES_TAX);
        map.put("rowSC", "+" + POSConstants.SERVICE_CHARGE);
        map.put("rowTotal", "=" + POSConstants.TOTAL);
        map.put("rowTips", "+" + POSConstants.TIPS);
        map.put("rowGReceivable", "=" + Messages.getString("grossReceivable"));
        map.put("rowCReceipts", "-" + Messages.getString("cashReceipts"));
        map.put("rowCCards", "-" + Messages.getString("creditCards"));
        map.put("rowDCards", "-" + Messages.getString("debitCards"));
        map.put("rowMPayments", "-" + Messages.getString("memberPayments"));
        map.put("rowCPayments", "-" + Messages.getString("customPayments"));
        map.put("rowGCert", "-" + Messages.getString("giftCertificate"));
        map.put("rowRefundPlus", "+" + POSConstants.REFUND_BUTTON_TEXT);
        map.put("rowTolerance", "+" + Messages.getString("CurrencyExplorer.8"));
        map.put("rowReceiptDiff", "=" + Messages.getString("receiptDifferential"));
        map.put("rowCashTips", "+" + Messages.getString("TipsCashoutReportTableModel.9"));
        map.put("rowChargedTips", "+" + Messages.getString("chargedTips"));
        map.put("rowTipsPaid", "-" + Messages.getString("TipsCashoutReportTableModel.5"));
        map.put("rowTipsDiff", "=" + Messages.getString("tipsDiff"));
        map.put("cashBalance", Messages.getString("CASH_BALANCE"));
        map.put("rowCash", POSConstants.CASH);
        map.put("rowTipsPaid", "-" + Messages.getString("TipsCashoutReportTableModel.5"));
        map.put("rowPayOut", "-" + Messages.getString("UserPermission.13"));
        map.put("rowRefundMinus", "-" + POSConstants.REFUND_BUTTON_TEXT);
        map.put("rowBeginCash", "+" + Messages.getString("beginCash"));
        map.put("rowDBleed", "-" + Messages.getString("CashDropDialog.2"));
        map.put("rowDAcc", "=" + Messages.getString("drawerAccountable"));
        map.put("rowDTips", ">" + Messages.getString("declaredTips"));
        map.put("IS_IGNORE_PAGINATION", true);
        map.put("startTime", Messages.getString("PosPrintService.14") + date_formatter.format(cashDrawer.getStartTime()));
        map.put("user", Messages.getString("PosPrintService.16") + cashDrawer.getAssignedBy());
        if (cashDrawer.getReportTime() != null) {
            map.put("date", Messages.getString("PosPrintService.17") + date_formatter.format(cashDrawer.getReportTime()));
            map.put("reportUser", Messages.getString("PosPrintService.18") + cashDrawer.getClosedBy());
        }
        map.put("totalVoid", cashDrawer.getTotalVoid());
        map.put("declaredTips", cashDrawer.getDeclaredTips());
        JasperReport subReportCurrencyBalance = ReportUtil.getReport("drawer-currency-balance");
        JasperReport subReport = ReportUtil.getReport("drawer-pull-void-veport");
        map.put("currencyBalanceReport", subReportCurrencyBalance);
        map.put("subreportParameter", subReport);
        JasperReport mainReport = ReportUtil.getReport("store-session-summary-report_72");
        JRBeanCollectionDataSource dataSource = new JRBeanCollectionDataSource(Arrays.asList(cashDrawer));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)mainReport, map, (JRDataSource)dataSource);
        jasperPrint.setProperty("printerName", DataProvider.get().getPrinters().getReceiptPrinter());
        jasperPrint.setName("StoreSessionSummaryReport");
        return jasperPrint;
    }

    public static JasperPrint populateTerminalStatusReport(CashDrawer cashDrawer) throws Exception {
        boolean staffBankReport = cashDrawer.getDrawerType() == DrawerType.STAFF_BANK;
        HashMap<String, String> map = new HashMap<String, String>();
        Store store = StoreDAO.getRestaurant();
        map.put("headerLine1", store.getName());
        map.put("reportTitle", staffBankReport ? Messages.getString("StaffBankReportTitle") : Messages.getString("CashDrawerReportTitle"));
        PosPrintService.populateTerminalStatusReportParams(map);
        JasperPrint jasperPrint = PosPrintService.populateTerminalStatusReport(cashDrawer, staffBankReport, map);
        return jasperPrint;
    }

    private static void populateTerminalStatusReportParams(HashMap map) {
        map.put("salesBalance", Messages.getString("SALES_BALANCE"));
        map.put("rowGrossReceipts", Messages.getString("grossReceipts"));
        map.put("rowCReceipts", "-" + Messages.getString("cashReceipts"));
        map.put("rowCCards", "-" + Messages.getString("creditCards"));
        map.put("rowDCards", "-" + Messages.getString("debitCards"));
        map.put("rowMPayments", "-" + Messages.getString("memberPayments"));
        map.put("rowCPayments", "-" + Messages.getString("customPayments"));
        map.put("rowGReturns", "-" + Messages.getString("giftReurns"));
        map.put("rowGCChange", "-" + Messages.getString("giftCertChange"));
        map.put("rowRefundPlus", "+" + POSConstants.REFUND_BUTTON_TEXT);
        map.put("rowReceiptDiff", "=" + Messages.getString("receiptDifferential"));
        map.put("rowCashTips", "+" + Messages.getString("TipsCashoutReportTableModel.9"));
        map.put("rowChargedTips", "+" + Messages.getString("chargedTips"));
        map.put("rowTipsPaid", "-" + Messages.getString("TipsCashoutReportTableModel.5"));
        map.put("rowTipsDiff", "=" + Messages.getString("tipsDiff"));
        map.put("cashBalance", Messages.getString("CASH_BALANCE"));
        map.put("rowCash", POSConstants.CASH);
        map.put("rowTipsPaid", "-" + Messages.getString("TipsCashoutReportTableModel.5"));
        map.put("rowPayOut", "-" + Messages.getString("UserPermission.13"));
        map.put("rowRefundMinus", "-" + POSConstants.REFUND_BUTTON_TEXT);
        map.put("rowBeginCash", "+" + Messages.getString("beginCash"));
        map.put("rowDBleed", "-" + Messages.getString("CashDropDialog.2"));
        map.put("rowDAcc", "=" + Messages.getString("drawerAccountable"));
        map.put("rowDTips", ">" + Messages.getString("declaredTips"));
        map.put("rowCToDipo", ">" + Messages.getString("cashToDeposit"));
        map.put("rowCBreakD", Messages.getString("CBreakDown"));
        map.put("rowCSRAmount", POSConstants.AMOUNT);
        map.put("rowVRExceptions", Messages.getString("VRExceptions"));
        map.put("rowVRTax", Messages.getString("VRTax"));
        map.put("rowVRAmount", POSConstants.AMOUNT);
        map.put("rowVRTotal", POSConstants.TOTAL);
    }

    public static JasperPrint populateServerSummaryReportParameters(CashDrawer cashDrawer) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Store store = StoreDAO.getRestaurant();
        map.put("headerLine1", store.getName());
        map.put("SSReportTitle", Messages.getString("SSReportTitle"));
        map.put("salesBalance", Messages.getString("SALES_BALANCE"));
        map.put("rowNetSales", POSConstants.NET_SALES);
        map.put("rowDiscount", "-" + POSConstants.DISCOUNT);
        map.put("rowSalesTax", "+" + POSConstants.SALES_TAX);
        map.put("rowSC", "+" + POSConstants.SERVICE_CHARGE);
        map.put("rowTotal", "=" + POSConstants.TOTAL);
        map.put("rowTips", "+" + POSConstants.TIPS);
        map.put("rowGReceivable", "=" + Messages.getString("grossReceivable"));
        map.put("rowCReceipts", Messages.getString("cashReceipts"));
        map.put("rowCCards", Messages.getString("creditCards"));
        map.put("rowDCards", Messages.getString("debitCards"));
        map.put("rowMPayments", Messages.getString("memberPayments"));
        map.put("rowCPayments", Messages.getString("customPayments"));
        map.put("rowPromotion", Messages.getString("PosPrintService.3"));
        map.put("rowGCert", Messages.getString("giftCertificate"));
        map.put("rowRefundPlus", Messages.getString("PosPrintService.5"));
        map.put("rowTolerance", "Tolerance");
        map.put("rowCashTips", Messages.getString("PosPrintService.6"));
        map.put("rowChargedTips", Messages.getString("chargedTips"));
        map.put("rowNumberOfTickets", Messages.getString("PosPrintService.0"));
        map.put("IS_IGNORE_PAGINATION", true);
        User assignedUser = cashDrawer.getAssignedUser();
        if (assignedUser != null) {
            String userInfo = assignedUser.getFullName();
            map.put("user", Messages.getString("PosPrintService.27") + userInfo);
        }
        String storeSessionStartTime = DateUtil.formatFullDateAndTimeAsString(cashDrawer.getStartTime());
        if (cashDrawer.getReportTime() != null) {
            map.put("date", "<b>" + Messages.getString("FROM") + "</b> " + storeSessionStartTime + " <b>" + Messages.getString("TO") + "</b> " + DateUtil.formatFullDateAndTimeAsString(cashDrawer.getReportTime()));
        } else {
            map.put("date", "<b>" + Messages.getString("FROM") + "</b> " + storeSessionStartTime + "&#10;" + Messages.getString("TO") + "</b> " + DateUtil.formatFullDateAndTimeAsString(new Date()));
        }
        map.put("totalVoid", cashDrawer.getTotalVoid());
        map.put("declaredTips", cashDrawer.getDeclaredTips());
        JasperReport subReportCurrencyBalance = ReportUtil.getReport("drawer-currency-balance");
        JasperReport subReport = ReportUtil.getReport("drawer-pull-void-veport");
        JasperReport catBreakOutSubReport = ReportUtil.getReport("category-break-out-sub-report");
        map.put("currencyBalanceReport", subReportCurrencyBalance);
        map.put("subreportParameter", subReport);
        map.put("catBreakOutSubReport", catBreakOutSubReport);
        map.put("TitleCatBreakOut", Messages.getString("CategoryBreakout"));
        JasperReport mainReport = ReportUtil.getReport("server-summary-report_72");
        JRBeanCollectionDataSource dataSource = new JRBeanCollectionDataSource(Arrays.asList(cashDrawer));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)mainReport, map, (JRDataSource)dataSource);
        jasperPrint.setProperty("printerName", DataProvider.get().getPrinters().getReceiptPrinter());
        jasperPrint.setName("ServerSummaryReport");
        return jasperPrint;
    }

    public static JasperPrint populateTerminalStatusReport(CashDrawer cashDrawer, boolean staffBankReport, HashMap parameters) throws JRException {
        parameters.put("IS_IGNORE_PAGINATION", true);
        User assignedUser = cashDrawer.getAssignedUser();
        if (assignedUser != null) {
            String userInfo = assignedUser.getFullName();
            parameters.put("user", (staffBankReport ? Messages.getString("PosPrintService.21") : Messages.getString("PosPrintService.4") + " ") + userInfo);
        }
        if (cashDrawer.getStartTime() != null) {
            parameters.put("startTime", Messages.getString("PosPrintService.24") + date_formatter.format(cashDrawer.getStartTime()));
        }
        parameters.put("date", Messages.getString("PosPrintService.25") + date_formatter.format(new Date()));
        parameters.put("totalVoid", cashDrawer.getTotalVoid());
        parameters.put("declaredTips", cashDrawer.getDeclaredTips());
        JasperReport subReportCurrencyBalance = ReportUtil.getReport("drawer-currency-balance");
        JasperReport subReport = ReportUtil.getReport("drawer-pull-void-veport");
        parameters.put("currencyBalanceReport", subReportCurrencyBalance);
        parameters.put("subreportParameter", subReport);
        JasperReport mainReport = ReportUtil.getReport("terminal_status_report_72");
        JRBeanCollectionDataSource dataSource = new JRBeanCollectionDataSource(Arrays.asList(cashDrawer));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)mainReport, (Map)parameters, (JRDataSource)dataSource);
        jasperPrint.setProperty("printerName", DataProvider.get().getPrinters().getReceiptPrinter());
        jasperPrint.setName("TerminalStatusReport" + cashDrawer.getTerminalId());
        return jasperPrint;
    }

    public static CashDrawer populateCashDrawerReportSummary(List<CashDrawer> reportList) {
        CashDrawer cashDrawersReportSummary = new CashDrawer();
        HashMap<String, CashBreakdown> summaryCashBreakdownMap = new HashMap<String, CashBreakdown>();
        ArrayList<String> cashDrawerIds = new ArrayList<String>();
        if (reportList != null) {
            for (CashDrawer report : reportList) {
                if (report.getReportTime() == null) {
                    try {
                        CashDrawerReportService reportService2 = new CashDrawerReportService(report);
                        reportService2.populateReport();
                    }
                    catch (Exception reportService2) {
                        // empty catch block
                    }
                }
                cashDrawerIds.add(report.getId());
                cashDrawersReportSummary.setBeginCash(cashDrawersReportSummary.getBeginCash() + report.getBeginCash());
                cashDrawersReportSummary.setNetSales(cashDrawersReportSummary.getNetSales() + report.getNetSales());
                cashDrawersReportSummary.setSalesTax(cashDrawersReportSummary.getSalesTax() + report.getSalesTax());
                cashDrawersReportSummary.setSalesDeliveryCharge(cashDrawersReportSummary.getSalesDeliveryCharge() + report.getSalesDeliveryCharge());
                cashDrawersReportSummary.setTotalVoid(cashDrawersReportSummary.getTotalVoid() + report.getTotalVoid());
                cashDrawersReportSummary.setTotalVoidWst(cashDrawersReportSummary.getTotalVoidWst() + report.getTotalVoidWst());
                cashDrawersReportSummary.setTipsPaid(cashDrawersReportSummary.getTipsPaid() + report.getTipsPaid());
                cashDrawersReportSummary.setTotalDiscountCount(cashDrawersReportSummary.getTotalDiscountCount() + report.getTotalDiscountCount());
                cashDrawersReportSummary.setTotalDiscountAmount(cashDrawersReportSummary.getTotalDiscountAmount() + report.getTotalDiscountAmount());
                cashDrawersReportSummary.setCashReceiptCount(cashDrawersReportSummary.getCashReceiptCount() + report.getCashReceiptCount());
                cashDrawersReportSummary.setCashReceiptAmount(cashDrawersReportSummary.getCashReceiptAmount() + report.getCashReceiptAmount());
                cashDrawersReportSummary.setCreditCardReceiptCount(cashDrawersReportSummary.getCreditCardReceiptCount() + report.getCreditCardReceiptCount());
                cashDrawersReportSummary.setCreditCardReceiptAmount(cashDrawersReportSummary.getCreditCardReceiptAmount() + report.getCreditCardReceiptAmount());
                cashDrawersReportSummary.setDebitCardReceiptCount(cashDrawersReportSummary.getDebitCardReceiptCount() + report.getDebitCardReceiptCount());
                cashDrawersReportSummary.setDebitCardReceiptAmount(cashDrawersReportSummary.getDebitCardReceiptAmount() + report.getDebitCardReceiptAmount());
                cashDrawersReportSummary.setGiftCertReturnCount(cashDrawersReportSummary.getGiftCertReturnCount() + report.getGiftCertReturnCount());
                cashDrawersReportSummary.setGiftCertReturnAmount(cashDrawersReportSummary.getGiftCertReturnAmount() + report.getGiftCertReturnAmount());
                cashDrawersReportSummary.setGiftCertChangeAmount(cashDrawersReportSummary.getGiftCertChangeAmount() + report.getGiftCertChangeAmount());
                cashDrawersReportSummary.setCustomPaymentCount(cashDrawersReportSummary.getCustomPaymentCount() + report.getCustomPaymentCount());
                cashDrawersReportSummary.setCustomPaymentAmount(cashDrawersReportSummary.getCustomPaymentAmount() + report.getCustomPaymentAmount());
                cashDrawersReportSummary.setRefundReceiptCount(cashDrawersReportSummary.getRefundReceiptCount() + report.getRefundReceiptCount());
                cashDrawersReportSummary.setRefundAmount(cashDrawersReportSummary.getRefundAmount() + report.getRefundAmount());
                cashDrawersReportSummary.setPayOutCount(cashDrawersReportSummary.getPayOutCount() + report.getPayOutCount());
                cashDrawersReportSummary.setPayOutAmount(cashDrawersReportSummary.getPayOutAmount() + report.getPayOutAmount());
                cashDrawersReportSummary.setDrawerBleedCount(cashDrawersReportSummary.getDrawerBleedCount() + report.getDrawerBleedCount());
                cashDrawersReportSummary.setDrawerBleedAmount(cashDrawersReportSummary.getDrawerBleedAmount() + report.getDrawerBleedAmount());
                cashDrawersReportSummary.setCashTips(cashDrawersReportSummary.getCashTips() + report.getCashTips());
                cashDrawersReportSummary.setChargedTips(cashDrawersReportSummary.getChargedTips() + report.getChargedTips());
                cashDrawersReportSummary.setCashBack(cashDrawersReportSummary.getCashBack() + report.getCashBack());
                cashDrawersReportSummary.setCashToDeposit(cashDrawersReportSummary.getCashToDeposit() + report.getCashToDeposit());
                List<CashBreakdown> cashBreakdowns = report.getCashBreakdownList();
                if (cashBreakdowns != null) {
                    for (CashBreakdown cashBreakdown : cashBreakdowns) {
                        CashBreakdown breakdown = (CashBreakdown)summaryCashBreakdownMap.get(cashBreakdown.getCurrency().getName());
                        if (breakdown == null) {
                            breakdown = new CashBreakdown();
                            summaryCashBreakdownMap.put(cashBreakdown.getCurrency().getName(), breakdown);
                        }
                        breakdown.setBalance(breakdown.getBalance() + cashBreakdown.getBalance());
                        breakdown.setBalance(breakdown.getTotalAmount() + cashBreakdown.getTotalAmount());
                    }
                }
                cashDrawersReportSummary.setStoreSession(report.getStoreSession());
            }
        }
        cashDrawersReportSummary.calculate();
        cashDrawersReportSummary.setVoidEntries(new HashSet<DrawerPullVoidEntry>(VoidItemDAO.getInstance().getVoidEntries(cashDrawerIds)));
        return cashDrawersReportSummary;
    }

    public static void printCashDrawerReportSummary(StoreSession currentData) {
        List<CashDrawer> drawerReports = CashDrawerDAO.getInstance().findByStoreOperationData(currentData, false);
        CashDrawer cashDrawersReportSummary = PosPrintService.populateCashDrawerReportSummary(drawerReports);
        cashDrawersReportSummary.setStartTime(currentData.getOpenTime());
        cashDrawersReportSummary.setAssignedBy(currentData.getOpenedBy());
        cashDrawersReportSummary.setReportTime(currentData.getCloseTime());
        cashDrawersReportSummary.setClosedBy(currentData.getClosedBy());
        PosPrintService.printCashDrawerSummaryReport(cashDrawersReportSummary);
    }

    public static CashDrawer populateCloudCashDrawerReportSummary(List<CashDrawer> reportList) {
        CashDrawer cashDrawersReportSummary = new CashDrawer();
        HashMap<String, CashBreakdown> summaryCashBreakdownMap = new HashMap<String, CashBreakdown>();
        ArrayList<String> cashDrawerIds = new ArrayList<String>();
        if (reportList != null) {
            for (CashDrawer report : reportList) {
                cashDrawerIds.add(report.getId());
                cashDrawersReportSummary.setBeginCash(cashDrawersReportSummary.getBeginCash() + report.getBeginCash());
                cashDrawersReportSummary.setNetSales(cashDrawersReportSummary.getNetSales() + report.getNetSales());
                cashDrawersReportSummary.setSalesTax(cashDrawersReportSummary.getSalesTax() + report.getSalesTax());
                cashDrawersReportSummary.setSalesDeliveryCharge(cashDrawersReportSummary.getSalesDeliveryCharge() + report.getSalesDeliveryCharge());
                cashDrawersReportSummary.setTotalVoid(cashDrawersReportSummary.getTotalVoid() + report.getTotalVoid());
                cashDrawersReportSummary.setTotalVoidWst(cashDrawersReportSummary.getTotalVoidWst() + report.getTotalVoidWst());
                cashDrawersReportSummary.setTipsPaid(cashDrawersReportSummary.getTipsPaid() + report.getTipsPaid());
                cashDrawersReportSummary.setTotalDiscountCount(cashDrawersReportSummary.getTotalDiscountCount() + report.getTotalDiscountCount());
                cashDrawersReportSummary.setTotalDiscountAmount(cashDrawersReportSummary.getTotalDiscountAmount() + report.getTotalDiscountAmount());
                cashDrawersReportSummary.setCashReceiptCount(cashDrawersReportSummary.getCashReceiptCount() + report.getCashReceiptCount());
                cashDrawersReportSummary.setCashReceiptAmount(cashDrawersReportSummary.getCashReceiptAmount() + report.getCashReceiptAmount());
                cashDrawersReportSummary.setCreditCardReceiptCount(cashDrawersReportSummary.getCreditCardReceiptCount() + report.getCreditCardReceiptCount());
                cashDrawersReportSummary.setCreditCardReceiptAmount(cashDrawersReportSummary.getCreditCardReceiptAmount() + report.getCreditCardReceiptAmount());
                cashDrawersReportSummary.setDebitCardReceiptCount(cashDrawersReportSummary.getDebitCardReceiptCount() + report.getDebitCardReceiptCount());
                cashDrawersReportSummary.setDebitCardReceiptAmount(cashDrawersReportSummary.getDebitCardReceiptAmount() + report.getDebitCardReceiptAmount());
                cashDrawersReportSummary.setGiftCertReturnCount(cashDrawersReportSummary.getGiftCertReturnCount() + report.getGiftCertReturnCount());
                cashDrawersReportSummary.setGiftCertReturnAmount(cashDrawersReportSummary.getGiftCertReturnAmount() + report.getGiftCertReturnAmount());
                cashDrawersReportSummary.setGiftCertChangeAmount(cashDrawersReportSummary.getGiftCertChangeAmount() + report.getGiftCertChangeAmount());
                cashDrawersReportSummary.setCustomPaymentCount(cashDrawersReportSummary.getCustomPaymentCount() + report.getCustomPaymentCount());
                cashDrawersReportSummary.setCustomPaymentAmount(cashDrawersReportSummary.getCustomPaymentAmount() + report.getCustomPaymentAmount());
                cashDrawersReportSummary.setRefundReceiptCount(cashDrawersReportSummary.getRefundReceiptCount() + report.getRefundReceiptCount());
                cashDrawersReportSummary.setRefundAmount(cashDrawersReportSummary.getRefundAmount() + report.getRefundAmount());
                cashDrawersReportSummary.setPayOutCount(cashDrawersReportSummary.getPayOutCount() + report.getPayOutCount());
                cashDrawersReportSummary.setPayOutAmount(cashDrawersReportSummary.getPayOutAmount() + report.getPayOutAmount());
                cashDrawersReportSummary.setDrawerBleedCount(cashDrawersReportSummary.getDrawerBleedCount() + report.getDrawerBleedCount());
                cashDrawersReportSummary.setDrawerBleedAmount(cashDrawersReportSummary.getDrawerBleedAmount() + report.getDrawerBleedAmount());
                cashDrawersReportSummary.setCashTips(cashDrawersReportSummary.getCashTips() + report.getCashTips());
                cashDrawersReportSummary.setChargedTips(cashDrawersReportSummary.getChargedTips() + report.getChargedTips());
                cashDrawersReportSummary.setCashBack(cashDrawersReportSummary.getCashBack() + report.getCashBack());
                cashDrawersReportSummary.setCashToDeposit(cashDrawersReportSummary.getCashToDeposit() + report.getCashToDeposit());
                List<CashBreakdown> cashBreakdowns = report.getCashBreakdownList();
                if (cashBreakdowns != null) {
                    for (CashBreakdown cashBreakdown : cashBreakdowns) {
                        CashBreakdown breakdown = (CashBreakdown)summaryCashBreakdownMap.get(cashBreakdown.getCurrency().getName());
                        if (breakdown == null) {
                            breakdown = new CashBreakdown();
                            summaryCashBreakdownMap.put(cashBreakdown.getCurrency().getName(), breakdown);
                        }
                        breakdown.setBalance(breakdown.getBalance() + cashBreakdown.getBalance());
                        breakdown.setBalance(breakdown.getTotalAmount() + cashBreakdown.getTotalAmount());
                    }
                }
                cashDrawersReportSummary.setStoreSession(report.getStoreSession());
            }
        }
        cashDrawersReportSummary.calculate();
        cashDrawersReportSummary.setVoidEntries(new HashSet<DrawerPullVoidEntry>(VoidItemDAO.getInstance().getVoidEntries(cashDrawerIds)));
        return cashDrawersReportSummary;
    }

    public static void printClockInOutReceipt(User user) throws Exception {
        Date currentTime = new Date();
        Store store = DataProvider.get().getStore();
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd MMM, yyyy");
        SimpleDateFormat dateFormat2 = new SimpleDateFormat("dd MMM, hh:mm aaa");
        SimpleDateFormat timeFormat = new SimpleDateFormat("hh:mm:ss aaa");
        String message = "";
        message = user.isClockedIn() != false ? Messages.getString("PosPrintService.36") + timeFormat.format(currentTime) : Messages.getString("PosPrintService.37") + timeFormat.format(currentTime);
        String sep = "\n.......................................................................";
        String data = "\n" + store.getName();
        data = data + "\n" + store.getAddressLine1();
        data = data + sep;
        data = data + "\n-" + user.getFullName() + " (#" + user.getId() + ")" + (user.isClockedIn() != false ? " clock in" : " clock out") + "-";
        data = data + sep;
        data = data + Messages.getString("PosPrintService.47") + dateFormat.format(currentTime);
        data = data + "\n" + message;
        data = data + Messages.getString("PosPrintService.49") + dateFormat2.format(new Date());
        data = data + sep;
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("title", "");
        map.put("data", data);
        JasperReport report = ReportUtil.getReport("generic-receipt");
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)report, map, (JRDataSource)new JREmptyDataSource());
        PosPrintService.printReportByJasperPrint(jasperPrint);
    }
}

