/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.model.User;
import com.floreantpos.report.AttendanceReportData;
import com.floreantpos.swing.ListTableModel;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;

public class AttendanceReportModel
extends ListTableModel {
    SimpleDateFormat dateFormat2 = new SimpleDateFormat("dd MMM yy hh:mm a");
    DecimalFormat decimalFormat = new DecimalFormat("0.00");

    public AttendanceReportModel() {
        super(new String[]{"userID", "userName", "from", "to", "total", "role", "rate", "payment", "userSSN", "parentUserID"});
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        AttendanceReportData data = (AttendanceReportData)this.rows.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return String.valueOf(data.getUser().getId());
            }
            case 1: {
                return data.getUser().getFirstName() + " " + data.getUser().getLastName();
            }
            case 2: {
                return this.dateFormat2.format(data.getFrom());
            }
            case 3: {
                return this.dateFormat2.format(data.getTo());
            }
            case 4: {
                return data.getTotalHour();
            }
            case 5: {
                String name = "";
                if (data.getUser() != null && data.getUser().getType() != null) {
                    name = data.getUser().getType().getName();
                }
                return name;
            }
            case 6: {
                return this.decimalFormat.format(data.getRate());
            }
            case 7: {
                return data.getTotalPayment();
            }
            case 8: {
                return String.valueOf(data.getUser().getId());
            }
            case 9: {
                User user = data.getUser();
                User parentUser = user.getParentUser();
                if (parentUser != null) {
                    return String.valueOf(parentUser.getId());
                }
                return String.valueOf(user.getId());
            }
        }
        return null;
    }
}

