/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.Customer;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.model.CustomerPaymentReportModel;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.swingx.JXDatePicker;

public class CustomerPaymentReportView
extends TransparentPanel {
    private JButton btnGo;
    private JXDatePicker fromDatePicker;
    private JXDatePicker toDatePicker;
    private JPanel reportPanel;
    private JPanel contentPane;
    private JComboBox jcbCustomer;

    public CustomerPaymentReportView() {
        this.setLayout(new BorderLayout());
        this.createUI();
    }

    private void viewReport() throws Exception {
        List<CustomerAccountTransactionItem> transactionList;
        Date toDate;
        Date fromDate = this.fromDatePicker.getDate();
        if (fromDate.after(toDate = this.toDatePicker.getDate())) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(fromDate);
        calendar.set(1, calendar2.get(1));
        calendar.set(2, calendar2.get(2));
        calendar.set(5, calendar2.get(5));
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        fromDate = calendar.getTime();
        calendar.clear();
        calendar2.setTime(toDate);
        calendar.set(1, calendar2.get(1));
        calendar.set(2, calendar2.get(2));
        calendar.set(5, calendar2.get(5));
        calendar.set(10, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        toDate = calendar.getTime();
        Object selectedItem = this.jcbCustomer.getSelectedItem();
        Customer customer = null;
        if (selectedItem instanceof Customer) {
            customer = (Customer)selectedItem;
        }
        if ((transactionList = PosTransactionDAO.getInstance().findCustomerAccountTransactions(fromDate, toDate, customer)) == null || transactionList.size() < 1) {
            this.reportPanel.removeAll();
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("CustomerPaymentReportView.0"));
            return;
        }
        JasperReport report = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("customer-payment-report"));
        HashMap properties = new HashMap();
        ReportUtil.populateRestaurantProperties(properties);
        ReportUtil.populateReportTime(properties, fromDate, toDate);
        ReportUtil.populateReportFooter(properties);
        this.populateReportParams(properties);
        CustomerPaymentReportModel reportModel = new CustomerPaymentReportModel();
        reportModel.setRows(transactionList);
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, properties, (JRDataSource)new JRTableModelDataSource((TableModel)reportModel));
        JRViewer viewer = ReportUtil.getCustomJRViewer(print);
        this.reportPanel.removeAll();
        this.reportPanel.add((Component)viewer);
        this.reportPanel.revalidate();
    }

    private void populateReportParams(HashMap properties) {
        properties.put("reportTitle", Messages.getString("CustomerPaymentReportView.2"));
        properties.put("tips", Messages.getString("CustomerPaymentReportView.13") + CurrencyUtil.getCurrencySymbolWithBracket());
        properties.put("totalAmount", Messages.getString("CustomerPaymentReportView.17") + CurrencyUtil.getCurrencySymbolWithBracket());
        properties.put("colCName", Messages.getString("CustomerName"));
        properties.put("colCId", Messages.getString("CustomerId"));
        properties.put("colTicketNo", Messages.getString("TicketNo"));
        properties.put("colTransNo", Messages.getString("TransNo"));
        properties.put("colDate", POSConstants.DATE);
        properties.put("colTotal", POSConstants.TOTAL);
    }

    private void createUI() {
        this.fromDatePicker = UiUtil.getCurrentMonthStart();
        this.toDatePicker = UiUtil.getDeafultDate();
        this.toDatePicker.setDate(new Date());
        this.btnGo = new JButton();
        this.btnGo.setText(POSConstants.GO);
        this.btnGo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    CustomerPaymentReportView.this.viewReport();
                }
                catch (Exception e1) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, e1);
                }
            }
        });
        this.jcbCustomer = new JComboBox();
        CustomerDAO dao = new CustomerDAO();
        List<Customer> userTypes = dao.findAll();
        Vector<Object> list = new Vector<Object>();
        list.add(POSConstants.ALL);
        list.addAll(userTypes);
        this.jcbCustomer.setModel(new DefaultComboBoxModel(list));
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel((LayoutManager)new MigLayout());
        topPanel.add(new JLabel(Messages.getString("CustomerPaymentReportView.20") + ":"));
        topPanel.add(this.jcbCustomer);
        topPanel.add(new JLabel(POSConstants.START_DATE + ":"));
        this.fromDatePicker.setFormats(new String[]{"dd MMM yy"});
        topPanel.add((Component)this.fromDatePicker);
        topPanel.add(new JLabel(POSConstants.END_DATE + ":"));
        this.toDatePicker.setFormats(new String[]{"dd MMM yy"});
        topPanel.add((Component)this.toDatePicker);
        topPanel.add((Component)this.btnGo, "width 60!");
        this.add((Component)topPanel, "North");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBorder(new EmptyBorder(0, 10, 10, 10));
        centerPanel.add((Component)new JSeparator(), "North");
        this.reportPanel = new JPanel(new BorderLayout());
        centerPanel.add(this.reportPanel);
        this.add(centerPanel);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    public static class CustomerAccountTransactionItem {
        private String customerName;
        private String customerId;
        private String ticketNo;
        private String transactionNo;
        private Date date;
        private Double tips;
        private Double totalAmount;

        public String getCustomerId() {
            return this.customerId;
        }

        public void setCustomerId(String id) {
            this.customerId = id;
        }

        public String getTicketNo() {
            return this.ticketNo;
        }

        public void setTicketNo(String ticketNo) {
            this.ticketNo = ticketNo;
        }

        public String getTransactionNo() {
            return this.transactionNo;
        }

        public void setTransactionNo(String transactionNo) {
            this.transactionNo = transactionNo;
        }

        public Date getDate() {
            return this.date;
        }

        public void setDate(Date date) {
            this.date = date;
        }

        public Double getTips() {
            return this.tips;
        }

        public void setTips(Double tips) {
            this.tips = tips;
        }

        public Double getTotalAmount() {
            return this.totalAmount;
        }

        public void setTotalAmount(Double totalAmount) {
            this.totalAmount = totalAmount;
        }

        public String getCustomerName() {
            return this.customerName;
        }

        public void setCustomerName(String customerName) {
            this.customerName = customerName;
        }
    }
}

