/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.dao.GiftCardDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.model.GiftCardSummaryReportModel;
import com.floreantpos.services.report.ReportService;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.swingx.JXDatePicker;

public class GiftCardSummaryReportView
extends TransparentPanel {
    private JButton btnGo;
    private JPanel reportPanel;
    private JXDatePicker fromDatePicker;
    private JXDatePicker toDatePicker;
    private JCheckBox chkExpired;
    private JComboBox<String> cbSortOptions;

    public GiftCardSummaryReportView() {
        this.setLayout(new BorderLayout());
        this.createUI();
    }

    private void viewReport() throws Exception {
        Date fromDate = this.fromDatePicker.getDate();
        Date toDate = this.toDatePicker.getDate();
        String sortOption = (String)this.cbSortOptions.getSelectedItem();
        if (fromDate.after(toDate)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            this.reportPanel.removeAll();
            return;
        }
        List<GiftCard> giftCardList = GiftCardDAO.getInstance().findGiftCards(fromDate, toDate, this.chkExpired.isSelected(), sortOption);
        JasperReport report = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("gift_card_summary_report"));
        HashMap properties = new HashMap();
        ReportUtil.populateRestaurantProperties(properties);
        ReportUtil.populateReportFooter(properties);
        this.populateReportFooterr(properties, fromDate, toDate);
        GiftCardSummaryReportModel giftCardSummaryModel = new GiftCardSummaryReportModel(giftCardList);
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, properties, (JRDataSource)new JRTableModelDataSource((TableModel)giftCardSummaryModel));
        JRViewer viewer = ReportUtil.getCustomJRViewer(print);
        this.reportPanel.removeAll();
        this.reportPanel.add((Component)viewer);
        this.reportPanel.revalidate();
    }

    private void populateReportFooterr(HashMap properties, Date fromDate, Date toDate) {
        properties.put("reportTitle", Messages.getString("GiftCardSummaryReport"));
        properties.put("reportTime", ReportUtil.reportLabelWithBoldTag(POSConstants.REPORT_TIME) + ReportService.formatFullDate(new Date()));
        properties.put("fromDate", ReportUtil.reportLabelWithBoldTag(POSConstants.FROM_DATE) + ReportService.formatShortDate(fromDate));
        properties.put("toDate", ReportUtil.reportLabelWithBoldTag(POSConstants.TO_DATE) + ReportService.formatShortDate(toDate));
        properties.put("colCNumber", Messages.getString("CardNumber"));
        properties.put("colOName", Messages.getString("GiftCardExplorer.44"));
        properties.put("colBatch", Messages.getString("GiftCardExplorer.48"));
        properties.put("colADate", Messages.getString("GiftCardSummaryReportView.2"));
        properties.put("colDDate", Messages.getString("GiftCardExplorer.56"));
        properties.put("colEDate", Messages.getString("EXpirationDate"));
        properties.put("colBalance", Messages.getString("CustomerExplorer.13") + CurrencyUtil.getCurrencySymbolWithBracket());
    }

    private void createUI() {
        this.fromDatePicker = UiUtil.getCurrentMonthStart();
        this.toDatePicker = UiUtil.getCurrentMonthEnd();
        this.chkExpired = new JCheckBox(Messages.getString("GiftCardSummaryReportView.1"));
        this.cbSortOptions = new JComboBox();
        ComboBoxModel comboBoxModel = new ComboBoxModel();
        comboBoxModel.addElement(Messages.getString("GiftCardSummaryReportView.2"));
        comboBoxModel.addElement(Messages.getString("GiftCardSummaryReportView.3"));
        this.cbSortOptions.setModel(comboBoxModel);
        this.btnGo = new JButton();
        this.btnGo.setText(POSConstants.GO);
        this.btnGo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                try {
                    GiftCardSummaryReportView.this.viewReport();
                }
                catch (Exception e) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, e);
                }
            }
        });
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel((LayoutManager)new MigLayout());
        topPanel.add(new JLabel("Activated between "));
        this.fromDatePicker.setFormats(new String[]{"dd MMM yy"});
        topPanel.add((Component)this.fromDatePicker);
        topPanel.add(new JLabel("and "));
        this.toDatePicker.setFormats(new String[]{"dd MMM yy"});
        topPanel.add((Component)this.toDatePicker);
        topPanel.add((Component)new JLabel(Messages.getString("GiftCardSummaryReportView.6")), "gapLeft 20");
        topPanel.add(this.cbSortOptions);
        topPanel.add((Component)this.chkExpired, "gapLeft 20");
        topPanel.add((Component)this.btnGo, "width 60!,gapLeft 20");
        this.add((Component)topPanel, "North");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBorder(new EmptyBorder(0, 10, 10, 10));
        centerPanel.add((Component)new JSeparator(), "North");
        this.reportPanel = new JPanel(new BorderLayout());
        centerPanel.add(this.reportPanel);
        this.add(centerPanel);
    }
}

