/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.dao.GiftCardDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.model.GiftCardTransactionsReportModel;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.swingx.JXDatePicker;

public class GiftCardTransactionReportView
extends TransparentPanel {
    private JButton btnGo;
    private JPanel reportPanel;
    private JXDatePicker fromDatePicker;
    private JXDatePicker toDatePicker;
    private JTextField tfCardNumber;

    public GiftCardTransactionReportView() {
        this.setLayout(new BorderLayout());
        this.createUI();
    }

    private void viewReport() throws Exception {
        String cardNumber = this.tfCardNumber.getText();
        Date fromDate = this.fromDatePicker.getDate();
        Date toDate = this.toDatePicker.getDate();
        if (StringUtils.isEmpty((String)cardNumber)) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("EnterCardNumber"));
            this.reportPanel.removeAll();
            return;
        }
        if (fromDate.after(toDate)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            this.reportPanel.removeAll();
            return;
        }
        GiftCard giftCard = GiftCardDAO.getInstance().get(cardNumber);
        if (giftCard == null) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GiftCardTransactionReportView.1"));
            this.reportPanel.removeAll();
            return;
        }
        List<PosTransaction> transactions = PosTransactionDAO.getInstance().findTransactionListByGiftCardNumber(cardNumber, fromDate, toDate);
        if (transactions.isEmpty()) {
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("GiftCardTransactionReportView.2"));
            this.reportPanel.removeAll();
            return;
        }
        JasperReport report = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("gift_card_transaction_report"));
        HashMap properties = new HashMap();
        ReportUtil.populateRestaurantProperties(properties, true);
        ReportUtil.populateReportFooter(properties);
        this.populateReportParams(properties, giftCard);
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, properties, (JRDataSource)new JRTableModelDataSource((TableModel)new GiftCardTransactionsReportModel(transactions)));
        JRViewer viewer = ReportUtil.getCustomJRViewer(print);
        this.reportPanel.removeAll();
        this.reportPanel.add((Component)viewer);
        this.reportPanel.revalidate();
    }

    private void populateReportParams(HashMap properties, GiftCard giftCard) {
        String cardNo = giftCard.getCardNumber() != null ? giftCard.getCardNumber() : "";
        String activeDate = DateUtil.formatDateWithTime(giftCard.getActivationDate());
        String cardOwner = giftCard.getOwnerName() != null ? giftCard.getOwnerName() : "";
        String endBalance = giftCard.getBalance() != null ? CurrencyUtil.getCurrencySymbol() + NumberUtil.formatNumber(giftCard.getBalance()) : "";
        properties.put("reportTitle", Messages.getString("GiftCardTransactionsReport"));
        properties.put("cardNo", ReportUtil.reportLabelWithBoldTag(Messages.getString("GiftCardExplorer.42") + ": ") + cardNo);
        properties.put("activeDate", ReportUtil.reportLabelWithBoldTag(Messages.getString("GiftCardSummaryReportView.2") + ": ") + activeDate);
        properties.put("reportTime", ReportUtil.reportLabelWithBoldTag(POSConstants.REPORT_TIME) + DateUtil.formatDateWithTime(new Date()));
        properties.put("cardOwner", ReportUtil.reportLabelWithBoldTag(Messages.getString("CardOwner") + " ") + cardOwner);
        properties.put("endBalance", ReportUtil.reportLabelWithBoldTag(Messages.getString("EndBalance") + " ") + endBalance);
        properties.put("titleAmount", POSConstants.AMOUNT + CurrencyUtil.getCurrencySymbolWithBracket());
        properties.put("colTicketN", Messages.getString("TicketNo"));
        properties.put("colTransT", Messages.getString("TRANSACTION_TIME"));
        properties.put("colDes", Messages.getString("MenuItemSizeForm.4"));
    }

    private void createUI() {
        JLabel lblCardNumber = new JLabel(Messages.getString("GiftCardTransactionReportView.11"));
        this.tfCardNumber = new JTextField(20);
        this.fromDatePicker = UiUtil.getCurrentMonthStart();
        this.toDatePicker = UiUtil.getCurrentMonthEnd();
        this.btnGo = new JButton();
        this.btnGo.setText(POSConstants.GO);
        this.btnGo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                try {
                    GiftCardTransactionReportView.this.viewReport();
                }
                catch (Exception e) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, e);
                }
            }
        });
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel((LayoutManager)new MigLayout());
        topPanel.add(lblCardNumber);
        topPanel.add((Component)this.tfCardNumber, "grow");
        topPanel.add(new JLabel(POSConstants.START_DATE + ":"));
        this.fromDatePicker.setFormats(new String[]{"dd MMM yy"});
        topPanel.add((Component)this.fromDatePicker);
        topPanel.add(new JLabel(POSConstants.END_DATE + ":"));
        this.toDatePicker.setFormats(new String[]{"dd MMM yy"});
        topPanel.add((Component)this.toDatePicker);
        topPanel.add((Component)this.btnGo, "width 60!");
        this.add((Component)topPanel, "North");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBorder(new EmptyBorder(0, 10, 10, 10));
        centerPanel.add((Component)new JSeparator(), "North");
        this.reportPanel = new JPanel(new BorderLayout());
        centerPanel.add(this.reportPanel);
        this.add(centerPanel);
    }
}

