/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.report.HourlySalesReportView;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.util.NumberUtil;
import java.util.List;

public class HourlySalesReportModel
extends ListTableModel {
    private String[] columnNames = new String[]{"period", "checks", "guests", "sales", "manHour", "labor", "salesPerMHr", "guestsPerMHr", "checksPerMHr", "laborCost"};

    public HourlySalesReportModel() {
        this.setColumnNames(this.columnNames);
    }

    public HourlySalesReportModel(List rows) {
        this.setColumnNames(this.columnNames);
        this.setRows(rows);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        HourlySalesReportView.LaborReportData reportData = (HourlySalesReportView.LaborReportData)this.rows.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return reportData.getPeriod();
            }
            case 1: {
                return NumberUtil.getIntegerFormat(reportData.getNoOfChecks());
            }
            case 2: {
                return NumberUtil.getIntegerFormat(reportData.getNoOfGuests());
            }
            case 3: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(reportData.getSales());
            }
            case 4: {
                return reportData.getManHour();
            }
            case 5: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(reportData.getLabor());
            }
            case 6: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(reportData.getSalesPerMHr());
            }
            case 7: {
                return reportData.getGuestsPerMHr();
            }
            case 8: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(reportData.getCheckPerMHr());
            }
            case 9: {
                double laborCost = 0.0;
                try {
                    laborCost = NumberUtil.getCurrencyFormatWithoutSymbol(reportData.getLaborCost());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return laborCost;
            }
        }
        return null;
    }
}

