/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.model.PaymentReceivedReportModel;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.swingx.JXDatePicker;

public class PaymentReceivedReportView
extends TransparentPanel {
    private JButton btnGo;
    private JXDatePicker fromDatePicker;
    private JXDatePicker toDatePicker;
    private JPanel reportPanel;
    private JPanel contentPane;
    private JComboBox jcbEmployee;

    public PaymentReceivedReportView() {
        this.setLayout(new BorderLayout());
        this.createUI();
    }

    private void viewReport() throws Exception {
        List<PosTransaction> transactionList;
        Date toDate;
        Date fromDate = this.fromDatePicker.getDate();
        if (fromDate.after(toDate = this.toDatePicker.getDate())) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(fromDate);
        calendar.set(1, calendar2.get(1));
        calendar.set(2, calendar2.get(2));
        calendar.set(5, calendar2.get(5));
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        fromDate = calendar.getTime();
        calendar.clear();
        calendar2.setTime(toDate);
        calendar.set(1, calendar2.get(1));
        calendar.set(2, calendar2.get(2));
        calendar.set(5, calendar2.get(5));
        calendar.set(10, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        toDate = calendar.getTime();
        Object selectedItem = this.jcbEmployee.getSelectedItem();
        User user = null;
        if (selectedItem instanceof User) {
            user = (User)selectedItem;
        }
        if ((transactionList = PosTransactionDAO.getInstance().findCreditTransactions(fromDate, toDate, user)) == null || transactionList.size() < 1) {
            this.reportPanel.removeAll();
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("PaymentReceivedReportView.0"));
            return;
        }
        JasperReport report = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("payment_receive_report"));
        HashMap properties = new HashMap();
        ReportUtil.populateRestaurantProperties(properties);
        ReportUtil.populateReportTime(properties, fromDate, toDate);
        ReportUtil.populateReportFooter(properties);
        this.populateReportParams(properties);
        PaymentReceivedReportModel reportModel = new PaymentReceivedReportModel();
        reportModel.setRows(transactionList);
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, properties, (JRDataSource)new JRTableModelDataSource((TableModel)reportModel));
        JRViewer viewer = ReportUtil.getCustomJRViewer(print);
        this.reportPanel.removeAll();
        this.reportPanel.add((Component)viewer);
        this.reportPanel.revalidate();
    }

    private void populateReportParams(HashMap properties) {
        properties.put("reportTitle", Messages.getString("PaymentReceivedReportView.2"));
        properties.put("totalMsg", Messages.getString("PaymentReceivedReportView.13"));
        properties.put("totalAmount", Messages.getString("PaymentReceivedReportView.15") + CurrencyUtil.getCurrencySymbolWithBracket());
        properties.put("colUser", POSConstants.USER);
        properties.put("colTime", POSConstants.TIME);
        properties.put("colTrans", Messages.getString("TransCount"));
        properties.put("colPType", Messages.getString("SettleTicketDialog.9"));
        properties.put("colTicket", Messages.getString("TicketCount"));
    }

    private void createUI() {
        this.fromDatePicker = UiUtil.getCurrentMonthStart();
        this.toDatePicker = UiUtil.getDeafultDate();
        this.toDatePicker.setDate(new Date());
        this.btnGo = new JButton();
        this.btnGo.setText(POSConstants.GO);
        this.btnGo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PaymentReceivedReportView.this.viewReport();
                }
                catch (Exception e1) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, e1);
                }
            }
        });
        this.jcbEmployee = new JComboBox();
        UserDAO dao = new UserDAO();
        List<User> userTypes = dao.findActiveUsersForPayroll();
        Vector<Object> list = new Vector<Object>();
        list.add(POSConstants.ALL);
        list.addAll(userTypes);
        this.jcbEmployee.setModel(new DefaultComboBoxModel(list));
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel((LayoutManager)new MigLayout());
        topPanel.add(new JLabel(POSConstants.EMPLOYEE + ":"));
        topPanel.add(this.jcbEmployee);
        topPanel.add(new JLabel(POSConstants.START_DATE + ":"));
        this.fromDatePicker.setFormats(new String[]{"dd MMM yy"});
        topPanel.add((Component)this.fromDatePicker);
        topPanel.add(new JLabel(POSConstants.END_DATE + ":"));
        this.toDatePicker.setFormats(new String[]{"dd MMM yy"});
        topPanel.add((Component)this.toDatePicker);
        topPanel.add((Component)this.btnGo, "width 60!");
        this.add((Component)topPanel, "North");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBorder(new EmptyBorder(0, 10, 10, 10));
        centerPanel.add((Component)new JSeparator(), "North");
        this.reportPanel = new JPanel(new BorderLayout());
        centerPanel.add(this.reportPanel);
        this.add(centerPanel);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

