/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.floreantpos.model.util.DateUtil;
import java.util.Date;
import java.util.List;
import net.sf.jasperreports.view.JRViewer;

public abstract class Report {
    public static final int REPORT_TYPE_1 = 0;
    public static final int REPORT_TYPE_2 = 1;
    private Date fromDate;
    private Date toDate;
    private Terminal terminal;
    private UserType userType;
    private OrderType orderType;
    private int reportType = 0;
    private boolean includeFreeItem = false;
    private boolean isShowInGroups = false;
    private boolean isConsolidate = false;
    protected JRViewer viewer;
    private MenuGroup menuGroup;
    private List<InventoryLocation> inventoryLocations;
    private List<MenuCategory> menuCategories;
    private List<MenuGroup> menuGroups;
    private List<Terminal> terminals;
    private List<OrderType> orderTypes;
    private List<User> users;

    public abstract void refresh() throws Exception;

    public abstract boolean isDateRangeSupported();

    public abstract boolean isTypeSupported();

    public JRViewer getViewer() {
        return this.viewer;
    }

    public Date getEndDate() {
        if (this.toDate == null) {
            return DateUtil.endOfDay(new Date());
        }
        return this.toDate;
    }

    public void setEndDate(Date toDate) {
        this.toDate = toDate;
    }

    public int getReportType() {
        return this.reportType;
    }

    public void setReportType(int reportType) {
        this.reportType = reportType;
    }

    public boolean isIncludedFreeItems() {
        return this.includeFreeItem;
    }

    public void setIncludeFreeItems(boolean includeFreeItem) {
        this.includeFreeItem = includeFreeItem;
    }

    public boolean isShowInGroups() {
        return this.isShowInGroups;
    }

    public void setShowInGroups(boolean isShowInGroups) {
        this.isShowInGroups = isShowInGroups;
    }

    public Terminal getTerminal() {
        return this.terminal;
    }

    public void setTerminal(Terminal terminal) {
        this.terminal = terminal;
    }

    public UserType getUserType() {
        return this.userType;
    }

    public void setUserType(UserType userType) {
        this.userType = userType;
    }

    public OrderType getOrderType() {
        return this.orderType;
    }

    public void setOrderType(OrderType orderType) {
        this.orderType = orderType;
    }

    public Date getStartDate() {
        if (this.fromDate == null) {
            return DateUtil.startOfDay(new Date());
        }
        return this.fromDate;
    }

    public void setStartDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public MenuGroup getMenuGroup() {
        return this.menuGroup;
    }

    public void setMenuGroup(MenuGroup menuGroup) {
        this.menuGroup = menuGroup;
    }

    public List<InventoryLocation> getInventoryLocations() {
        return this.inventoryLocations;
    }

    public void setInventoryLocations(List<InventoryLocation> inventoryLocations) {
        this.inventoryLocations = inventoryLocations;
    }

    public List<MenuCategory> getMenuCategories() {
        return this.menuCategories;
    }

    public void setMenuCategories(List<MenuCategory> menuCategories) {
        this.menuCategories = menuCategories;
    }

    public List<MenuGroup> getMenuGroups() {
        return this.menuGroups;
    }

    public void setMenuGroups(List<MenuGroup> menuGroups) {
        this.menuGroups = menuGroups;
    }

    public List<Terminal> getTerminals() {
        return this.terminals;
    }

    public void setTerminals(List<Terminal> terminals) {
        this.terminals = terminals;
    }

    public List<User> getUsers() {
        return this.users;
    }

    public void setUsers(List<User> users) {
        this.users = users;
    }

    public List<OrderType> getOrderTypes() {
        return this.orderTypes;
    }

    public void setOrderTypes(List<OrderType> orderTypes) {
        this.orderTypes = orderTypes;
    }

    public boolean isConsolidate() {
        return this.isConsolidate;
    }

    public void setConsolidate(boolean isConsolidate) {
        this.isConsolidate = isConsolidate;
    }
}

