/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.SalesDetailedReport;
import com.floreantpos.services.report.ReportService;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.swingx.JXDatePicker;

public class SalesDetailReportView
extends JPanel {
    private JXDatePicker fromDatePicker = UiUtil.getCurrentMonthStart();
    private JXDatePicker toDatePicker = UiUtil.getCurrentMonthEnd();
    private JButton btnGo = new JButton(POSConstants.GO);
    private JPanel reportContainer;

    public SalesDetailReportView() {
        super(new BorderLayout());
        JPanel topPanel = new JPanel((LayoutManager)new MigLayout());
        topPanel.add((Component)new JLabel(POSConstants.FROM + ":"), "grow");
        topPanel.add((Component)this.fromDatePicker);
        topPanel.add((Component)new JLabel(POSConstants.TO + ":"), "grow");
        topPanel.add((Component)this.toDatePicker);
        topPanel.add((Component)this.btnGo, "skip 1, al right");
        this.add((Component)topPanel, "North");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBorder(new EmptyBorder(0, 10, 10, 10));
        centerPanel.add((Component)new JSeparator(), "North");
        this.reportContainer = new JPanel(new BorderLayout());
        centerPanel.add(this.reportContainer);
        this.add(centerPanel);
        this.btnGo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    SalesDetailReportView.this.viewReport();
                }
                catch (Exception e1) {
                    POSMessageDialog.showError(SalesDetailReportView.this, POSConstants.ERROR_MESSAGE, e1);
                }
            }
        });
    }

    private void viewReport() throws Exception {
        Date toDate;
        Date fromDate = this.fromDatePicker.getDate();
        if (fromDate.after(toDate = this.toDatePicker.getDate())) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            return;
        }
        fromDate = DateUtil.startOfDay(fromDate);
        toDate = DateUtil.endOfDay(toDate);
        ReportService reportService = new ReportService();
        SalesDetailedReport report = reportService.getSalesDetailedReport(fromDate, toDate);
        JasperReport drawerPullReport = ReportUtil.getReport("sales_summary_balance_detailed__1");
        JasperReport creditCardReport = ReportUtil.getReport("sales_summary_balance_detailed_2");
        HashMap<String, Number> map = new HashMap<String, Number>();
        ReportUtil.populateRestaurantProperties(map, true);
        ReportUtil.populateReportHeader(map, null, fromDate, toDate, null);
        ReportUtil.populateReportFooter(map);
        this.populateReportParams(map);
        map.put("giftCertReturnCount", report.getGiftCertReturnCount());
        map.put("giftCertReturnAmount", report.getGiftCertReturnAmount());
        map.put("giftCertChangeCount", report.getGiftCertChangeCount());
        map.put("giftCertChangeAmount", report.getGiftCertChangeAmount());
        map.put("tipsCount", report.getTipsCount());
        map.put("tipsAmount", report.getChargedTips());
        map.put("tipsPaidAmount", report.getTipsPaid());
        map.put("drawerPullReport", (Number)drawerPullReport);
        map.put("drawerPullDatasource", (Number)new JRTableModelDataSource((TableModel)report.getDrawerPullDataTableModel()));
        map.put("creditCardReport", (Number)creditCardReport);
        map.put("creditCardReportDatasource", (Number)new JRTableModelDataSource((TableModel)report.getCreditCardDataTableModel()));
        JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("sales_detail_report"));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, map, (JRDataSource)new JREmptyDataSource());
        JRViewer viewer = ReportUtil.getCustomJRViewer(jasperPrint);
        this.reportContainer.removeAll();
        this.reportContainer.add((Component)viewer);
        this.reportContainer.revalidate();
    }

    private void populateReportParams(HashMap map) {
        map.put("SDRTitle", Messages.getString("PosMessage.237"));
        map.put("MRGCR", Messages.getString("MRGCR"));
        map.put("MRGCC", Messages.getString("MRGCC"));
        map.put("MRTCT", Messages.getString("MRTCT"));
        map.put("MRTP", Messages.getString("DrawerPullReportExplorer.26"));
        map.put("MRCount", Messages.getString("MRCount"));
        map.put("MRAmount", Messages.getString("MRAmount"));
        map.put("SRDPRTitle", Messages.getString("SRDPRTitle"));
        map.put("SRDPRCount", POSConstants.COUNT);
        map.put("SRDPRIdeal", Messages.getString("SRDPRIdeal"));
        map.put("SRDPRActual", Messages.getString("SRDPRActual"));
        map.put("SRDPRVariant", Messages.getString("MenuItemForm.112"));
        map.put("SRDPRTDP", Messages.getString("SRDPRTDP"));
        map.put("SRCCard", Messages.getString("PaymentTypeSelectionDialog.4"));
        map.put("SRSCount", Messages.getString("SalesCount"));
        map.put("SRSAmount", Messages.getString("SalesAmount"));
        map.put("SRRCount", Messages.getString("SRRCount"));
        map.put("SRRAmount", Messages.getString("SRRAmount"));
        map.put("SRNAmount", Messages.getString("SRNAmount"));
        map.put("SRNTips", Messages.getString("SRNTips"));
        map.put("SRTotal", POSConstants.TOTAL);
    }
}

