/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.SalesExceptionReport;
import com.floreantpos.services.report.ReportService;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.swingx.JXDatePicker;

public class SalesExceptionReportView
extends JPanel {
    private JXDatePicker fromDatePicker = UiUtil.getCurrentMonthStart();
    private JXDatePicker toDatePicker = UiUtil.getCurrentMonthEnd();
    private JButton btnGo = new JButton(POSConstants.GO);
    private JPanel reportContainer;

    public SalesExceptionReportView() {
        super(new BorderLayout());
        JPanel topPanel = new JPanel((LayoutManager)new MigLayout());
        topPanel.add((Component)new JLabel(POSConstants.FROM + ":"), "grow");
        topPanel.add((Component)this.fromDatePicker);
        topPanel.add((Component)new JLabel(POSConstants.TO + ":"), "grow");
        topPanel.add((Component)this.toDatePicker);
        topPanel.add((Component)this.btnGo, "skip 1, al right");
        this.add((Component)topPanel, "North");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBorder(new EmptyBorder(0, 10, 10, 10));
        centerPanel.add((Component)new JSeparator(), "North");
        this.reportContainer = new JPanel(new BorderLayout());
        centerPanel.add(this.reportContainer);
        this.add(centerPanel);
        this.btnGo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    SalesExceptionReportView.this.viewReport();
                }
                catch (Exception e1) {
                    POSMessageDialog.showError(SalesExceptionReportView.this, POSConstants.ERROR_MESSAGE, e1);
                }
            }
        });
    }

    private void viewReport() throws Exception {
        Date toDate;
        Date fromDate = this.fromDatePicker.getDate();
        if (fromDate.after(toDate = this.toDatePicker.getDate())) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            return;
        }
        fromDate = DateUtil.startOfDay(fromDate);
        toDate = DateUtil.endOfDay(toDate);
        ReportService reportService = new ReportService();
        SalesExceptionReport report = reportService.getSalesExceptionReport(fromDate, toDate);
        JasperReport voidReport = ReportUtil.getReport("sales_summary_exception_voids");
        JasperReport refundReport = ReportUtil.getReport("sales_summary_exception_refund_trns");
        JasperReport discountReport = ReportUtil.getReport("sales_summary_exception_discounts");
        HashMap<String, Object> map = new HashMap<String, Object>();
        ReportUtil.populateRestaurantProperties(map, true);
        ReportUtil.populateReportHeader(map, null, fromDate, toDate, null);
        ReportUtil.populateReportFooter(map);
        this.populateReportParams(map);
        map.put("voidReport", voidReport);
        map.put("voidReportDataSource", new JRTableModelDataSource((TableModel)report.getVoidTableModel()));
        map.put("refundReport", refundReport);
        map.put("refundReportDataSource", new JRTableModelDataSource((TableModel)report.getRefundTableModel()));
        map.put("discountReport", discountReport);
        map.put("discountReportDataSource", new JRTableModelDataSource((TableModel)report.getDiscountTableModel()));
        JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("sales_exception_report"));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, map, (JRDataSource)new JREmptyDataSource());
        JRViewer viewer = ReportUtil.getCustomJRViewer(jasperPrint);
        this.reportContainer.removeAll();
        this.reportContainer.add((Component)viewer);
        this.reportContainer.revalidate();
    }

    private void populateReportParams(HashMap map) {
        map.put("SERTitle", Messages.getString("SERTitle"));
        map.put("VSRTitle", Messages.getString("VSRTitle"));
        map.put("VSRCode", Messages.getString("VSRCode"));
        map.put("VSRReason", Messages.getString("VSRReason"));
        map.put("VSRWasted", Messages.getString("VSRWasted"));
        map.put("VSRQTY", POSConstants.QTY);
        map.put("VSRAmount", POSConstants.AMOUNT);
        map.put("VSRTVW", Messages.getString("VSRTVW"));
        map.put("VSRTVoids", Messages.getString("VSRTVoids"));
        map.put("TSRTitle", Messages.getString("TSRTitle"));
        map.put("TSRTime", POSConstants.TIME);
        map.put("TSRTID", POSConstants.TICKET_ID);
        map.put("TSRTRNID", Messages.getString("SessionBasedTransactionBrowser.10"));
        map.put("TSRPType", Messages.getString("SettleTicketDialog.9"));
        map.put("TSRAmount", POSConstants.AMOUNT);
        map.put("TSRTRefund", Messages.getString("ReceiptPrintService.1"));
        map.put("DSRTitle", Messages.getString("DSRTitle"));
        map.put("DSRName", POSConstants.NAME);
        map.put("DSRTCount", Messages.getString("DSRTCount"));
        map.put("DSRTDiscount", Messages.getString("DSRTDiscount"));
        map.put("DSRTNSales", Messages.getString("DSRTNSales"));
        map.put("DSRPSize", Messages.getString("DSRPSize"));
        map.put("DSRCSize", Messages.getString("DSRCSize"));
        map.put("DSRTD", Messages.getString("DSRTD"));
    }
}

