/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.dao.UserTypeDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.ServerProductivityReport;
import com.floreantpos.services.report.ReportService;
import com.floreantpos.swing.MultiSelectComboBox;
import com.floreantpos.swing.OverflowCombobox;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.swingx.JXDatePicker;

public class ServerProductivityReportView
extends JPanel {
    private JXDatePicker fromDatePicker = UiUtil.getCurrentMonthStart();
    private JXDatePicker toDatePicker = UiUtil.getCurrentMonthEnd();
    private JButton btnGo = new JButton(POSConstants.GO);
    private JPanel reportContainer;
    private MultiSelectComboBox<User> cbMultiUser;
    private OverflowCombobox cbEmployeeType;

    public ServerProductivityReportView() {
        super(new BorderLayout());
        JPanel topPanel = new JPanel((LayoutManager)new MigLayout());
        this.cbMultiUser = new MultiSelectComboBox();
        this.cbMultiUser.setItems(UserDAO.getInstance().findAllActive());
        this.cbEmployeeType = new OverflowCombobox();
        List<UserType> userTypes = UserTypeDAO.getInstance().findAll();
        Vector<Object> userTypesList = new Vector<Object>();
        userTypesList.add(POSConstants.ALL);
        userTypesList.addAll(userTypes);
        this.cbEmployeeType.setModel(new DefaultComboBoxModel(userTypesList));
        topPanel.add((Component)new JLabel(POSConstants.FROM + ":"), "grow");
        topPanel.add((Component)this.fromDatePicker);
        topPanel.add((Component)new JLabel(POSConstants.TO + ":"), "grow");
        topPanel.add((Component)this.toDatePicker);
        topPanel.add(new JLabel(POSConstants.EMPLOYEE + ":"));
        topPanel.add(this.cbMultiUser);
        topPanel.add(new JLabel(Messages.getString("ROLE") + ":"));
        topPanel.add((Component)this.cbEmployeeType, "width 120!");
        topPanel.add((Component)this.btnGo, "skip 1, al right");
        this.add((Component)topPanel, "North");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBorder(new EmptyBorder(0, 10, 10, 10));
        centerPanel.add((Component)new JSeparator(), "North");
        this.reportContainer = new JPanel(new BorderLayout());
        centerPanel.add(this.reportContainer);
        this.add(centerPanel);
        this.btnGo.addActionListener(e -> {
            try {
                this.viewReport();
            }
            catch (Exception e1) {
                POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, e1);
            }
        });
    }

    private void viewReport() throws Exception {
        Date fromDate = this.fromDatePicker.getDate();
        Date toDate = this.toDatePicker.getDate();
        Object selectedItem = this.cbEmployeeType.getSelectedItem();
        UserType userType = null;
        if (selectedItem instanceof UserType) {
            userType = (UserType)selectedItem;
        }
        HashSet<String> allUserIds = new HashSet<String>();
        List<User> users = this.cbMultiUser.getSelectedItems();
        if (users != null && users.size() > 0) {
            for (User user : users) {
                if (user.isRoot().booleanValue()) {
                    allUserIds.addAll(user.getRoleIds());
                    continue;
                }
                allUserIds.add(user.getId());
            }
        }
        if (fromDate.after(toDate)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            return;
        }
        fromDate = DateUtil.startOfDay(fromDate);
        toDate = DateUtil.startOfNextDay(toDate);
        ReportService reportService = new ReportService();
        ServerProductivityReport report = reportService.getServerProductivityReport(fromDate, toDate, new ArrayList<String>(allUserIds), userType);
        HashMap<String, Object> map = new HashMap<String, Object>();
        ReportUtil.populateRestaurantProperties(map, true);
        ReportUtil.populateReportTime(map, fromDate, toDate);
        ReportUtil.populateReportFooter(map);
        this.populateReportParams(map);
        JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("server_productivity_report"));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, map, (JRDataSource)new JRTableModelDataSource((TableModel)report.getTableModel()));
        JRViewer viewer = ReportUtil.getCustomJRViewer(jasperPrint);
        this.reportContainer.removeAll();
        this.reportContainer.add((Component)viewer);
        this.reportContainer.revalidate();
    }

    private void populateReportParams(HashMap<String, Object> map) {
        map.put("reportTitle", Messages.getString("ServerProductivityReportView.0"));
        map.put("colServer", POSConstants.SERVER);
        map.put("colCategory", POSConstants.CATEGORY);
        map.put("colTCCount", Messages.getString("TCHKCount"));
        map.put("colTGuest", Messages.getString("TotalGuest"));
        map.put("colGross", Messages.getString("HourlySalesReportView.7"));
        map.put("colTSales", Messages.getString("TotalSales"));
        map.put("colDiscount", POSConstants.DISCOUNT);
        map.put("colAVGCheck", Messages.getString("AVGCHK"));
        map.put("colNet", Messages.getString("NET_SALES"));
        map.put("colAVGGuest", Messages.getString("AverageGuest"));
        map.put("colAVGNet", Messages.getString("AVGNet"));
        map.put("colAlloc", Messages.getString("Alloc"));
    }
}

