/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.POSConstants;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.TaxExemptReport;
import com.floreantpos.services.report.ReportService;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.swingx.JXDatePicker;

public class TaxExemptReportView
extends JPanel {
    private JXDatePicker fromDatePicker = UiUtil.getCurrentMonthStart();
    private JXDatePicker toDatePicker = UiUtil.getCurrentMonthEnd();
    private JButton btnGo = new JButton(POSConstants.GO);
    private JPanel reportContainer;

    public TaxExemptReportView() {
        super(new BorderLayout());
        this.initComponents();
    }

    private void initComponents() {
        JPanel topPanel = new JPanel((LayoutManager)new MigLayout());
        this.reportContainer = new JPanel(new BorderLayout());
        this.btnGo.addActionListener(e -> this.viewReport());
        topPanel.add((Component)new JLabel(POSConstants.FROM + ":"), "grow");
        topPanel.add((Component)this.fromDatePicker);
        topPanel.add((Component)new JLabel(POSConstants.TO + ":"), "grow");
        topPanel.add((Component)this.toDatePicker);
        topPanel.add((Component)this.btnGo, "skip 1, al right");
        this.add((Component)topPanel, "North");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBorder(new EmptyBorder(0, 10, 10, 10));
        centerPanel.add((Component)new JSeparator(), "North");
        centerPanel.add(this.reportContainer);
        this.add(centerPanel);
    }

    private void viewReport() {
        try {
            Date fromDate = this.fromDatePicker.getDate();
            Date toDate = this.toDatePicker.getDate();
            if (fromDate.after(toDate)) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
                return;
            }
            fromDate = DateUtil.startOfDay(fromDate);
            toDate = DateUtil.endOfDay(toDate);
            ReportService reportService = new ReportService();
            TaxExemptReport report = reportService.getTaxExemptReport(fromDate, toDate);
            HashMap map = new HashMap();
            ReportUtil.populateRestaurantProperties(map, true);
            ReportUtil.populateReportHeader(map, null, fromDate, toDate, null);
            ReportUtil.populateReportFooter(map);
            this.populateReportParams(map);
            JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("tax_exempt_report"));
            JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, map, (JRDataSource)new JRTableModelDataSource((TableModel)report.getTaxExemptTableModel()));
            JRViewer viewer = ReportUtil.getCustomJRViewer(jasperPrint);
            this.reportContainer.removeAll();
            this.reportContainer.add((Component)viewer);
            this.reportContainer.revalidate();
        }
        catch (JRException e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage());
        }
    }

    private void populateReportParams(HashMap map) {
        map.put("reportTitle", POSConstants.TAX_EXEMPT_REPORT);
        map.put("colTicketId", POSConstants.TICKET_ID);
        map.put("colCustomerName", POSConstants.CUSTOMER);
        map.put("colTotalAmount", POSConstants.TOTAL_AMOUNT);
        map.put("colCreateDate", POSConstants.CREATED);
        map.put("colTaxAmount", POSConstants.TAX_EXEMPT);
    }
}

