/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.DeletedItem;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class VoidItemReportModel
extends AbstractTableModel {
    private String[] columnNames = new String[]{"date", "order", "qty", "itemName", "amount", "voidReason", "itemWasted", "employee", "deletedBy", "terminalName", "orderType", "createDate"};
    private List<DeletedItem> items;

    @Override
    public int getRowCount() {
        if (this.items == null) {
            return 0;
        }
        return this.items.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        DeletedItem item = this.items.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return DateUtil.formatSmall(item.getVoidDate());
            }
            case 1: {
                return item.getTicketId();
            }
            case 2: {
                return item.getQuantity();
            }
            case 3: {
                return item.getName();
            }
            case 4: {
                return item.getTotal();
            }
            case 5: {
                return item.getVoidReason();
            }
            case 6: {
                return item.getItemWasted();
            }
            case 7: {
                if (item.getOwner() != null) {
                    return item.getOwner().getFullName();
                }
                return "";
            }
            case 8: {
                return item.getVoidUserName();
            }
            case 9: {
                return item.getTerminalName();
            }
            case 10: {
                return item.getOrderTypeName();
            }
            case 11: {
                return DateUtil.formatSmall(item.getCreateDate());
            }
        }
        return null;
    }

    public List<DeletedItem> getItems() {
        return this.items;
    }

    public void setItems(List<DeletedItem> items) {
        this.items = items;
    }
}

