/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report.model;

import com.floreantpos.Messages;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.DeliverySummaryReportData;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.util.NumberUtil;

public class DeliverySummaryReportModel
extends ListTableModel {
    public DeliverySummaryReportModel() {
        super(new String[]{"empName", "customerName", "ticketId", "ticketAmt", "serviceCharge", "tips", "tax", "total", "memberCharge", "creditCard", "cashPymt", "othersPayment", "discount", "createdDate", "deliveryDate"});
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        DeliverySummaryReportData data = (DeliverySummaryReportData)this.rows.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return data.getEmployeeId() + " - " + data.getEmployeeName();
            }
            case 1: {
                String customerName = data.getCustomerName();
                String memberId = data.getMemberId() == null ? "" : data.getMemberId() + " - ";
                return customerName == null ? Messages.getString("GUEST") : memberId + customerName;
            }
            case 2: {
                return data.getTicketId();
            }
            case 3: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(data.getNetAmount());
            }
            case 4: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(data.getServiceCharge());
            }
            case 5: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(data.getGratuityAmount());
            }
            case 6: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(data.getTaxAmount());
            }
            case 7: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(data.getTotalAmount() + data.getGratuityAmount());
            }
            case 8: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(data.getMemberCharge());
            }
            case 9: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(data.getCreditCardPayment());
            }
            case 10: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(data.getCashPayment());
            }
            case 11: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(data.getOthersPayment());
            }
            case 12: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(data.getDiscount());
            }
            case 13: {
                return DateUtil.tweentyFourHoursDateFormat(data.getCreatedDate());
            }
            case 14: {
                return DateUtil.tweentyFourHoursDateFormat(data.getDeliveryDate());
            }
        }
        return null;
    }
}

