/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report.model;

import com.floreantpos.Messages;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.EndOfDayReportData;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.util.NumberUtil;
import org.apache.commons.lang.StringUtils;

public class EndOfDaySummaryReportModel
extends ListTableModel {
    public EndOfDaySummaryReportModel() {
        super(new String[]{"empName", "customerName", "ticketId", "ticketAmt", "serviceCharge", "tips", "tax", "total", "memberCharge", "creditCard", "cashPymt", "othersPayment", "discount", "refund", "guestCount", "date", "employeeRole", "employeeId"});
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        EndOfDayReportData data = (EndOfDayReportData)this.rows.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return data.getEmployeeName();
            }
            case 1: {
                String customerName = data.getCustomerName();
                String memberId = StringUtils.isEmpty((String)data.getMemberId()) ? "" : " (" + data.getMemberId() + ")";
                return StringUtils.isEmpty((String)customerName) ? Messages.getString("GUEST") : customerName + memberId;
            }
            case 2: {
                return data.getTicketId();
            }
            case 3: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(data.getNetAmount());
            }
            case 4: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(data.getServiceCharge());
            }
            case 5: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(data.getGratuityAmount());
            }
            case 6: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(data.getTaxAmount());
            }
            case 7: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(data.getTotalTicketAmount() + data.getGratuityAmount());
            }
            case 8: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(data.getMemberCharge());
            }
            case 9: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(data.getCreditCardPayment());
            }
            case 10: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(data.getCashPayment());
            }
            case 11: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(data.getOthersPayment());
            }
            case 12: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(data.getDiscount());
            }
            case 13: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(data.getRefundPaymentCredit());
            }
            case 14: {
                return data.getGuestCount();
            }
            case 15: {
                return DateUtil.formatReportDateAsString(data.getTicketCreateDate());
            }
            case 16: {
                return data.getEmployeeRole();
            }
            case 17: {
                return data.getEmployeeId();
            }
        }
        return null;
    }
}

