/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.services.report;

import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.model.ActionHistory;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CashTransaction;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.CustomPaymentTransaction;
import com.floreantpos.model.CustomerAccountTransaction;
import com.floreantpos.model.DebitCardTransaction;
import com.floreantpos.model.Discount;
import com.floreantpos.model.GiftCertificateTransaction;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.PayOutTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.DiscountDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.TicketItemDAO;
import com.floreantpos.model.ext.CardTypeEnum;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.DiscountData;
import com.floreantpos.report.DiscountReportDataModel;
import com.floreantpos.report.JournalReportModel;
import com.floreantpos.report.MenuUsageReport;
import com.floreantpos.report.ReportItem;
import com.floreantpos.report.SalesBalanceReport;
import com.floreantpos.report.SalesDetailedReport;
import com.floreantpos.report.SalesExceptionReport;
import com.floreantpos.report.SalesReportModel;
import com.floreantpos.report.ServerProductivityReport;
import com.floreantpos.report.TaxExemptReport;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;

public class ReportService {
    private static SimpleDateFormat fullDateFormatter = new SimpleDateFormat("MMM dd yyyy, hh:mm a");
    private static SimpleDateFormat shortDateFormatter = new SimpleDateFormat("MMM dd yyyy ");

    public static String formatFullDate(Date date) {
        return fullDateFormatter.format(date);
    }

    public static String formatShortDate(Date date) {
        return shortDateFormatter.format(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuUsageReport getMenuUsageReport(Date fromDate, Date toDate) {
        GenericDAO dao = new GenericDAO();
        MenuUsageReport report = new MenuUsageReport();
        try (Session session = null;){
            session = dao.getSession();
            Criteria criteria = session.createCriteria(MenuCategory.class);
            List categories = criteria.list();
            MenuCategory miscCategory = new MenuCategory();
            miscCategory.setName(POSConstants.MISC_BUTTON_TEXT);
            categories.add(miscCategory);
            for (MenuCategory category : categories) {
                criteria = session.createCriteria(TicketItem.class, "item");
                criteria.createCriteria("ticket", "t");
                ProjectionList projectionList = Projections.projectionList();
                projectionList.add((Projection)Projections.sum((String)TicketItem.PROP_QUANTITY));
                projectionList.add((Projection)Projections.sum((String)TicketItem.PROP_SUBTOTAL_AMOUNT));
                projectionList.add((Projection)Projections.sum((String)TicketItem.PROP_DISCOUNT_AMOUNT));
                criteria.setProjection((Projection)projectionList);
                criteria.add((Criterion)Restrictions.eq((String)("item." + TicketItem.PROP_CATEGORY_ID), (Object)category.getId()));
                criteria.add((Criterion)Restrictions.ge((String)("t." + Ticket.PROP_CREATE_DATE), (Object)fromDate));
                criteria.add((Criterion)Restrictions.le((String)("t." + Ticket.PROP_CREATE_DATE), (Object)toDate));
                criteria.add((Criterion)Restrictions.eq((String)("t." + Ticket.PROP_PAID), (Object)Boolean.TRUE));
                List datas = criteria.list();
                if (datas.size() <= 0) continue;
                Object[] objects = (Object[])datas.get(0);
                MenuUsageReport.MenuUsageReportData data = new MenuUsageReport.MenuUsageReportData();
                data.setCategoryName(category.getName());
                if (objects.length > 0 && objects[0] != null) {
                    data.setCount(((Number)objects[0]).intValue());
                }
                if (objects.length > 1 && objects[1] != null) {
                    data.setGrossSales(((Number)objects[1]).doubleValue());
                }
                if (objects.length > 2 && objects[2] != null) {
                    data.setDiscount(((Number)objects[2]).doubleValue());
                }
                data.calculate();
                report.addReportData(data);
            }
            MenuUsageReport menuUsageReport = report;
            return menuUsageReport;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerProductivityReport getServerProductivityReport(Date fromDate, Date toDate, List<String> userIdList, UserType userType) {
        GenericDAO dao = new GenericDAO();
        ServerProductivityReport report = new ServerProductivityReport();
        try (Session session = null;){
            session = dao.getSession();
            Criteria criteria = session.createCriteria(User.class);
            if (userIdList != null && !userIdList.isEmpty()) {
                criteria.add(Restrictions.in((String)User.PROP_ID, userIdList));
            }
            if (userType != null) {
                criteria.add((Criterion)Restrictions.eq((String)User.PROP_USER_TYPE_ID, (Object)userType.getId()));
            }
            List servers = criteria.list();
            criteria = session.createCriteria(MenuCategory.class);
            List categories = criteria.list();
            MenuCategory miscCategory = new MenuCategory();
            miscCategory.setName(POSConstants.MISC_BUTTON_TEXT);
            categories.add(miscCategory);
            for (User server : servers) {
                ServerProductivityReport.ServerProductivityReportData data = new ServerProductivityReport.ServerProductivityReportData();
                String serverName = server.toString();
                if (server.getType() != null) {
                    serverName = serverName + ", Role: " + server.getType().getName();
                }
                data.setServerName(serverName);
                criteria = session.createCriteria(Ticket.class);
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_ID, (Object)server.getId()));
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)Boolean.FALSE));
                criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)fromDate));
                criteria.add((Criterion)Restrictions.lt((String)Ticket.PROP_CREATE_DATE, (Object)toDate));
                ProjectionList projectionList = Projections.projectionList();
                projectionList.add(Projections.rowCount());
                projectionList.add((Projection)Projections.sum((String)Ticket.PROP_NUMBER_OF_GUESTS));
                projectionList.add((Projection)Projections.sum((String)Ticket.PROP_TOTAL_AMOUNT));
                criteria.setProjection((Projection)projectionList);
                Object[] o = (Object[])criteria.uniqueResult();
                int totalCheckCount = 0;
                double totalServerSale = 0.0;
                if (o != null) {
                    int i;
                    if (o.length > 0 && o[0] != null) {
                        totalCheckCount = i = ((Number)o[0]).intValue();
                        data.setTotalCheckCount(totalCheckCount);
                    }
                    if (o.length > 1 && o[1] != null) {
                        i = ((Number)o[1]).intValue();
                        data.setTotalGuestCount(i);
                    }
                    if (o.length > 2 && o[2] != null) {
                        totalServerSale = ((Number)o[2]).doubleValue();
                        data.setTotalSales(totalServerSale);
                    }
                    if (data.getTotalSales() != 0.0 && totalServerSale != 0.0) {
                        data.setTotalAllocation(data.getTotalSales() / totalServerSale * 100.0);
                    }
                }
                data.calculate();
                report.addReportData(data);
                for (MenuCategory category : categories) {
                    Object[] objects;
                    data = new ServerProductivityReport.ServerProductivityReportData();
                    data.setServerName(serverName);
                    criteria = session.createCriteria(TicketItem.class, "item");
                    criteria.createCriteria(TicketItem.PROP_TICKET, "t");
                    projectionList = Projections.projectionList();
                    criteria.setProjection((Projection)projectionList);
                    projectionList.add((Projection)Projections.sum((String)TicketItem.PROP_QUANTITY));
                    projectionList.add((Projection)Projections.sum((String)TicketItem.PROP_TOTAL_AMOUNT));
                    projectionList.add((Projection)Projections.sum((String)("t." + Ticket.PROP_DISCOUNT_AMOUNT)));
                    projectionList.add(Projections.rowCount());
                    criteria.add((Criterion)Restrictions.eq((String)("item." + TicketItem.PROP_CATEGORY_NAME), (Object)category.getName()));
                    criteria.add((Criterion)Restrictions.ge((String)("t." + Ticket.PROP_CREATE_DATE), (Object)fromDate));
                    criteria.add((Criterion)Restrictions.lt((String)("t." + Ticket.PROP_CREATE_DATE), (Object)toDate));
                    criteria.add((Criterion)Restrictions.eq((String)("t." + Ticket.PROP_OWNER_ID), (Object)(server == null ? null : server.getId())));
                    List datas = criteria.list();
                    if (datas.size() <= 0 || (objects = (Object[])datas.get(0))[0] == null) continue;
                    data.setCategoryName(category.getName());
                    data.setTotalCheckCount(totalCheckCount);
                    if (objects.length > 0 && objects[0] != null) {
                        int i = ((Number)objects[0]).intValue();
                        data.setCheckCount(i);
                    }
                    if (objects.length > 1 && objects[1] != null) {
                        double d = ((Number)objects[1]).doubleValue();
                        data.setGrossSales(d);
                    }
                    if (objects.length > 2 && objects[2] != null) {
                        double d = ((Number)objects[2]).doubleValue();
                        data.setSalesDiscount(d);
                    }
                    if (data.getGrossSales() != 0.0 && totalServerSale != 0.0) {
                        data.setAllocation(data.getGrossSales() / totalServerSale * 100.0);
                    } else {
                        data.setAllocation(0.0);
                    }
                    data.calculate();
                    report.addReportData(data);
                }
            }
            ServerProductivityReport serverProductivityReport = report;
            return serverProductivityReport;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JournalReportModel getJournalReport(Date fromDate, Date toDate) {
        GenericDAO dao = new GenericDAO();
        JournalReportModel report = new JournalReportModel();
        Session session = null;
        report.setFromDate(fromDate);
        report.setToDate(toDate);
        report.setReportTime(new Date());
        try {
            session = dao.getSession();
            Criteria criteria = session.createCriteria(ActionHistory.class);
            criteria.add((Criterion)Restrictions.ge((String)ActionHistory.PROP_ACTION_TIME, (Object)fromDate));
            criteria.add((Criterion)Restrictions.le((String)ActionHistory.PROP_ACTION_TIME, (Object)toDate));
            criteria.addOrder(Order.desc((String)ActionHistory.PROP_ACTION_TIME));
            List list = criteria.list();
            for (ActionHistory history : list) {
                User user = history.getPerformer();
                String userInfo = "";
                if (user != null) {
                    userInfo = user.getId() + "/" + user;
                }
                JournalReportModel.JournalReportData data = new JournalReportModel.JournalReportData();
                data.setAction(history.getActionName());
                data.setUserInfo(userInfo);
                data.setTime(history.getActionTime());
                data.setComments(history.getDescription());
                report.addReportData(data);
            }
            JournalReportModel journalReportModel = report;
            return journalReportModel;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SalesBalanceReport getSalesBalanceReport(Date fromDate, Date toDate, User user) {
        GenericDAO dao = new GenericDAO();
        SalesBalanceReport report = new SalesBalanceReport();
        Session session = null;
        report.setFromDate(fromDate);
        report.setToDate(toDate);
        report.setReportTime(new Date());
        try {
            session = dao.getSession();
            report.setNetSalesAmount(this.getNetSales(session, fromDate, toDate, user));
            report.setGrossTaxableSalesAmount(this.calculateGrossSales(session, fromDate, toDate, user, true));
            report.setGrossNonTaxableSalesAmount(this.calculateGrossSales(session, fromDate, toDate, user, false));
            report.setDiscountAmount(this.calculateDiscount(session, fromDate, toDate, user));
            report.setSalesTaxAmount(this.calculateTax(session, fromDate, toDate, user));
            report.setCashTipsAmount(this.calculateCashTips(session, fromDate, toDate, user));
            report.setChargedTipsAmount(this.calculateChargedTips(session, fromDate, toDate, user));
            report.setCashReceiptsAmount(this.calculateCashReceipt(session, fromDate, toDate, user));
            report.setCreditCardReceiptsAmount(this.calculateCreditReceipt(session, CreditCardTransaction.class, fromDate, toDate, user));
            report.setDebitCardReceiptsAmount(this.calculateDebitReceipt(session, DebitCardTransaction.class, fromDate, toDate, user));
            report.setMemberPaymentAmount(this.calculateMemberPayment(session, CustomerAccountTransaction.class, fromDate, toDate, user));
            report.setCustomPaymentAmount(this.calculateCustomPayment(session, CustomPaymentTransaction.class, fromDate, toDate, user));
            report.setGiftCertReceipts(this.calculateGiftCertReceipts(session, fromDate, toDate, user));
            report.setCashBackAmount(this.calculateRefundAmount(session, RefundTransaction.class, fromDate, toDate, user));
            report.setCashRefundAmount(this.calculateCashRefundAmount(session, RefundTransaction.class, fromDate, toDate, user));
            report.setToleranceAmount(this.calculateToleranceAmount(session, fromDate, toDate, user));
            report.setServiceChargeAmnt(this.calculateServiceChargeAmount(session, fromDate, toDate, user));
            report.setGrossTipsPaidAmount(this.calculateTipsPaid(session, fromDate, toDate, user));
            report.setCashPayoutAmount(this.calculateCashPayout(session, fromDate, toDate, user));
            this.calculateDrawerPullAmount(session, report, fromDate, toDate, user);
            report.setVisaCreditCardAmount(this.calculateVisaCreditCardSummery(session, CreditCardTransaction.class, fromDate, toDate, user));
            report.setMasterCardAmount(this.calculateMasterCardSummery(session, CreditCardTransaction.class, fromDate, toDate, user));
            report.setAmexAmount(this.calculateAmexSummery(session, CreditCardTransaction.class, fromDate, toDate, user));
            report.setDiscoveryAmount(this.calculateDiscoverySummery(session, CreditCardTransaction.class, fromDate, toDate, user));
            report.setVisaDebitCardAmount(this.calculateVisaDebitCardSummery(session, DebitCardTransaction.class, fromDate, toDate, user));
            report.setMasterDebitCardAmount(this.calculateMasterDebitCardSummery(session, DebitCardTransaction.class, fromDate, toDate, user));
            report.calculate();
            SalesBalanceReport salesBalanceReport = report;
            return salesBalanceReport;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    private void calculateDrawerPullAmount(Session session, SalesBalanceReport report, Date fromDate, Date toDate, User user) {
        double amount;
        Criteria criteria = session.createCriteria(CashDrawer.class);
        criteria.add((Criterion)Restrictions.ge((String)CashDrawer.PROP_REPORT_TIME, (Object)fromDate));
        criteria.add((Criterion)Restrictions.le((String)CashDrawer.PROP_REPORT_TIME, (Object)toDate));
        this.addMultiUserFilter(user, criteria, CashDrawer.PROP_ASSIGNED_USER_ID);
        ProjectionList projectionList = Projections.projectionList();
        projectionList.add((Projection)Projections.sum((String)CashDrawer.PROP_DRAWER_ACCOUNTABLE));
        projectionList.add((Projection)Projections.sum((String)CashDrawer.PROP_BEGIN_CASH));
        criteria.setProjection((Projection)projectionList);
        Object[] o = (Object[])criteria.uniqueResult();
        if (o.length > 0 && o[0] instanceof Number) {
            amount = ((Number)o[0]).doubleValue();
            report.setDrawerPullsAmount(amount);
        }
        if (o.length > 1 && o[1] instanceof Number) {
            amount = ((Number)o[1]).doubleValue();
            report.setDrawerPullsAmount(report.getDrawerPullsAmount() - amount);
        }
    }

    private double calculateCashPayout(Session session, Date fromDate, Date toDate, User user) {
        Criteria criteria = session.createCriteria(PayOutTransaction.class);
        criteria.add((Criterion)Restrictions.ge((String)PayOutTransaction.PROP_TRANSACTION_TIME, (Object)fromDate));
        criteria.add((Criterion)Restrictions.le((String)PayOutTransaction.PROP_TRANSACTION_TIME, (Object)toDate));
        this.addMultiUserFilter(user, criteria, PosTransaction.PROP_USER_ID);
        criteria.setProjection((Projection)Projections.sum((String)PayOutTransaction.PROP_AMOUNT));
        return this.getDoubleAmount(criteria.uniqueResult());
    }

    private double calculateTipsPaid(Session session, Date fromDate, Date toDate, User user) {
        Criteria criteria = session.createCriteria(Ticket.class);
        criteria.createAlias(Ticket.PROP_GRATUITY, "gratuity");
        criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)fromDate));
        criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)toDate));
        criteria.add((Criterion)Restrictions.eq((String)("gratuity." + Gratuity.PROP_PAID), (Object)Boolean.TRUE));
        this.addMultiUserFilter(user, criteria, Ticket.PROP_OWNER_ID);
        criteria.setProjection((Projection)Projections.sum((String)("gratuity." + Gratuity.PROP_AMOUNT)));
        return this.getDoubleAmount(criteria.uniqueResult());
    }

    private double calculateCreditReceipt(Session session, Class transactionClass, Date fromDate, Date toDate, User user) {
        Criteria criteria = session.createCriteria(transactionClass);
        criteria.add((Criterion)Restrictions.ge((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)fromDate));
        criteria.add((Criterion)Restrictions.le((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)toDate));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        this.addMultiUserFilter(user, criteria, PosTransaction.PROP_USER_ID);
        criteria.setProjection((Projection)Projections.sum((String)CreditCardTransaction.PROP_AMOUNT));
        return this.getDoubleAmount(criteria.uniqueResult());
    }

    private double calculateRefundAmount(Session session, Class transactionClass, Date fromDate, Date toDate, User user) {
        Criteria criteria = session.createCriteria(transactionClass);
        criteria.add((Criterion)Restrictions.ge((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)fromDate));
        criteria.add((Criterion)Restrictions.le((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)toDate));
        this.addMultiUserFilter(user, criteria, PosTransaction.PROP_USER_ID);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.DEBIT.name()));
        criteria.setProjection((Projection)Projections.sum((String)RefundTransaction.PROP_AMOUNT));
        return this.getDoubleAmount(criteria.uniqueResult());
    }

    private double calculateCashRefundAmount(Session session, Class transactionClass, Date fromDate, Date toDate, User user) {
        Criteria criteria = session.createCriteria(transactionClass);
        criteria.add((Criterion)Restrictions.ge((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)fromDate));
        criteria.add((Criterion)Restrictions.le((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)toDate));
        this.addMultiUserFilter(user, criteria, PosTransaction.PROP_USER_ID);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.CASH.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.DEBIT.name()));
        criteria.setProjection((Projection)Projections.sum((String)RefundTransaction.PROP_AMOUNT));
        return this.getDoubleAmount(criteria.uniqueResult());
    }

    private double calculateServiceChargeAmount(Session session, Date fromDate, Date toDate, User user) {
        Criteria criteria = session.createCriteria(Ticket.class);
        criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)fromDate));
        criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)toDate));
        this.addMultiUserFilter(user, criteria, Ticket.PROP_OWNER_ID);
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.setProjection((Projection)Projections.sum((String)Ticket.PROP_SERVICE_CHARGE));
        return this.getDoubleAmount(criteria.uniqueResult());
    }

    private double calculateDebitReceipt(Session session, Class transactionClass, Date fromDate, Date toDate, User user) {
        Criteria criteria = session.createCriteria(transactionClass);
        criteria.add((Criterion)Restrictions.ge((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)fromDate));
        criteria.add((Criterion)Restrictions.le((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)toDate));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        this.addMultiUserFilter(user, criteria, PosTransaction.PROP_USER_ID);
        criteria.setProjection((Projection)Projections.sum((String)CashTransaction.PROP_AMOUNT));
        return this.getDoubleAmount(criteria.uniqueResult());
    }

    private double calculateCustomPayment(Session session, Class transactionClass, Date fromDate, Date toDate, User user) {
        Criteria criteria = session.createCriteria(transactionClass);
        criteria.add((Criterion)Restrictions.ge((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)fromDate));
        criteria.add((Criterion)Restrictions.le((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)toDate));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        this.addMultiUserFilter(user, criteria, PosTransaction.PROP_USER_ID);
        criteria.setProjection((Projection)Projections.sum((String)CustomPaymentTransaction.PROP_AMOUNT));
        return this.getDoubleAmount(criteria.uniqueResult());
    }

    private double calculateCashReceipt(Session session, Date fromDate, Date toDate, User user) {
        Criteria criteria = session.createCriteria(CashTransaction.class);
        criteria.add((Criterion)Restrictions.ge((String)CashTransaction.PROP_TRANSACTION_TIME, (Object)fromDate));
        criteria.add((Criterion)Restrictions.le((String)CashTransaction.PROP_TRANSACTION_TIME, (Object)toDate));
        this.addMultiUserFilter(user, criteria, CashTransaction.PROP_USER_ID);
        criteria.add((Criterion)Restrictions.eq((String)CashTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.CASH.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
        return this.getDoubleAmount(criteria.uniqueResult());
    }

    public double calculateGiftCertReceipts(Session session, Date fromDate, Date toDate, User user) {
        Criteria criteria = session.createCriteria(GiftCertificateTransaction.class);
        criteria.add((Criterion)Restrictions.ge((String)GiftCertificateTransaction.PROP_TRANSACTION_TIME, (Object)fromDate));
        criteria.add((Criterion)Restrictions.le((String)GiftCertificateTransaction.PROP_TRANSACTION_TIME, (Object)toDate));
        this.addMultiUserFilter(user, criteria, GiftCertificateTransaction.PROP_USER_ID);
        criteria.add((Criterion)Restrictions.eq((String)GiftCertificateTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.setProjection((Projection)Projections.sum((String)GiftCertificateTransaction.PROP_AMOUNT));
        return this.getDoubleAmount(criteria.uniqueResult());
    }

    private double calculateCashTips(Session session, Date fromDate, Date toDate, User user) {
        Criteria criteria = session.createCriteria(PosTransaction.class);
        criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)fromDate, (Object)toDate));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.CASH.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        if (user != null) {
            criteria.createAlias(PosTransaction.PROP_TICKET, "ticket");
            criteria.add((Criterion)Restrictions.eq((String)("ticket." + Ticket.PROP_OWNER_ID), (Object)(user == null ? null : user.getId())));
        }
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_TIPS_AMOUNT));
        return this.getDoubleAmount(criteria.uniqueResult());
    }

    private double calculateMemberPayment(Session session, Class transactionClass, Date fromDate, Date toDate, User user) {
        Criteria criteria = session.createCriteria(transactionClass);
        criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)fromDate, (Object)toDate));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.MEMBER_ACCOUNT.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
        return this.getDoubleAmount(criteria.uniqueResult());
    }

    private double calculateChargedTips(Session session, Date fromDate, Date toDate, User user) {
        Criteria criteria = session.createCriteria(PosTransaction.class);
        criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)fromDate, (Object)toDate));
        criteria.add((Criterion)Restrictions.ne((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.CASH.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        if (user != null) {
            criteria.createAlias(PosTransaction.PROP_TICKET, "ticket");
            criteria.add((Criterion)Restrictions.eq((String)("ticket." + Ticket.PROP_OWNER_ID), (Object)(user == null ? null : user.getId())));
        }
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_TIPS_AMOUNT));
        return this.getDoubleAmount(criteria.uniqueResult());
    }

    private double calculateDiscount(Session session, Date fromDate, Date toDate, User user) {
        Criteria criteria = session.createCriteria(Ticket.class);
        criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)fromDate));
        criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)toDate));
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_REFUNDED, (Object)Boolean.FALSE));
        this.addMultiUserFilter(user, criteria, Ticket.PROP_OWNER_ID);
        criteria.setProjection((Projection)Projections.sum((String)Ticket.PROP_DISCOUNT_AMOUNT));
        return this.getDoubleAmount(criteria.uniqueResult());
    }

    private double getDoubleAmount(Object result) {
        if (result != null && result instanceof Number) {
            return ((Number)result).doubleValue();
        }
        return 0.0;
    }

    private double calculateTax(Session session, Date fromDate, Date toDate, User user) {
        Criteria criteria = session.createCriteria(Ticket.class);
        criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)fromDate));
        criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)toDate));
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)Boolean.FALSE));
        this.addMultiUserFilter(user, criteria, Ticket.PROP_OWNER_ID);
        criteria.setProjection((Projection)Projections.sum((String)Ticket.PROP_TAX_AMOUNT));
        return this.getDoubleAmount(criteria.uniqueResult());
    }

    private double getNetSales(Session session, Date fromDate, Date toDate, User user) {
        Criteria criteria = session.createCriteria(Ticket.class);
        criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)fromDate));
        criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)toDate));
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)Boolean.FALSE));
        this.addMultiUserFilter(user, criteria, Ticket.PROP_OWNER_ID);
        criteria.setProjection((Projection)Projections.sum((String)Ticket.PROP_SUBTOTAL_AMOUNT));
        return this.getDoubleAmount(criteria.uniqueResult());
    }

    private double calculateToleranceAmount(Session session, Date fromDate, Date toDate, User user) {
        Criteria criteria = this.getCriteriaForTransaction(session, CashTransaction.class);
        criteria.add((Criterion)Restrictions.ge((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)fromDate));
        criteria.add((Criterion)Restrictions.le((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)toDate));
        this.addMultiUserFilter(user, criteria, PosTransaction.PROP_USER_ID);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_TOLERANCE_AMOUNT));
        return this.getDoubleAmount(criteria.uniqueResult());
    }

    private Criteria getCriteriaForTransaction(Session session, Class transactionClass) {
        Criteria criteria = session.createCriteria(transactionClass);
        if (transactionClass.equals(RefundTransaction.class) || transactionClass.equals(PayOutTransaction.class)) {
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.DEBIT.name()));
        } else {
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        }
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        return criteria;
    }

    private double calculateGrossSales(Session session, Date fromDate, Date toDate, User user, boolean taxableSales) {
        Criteria criteria = session.createCriteria(Ticket.class);
        criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)fromDate));
        criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)toDate));
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_REFUNDED, (Object)Boolean.FALSE));
        this.addMultiUserFilter(user, criteria, Ticket.PROP_OWNER_ID);
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_TAX_EXEMPT, (Object)(!taxableSales ? 1 : 0)));
        criteria.setProjection((Projection)Projections.sum((String)Ticket.PROP_SUBTOTAL_AMOUNT));
        return this.getDoubleAmount(criteria.uniqueResult());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SalesExceptionReport getSalesExceptionReport(Date fromDate, Date toDate) {
        GenericDAO dao = new GenericDAO();
        SalesExceptionReport report = new SalesExceptionReport();
        Session session = null;
        report.setFromDate(fromDate);
        report.setToDate(toDate);
        report.setReportTime(new Date());
        try {
            session = dao.getSession();
            Criteria criteriaRefund = session.createCriteria(RefundTransaction.class);
            criteriaRefund.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)fromDate, (Object)toDate));
            List list = criteriaRefund.list();
            for (RefundTransaction refundTransaction : list) {
                report.addRefundToRefundData(refundTransaction);
            }
            Criteria criteria = session.createCriteria(Ticket.class);
            criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)fromDate));
            criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CLOSING_DATE, (Object)toDate));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)true));
            list = criteria.list();
            for (Ticket ticket : list) {
                report.addVoidToVoidData(ticket);
            }
            criteria = session.createCriteria(Ticket.class);
            criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)fromDate));
            criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)toDate));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)Boolean.FALSE));
            list = criteria.list();
            for (Ticket ticket : list) {
                report.addDiscountOnTicket(ticket);
                List<TicketItem> ticketItems = ticket.getTicketItems();
                for (TicketItem ticketItem : ticketItems) {
                    report.addDiscountOnTicketItem(ticketItem);
                }
            }
            DiscountDAO discountDAO = new DiscountDAO();
            List<Discount> availableCoupons = discountDAO.getValidCoupons();
            report.addEmptyDiscounts(availableCoupons);
            SalesExceptionReport salesExceptionReport = report;
            return salesExceptionReport;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SalesDetailedReport getSalesDetailedReport(Date fromDate, Date toDate) {
        GenericDAO dao = new GenericDAO();
        SalesDetailedReport report = new SalesDetailedReport();
        Session session = null;
        report.setFromDate(fromDate);
        report.setToDate(toDate);
        report.setReportTime(new Date());
        try {
            session = dao.getSession();
            Criteria criteria = session.createCriteria(CashDrawer.class);
            criteria.add((Criterion)Restrictions.ge((String)CashDrawer.PROP_REPORT_TIME, (Object)fromDate));
            criteria.add((Criterion)Restrictions.le((String)CashDrawer.PROP_REPORT_TIME, (Object)toDate));
            List list = criteria.list();
            for (CashDrawer cashDrawer : list) {
                SalesDetailedReport.DrawerPullData data = new SalesDetailedReport.DrawerPullData();
                data.setDrawerPullId(cashDrawer.getId());
                data.setTicketCount(cashDrawer.getTicketCount());
                data.setIdealAmount(cashDrawer.getDrawerAccountable());
                data.setActualAmount(cashDrawer.getCashToDeposit());
                data.setVarinceAmount(cashDrawer.getDrawerAccountable() - cashDrawer.getCashToDeposit());
                report.addDrawerPullData(data);
            }
            criteria = session.createCriteria(CreditCardTransaction.class);
            criteria.add((Criterion)Restrictions.ge((String)CreditCardTransaction.PROP_TRANSACTION_TIME, (Object)fromDate));
            criteria.add((Criterion)Restrictions.le((String)CreditCardTransaction.PROP_TRANSACTION_TIME, (Object)toDate));
            list = criteria.list();
            for (PosTransaction t : list) {
                report.addCreditCardData((CreditCardTransaction)t);
            }
            criteria = session.createCriteria(DebitCardTransaction.class);
            criteria.add((Criterion)Restrictions.ge((String)DebitCardTransaction.PROP_TRANSACTION_TIME, (Object)fromDate));
            criteria.add((Criterion)Restrictions.le((String)DebitCardTransaction.PROP_TRANSACTION_TIME, (Object)toDate));
            list = criteria.list();
            for (PosTransaction t : list) {
                report.addCreditCardData((DebitCardTransaction)t);
            }
            criteria = session.createCriteria(GiftCertificateTransaction.class);
            criteria.add((Criterion)Restrictions.ge((String)GiftCertificateTransaction.PROP_TRANSACTION_TIME, (Object)fromDate));
            criteria.add((Criterion)Restrictions.le((String)GiftCertificateTransaction.PROP_TRANSACTION_TIME, (Object)toDate));
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add(Projections.rowCount());
            projectionList.add((Projection)Projections.sum((String)GiftCertificateTransaction.PROP_AMOUNT));
            criteria.setProjection((Projection)projectionList);
            Object[] object = (Object[])criteria.uniqueResult();
            if (object != null && object.length > 0 && object[0] instanceof Number) {
                report.setGiftCertReturnCount(((Number)object[0]).intValue());
            }
            if (object != null && object.length > 1 && object[1] instanceof Number) {
                report.setGiftCertReturnAmount(((Number)object[1]).doubleValue());
            }
            criteria = session.createCriteria(GiftCertificateTransaction.class);
            criteria.add((Criterion)Restrictions.ge((String)GiftCertificateTransaction.PROP_TRANSACTION_TIME, (Object)fromDate));
            criteria.add((Criterion)Restrictions.le((String)GiftCertificateTransaction.PROP_TRANSACTION_TIME, (Object)toDate));
            criteria.add((Criterion)Restrictions.gt((String)GiftCertificateTransaction.PROP_GIFT_CERT_CASH_BACK_AMOUNT, (Object)0.0));
            projectionList = Projections.projectionList();
            projectionList.add(Projections.rowCount());
            projectionList.add((Projection)Projections.sum((String)GiftCertificateTransaction.PROP_GIFT_CERT_CASH_BACK_AMOUNT));
            criteria.setProjection((Projection)projectionList);
            object = (Object[])criteria.uniqueResult();
            if (object != null && object.length > 0 && object[0] instanceof Number) {
                report.setGiftCertChangeCount(((Number)object[0]).intValue());
            }
            if (object != null && object.length > 1 && object[1] instanceof Number) {
                report.setGiftCertChangeAmount(((Number)object[1]).doubleValue());
            }
            criteria = session.createCriteria(Ticket.class);
            criteria.createAlias(Ticket.PROP_GRATUITY, "g");
            criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)fromDate));
            criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)toDate));
            criteria.add((Criterion)Restrictions.gt((String)("g." + Gratuity.PROP_AMOUNT), (Object)0.0));
            projectionList = Projections.projectionList();
            projectionList.add(Projections.rowCount());
            projectionList.add((Projection)Projections.sum((String)("g." + Gratuity.PROP_AMOUNT)));
            criteria.setProjection((Projection)projectionList);
            object = (Object[])criteria.uniqueResult();
            if (object != null && object.length > 0 && object[0] instanceof Number) {
                report.setTipsCount(((Number)object[0]).intValue());
            }
            if (object != null && object.length > 1 && object[1] instanceof Number) {
                report.setChargedTips(((Number)object[1]).doubleValue());
            }
            criteria = session.createCriteria(Ticket.class);
            criteria.createAlias(Ticket.PROP_GRATUITY, "g");
            criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)fromDate));
            criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)toDate));
            criteria.add((Criterion)Restrictions.gt((String)("g." + Gratuity.PROP_AMOUNT), (Object)0.0));
            criteria.add((Criterion)Restrictions.gt((String)("g." + Gratuity.PROP_PAID), (Object)Boolean.TRUE));
            projectionList = Projections.projectionList();
            projectionList.add((Projection)Projections.sum((String)("g." + Gratuity.PROP_AMOUNT)));
            criteria.setProjection((Projection)projectionList);
            object = (Object[])criteria.uniqueResult();
            if (object != null && object.length > 0 && object[0] instanceof Number) {
                report.setTipsPaid(((Number)object[0]).doubleValue());
            }
            SalesDetailedReport salesDetailedReport = report;
            return salesDetailedReport;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SalesDetailedReport getCloudSalesDetailedReport(Date fromDate, Date toDate) {
        GenericDAO dao = new GenericDAO();
        SalesDetailedReport report = new SalesDetailedReport();
        Session session = null;
        report.setFromDate(fromDate);
        report.setToDate(toDate);
        report.setReportTime(new Date());
        try {
            session = dao.getSession();
            Criteria criteria = session.createCriteria(CashDrawer.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)CashDrawer.PROP_REPORT_TIME), (Criterion)Restrictions.ge((String)CashDrawer.PROP_REPORT_TIME, (Object)fromDate)));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)CashDrawer.PROP_REPORT_TIME), (Criterion)Restrictions.le((String)CashDrawer.PROP_REPORT_TIME, (Object)toDate)));
            List list = criteria.list();
            for (CashDrawer cashDrawer : list) {
                SalesDetailedReport.DrawerPullData data = new SalesDetailedReport.DrawerPullData();
                data.setDrawerPullId(cashDrawer.getId());
                data.setTicketCount(cashDrawer.getTicketCount());
                data.setIdealAmount(cashDrawer.getDrawerAccountable());
                data.setActualAmount(cashDrawer.getCashToDeposit());
                data.setVarinceAmount(cashDrawer.getDrawerAccountable() - cashDrawer.getCashToDeposit());
                report.addDrawerPullData(data);
            }
            criteria = session.createCriteria(CreditCardTransaction.class);
            criteria.add((Criterion)Restrictions.ge((String)CreditCardTransaction.PROP_TRANSACTION_TIME, (Object)fromDate));
            criteria.add((Criterion)Restrictions.le((String)CreditCardTransaction.PROP_TRANSACTION_TIME, (Object)toDate));
            list = criteria.list();
            for (PosTransaction t : list) {
                report.addCreditCardData((CreditCardTransaction)t);
            }
            criteria = session.createCriteria(DebitCardTransaction.class);
            criteria.add((Criterion)Restrictions.ge((String)DebitCardTransaction.PROP_TRANSACTION_TIME, (Object)fromDate));
            criteria.add((Criterion)Restrictions.le((String)DebitCardTransaction.PROP_TRANSACTION_TIME, (Object)toDate));
            list = criteria.list();
            for (PosTransaction t : list) {
                report.addCreditCardData((DebitCardTransaction)t);
            }
            criteria = session.createCriteria(GiftCertificateTransaction.class);
            criteria.add((Criterion)Restrictions.ge((String)GiftCertificateTransaction.PROP_TRANSACTION_TIME, (Object)fromDate));
            criteria.add((Criterion)Restrictions.le((String)GiftCertificateTransaction.PROP_TRANSACTION_TIME, (Object)toDate));
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add(Projections.rowCount());
            projectionList.add((Projection)Projections.sum((String)GiftCertificateTransaction.PROP_AMOUNT));
            criteria.setProjection((Projection)projectionList);
            Object[] object = (Object[])criteria.uniqueResult();
            if (object != null && object.length > 0 && object[0] instanceof Number) {
                report.setGiftCertReturnCount(((Number)object[0]).intValue());
            }
            if (object != null && object.length > 1 && object[1] instanceof Number) {
                report.setGiftCertReturnAmount(((Number)object[1]).doubleValue());
            }
            criteria = session.createCriteria(GiftCertificateTransaction.class);
            criteria.add((Criterion)Restrictions.ge((String)GiftCertificateTransaction.PROP_TRANSACTION_TIME, (Object)fromDate));
            criteria.add((Criterion)Restrictions.le((String)GiftCertificateTransaction.PROP_TRANSACTION_TIME, (Object)toDate));
            criteria.add((Criterion)Restrictions.gt((String)GiftCertificateTransaction.PROP_GIFT_CERT_CASH_BACK_AMOUNT, (Object)0.0));
            projectionList = Projections.projectionList();
            projectionList.add(Projections.rowCount());
            projectionList.add((Projection)Projections.sum((String)GiftCertificateTransaction.PROP_GIFT_CERT_CASH_BACK_AMOUNT));
            criteria.setProjection((Projection)projectionList);
            object = (Object[])criteria.uniqueResult();
            if (object != null && object.length > 0 && object[0] instanceof Number) {
                report.setGiftCertChangeCount(((Number)object[0]).intValue());
            }
            if (object != null && object.length > 1 && object[1] instanceof Number) {
                report.setGiftCertChangeAmount(((Number)object[1]).doubleValue());
            }
            SalesDetailedReport salesDetailedReport = report;
            return salesDetailedReport;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    private double calculateVisaCreditCardSummery(Session session, Class transactionClass, Date fromDate, Date toDate, User user) {
        Criteria criteria = session.createCriteria(transactionClass);
        criteria.add((Criterion)Restrictions.ge((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)fromDate));
        criteria.add((Criterion)Restrictions.le((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)toDate));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_CARD_TYPE, (Object)CardTypeEnum.VISA.name()).ignoreCase());
        this.addMultiUserFilter(user, criteria, PosTransaction.PROP_USER_ID);
        criteria.setProjection((Projection)Projections.sum((String)CashTransaction.PROP_AMOUNT));
        return this.getDoubleAmount(criteria.uniqueResult());
    }

    private double calculateMasterCardSummery(Session session, Class transactionClass, Date fromDate, Date toDate, User user) {
        Criteria criteria = session.createCriteria(transactionClass);
        criteria.add((Criterion)Restrictions.ge((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)fromDate));
        criteria.add((Criterion)Restrictions.le((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)toDate));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        criteria.add((Criterion)PosTransactionDAO.createMasterCardSearchCriteria());
        this.addMultiUserFilter(user, criteria, PosTransaction.PROP_USER_ID);
        criteria.setProjection((Projection)Projections.sum((String)CashTransaction.PROP_AMOUNT));
        return this.getDoubleAmount(criteria.uniqueResult());
    }

    private double calculateAmexSummery(Session session, Class transactionClass, Date fromDate, Date toDate, User user) {
        Criteria criteria = session.createCriteria(transactionClass);
        criteria.add((Criterion)Restrictions.ge((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)fromDate));
        criteria.add((Criterion)Restrictions.le((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)toDate));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        criteria.add((Criterion)PosTransactionDAO.createAmexOrAmericanExpCardSearchCriteria());
        this.addMultiUserFilter(user, criteria, PosTransaction.PROP_USER_ID);
        criteria.setProjection((Projection)Projections.sum((String)CashTransaction.PROP_AMOUNT));
        return this.getDoubleAmount(criteria.uniqueResult());
    }

    private double calculateDiscoverySummery(Session session, Class transactionClass, Date fromDate, Date toDate, User user) {
        Criteria criteria = session.createCriteria(transactionClass);
        criteria.add((Criterion)Restrictions.ge((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)fromDate));
        criteria.add((Criterion)Restrictions.le((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)toDate));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_CARD_TYPE, (Object)CardTypeEnum.DISCOVER.name()).ignoreCase());
        this.addMultiUserFilter(user, criteria, PosTransaction.PROP_USER_ID);
        criteria.setProjection((Projection)Projections.sum((String)CashTransaction.PROP_AMOUNT));
        return this.getDoubleAmount(criteria.uniqueResult());
    }

    private double calculateVisaDebitCardSummery(Session session, Class transactionClass, Date fromDate, Date toDate, User user) {
        Criteria criteria = session.createCriteria(transactionClass);
        criteria.add((Criterion)Restrictions.ge((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)fromDate));
        criteria.add((Criterion)Restrictions.le((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)toDate));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_CARD_TYPE, (Object)CardTypeEnum.VISA.name()).ignoreCase());
        this.addMultiUserFilter(user, criteria, PosTransaction.PROP_USER_ID);
        criteria.setProjection((Projection)Projections.sum((String)CashTransaction.PROP_AMOUNT));
        return this.getDoubleAmount(criteria.uniqueResult());
    }

    private double calculateMasterDebitCardSummery(Session session, Class transactionClass, Date fromDate, Date toDate, User user) {
        Criteria criteria = session.createCriteria(transactionClass);
        criteria.add((Criterion)Restrictions.ge((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)fromDate));
        criteria.add((Criterion)Restrictions.le((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)toDate));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        criteria.add((Criterion)PosTransactionDAO.createMasterCardSearchCriteria());
        this.addMultiUserFilter(user, criteria, PosTransaction.PROP_USER_ID);
        criteria.setProjection((Projection)Projections.sum((String)CashTransaction.PROP_AMOUNT));
        return this.getDoubleAmount(criteria.uniqueResult());
    }

    private void addMultiUserFilter(User user, Criteria criteria, String fieldName) {
        if (user != null) {
            PosLog.info(this.getClass(), "setting multi user filter for root user '" + user.getFullName() + "', id: " + user.getId());
            Disjunction disjunction = Restrictions.disjunction();
            disjunction.add((Criterion)Restrictions.eq((String)fieldName, (Object)user.getId()));
            List<User> linkedUsers = user.getLinkedUser();
            if (linkedUsers != null) {
                for (User linkedUser : linkedUsers) {
                    if (linkedUser.getId().equals(user.getId())) continue;
                    PosLog.info(this.getClass(), "linked user '" + linkedUser.getFullName() + "', id: " + linkedUser.getId());
                    disjunction.add((Criterion)Restrictions.eq((String)fieldName, (Object)linkedUser.getId()));
                }
            }
            criteria.add((Criterion)disjunction);
        }
    }

    public static SalesReportModel prepareItemSalesReportModel(List<TicketItem> ticketItems) {
        SalesReportModel itemReportModel = new SalesReportModel();
        if (ticketItems != null && ticketItems.size() > 0) {
            LinkedHashMap<String, ReportItem> itemMap = new LinkedHashMap<String, ReportItem>();
            String key = null;
            for (TicketItem ticketItem : ticketItems) {
                String menuItemId = ticketItem.getMenuItemId();
                key = (menuItemId == null ? ticketItem.getName() : menuItemId) + "-" + ticketItem.getUnitPrice() + "-" + ticketItem.getUnitName();
                ReportItem reportItem = (ReportItem)((HashMap)itemMap).get(key);
                if (reportItem == null) {
                    reportItem = new ReportItem();
                    reportItem.setId(key);
                    reportItem.setPrice(ticketItem.getUnitPrice());
                    reportItem.setUnit(ticketItem.getUnitName());
                    reportItem.setCost(ticketItem.getUnitCost());
                    reportItem.setName(ticketItem.getName());
                    reportItem.setTaxRate(ticketItem.getTotalTaxRate());
                    reportItem.setGroupId(ticketItem.getGroupId());
                    reportItem.setGroupName(ticketItem.getGroupName());
                    reportItem.setBarcode(menuItemId);
                    reportItem.setAdjustedPrice(ticketItem.getAdjustedUnitPrice());
                    itemMap.put(key, reportItem);
                }
                reportItem.setQuantity(reportItem.getQuantity() + ticketItem.getQuantity());
                reportItem.setGrossTotal(reportItem.getGrossTotal() + ticketItem.getAdjustedTotalWithoutModifiers());
                reportItem.setDiscount(reportItem.getDiscount() + ticketItem.getAdjustedDiscountWithoutModifiers());
                reportItem.setTaxTotal(reportItem.getTaxTotal() + ticketItem.getAdjustedTaxWithoutModifiers());
                reportItem.setServiceCharge(reportItem.getServiceCharge() + ticketItem.getServiceCharge());
                double adjustedAmount = ticketItem.isTaxIncluded() != false ? ticketItem.getAdjustedTotalWithoutModifiers() - ticketItem.getAdjustedTaxWithoutModifiers() : ticketItem.getAdjustedSubtotalWithoutModifiers();
                reportItem.setNetTotal(reportItem.getNetTotal() + adjustedAmount);
            }
            itemReportModel.setItems(new ArrayList<ReportItem>(((HashMap)itemMap).values()));
        }
        return itemReportModel;
    }

    public static Map<String, Integer> prepareTicketForDashBoard(List<Date> listOfDate) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (listOfDate != null && listOfDate.size() > 0) {
            int countNumberOfDate = 0;
            for (Date date : listOfDate) {
                String formatDate = DateUtil.formatAsDefaultMonthDate(date);
                if (map.get(formatDate) == null) {
                    countNumberOfDate = 1;
                }
                if (map.containsKey(formatDate)) {
                    ++countNumberOfDate;
                }
                map.put(formatDate, countNumberOfDate);
            }
        }
        return map;
    }

    public TaxExemptReport getTaxExemptReport(Date fromDate, Date toDate) throws Exception {
        TaxExemptReport report = new TaxExemptReport();
        try (Session session = TicketDAO.getInstance().createNewSession();){
            Criteria criteria = session.createCriteria(Ticket.class);
            criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)fromDate));
            criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CLOSING_DATE, (Object)toDate));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_TAX_EXEMPT, (Object)true));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)false));
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add((Projection)Projections.property((String)Ticket.PROP_ID), Ticket.PROP_ID);
            projectionList.add((Projection)Projections.property((String)Ticket.PROP_CREATE_DATE), Ticket.PROP_CREATE_DATE);
            projectionList.add((Projection)Projections.property((String)Ticket.PROP_TOTAL_AMOUNT), Ticket.PROP_TOTAL_AMOUNT);
            projectionList.add((Projection)Projections.property((String)Ticket.PROP_EXTRA_PROPERTIES), Ticket.PROP_EXTRA_PROPERTIES);
            criteria.setProjection((Projection)projectionList);
            criteria.setResultTransformer(Transformers.aliasToBean(Ticket.class));
            List tickets = criteria.list();
            for (Ticket ticket : tickets) {
                report.addTaxExemptTicket(ticket);
            }
            TaxExemptReport taxExemptReport = report;
            return taxExemptReport;
        }
    }

    public DiscountReportDataModel createItemDiscountDataList(Date fromDate, Date toDate) {
        DiscountReportDataModel discountReport = new DiscountReportDataModel();
        try (Session session = TicketItemDAO.getInstance().createNewSession();){
            Criteria criteria = session.createCriteria(TicketItem.class);
            criteria.createAlias("ticket", "t");
            criteria.add((Criterion)Restrictions.eq((String)("t." + Ticket.PROP_VOIDED), (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.ge((String)TicketItem.PROP_CREATE_DATE, (Object)fromDate));
            criteria.add((Criterion)Restrictions.le((String)TicketItem.PROP_CREATE_DATE, (Object)toDate));
            criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_VOIDED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.gt((String)TicketItem.PROP_DISCOUNT_AMOUNT, (Object)0.0));
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add((Projection)Projections.property((String)TicketItem.PROP_NAME), "itemName");
            projectionList.add((Projection)Projections.property((String)("t." + Ticket.PROP_ID)), "ticketId");
            projectionList.add((Projection)Projections.property((String)TicketItem.PROP_CREATE_DATE), "date");
            projectionList.add((Projection)Projections.property((String)("t." + Ticket.PROP_OWNER_ID)), "server");
            projectionList.add((Projection)Projections.property((String)TicketItem.PROP_DISCOUNT_AMOUNT), "discount");
            projectionList.add((Projection)Projections.property((String)TicketItem.PROP_TOTAL_AMOUNT), "totalWithDiscount");
            criteria.setProjection((Projection)projectionList);
            criteria.setResultTransformer(Transformers.aliasToBean(DiscountData.class));
            List list = criteria.list();
            discountReport.addDiscountDataList(list);
            DiscountReportDataModel discountReportDataModel = discountReport;
            return discountReportDataModel;
        }
    }
}

