/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.swing;

import com.floreantpos.PosLog;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;
import javax.swing.text.html.ImageView;
import org.apache.commons.codec.binary.Base64;

public class BASE64ImageView
extends ImageView {
    public BASE64ImageView(Element elmnt) {
        super(elmnt);
        this.populateImage();
    }

    private void populateImage() {
        Hashtable<URL, Image> cache = (Hashtable<URL, Image>)this.getDocument().getProperty("imageCache");
        if (cache == null) {
            cache = new Hashtable<URL, Image>();
            this.getDocument().putProperty("imageCache", cache);
        }
        URL src = this.getImageURL();
        ((Dictionary)cache).put(src, this.loadImage());
    }

    private Image loadImage() {
        String b64 = this.getBASE64Image();
        BufferedImage newImage = null;
        ByteArrayInputStream bais = null;
        try {
            bais = new ByteArrayInputStream(Base64.decodeBase64((byte[])b64.getBytes()));
            newImage = ImageIO.read(bais);
        }
        catch (Exception ex) {
            PosLog.error(this.getClass(), ex.getMessage(), ex);
        }
        return newImage;
    }

    @Override
    public URL getImageURL() {
        String src = (String)this.getElement().getAttributes().getAttribute(HTML.Attribute.SRC);
        if (this.isBase64Encoded(src)) {
            URL url = BASE64ImageView.class.getProtectionDomain().getCodeSource().getLocation();
            return url;
        }
        return super.getImageURL();
    }

    private boolean isBase64Encoded(String src) {
        return src != null && src.contains("base64,");
    }

    private String getBASE64Image() {
        String src = (String)this.getElement().getAttributes().getAttribute(HTML.Attribute.SRC);
        if (!this.isBase64Encoded(src)) {
            return null;
        }
        return src.substring(src.indexOf("base64,") + 7, src.length() - 1);
    }
}

