/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.swing;

import com.floreantpos.swing.CheckBoxList;
import com.floreantpos.swing.PaginationSupport;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class CheckBoxListModel<E>
extends AbstractTableModel
implements PaginationSupport {
    List<CheckBoxList.Entry<E>> items;
    private int numRows;
    private int currentRowIndex;
    private int pageSize = 3;
    private String[] columnNames;

    public CheckBoxListModel() {
    }

    public CheckBoxListModel(String[] names) {
        this.columnNames = names;
    }

    public CheckBoxListModel(String[] names, List<E> rows) {
        this.items = new ArrayList<CheckBoxList.Entry<E>>(rows.size());
        for (E e : rows) {
            this.items.add(this.createEntry(e));
        }
        this.columnNames = names;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
    }

    public CheckBoxListModel(List<E> _items) {
        this.items = new ArrayList<CheckBoxList.Entry<E>>(_items.size());
        for (int i = 0; i < _items.size(); ++i) {
            this.items.add(this.createEntry(_items.get(i)));
        }
    }

    public CheckBoxListModel(E[] _items) {
        this.items = new ArrayList<CheckBoxList.Entry<E>>(_items.length);
        for (int i = 0; i < _items.length; ++i) {
            this.items.add(this.createEntry(_items[i]));
        }
    }

    public CheckBoxListModel(E[] _items, String[] columnNames) {
        this.items = new ArrayList<CheckBoxList.Entry<E>>(_items.length);
        for (int i = 0; i < _items.length; ++i) {
            this.items.add(this.createEntry(_items[i]));
        }
        this.columnNames = columnNames;
    }

    protected CheckBoxList.Entry createEntry(E obj) {
        if (obj instanceof CheckBoxList.Entry) {
            return (CheckBoxList.Entry)obj;
        }
        return new CheckBoxList.Entry<E>(false, obj);
    }

    @Override
    public int getRowCount() {
        if (this.items == null) {
            return 0;
        }
        return this.items.size();
    }

    public E getRow(int index) {
        return (E)this.getItems().get(index);
    }

    @Override
    public int getColumnCount() {
        if (this.columnNames != null) {
            return this.columnNames.length;
        }
        return this.currentRowIndex;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public Object getValueAt(int row, int col) {
        CheckBoxList.Entry<E> entry = this.items.get(row);
        switch (col) {
            case 0: {
                return entry.checked;
            }
            case 1: {
                return entry.value;
            }
        }
        throw new InternalError();
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
        }
        throw new InternalError();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 0;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 0) {
            CheckBoxList.Entry<E> entry = this.items.get(row);
            entry.checked = value.equals(Boolean.TRUE);
            this.fireTableRowsUpdated(row, row);
        }
    }

    public List<CheckBoxList.Entry<E>> getItems() {
        return this.items;
    }

    public void setItems(List<CheckBoxList.Entry<E>> items) {
        this.items = items;
    }

    @Override
    public int getNumRows() {
        return this.numRows;
    }

    @Override
    public void setNumRows(int numRows) {
        this.numRows = numRows;
    }

    @Override
    public int getCurrentRowIndex() {
        return this.currentRowIndex;
    }

    @Override
    public void setCurrentRowIndex(int currentRowIndex) {
        this.currentRowIndex = currentRowIndex;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public boolean hasNext() {
        return this.currentRowIndex + this.pageSize < this.numRows;
    }

    @Override
    public boolean hasPrevious() {
        return this.currentRowIndex > 0;
    }

    @Override
    public int getNextRowIndex() {
        if (this.numRows == 0) {
            return 0;
        }
        return this.getCurrentRowIndex() + this.getPageSize();
    }

    @Override
    public int getPreviousRowIndex() {
        int i = this.getCurrentRowIndex() - this.getPageSize();
        if (i < 0) {
            i = 0;
        }
        return i;
    }

    @Override
    public void setRows(List rows) {
        if (this.items != null) {
            this.items.clear();
        }
        this.items = new ArrayList<CheckBoxList.Entry<E>>(rows.size());
        for (Object e : rows) {
            this.items.add(this.createEntry(e));
        }
        this.fireTableDataChanged();
    }

    public void addItem(E item) {
        if (this.items == null) {
            return;
        }
        this.items.clear();
        this.items.add(this.createEntry(item));
    }

    public boolean hasContain(E item) {
        if (this.items == null) {
            return false;
        }
        for (CheckBoxList.Entry<E> entry : this.items) {
            if (!entry.getValue().equals(item)) continue;
            return true;
        }
        return false;
    }
}

