/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.swing;

import com.floreantpos.main.Application;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.QwertyKeyPad;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class PosOptionPane
extends OkCancelOptionDialog {
    private JTextArea taInputText;
    private String inputText;
    private QwertyKeyPad qwertyKeyPad;
    private String inputValidationPattern;
    private String validationMessage;

    private PosOptionPane() {
        super(POSUtil.getFocusedWindow());
        this.init();
    }

    private PosOptionPane(Window parent) {
        super(parent);
        this.init();
    }

    private void init() {
        this.setResizable(false);
        JPanel contentPane = this.getContentPanel();
        MigLayout layout = new MigLayout("inset 0");
        contentPane.setLayout((LayoutManager)layout);
        Dimension size = PosUIManager.getSize(0, 100);
        this.taInputText = new JTextArea();
        this.taInputText.setFont(this.taInputText.getFont().deriveFont(1, PosUIManager.getFontSize(16)));
        this.taInputText.setFocusable(true);
        this.taInputText.requestFocus();
        this.taInputText.setLineWrap(true);
        this.taInputText.setBackground(Color.WHITE);
        this.taInputText.setPreferredSize(size);
        this.qwertyKeyPad = new QwertyKeyPad();
        JScrollPane scrollPane = new JScrollPane(this.taInputText);
        contentPane.add((Component)scrollPane, "spanx, grow");
        contentPane.add((Component)((Object)this.qwertyKeyPad), "spanx ,grow");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void doOk() {
        String s = this.taInputText.getText();
        if (s.isEmpty()) {
            POSMessageDialog.showError(Application.getPosWindow(), "Please enter value");
            return;
        }
        String INPUT_VALIDATION_PATTERN = this.getInputValidationPattern();
        if (StringUtils.isEmpty((String)INPUT_VALIDATION_PATTERN)) {
            this.setValue(this.taInputText.getText());
            this.setCanceled(false);
            this.dispose();
            return;
        }
        Pattern pattern = Pattern.compile(INPUT_VALIDATION_PATTERN);
        Matcher matcher = pattern.matcher(s);
        if (matcher.matches()) {
            this.setValue(s);
            this.setCanceled(false);
            this.dispose();
            return;
        }
        POSMessageDialog.showError(POSUtil.getFocusedWindow(), this.getValidationMessage());
    }

    public String getValue() {
        return this.inputText;
    }

    public void setValue(String value) {
        this.inputText = value;
    }

    private void setDefaultValue(String value) {
        this.taInputText.setText(value);
    }

    public static String showInputDialog(String title) {
        PosOptionPane dialog = new PosOptionPane();
        dialog.setCaption(title);
        dialog.setTitle(title);
        dialog.pack();
        dialog.open();
        if (dialog.isCanceled()) {
            return null;
        }
        return dialog.getValue();
    }

    public static String showInputDialog(String title, String inputValidationPattern, String validationMessage, boolean isValidationCheck) {
        PosOptionPane dialog = new PosOptionPane();
        dialog.setCaption(title);
        dialog.setTitle(title);
        dialog.setInputValidationPattern(inputValidationPattern);
        dialog.setValidationMessage(validationMessage);
        dialog.pack();
        dialog.open();
        if (dialog.isCanceled()) {
            return null;
        }
        return dialog.getValue();
    }

    public static String showInputDialog(String title, String defaultText) {
        PosOptionPane dialog = new PosOptionPane();
        dialog.setCaption(title);
        dialog.setTitle(title);
        dialog.setDefaultValue(defaultText);
        dialog.pack();
        dialog.open();
        if (dialog.isCanceled()) {
            return null;
        }
        return dialog.getValue();
    }

    public static String showEmailInputDialog(String title, String defaultText) {
        PosOptionPane dialog = new PosOptionPane();
        dialog.setCaption(title);
        dialog.setTitle(title);
        dialog.setDefaultValue(defaultText);
        dialog.pack();
        dialog.open();
        if (dialog.isCanceled()) {
            return null;
        }
        return dialog.getValue();
    }

    public static String showInputDialog(Window parent, String title) {
        PosOptionPane dialog = new PosOptionPane(parent);
        dialog.setCaption(title);
        dialog.setTitle(title);
        dialog.pack();
        dialog.open();
        if (dialog.isCanceled()) {
            return null;
        }
        return dialog.getValue();
    }

    public String getInputValidationPattern() {
        return this.inputValidationPattern;
    }

    public void setInputValidationPattern(String inputValidationPattern) {
        this.inputValidationPattern = inputValidationPattern;
    }

    public String getValidationMessage() {
        return this.validationMessage;
    }

    public void setValidationMessage(String validation) {
        this.validationMessage = validation;
    }
}

